/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.querychannels;

import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.offline.querychannels.EventHandlingResult;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0000\u001a&\u0010\u0007\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0000\u001a.\u0010\b\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"addIfChannelIsAbsent", "Lio/getstream/chat/android/offline/querychannels/EventHandlingResult;", "channels", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lio/getstream/chat/android/client/models/Channel;", "channel", "removeIfChannelIsPresent", "removeIfCurrentUserLeftChannel", "member", "Lio/getstream/chat/android/client/models/Member;", "stream-chat-android-offline_release"})
public final class ChatEventHandlerKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final EventHandlingResult addIfChannelIsAbsent(@NotNull StateFlow<? extends List<Channel>> channels, @Nullable Channel channel) {
        EventHandlingResult eventHandlingResult;
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        if (channel != null) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = (Iterable)channels.getValue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Channel it = (Channel)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getCid(), (Object)channel.getCid())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                eventHandlingResult = new EventHandlingResult.Add(channel);
                return eventHandlingResult;
            }
        }
        eventHandlingResult = EventHandlingResult.Skip.INSTANCE;
        return eventHandlingResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final EventHandlingResult removeIfChannelIsPresent(@NotNull StateFlow<? extends List<Channel>> channels, @Nullable Channel channel) {
        EventHandlingResult eventHandlingResult;
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        if (channel != null) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = (Iterable)channels.getValue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Channel it = (Channel)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getCid(), (Object)channel.getCid())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                eventHandlingResult = new EventHandlingResult.Remove(channel.getCid());
                return eventHandlingResult;
            }
        }
        eventHandlingResult = EventHandlingResult.Skip.INSTANCE;
        return eventHandlingResult;
    }

    @NotNull
    public static final EventHandlingResult removeIfCurrentUserLeftChannel(@NotNull StateFlow<? extends List<Channel>> channels, @Nullable Channel channel, @NotNull Member member) {
        String string;
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        if (ChatClient.Companion.isInitialized()) {
            User user = ChatClient.Companion.instance().getCurrentUser();
            string = user == null ? null : user.getId();
        } else {
            string = null;
        }
        String currentUserId = string;
        String removedMemberId = member.getUserId();
        return Intrinsics.areEqual((Object)currentUserId, (Object)removedMemberId) ? ChatEventHandlerKt.removeIfChannelIsPresent(channels, channel) : (EventHandlingResult)EventHandlingResult.Skip.INSTANCE;
    }
}

