/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.repository.builder;

import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.offline.repository.database.ChatDatabase;
import io.getstream.chat.android.offline.repository.domain.channel.ChannelRepository;
import io.getstream.chat.android.offline.repository.domain.channel.ChannelRepositoryImpl;
import io.getstream.chat.android.offline.repository.domain.channelconfig.ChannelConfigRepository;
import io.getstream.chat.android.offline.repository.domain.channelconfig.ChannelConfigRepositoryImpl;
import io.getstream.chat.android.offline.repository.domain.message.MessageRepository;
import io.getstream.chat.android.offline.repository.domain.message.MessageRepositoryImpl;
import io.getstream.chat.android.offline.repository.domain.message.attachment.AttachmentRepository;
import io.getstream.chat.android.offline.repository.domain.message.attachment.AttachmentRepositoryImpl;
import io.getstream.chat.android.offline.repository.domain.queryChannels.QueryChannelsRepository;
import io.getstream.chat.android.offline.repository.domain.queryChannels.QueryChannelsRepositoryImpl;
import io.getstream.chat.android.offline.repository.domain.reaction.ReactionRepository;
import io.getstream.chat.android.offline.repository.domain.reaction.ReactionRepositoryImpl;
import io.getstream.chat.android.offline.repository.domain.syncState.SyncStateRepository;
import io.getstream.chat.android.offline.repository.domain.syncState.SyncStateRepositoryImpl;
import io.getstream.chat.android.offline.repository.domain.user.UserRepository;
import io.getstream.chat.android.offline.repository.domain.user.UserRepositoryImpl;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJv\u0010\u000b\u001a\u00020\f21\u0010\r\u001a-\b\u0001\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e23\u0010\u0014\u001a/\b\u0001\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017JA\u0010\u0018\u001a\u00020\u001921\u0010\r\u001a-\b\u0001\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJA\u0010\u001d\u001a\u00020\u001e21\u0010\r\u001a-\b\u0001\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lio/getstream/chat/android/offline/repository/builder/RepositoryFactory;", "", "database", "Lio/getstream/chat/android/offline/repository/database/ChatDatabase;", "currentUser", "Lio/getstream/chat/android/client/models/User;", "(Lio/getstream/chat/android/offline/repository/database/ChatDatabase;Lio/getstream/chat/android/client/models/User;)V", "createAttachmentRepository", "Lio/getstream/chat/android/offline/repository/domain/message/attachment/AttachmentRepository;", "createChannelConfigRepository", "Lio/getstream/chat/android/offline/repository/domain/channelconfig/ChannelConfigRepository;", "createChannelRepository", "Lio/getstream/chat/android/offline/repository/domain/channel/ChannelRepository;", "getUser", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "userId", "Lkotlin/coroutines/Continuation;", "getMessage", "messageId", "Lio/getstream/chat/android/client/models/Message;", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)Lio/getstream/chat/android/offline/repository/domain/channel/ChannelRepository;", "createMessageRepository", "Lio/getstream/chat/android/offline/repository/domain/message/MessageRepository;", "(Lkotlin/jvm/functions/Function2;)Lio/getstream/chat/android/offline/repository/domain/message/MessageRepository;", "createQueryChannelsRepository", "Lio/getstream/chat/android/offline/repository/domain/queryChannels/QueryChannelsRepository;", "createReactionRepository", "Lio/getstream/chat/android/offline/repository/domain/reaction/ReactionRepository;", "(Lkotlin/jvm/functions/Function2;)Lio/getstream/chat/android/offline/repository/domain/reaction/ReactionRepository;", "createSyncStateRepository", "Lio/getstream/chat/android/offline/repository/domain/syncState/SyncStateRepository;", "createUserRepository", "Lio/getstream/chat/android/offline/repository/domain/user/UserRepository;", "stream-chat-android-offline_release"})
public final class RepositoryFactory {
    @NotNull
    private final ChatDatabase database;
    @Nullable
    private final User currentUser;

    public RepositoryFactory(@NotNull ChatDatabase database, @Nullable User currentUser) {
        Intrinsics.checkNotNullParameter((Object)((Object)database), (String)"database");
        this.database = database;
        this.currentUser = currentUser;
    }

    @NotNull
    public final UserRepository createUserRepository() {
        return new UserRepositoryImpl(this.database.userDao(), this.currentUser, 100);
    }

    @NotNull
    public final ChannelConfigRepository createChannelConfigRepository() {
        return new ChannelConfigRepositoryImpl(this.database.channelConfigDao());
    }

    @NotNull
    public final ChannelRepository createChannelRepository(@NotNull Function2<? super String, ? super Continuation<? super User>, ? extends Object> getUser2, @NotNull Function2<? super String, ? super Continuation<? super Message>, ? extends Object> getMessage2) {
        Intrinsics.checkNotNullParameter(getUser2, (String)"getUser");
        Intrinsics.checkNotNullParameter(getMessage2, (String)"getMessage");
        return new ChannelRepositoryImpl(this.database.channelStateDao(), getUser2, getMessage2, 100);
    }

    @NotNull
    public final QueryChannelsRepository createQueryChannelsRepository() {
        return new QueryChannelsRepositoryImpl(this.database.queryChannelsDao());
    }

    @NotNull
    public final MessageRepository createMessageRepository(@NotNull Function2<? super String, ? super Continuation<? super User>, ? extends Object> getUser2) {
        Intrinsics.checkNotNullParameter(getUser2, (String)"getUser");
        return new MessageRepositoryImpl(this.database.messageDao(), getUser2, this.currentUser, 100, null, 16, null);
    }

    @NotNull
    public final ReactionRepository createReactionRepository(@NotNull Function2<? super String, ? super Continuation<? super User>, ? extends Object> getUser2) {
        Intrinsics.checkNotNullParameter(getUser2, (String)"getUser");
        return new ReactionRepositoryImpl(this.database.reactionDao(), getUser2);
    }

    @NotNull
    public final SyncStateRepository createSyncStateRepository() {
        return new SyncStateRepositoryImpl(this.database.syncStateDao());
    }

    @NotNull
    public final AttachmentRepository createAttachmentRepository() {
        return new AttachmentRepositoryImpl(this.database.attachmentDao());
    }
}

