/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.usecase;

import android.app.DownloadManager;
import android.net.Uri;
import android.os.Environment;
import androidx.annotation.CheckResult;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.call.CoroutineCall;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.offline.ChatDomainImpl;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalStreamChatApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0087\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/getstream/chat/android/offline/usecase/DownloadAttachment;", "", "domainImpl", "Lio/getstream/chat/android/offline/ChatDomainImpl;", "(Lio/getstream/chat/android/offline/ChatDomainImpl;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "invoke", "Lio/getstream/chat/android/client/call/Call;", "", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "stream-chat-android-offline_release"})
public final class DownloadAttachment {
    @NotNull
    private final ChatDomainImpl domainImpl;
    @NotNull
    private final TaggedLogger logger;

    public DownloadAttachment(@NotNull ChatDomainImpl domainImpl) {
        Intrinsics.checkNotNullParameter((Object)domainImpl, (String)"domainImpl");
        this.domainImpl = domainImpl;
        this.logger = ChatLogger.Companion.get((Object)"DownloadAttachment");
    }

    @CheckResult
    @NotNull
    public final Call<Unit> invoke(@NotNull Attachment attachment) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        try {
            String string;
            String url;
            Object object = this.domainImpl.getAppContext$stream_chat_android_offline_release().getSystemService("download");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.DownloadManager");
            }
            DownloadManager downloadManager = (DownloadManager)object;
            String string2 = attachment.getAssetUrl();
            if (string2 == null) {
                string2 = url = attachment.getImageUrl();
            }
            if ((string = attachment.getName()) == null) {
                string = attachment.getTitle();
            }
            String subPath = string;
            this.logger.logD("Downloading attachment. Name: " + subPath + ", Url: " + url);
            downloadManager.enqueue(new DownloadManager.Request(Uri.parse((String)url)).setTitle((CharSequence)subPath).setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, subPath).setNotificationVisibility(1));
            result2 = new Result((Object)Unit.INSTANCE);
        }
        catch (Exception e) {
            result2 = new Result(new ChatError(null, (Throwable)e, 1, null));
        }
        Result result3 = result2;
        return (Call)new CoroutineCall(this.domainImpl.getScope$stream_chat_android_offline_release(), (Function2)new Function2<CoroutineScope, Continuation<? super Result<Unit>>, Object>((Result<Unit>)result3, null){
            int label;
            final /* synthetic */ Result<Unit> $result;
            {
                this.$result = $result;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return this.$result;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }
}

