/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.models.Config;
import io.getstream.chat.android.livedata.converter.ConfigConverter;
import io.getstream.chat.android.livedata.dao.ChannelConfigDao;
import io.getstream.chat.android.livedata.entity.ChannelConfigEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ChannelConfigDao_Impl
implements ChannelConfigDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelConfigEntity> __insertionAdapterOfChannelConfigEntity;
    private final ConfigConverter __configConverter = new ConfigConverter();

    public ChannelConfigDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelConfigEntity = new EntityInsertionAdapter<ChannelConfigEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_channel_config` (`channelType`,`config`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelConfigEntity value) {
                if (value.getChannelType() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelType());
                }
                String _tmp = ChannelConfigDao_Impl.this.__configConverter.channelConfigToString(value.getConfig());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
            }
        };
    }

    @Override
    public Object insertMany(final List<ChannelConfigEntity> channelConfigEntities, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ChannelConfigDao_Impl.this.__db.beginTransaction();
                try {
                    ChannelConfigDao_Impl.this.__insertionAdapterOfChannelConfigEntity.insert((Iterable)channelConfigEntities);
                    ChannelConfigDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelConfigDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object insert(final ChannelConfigEntity channelConfigEntity, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ChannelConfigDao_Impl.this.__db.beginTransaction();
                try {
                    ChannelConfigDao_Impl.this.__insertionAdapterOfChannelConfigEntity.insert((Object)channelConfigEntity);
                    ChannelConfigDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelConfigDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object selectAll(Continuation<? super List<ChannelConfigEntity>> p0) {
        String _sql = "SELECT * FROM stream_chat_channel_config LIMIT 100";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_channel_config LIMIT 100", (int)0);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<ChannelConfigEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ChannelConfigEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelConfigDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
                    int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"config");
                    ArrayList<ChannelConfigEntity> _result = new ArrayList<ChannelConfigEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpChannelType = _cursor.getString(_cursorIndexOfChannelType);
                        String _tmp = _cursor.getString(_cursorIndexOfConfig);
                        Config _tmpConfig = ChannelConfigDao_Impl.this.__configConverter.stringToChannelConfig(_tmp);
                        ChannelConfigEntity _item = new ChannelConfigEntity(_tmpChannelType, _tmpConfig);
                        _result.add(_item);
                    }
                    ArrayList<ChannelConfigEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p0);
    }
}

