/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.livedata.converter.DateConverter;
import io.getstream.chat.android.livedata.converter.ListConverter;
import io.getstream.chat.android.livedata.dao.SyncStateDao;
import io.getstream.chat.android.livedata.entity.SyncStateEntity;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class SyncStateDao_Impl
implements SyncStateDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SyncStateEntity> __insertionAdapterOfSyncStateEntity;
    private final ListConverter __listConverter = new ListConverter();
    private final DateConverter __dateConverter = new DateConverter();

    public SyncStateDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSyncStateEntity = new EntityInsertionAdapter<SyncStateEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_sync_state` (`userId`,`activeChannelIds`,`activeQueryIds`,`lastSyncedAt`,`markedAllReadAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SyncStateEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                String _tmp = SyncStateDao_Impl.this.__listConverter.stringListToString(value.getActiveChannelIds());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = SyncStateDao_Impl.this.__listConverter.stringListToString(value.getActiveQueryIds());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                Long _tmp_2 = SyncStateDao_Impl.this.__dateConverter.dateToTimestamp(value.getLastSyncedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, _tmp_2.longValue());
                }
                Long _tmp_3 = SyncStateDao_Impl.this.__dateConverter.dateToTimestamp(value.getMarkedAllReadAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, _tmp_3.longValue());
                }
            }
        };
    }

    @Override
    public Object insert(final SyncStateEntity syncStateEntity, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SyncStateDao_Impl.this.__db.beginTransaction();
                try {
                    SyncStateDao_Impl.this.__insertionAdapterOfSyncStateEntity.insert((Object)syncStateEntity);
                    SyncStateDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SyncStateDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object select(String userId, Continuation<? super SyncStateEntity> p1) {
        String _sql = "SELECT * FROM stream_sync_state WHERE stream_sync_state.userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_sync_state WHERE stream_sync_state.userId = ?", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<SyncStateEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncStateEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SyncStateDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    SyncStateEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfActiveChannelIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activeChannelIds");
                    int _cursorIndexOfActiveQueryIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activeQueryIds");
                    int _cursorIndexOfLastSyncedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastSyncedAt");
                    int _cursorIndexOfMarkedAllReadAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markedAllReadAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmp = _cursor.getString(_cursorIndexOfActiveChannelIds);
                        List<String> _tmpActiveChannelIds = SyncStateDao_Impl.this.__listConverter.stringToStringList(_tmp);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfActiveQueryIds);
                        List<String> _tmpActiveQueryIds = SyncStateDao_Impl.this.__listConverter.stringToStringList(_tmp_1);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfLastSyncedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastSyncedAt));
                        Date _tmpLastSyncedAt = SyncStateDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfMarkedAllReadAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfMarkedAllReadAt));
                        Date _tmpMarkedAllReadAt = SyncStateDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        _result = new SyncStateEntity(_tmpUserId, _tmpActiveChannelIds, _tmpActiveQueryIds, _tmpLastSyncedAt, _tmpMarkedAllReadAt);
                    } else {
                        _result = null;
                    }
                    SyncStateEntity syncStateEntity = _result;
                    return syncStateEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }
}

