/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.utils;

import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.livedata.utils.ComputeUnreadCountKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0001\u00a2\u0006\u0002\u0010\nJ\r\u0010 \u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010!J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u000e\u0010&\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u000eH\u0016J\u0018\u0010'\u001a\u00020#2\u000e\u0010&\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010\u00a8\u0006("}, d2={"Lio/getstream/chat/android/livedata/utils/ChannelUnreadCountLiveData;", "Landroidx/lifecycle/LiveData;", "", "currentUser", "Lio/getstream/chat/android/client/models/User;", "readLiveData", "Lio/getstream/chat/android/client/models/ChannelUserRead;", "messagesLiveData", "", "Lio/getstream/chat/android/client/models/Message;", "(Lio/getstream/chat/android/client/models/User;Landroidx/lifecycle/LiveData;Landroidx/lifecycle/LiveData;)V", "getCurrentUser", "()Lio/getstream/chat/android/client/models/User;", "messageObserver", "Landroidx/lifecycle/Observer;", "getMessageObserver", "()Landroidx/lifecycle/Observer;", "messages", "getMessages", "()Ljava/util/List;", "setMessages", "(Ljava/util/List;)V", "getMessagesLiveData", "()Landroidx/lifecycle/LiveData;", "read", "getRead", "()Lio/getstream/chat/android/client/models/ChannelUserRead;", "setRead", "(Lio/getstream/chat/android/client/models/ChannelUserRead;)V", "getReadLiveData", "readObserver", "getReadObserver", "calculateUnreadCount", "()Ljava/lang/Integer;", "observe", "", "owner", "Landroidx/lifecycle/LifecycleOwner;", "observer", "observeForever", "stream-chat-android-offline_release"})
public final class ChannelUnreadCountLiveData
extends LiveData<Integer> {
    @Nullable
    private ChannelUserRead read;
    @Nullable
    private List<Message> messages;
    @NotNull
    private final Observer<ChannelUserRead> readObserver;
    @NotNull
    private final Observer<List<Message>> messageObserver;
    @NotNull
    private final User currentUser;
    @NotNull
    private final LiveData<ChannelUserRead> readLiveData;
    @NotNull
    private final LiveData<List<Message>> messagesLiveData;

    @Nullable
    public final ChannelUserRead getRead() {
        return this.read;
    }

    public final void setRead(@Nullable ChannelUserRead channelUserRead) {
        this.read = channelUserRead;
    }

    @Nullable
    public final List<Message> getMessages() {
        return this.messages;
    }

    public final void setMessages(@Nullable List<Message> list) {
        this.messages = list;
    }

    @NotNull
    public final Observer<ChannelUserRead> getReadObserver() {
        return this.readObserver;
    }

    @NotNull
    public final Observer<List<Message>> getMessageObserver() {
        return this.messageObserver;
    }

    public void observe(@NotNull LifecycleOwner owner, @NotNull Observer<? super Integer> observer) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(observer, (String)"observer");
        super.observe(owner, observer);
        this.readLiveData.observe(owner, this.readObserver);
        this.messagesLiveData.observe(owner, this.messageObserver);
    }

    public void observeForever(@NotNull Observer<? super Integer> observer) {
        Intrinsics.checkNotNullParameter(observer, (String)"observer");
        super.observeForever(observer);
        this.readLiveData.observeForever(this.readObserver);
        this.messagesLiveData.observeForever(this.messageObserver);
    }

    @Nullable
    public final synchronized Integer calculateUnreadCount() {
        return ComputeUnreadCountKt.computeUnreadCount(this.currentUser, this.read, this.messages);
    }

    @NotNull
    public final User getCurrentUser() {
        return this.currentUser;
    }

    @NotNull
    public final LiveData<ChannelUserRead> getReadLiveData() {
        return this.readLiveData;
    }

    @NotNull
    public final LiveData<List<Message>> getMessagesLiveData() {
        return this.messagesLiveData;
    }

    public ChannelUnreadCountLiveData(@NotNull User currentUser, @NotNull LiveData<ChannelUserRead> readLiveData, @NotNull LiveData<List<Message>> messagesLiveData) {
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        Intrinsics.checkNotNullParameter(readLiveData, (String)"readLiveData");
        Intrinsics.checkNotNullParameter(messagesLiveData, (String)"messagesLiveData");
        this.currentUser = currentUser;
        this.readLiveData = readLiveData;
        this.messagesLiveData = messagesLiveData;
        this.readObserver = (Observer)new Observer<ChannelUserRead>(this){
            final /* synthetic */ ChannelUnreadCountLiveData this$0;

            public final void onChanged(ChannelUserRead read) {
                block0: {
                    this.this$0.setRead(read);
                    Integer n = this.this$0.calculateUnreadCount();
                    if (n == null) break block0;
                    Integer n2 = n;
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = ((Number)n2).intValue();
                    boolean bl3 = false;
                    ChannelUnreadCountLiveData.access$setValue(this.this$0, it);
                }
            }
            {
                this.this$0 = channelUnreadCountLiveData;
            }
        };
        this.messageObserver = (Observer)new Observer<List<? extends Message>>(this){
            final /* synthetic */ ChannelUnreadCountLiveData this$0;

            public final void onChanged(List<Message> messages) {
                block0: {
                    this.this$0.setMessages(messages);
                    Integer n = this.this$0.calculateUnreadCount();
                    if (n == null) break block0;
                    Integer n2 = n;
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = ((Number)n2).intValue();
                    boolean bl3 = false;
                    ChannelUnreadCountLiveData.access$setValue(this.this$0, it);
                }
            }
            {
                this.this$0 = channelUnreadCountLiveData;
            }
        };
    }

    public static final /* synthetic */ void access$setValue(ChannelUnreadCountLiveData $this, Integer p0) {
        $this.setValue(p0);
    }
}

