/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.utils;

import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a1\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"computeUnreadCount", "", "currentUser", "Lio/getstream/chat/android/client/models/User;", "read", "Lio/getstream/chat/android/client/models/ChannelUserRead;", "messages", "", "Lio/getstream/chat/android/client/models/Message;", "(Lio/getstream/chat/android/client/models/User;Lio/getstream/chat/android/client/models/ChannelUserRead;Ljava/util/List;)Ljava/lang/Integer;", "stream-chat-android-offline_release"})
public final class ComputeUnreadCountKt {
    @Nullable
    public static final Integer computeUnreadCount(@NotNull User currentUser, @Nullable ChannelUserRead read, @Nullable List<Message> messages) {
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        Integer unreadMessageCount = null;
        if (messages != null) {
            Date lastRead;
            unreadMessageCount = 0;
            ChannelUserRead channelUserRead = read;
            Date date = lastRead = channelUserRead != null ? channelUserRead.getLastRead() : null;
            long lastReadTime = date != null ? date.getTime() : 0L;
            String currentUserId = currentUser.getId();
            for (Message m : CollectionsKt.reversed((Iterable)messages)) {
                if (Intrinsics.areEqual((Object)m.getUser().getId(), (Object)currentUserId) || m.getDeletedAt() != null || m.getSilent()) continue;
                Date date2 = m.getCreatedAt();
                if (date2 == null) {
                    date2 = m.getCreatedLocallyAt();
                }
                if ((date2 != null ? date2.getTime() : lastReadTime) <= lastReadTime) continue;
                int n = unreadMessageCount;
                unreadMessageCount = n + 1;
            }
        }
        return unreadMessageCount;
    }
}

