/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.entity;

import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import io.getstream.chat.android.client.models.Reaction;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.utils.SyncStatus;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\t\u00100\u001a\u00020\u0006H\u00c6\u0003J\t\u00101\u001a\u00020\u0006H\u00c6\u0003J\t\u00102\u001a\u00020\u0006H\u00c6\u0003J'\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u00020\u001eH\u00d6\u0001J\u001a\u00108\u001a\u00020\u00032\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020;0:J\t\u0010<\u001a\u00020\u0006H\u00d6\u0001R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR&\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001a\"\u0004\b*\u0010\u001cR\u001c\u0010+\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\r\"\u0004\b-\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001a\"\u0004\b/\u0010\u001c\u00a8\u0006="}, d2={"Lio/getstream/chat/android/livedata/entity/ReactionEntity;", "", "r", "Lio/getstream/chat/android/client/models/Reaction;", "(Lio/getstream/chat/android/client/models/Reaction;)V", "messageId", "", "userId", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "createdAt", "Ljava/util/Date;", "getCreatedAt", "()Ljava/util/Date;", "setCreatedAt", "(Ljava/util/Date;)V", "deletedAt", "getDeletedAt", "setDeletedAt", "extraData", "", "getExtraData", "()Ljava/util/Map;", "setExtraData", "(Ljava/util/Map;)V", "getMessageId", "()Ljava/lang/String;", "setMessageId", "(Ljava/lang/String;)V", "score", "", "getScore", "()I", "setScore", "(I)V", "syncStatus", "Lio/getstream/chat/android/client/utils/SyncStatus;", "getSyncStatus", "()Lio/getstream/chat/android/client/utils/SyncStatus;", "setSyncStatus", "(Lio/getstream/chat/android/client/utils/SyncStatus;)V", "getType", "setType", "updatedAt", "getUpdatedAt", "setUpdatedAt", "getUserId", "setUserId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toReaction", "userMap", "", "Lio/getstream/chat/android/client/models/User;", "toString", "stream-chat-android-offline_release"})
@Entity(tableName="stream_chat_reaction", indices={@Index(unique=true, value={"messageId", "userId", "type"}), @Index(value={"syncStatus"})})
public final class ReactionEntity {
    private int score;
    @Nullable
    private Date createdAt;
    @Nullable
    private Date updatedAt;
    @Nullable
    private Date deletedAt;
    @NotNull
    private Map<String, Object> extraData;
    @NotNull
    private SyncStatus syncStatus;
    @PrimaryKey
    @NotNull
    private String messageId;
    @NotNull
    private String userId;
    @NotNull
    private String type;

    public final int getScore() {
        return this.score;
    }

    public final void setScore(int n) {
        this.score = n;
    }

    @Nullable
    public final Date getCreatedAt() {
        return this.createdAt;
    }

    public final void setCreatedAt(@Nullable Date date) {
        this.createdAt = date;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    public final void setUpdatedAt(@Nullable Date date) {
        this.updatedAt = date;
    }

    @Nullable
    public final Date getDeletedAt() {
        return this.deletedAt;
    }

    public final void setDeletedAt(@Nullable Date date) {
        this.deletedAt = date;
    }

    @NotNull
    public final Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public final void setExtraData(@NotNull Map<String, Object> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.extraData = map2;
    }

    @NotNull
    public final SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public final void setSyncStatus(@NotNull SyncStatus syncStatus) {
        Intrinsics.checkNotNullParameter((Object)syncStatus, (String)"<set-?>");
        this.syncStatus = syncStatus;
    }

    @NotNull
    public final Reaction toReaction(@NotNull Map<String, User> userMap) {
        Intrinsics.checkNotNullParameter(userMap, (String)"userMap");
        Reaction r = new Reaction(this.messageId, this.type, this.score, null, null, null, null, null, null, 504, null);
        r.setUserId(this.userId);
        User user = userMap.get(this.userId);
        if (user == null) {
            String string = "userMap is missing the user for this reaction";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        r.setUser(user);
        Map map2 = this.extraData;
        if (map2 == null) {
            boolean bl = false;
            map2 = new LinkedHashMap();
        }
        r.setExtraData(map2);
        r.setCreatedAt(this.createdAt);
        r.setUpdatedAt(this.updatedAt);
        SyncStatus syncStatus = this.syncStatus;
        if (syncStatus == null) {
            syncStatus = SyncStatus.COMPLETED;
        }
        r.setSyncStatus(syncStatus);
        return r;
    }

    @NotNull
    public final String getMessageId() {
        return this.messageId;
    }

    public final void setMessageId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.messageId = string;
    }

    @NotNull
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.userId = string;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final void setType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.type = string;
    }

    public ReactionEntity(@NotNull String messageId, @NotNull String userId, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.messageId = messageId;
        this.userId = userId;
        this.type = type;
        this.score = 1;
        boolean bl = false;
        this.extraData = new LinkedHashMap();
        this.syncStatus = SyncStatus.COMPLETED;
    }

    public ReactionEntity(@NotNull Reaction r) {
        SyncStatus syncStatus;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this(r.getMessageId(), r.fetchUserId(), r.getType());
        this.score = r.getScore();
        this.createdAt = r.getCreatedAt();
        this.updatedAt = r.getUpdatedAt();
        Map map2 = r.getExtraData();
        if (map2 == null) {
            boolean bl = false;
            map2 = this.extraData = (Map)new LinkedHashMap();
        }
        if ((syncStatus = r.getSyncStatus()) == null) {
            syncStatus = SyncStatus.COMPLETED;
        }
        this.syncStatus = syncStatus;
    }

    @NotNull
    public final String component1() {
        return this.messageId;
    }

    @NotNull
    public final String component2() {
        return this.userId;
    }

    @NotNull
    public final String component3() {
        return this.type;
    }

    @NotNull
    public final ReactionEntity copy(@NotNull String messageId, @NotNull String userId, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new ReactionEntity(messageId, userId, type);
    }

    public static /* synthetic */ ReactionEntity copy$default(ReactionEntity reactionEntity, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = reactionEntity.messageId;
        }
        if ((n & 2) != 0) {
            string2 = reactionEntity.userId;
        }
        if ((n & 4) != 0) {
            string3 = reactionEntity.type;
        }
        return reactionEntity.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "ReactionEntity(messageId=" + this.messageId + ", userId=" + this.userId + ", type=" + this.type + ")";
    }

    public int hashCode() {
        String string = this.messageId;
        String string2 = this.userId;
        String string3 = this.type;
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ReactionEntity)) break block3;
                ReactionEntity reactionEntity = (ReactionEntity)object;
                if (!Intrinsics.areEqual((Object)this.messageId, (Object)reactionEntity.messageId) || !Intrinsics.areEqual((Object)this.userId, (Object)reactionEntity.userId) || !Intrinsics.areEqual((Object)this.type, (Object)reactionEntity.type)) break block3;
            }
            return true;
        }
        return false;
    }
}

