/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.utils;

import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.livedata.utils.ComputeUnreadCountKt;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a5\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"computeUnreadCount", "", "currentUser", "Lio/getstream/chat/android/client/models/User;", "read", "Lio/getstream/chat/android/client/models/ChannelUserRead;", "messages", "", "Lio/getstream/chat/android/client/models/Message;", "(Lio/getstream/chat/android/client/models/User;Lio/getstream/chat/android/client/models/ChannelUserRead;Ljava/util/List;)Ljava/lang/Integer;", "stream-chat-android-offline_release"})
public final class ComputeUnreadCountKt {
    @Nullable
    public static final Integer computeUnreadCount(@NotNull User currentUser, @Nullable ChannelUserRead read, @Nullable List<Message> messages) {
        int n;
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        TaggedLogger logger = ChatLogger.Companion.get((Object)"computeUnreadCount");
        if (messages == null) {
            logger.logD("Messages null; returning null");
            return null;
        }
        List validMessages2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)messages), (Function1)((Function1)new Function1<Message, Boolean>(currentUser){
            final /* synthetic */ User $currentUser;

            public final boolean invoke(@NotNull Message it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getUser().getId(), (Object)this.$currentUser.getId()) ^ true;
            }
            {
                this.$currentUser = user;
                super(1);
            }
        })), (Function1)computeUnreadCount.validMessages.2.INSTANCE), (Function1)computeUnreadCount.validMessages.3.INSTANCE));
        if (read == null) {
            logger.logD("Read null; treating as if no reads and all messages unread (" + validMessages2.size() + ')');
            return validMessages2.size();
        }
        Date date = read.getLastRead();
        if (date == null) {
            throw (Throwable)new IllegalStateException("ChannelUserRead instance for " + read.getUser().getId() + " missing lastRead date");
        }
        Date lastRead = date;
        if (validMessages2.size() <= 1) {
            logger.logD("Zero or one message; returning ChannelUserRead::unreadMessages (" + read.getUnreadMessages() + ')');
            return read.getUnreadMessages();
        }
        Iterable $this$count$iv = validMessages2;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Message message22 = (Message)element$iv;
                boolean bl = false;
                Date date2 = message22.getCreatedAt();
                if (date2 == null) {
                    date2 = message22.getCreatedLocallyAt();
                }
                if (date2 == null) {
                    throw (Throwable)new IllegalStateException("Message " + message22.getId() + " missing creation date");
                }
                Date messageCreatedAt = date2;
                boolean bl2 = lastRead.before(messageCreatedAt);
                boolean bl3 = false;
                boolean bl4 = false;
                boolean unread = bl2;
                boolean bl5 = false;
                logger.logD("Last read @ [" + lastRead + "] is " + (unread ? "before" : "the same or older than") + " [" + messageCreatedAt + ']');
                if (!bl2) continue;
                int message22 = ++count$iv;
                bl = false;
                if (message22 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n2 = n;
        boolean bl = false;
        boolean bl6 = false;
        int count = n2;
        boolean bl7 = false;
        logger.logD("Counted " + count + " unread messages");
        int unreadFromServerFactor = read.getUnreadMessages() > 0 ? 1 : 0;
        int calculated = read.getUnreadMessages() + count - unreadFromServerFactor;
        logger.logD("Calculated " + calculated + " unread messages (ChannelUserRead::unreadMessages (" + read.getUnreadMessages() + ") + counted (" + count + ") - unreadFromServer (" + unreadFromServerFactor + ')');
        return calculated;
    }

    public static /* synthetic */ Integer computeUnreadCount$default(User user, ChannelUserRead channelUserRead, List list, int n, Object object) {
        if ((n & 2) != 0) {
            channelUserRead = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        return ComputeUnreadCountKt.computeUnreadCount(user, channelUserRead, list);
    }
}

