/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.FlowLiveDataConversions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.api.models.QueryChannelsRequest;
import io.getstream.chat.android.client.api.models.QuerySort;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.MarkAllReadEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Config;
import io.getstream.chat.android.client.models.Filters;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.Mute;
import io.getstream.chat.android.client.models.TypingEvent;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.utils.FilterObject;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.client.utils.observable.Disposable;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.chat.android.livedata.ChatDatabase;
import io.getstream.chat.android.livedata.ChatDomain;
import io.getstream.chat.android.livedata.ChatDomainImpl;
import io.getstream.chat.android.livedata.ChatDomainImplKt;
import io.getstream.chat.android.livedata.ChatDomainImplKt$sam$androidx_lifecycle_Observer$0;
import io.getstream.chat.android.livedata.EventHandlerImpl;
import io.getstream.chat.android.livedata.controller.ChannelControllerImpl;
import io.getstream.chat.android.livedata.controller.QueryChannelsControllerImpl;
import io.getstream.chat.android.livedata.controller.QueryChannelsSpec;
import io.getstream.chat.android.livedata.entity.ChannelEntity;
import io.getstream.chat.android.livedata.entity.ReactionEntity;
import io.getstream.chat.android.livedata.entity.SyncStateEntity;
import io.getstream.chat.android.livedata.extensions.ClientExtensionsKt;
import io.getstream.chat.android.livedata.repository.MessageRepository;
import io.getstream.chat.android.livedata.repository.QueryChannelsRepository;
import io.getstream.chat.android.livedata.repository.RepositoryFactory;
import io.getstream.chat.android.livedata.repository.RepositoryHelper;
import io.getstream.chat.android.livedata.request.AnyChannelPaginationRequest;
import io.getstream.chat.android.livedata.request.MapperKt;
import io.getstream.chat.android.livedata.request.QueryChannelPaginationRequest;
import io.getstream.chat.android.livedata.request.QueryChannelsPaginationRequest;
import io.getstream.chat.android.livedata.service.sync.BackgroundSyncConfig;
import io.getstream.chat.android.livedata.service.sync.EncryptedBackgroundSyncConfigStore;
import io.getstream.chat.android.livedata.service.sync.SyncProvider;
import io.getstream.chat.android.livedata.usecase.UseCaseHelper;
import io.getstream.chat.android.livedata.utils.DefaultRetryPolicy;
import io.getstream.chat.android.livedata.utils.Event;
import io.getstream.chat.android.livedata.utils.RetryPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bd\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001e*\u00019\b\u0000\u0018\u0000 \u00f4\u00012\u00020\u0001:\u0002\u00f4\u0001B?\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB_\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0013J\u0011\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u0097\u0001\u001a\u00020\u001aJ\u0013\u0010\u0098\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u0099\u0001\u001a\u00020'H\u0002J\u0015\u0010\u009a\u0001\u001a\b\u0012\u0004\u0012\u00020'0\u001dH\u0000\u00a2\u0006\u0003\b\u009b\u0001J\u0019\u0010\u009c\u0001\u001a\u00020'2\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001H\u0000\u00a2\u0006\u0003\b\u009f\u0001J\u0018\u0010\u009c\u0001\u001a\u00020'2\u0007\u0010\u00a0\u0001\u001a\u00020&H\u0000\u00a2\u0006\u0003\b\u009f\u0001J!\u0010\u009c\u0001\u001a\u00020'2\u0007\u0010\u00a1\u0001\u001a\u00020&2\u0007\u0010\u00a2\u0001\u001a\u00020&H\u0000\u00a2\u0006\u0003\b\u009f\u0001J\n\u0010\u00a3\u0001\u001a\u00030\u0096\u0001H\u0016J\n\u0010\u00a4\u0001\u001a\u00030\u0096\u0001H\u0002J\u001f\u0010\u00a5\u0001\u001a\u00030\u0096\u00012\t\b\u0002\u0010\u00a6\u0001\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a7\u0001J%\u0010\u00a8\u0001\u001a\n\u0012\u0005\u0012\u00030\u009e\u00010\u00a9\u00012\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00aa\u0001J#\u0010\u00ab\u0001\u001a\u00020\u00112\u0007\u0010\u00ac\u0001\u001a\u00020\f2\u0007\u0010\u00ad\u0001\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\u00ae\u0001\u001a\u00030\u0096\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00af\u0001J\u0007\u0010\u00b0\u0001\u001a\u00020&J\u000f\u0010\u00b1\u0001\u001a\b\u0012\u0004\u0012\u00020)0\u001dH\u0016J\u0012\u0010\u00b2\u0001\u001a\u00020L2\u0007\u0010\u00a1\u0001\u001a\u00020&H\u0016J\t\u0010\u00b3\u0001\u001a\u00020&H\u0016J\n\u0010\u00b4\u0001\u001a\u00030\u0096\u0001H\u0002J\u0010\u0010\u00b5\u0001\u001a\u00020\u00072\u0007\u0010\u00a0\u0001\u001a\u00020&J\t\u0010\u00b6\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u00b7\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u00b8\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u00b9\u0001\u001a\u00020\u0007H\u0002J\"\u0010\u00ba\u0001\u001a\u00020)2\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u00012\u000f\u0010\u00bd\u0001\u001a\n\u0012\u0005\u0012\u00030\u009e\u00010\u00be\u0001J&\u0010\u00bf\u0001\u001a\u0010\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u00c0\u00010\u001d0\u00a9\u00012\r\u0010\u00c1\u0001\u001a\b\u0012\u0004\u0012\u00020&0\u001dH\u0002J.\u0010\u00c2\u0001\u001a\u0010\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u00c0\u00010\u001d0\u00a9\u00012\u000b\b\u0002\u0010\u00a0\u0001\u001a\u0004\u0018\u00010&H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00c3\u0001J\u0014\u0010\u00c4\u0001\u001a\u00030\u0096\u0001H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00af\u0001J\u001d\u0010\u00c5\u0001\u001a\t\u0012\u0005\u0012\u00030\u00c6\u00010\u001dH\u0081@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00c7\u0001\u0010\u00af\u0001J?\u0010\u00c8\u0001\u001a\n\u0012\u0005\u0012\u0003H\u00c9\u00010\u00a9\u0001\"\n\b\u0000\u0010\u00c9\u0001*\u00030\u00ca\u00012\u0016\u0010\u00cb\u0001\u001a\u0011\u0012\f\u0012\n\u0012\u0005\u0012\u0003H\u00c9\u00010\u00cd\u00010\u00cc\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ce\u0001J)\u0010\u00cf\u0001\u001a\u0005\u0018\u00010\u009e\u00012\u0007\u0010\u00a2\u0001\u001a\u00020&2\b\u0010\u00d0\u0001\u001a\u00030\u00d1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d2\u0001J)\u0010\u00cf\u0001\u001a\u0005\u0018\u00010\u009e\u00012\u0007\u0010\u00a2\u0001\u001a\u00020&2\b\u0010\u00d0\u0001\u001a\u00030\u00d3\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d4\u0001J3\u0010\u00d5\u0001\u001a\t\u0012\u0005\u0012\u00030\u009e\u00010\u001d2\r\u0010\u00d6\u0001\u001a\b\u0012\u0004\u0012\u00020&0\u001d2\b\u0010\u00d0\u0001\u001a\u00030\u00d7\u0001H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d8\u0001J3\u0010\u00d5\u0001\u001a\t\u0012\u0005\u0012\u00030\u009e\u00010\u001d2\r\u0010\u00d6\u0001\u001a\b\u0012\u0004\u0012\u00020&0\u001d2\b\u0010\u00d0\u0001\u001a\u00030\u00d3\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d9\u0001J\u0011\u0010\u00da\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u00db\u0001\u001a\u00020\u0007J\u0011\u0010\u00dc\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u00dd\u0001\u001a\u00020\u0017J\u0010\u0010\u00de\u0001\u001a\u00030\u0096\u0001H\u0000\u00a2\u0006\u0003\b\u00df\u0001J\u0010\u0010\u00e0\u0001\u001a\u00030\u0096\u0001H\u0000\u00a2\u0006\u0003\b\u00e1\u0001J\u0010\u0010\u00e2\u0001\u001a\u00030\u0096\u0001H\u0000\u00a2\u0006\u0003\b\u00e3\u0001J\u0011\u0010\u00e4\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u00dd\u0001\u001a\u00020\u0017J\u0019\u0010\u00e5\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u00ad\u0001\u001a\u00020\u000fH\u0000\u00a2\u0006\u0003\b\u00e6\u0001J\n\u0010\u00e7\u0001\u001a\u00030\u0096\u0001H\u0002J\n\u0010\u00e8\u0001\u001a\u00030\u0096\u0001H\u0002J\n\u0010\u00e9\u0001\u001a\u00030\u0096\u0001H\u0002J\u001e\u0010\u00ea\u0001\u001a\u00030\u0096\u00012\b\u0010\u009c\u0001\u001a\u00030\u009e\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00aa\u0001J$\u0010\u00eb\u0001\u001a\u00030\u0096\u00012\u000e\u0010\u00ec\u0001\u001a\t\u0012\u0005\u0012\u00030\u009e\u00010\u001dH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ed\u0001J\u0018\u0010\u00ee\u0001\u001a\u0004\u0018\u00010[H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00ef\u0001\u0010\u00af\u0001J \u0010\u00f0\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u00f1\u0001\u001a\u00020\u000fH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00f2\u0001\u0010\u00f3\u0001R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00190\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020)0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010\n\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u000703X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u001703X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00105R\u0010\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010:R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020\u000fX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010F\"\u0004\bJ\u0010HR\u001a\u0010K\u001a\u00020LX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR \u0010Q\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u001903X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u00105R\u0014\u0010S\u001a\u00020TX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR\u000e\u0010W\u001a\u00020XX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010Y\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010[0ZX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001a\u0010`\u001a\b\u0012\u0004\u0012\u00020\u000703X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u00105R\u0014\u0010b\u001a\u00020cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010eR\u000e\u0010f\u001a\u00020gX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010h\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d03X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u00105R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010/\"\u0004\bk\u00101R\u001a\u0010l\u001a\b\u0012\u0004\u0012\u00020\u000703X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u00105R\u001a\u0010\b\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010/\"\u0004\bo\u00101R\u001a\u0010p\u001a\u00020qX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\br\u0010s\"\u0004\bt\u0010uR\u001a\u0010v\u001a\u00020wX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bx\u0010y\"\u0004\bz\u0010{R\u001c\u0010|\u001a\u00020}X\u0080\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0004\b~\u0010\u007f\"\u0006\b\u0080\u0001\u0010\u0081\u0001R!\u0010\u0082\u0001\u001a\u00030\u0083\u00018BX\u0082\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u0086\u0001\u0010\u0087\u0001\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R\u0011\u0010\u0088\u0001\u001a\u0004\u0018\u00010[X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0089\u0001\u001a\b\u0012\u0004\u0012\u00020\u001703X\u0096\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008a\u0001\u00105R\u001c\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020#03X\u0096\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008c\u0001\u00105R\u0018\u0010\u008d\u0001\u001a\u00030\u008e\u0001X\u0096\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001R\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0091\u0001\u0010A\"\u0005\b\u0092\u0001\u0010CR\u001c\u0010\t\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0093\u0001\u0010/\"\u0005\b\u0094\u0001\u00101\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u00f5\u0001"}, d2={"Lio/getstream/chat/android/livedata/ChatDomainImpl;", "Lio/getstream/chat/android/livedata/ChatDomain;", "client", "Lio/getstream/chat/android/client/ChatClient;", "handler", "Landroid/os/Handler;", "offlineEnabled", "", "recoveryEnabled", "userPresence", "backgroundSyncEnabled", "appContext", "Landroid/content/Context;", "(Lio/getstream/chat/android/client/ChatClient;Landroid/os/Handler;ZZZZLandroid/content/Context;)V", "userOverwrite", "Lio/getstream/chat/android/client/models/User;", "db", "Lio/getstream/chat/android/livedata/ChatDatabase;", "mainHandler", "(Lio/getstream/chat/android/client/ChatClient;Lio/getstream/chat/android/client/models/User;Lio/getstream/chat/android/livedata/ChatDatabase;Landroid/os/Handler;ZZZZLandroid/content/Context;)V", "_banned", "Lkotlinx/coroutines/flow/MutableStateFlow;", "_channelUnreadCount", "", "_errorEvent", "Lio/getstream/chat/android/livedata/utils/Event;", "Lio/getstream/chat/android/client/errors/ChatError;", "_initialized", "_mutedUsers", "", "Lio/getstream/chat/android/client/models/Mute;", "_online", "_totalUnreadCount", "_typingChannels", "Landroidx/lifecycle/MediatorLiveData;", "Lio/getstream/chat/android/client/models/TypingEvent;", "activeChannelMapImpl", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/getstream/chat/android/livedata/controller/ChannelControllerImpl;", "activeQueryMapImpl", "Lio/getstream/chat/android/livedata/controller/QueryChannelsControllerImpl;", "getAppContext$stream_chat_android_offline_release", "()Landroid/content/Context;", "setAppContext$stream_chat_android_offline_release", "(Landroid/content/Context;)V", "getBackgroundSyncEnabled$stream_chat_android_offline_release", "()Z", "setBackgroundSyncEnabled$stream_chat_android_offline_release", "(Z)V", "banned", "Landroidx/lifecycle/LiveData;", "getBanned", "()Landroidx/lifecycle/LiveData;", "channelUnreadCount", "getChannelUnreadCount", "cleanTask", "io/getstream/chat/android/livedata/ChatDomainImpl$cleanTask$1", "Lio/getstream/chat/android/livedata/ChatDomainImpl$cleanTask$1;", "getClient$stream_chat_android_offline_release", "()Lio/getstream/chat/android/client/ChatClient;", "setClient$stream_chat_android_offline_release", "(Lio/getstream/chat/android/client/ChatClient;)V", "currentUser", "getCurrentUser", "()Lio/getstream/chat/android/client/models/User;", "setCurrentUser", "(Lio/getstream/chat/android/client/models/User;)V", "database", "getDatabase", "()Lio/getstream/chat/android/livedata/ChatDatabase;", "setDatabase", "(Lio/getstream/chat/android/livedata/ChatDatabase;)V", "getDb$stream_chat_android_offline_release", "setDb$stream_chat_android_offline_release", "defaultConfig", "Lio/getstream/chat/android/client/models/Config;", "getDefaultConfig", "()Lio/getstream/chat/android/client/models/Config;", "setDefaultConfig", "(Lio/getstream/chat/android/client/models/Config;)V", "errorEvents", "getErrorEvents", "eventHandler", "Lio/getstream/chat/android/livedata/EventHandlerImpl;", "getEventHandler$stream_chat_android_offline_release", "()Lio/getstream/chat/android/livedata/EventHandlerImpl;", "eventSubscription", "Lio/getstream/chat/android/client/utils/observable/Disposable;", "initJob", "Lkotlinx/coroutines/Deferred;", "Lio/getstream/chat/android/livedata/entity/SyncStateEntity;", "getInitJob$stream_chat_android_offline_release", "()Lkotlinx/coroutines/Deferred;", "setInitJob$stream_chat_android_offline_release", "(Lkotlinx/coroutines/Deferred;)V", "initialized", "getInitialized", "job", "Lkotlinx/coroutines/CompletableJob;", "getJob$stream_chat_android_offline_release", "()Lkotlinx/coroutines/CompletableJob;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "muted", "getMuted", "getOfflineEnabled", "setOfflineEnabled", "online", "getOnline", "getRecoveryEnabled$stream_chat_android_offline_release", "setRecoveryEnabled$stream_chat_android_offline_release", "repos", "Lio/getstream/chat/android/livedata/repository/RepositoryHelper;", "getRepos$stream_chat_android_offline_release", "()Lio/getstream/chat/android/livedata/repository/RepositoryHelper;", "setRepos$stream_chat_android_offline_release", "(Lio/getstream/chat/android/livedata/repository/RepositoryHelper;)V", "retryPolicy", "Lio/getstream/chat/android/livedata/utils/RetryPolicy;", "getRetryPolicy", "()Lio/getstream/chat/android/livedata/utils/RetryPolicy;", "setRetryPolicy", "(Lio/getstream/chat/android/livedata/utils/RetryPolicy;)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope$stream_chat_android_offline_release", "()Lkotlinx/coroutines/CoroutineScope;", "setScope$stream_chat_android_offline_release", "(Lkotlinx/coroutines/CoroutineScope;)V", "syncModule", "Lio/getstream/chat/android/livedata/service/sync/SyncProvider;", "getSyncModule", "()Lio/getstream/chat/android/livedata/service/sync/SyncProvider;", "syncModule$delegate", "Lkotlin/Lazy;", "syncState", "totalUnreadCount", "getTotalUnreadCount", "typingUpdates", "getTypingUpdates", "useCases", "Lio/getstream/chat/android/livedata/usecase/UseCaseHelper;", "getUseCases", "()Lio/getstream/chat/android/livedata/usecase/UseCaseHelper;", "getUserOverwrite$stream_chat_android_offline_release", "setUserOverwrite$stream_chat_android_offline_release", "getUserPresence", "setUserPresence", "addError", "", "error", "addTypingChannel", "channelController", "allActiveChannels", "allActiveChannels$stream_chat_android_offline_release", "channel", "c", "Lio/getstream/chat/android/client/models/Channel;", "channel$stream_chat_android_offline_release", "cid", "channelType", "channelId", "clean", "clearState", "connectionRecovered", "recoveryNeeded", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createChannel", "Lio/getstream/chat/android/client/utils/Result;", "(Lio/getstream/chat/android/client/models/Channel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createDatabase", "context", "user", "disconnect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateMessageId", "getActiveQueries", "getChannelConfig", "getVersion", "initClean", "isActiveChannel", "isInitialized", "isOffline", "isOnline", "isTestRunner", "queryChannels", "filter", "Lio/getstream/chat/android/client/utils/FilterObject;", "sort", "Lio/getstream/chat/android/client/api/models/QuerySort;", "queryEvents", "Lio/getstream/chat/android/client/events/ChatEvent;", "cids", "replayEventsForActiveChannels", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retryFailedEntities", "retryMessages", "Lio/getstream/chat/android/client/models/Message;", "retryMessages$stream_chat_android_offline_release", "runAndRetry", "T", "", "runnable", "Lkotlin/Function0;", "Lio/getstream/chat/android/client/call/Call;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selectAndEnrichChannel", "pagination", "Lio/getstream/chat/android/livedata/request/QueryChannelPaginationRequest;", "(Ljava/lang/String;Lio/getstream/chat/android/livedata/request/QueryChannelPaginationRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/getstream/chat/android/livedata/request/QueryChannelsPaginationRequest;", "(Ljava/lang/String;Lio/getstream/chat/android/livedata/request/QueryChannelsPaginationRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selectAndEnrichChannels", "channelIds", "Lio/getstream/chat/android/livedata/request/AnyChannelPaginationRequest;", "(Ljava/util/List;Lio/getstream/chat/android/livedata/request/AnyChannelPaginationRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/util/List;Lio/getstream/chat/android/livedata/request/QueryChannelsPaginationRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setBanned", "newBanned", "setChannelUnreadCount", "newCount", "setInitialized", "setInitialized$stream_chat_android_offline_release", "setOffline", "setOffline$stream_chat_android_offline_release", "setOnline", "setOnline$stream_chat_android_offline_release", "setTotalUnreadCount", "setUser", "setUser$stream_chat_android_offline_release", "startListening", "stopClean", "stopListening", "storeStateForChannel", "storeStateForChannels", "channelsResponse", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "storeSyncState", "storeSyncState$stream_chat_android_offline_release", "updateCurrentUser", "me", "updateCurrentUser$stream_chat_android_offline_release", "(Lio/getstream/chat/android/client/models/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "stream-chat-android-offline_release"})
public final class ChatDomainImpl
implements ChatDomain {
    private final MutableStateFlow<Boolean> _initialized;
    private final MutableStateFlow<Boolean> _online;
    private final MutableStateFlow<Integer> _totalUnreadCount;
    private final MutableStateFlow<Integer> _channelUnreadCount;
    private final MutableStateFlow<Event<ChatError>> _errorEvent;
    private final MutableStateFlow<Boolean> _banned;
    private final MutableStateFlow<List<Mute>> _mutedUsers;
    private final MediatorLiveData<TypingEvent> _typingChannels;
    public User currentUser;
    public ChatDatabase database;
    private final Lazy syncModule$delegate;
    @NotNull
    private final UseCaseHelper useCases;
    @NotNull
    private Config defaultConfig;
    @NotNull
    private final LiveData<Boolean> initialized;
    @NotNull
    private final LiveData<Boolean> online;
    @NotNull
    private final LiveData<Integer> totalUnreadCount;
    @NotNull
    private final LiveData<Integer> channelUnreadCount;
    @NotNull
    private final LiveData<List<Mute>> muted;
    @NotNull
    private final LiveData<Boolean> banned;
    @NotNull
    private final LiveData<Event<ChatError>> errorEvents;
    private Disposable eventSubscription;
    private final ConcurrentHashMap<String, ChannelControllerImpl> activeChannelMapImpl;
    @NotNull
    private final LiveData<TypingEvent> typingUpdates;
    private final ConcurrentHashMap<String, QueryChannelsControllerImpl> activeQueryMapImpl;
    @NotNull
    private final EventHandlerImpl eventHandler;
    private TaggedLogger logger;
    private final cleanTask.1 cleanTask;
    public RepositoryHelper repos;
    private SyncStateEntity syncState;
    public Deferred<SyncStateEntity> initJob;
    @NotNull
    private RetryPolicy retryPolicy;
    @NotNull
    private final CompletableJob job;
    @NotNull
    private CoroutineScope scope;
    @NotNull
    private ChatClient client;
    @Nullable
    private User userOverwrite;
    @Nullable
    private ChatDatabase db;
    private final Handler mainHandler;
    private boolean offlineEnabled;
    private boolean recoveryEnabled;
    private boolean userPresence;
    private boolean backgroundSyncEnabled;
    @NotNull
    private Context appContext;
    @NotNull
    private static final Disposable EMPTY_DISPOSABLE;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public User getCurrentUser() {
        User user = this.currentUser;
        if (user == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUser");
        }
        return user;
    }

    @Override
    public void setCurrentUser(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"<set-?>");
        this.currentUser = user;
    }

    @NotNull
    public final ChatDatabase getDatabase() {
        ChatDatabase chatDatabase = this.database;
        if (chatDatabase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"database");
        }
        return chatDatabase;
    }

    public final void setDatabase(@NotNull ChatDatabase chatDatabase) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatDatabase), (String)"<set-?>");
        this.database = chatDatabase;
    }

    private final SyncProvider getSyncModule() {
        Lazy lazy = this.syncModule$delegate;
        ChatDomainImpl chatDomainImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SyncProvider)lazy.getValue();
    }

    @Override
    @NotNull
    public UseCaseHelper getUseCases() {
        return this.useCases;
    }

    @NotNull
    public final Config getDefaultConfig() {
        return this.defaultConfig;
    }

    public final void setDefaultConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        this.defaultConfig = config;
    }

    @Override
    @NotNull
    public LiveData<Boolean> getInitialized() {
        return this.initialized;
    }

    @Override
    @NotNull
    public LiveData<Boolean> getOnline() {
        return this.online;
    }

    @Override
    @NotNull
    public LiveData<Integer> getTotalUnreadCount() {
        return this.totalUnreadCount;
    }

    @Override
    @NotNull
    public LiveData<Integer> getChannelUnreadCount() {
        return this.channelUnreadCount;
    }

    @Override
    @NotNull
    public LiveData<List<Mute>> getMuted() {
        return this.muted;
    }

    @Override
    @NotNull
    public LiveData<Boolean> getBanned() {
        return this.banned;
    }

    @Override
    @NotNull
    public LiveData<Event<ChatError>> getErrorEvents() {
        return this.errorEvents;
    }

    @Override
    @NotNull
    public LiveData<TypingEvent> getTypingUpdates() {
        return this.typingUpdates;
    }

    @NotNull
    public final EventHandlerImpl getEventHandler$stream_chat_android_offline_release() {
        return this.eventHandler;
    }

    @NotNull
    public final RepositoryHelper getRepos$stream_chat_android_offline_release() {
        RepositoryHelper repositoryHelper = this.repos;
        if (repositoryHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
        }
        return repositoryHelper;
    }

    public final void setRepos$stream_chat_android_offline_release(@NotNull RepositoryHelper repositoryHelper) {
        Intrinsics.checkNotNullParameter((Object)repositoryHelper, (String)"<set-?>");
        this.repos = repositoryHelper;
    }

    @NotNull
    public final Deferred<SyncStateEntity> getInitJob$stream_chat_android_offline_release() {
        Deferred<SyncStateEntity> deferred = this.initJob;
        if (deferred == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initJob");
        }
        return deferred;
    }

    public final void setInitJob$stream_chat_android_offline_release(@NotNull Deferred<SyncStateEntity> deferred) {
        Intrinsics.checkNotNullParameter(deferred, (String)"<set-?>");
        this.initJob = deferred;
    }

    @Override
    @NotNull
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public void setRetryPolicy(@NotNull RetryPolicy retryPolicy) {
        Intrinsics.checkNotNullParameter((Object)retryPolicy, (String)"<set-?>");
        this.retryPolicy = retryPolicy;
    }

    private final void clearState() {
        this._initialized.setValue((Object)false);
        this._online.setValue((Object)false);
        this._totalUnreadCount.setValue((Object)0);
        this._channelUnreadCount.setValue((Object)0);
        this._banned.setValue((Object)false);
        this._mutedUsers.setValue((Object)CollectionsKt.emptyList());
        this.activeChannelMapImpl.clear();
        this.activeQueryMapImpl.clear();
    }

    private final ChatDatabase createDatabase(Context context, User user, boolean offlineEnabled) {
        ChatDatabase chatDatabase;
        if (offlineEnabled) {
            chatDatabase = ChatDatabase.Companion.getDatabase(context, user.getId());
        } else {
            RoomDatabase roomDatabase = Room.inMemoryDatabaseBuilder((Context)context, ChatDatabase.class).build();
            Intrinsics.checkNotNullExpressionValue((Object)roomDatabase, (String)"Room.inMemoryDatabaseBui\u2026base::class.java).build()");
            chatDatabase = (ChatDatabase)roomDatabase;
        }
        return chatDatabase;
    }

    private final boolean isTestRunner() {
        String string = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Build.FINGERPRINT");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        return StringsKt.contains$default((CharSequence)string4, (CharSequence)"robolectric", (boolean)false, (int)2, null);
    }

    public final void setUser$stream_chat_android_offline_release(@NotNull User user) {
        ChatDatabase chatDatabase;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.clearState();
        this.setCurrentUser(user);
        if (this.backgroundSyncEnabled && !this.isTestRunner()) {
            String string = this.client.getConfig().getApiKey();
            String string2 = this.getCurrentUser().getId();
            String string3 = this.client.getCurrentToken();
            if (string3 == null) {
                string3 = "";
            }
            BackgroundSyncConfig config = new BackgroundSyncConfig(string, string2, string3);
            if (config.isValid()) {
                EncryptedBackgroundSyncConfigStore encryptedBackgroundSyncConfigStore2 = this.getSyncModule().getEncryptedBackgroundSyncConfigStore$stream_chat_android_offline_release();
                boolean bl = false;
                boolean bl2 = false;
                EncryptedBackgroundSyncConfigStore $this$apply = encryptedBackgroundSyncConfigStore2;
                boolean bl3 = false;
                $this$apply.put(config);
            }
        }
        if ((chatDatabase = this.db) == null) {
            chatDatabase = this.createDatabase(this.appContext, user, this.getOfflineEnabled());
        }
        ChatDatabase chatDatabase2 = this.database = chatDatabase;
        if (chatDatabase2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"database");
        }
        this.repos = new RepositoryHelper(new RepositoryFactory(chatDatabase2, this.client, user), this.scope);
        this.initJob = BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SyncStateEntity>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ ChatDomainImpl this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var20_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getRepos$stream_chat_android_offline_release().getConfigs().load((Continuation<? super Unit>)this);
                        if (v0 == var20_2) {
                            return var20_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        initialSyncState = new SyncStateEntity(this.this$0.getCurrentUser().getId(), null, null, null, null, 30, null);
                        var18_4 = this.this$0;
                        this.L$0 = initialSyncState;
                        this.L$1 = var18_4;
                        this.label = 2;
                        v1 = this.this$0.getRepos$stream_chat_android_offline_release().getSyncState().select(this.this$0.getCurrentUser().getId(), (Continuation<? super SyncStateEntity>)this);
                        if (v1 == var20_2) {
                            return var20_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        var18_4 = (ChatDomainImpl)this.L$1;
                        initialSyncState = (SyncStateEntity)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        if ((v2 = (SyncStateEntity)(var19_5 = v1)) == null) {
                            v2 = var2_3;
                        }
                        ChatDomainImpl.access$setSyncState$p(var18_4, v2);
                        v3 = ChatDomainImpl.access$getSyncState$p(this.this$0);
                        if (v3 == null) break;
                        var3_6 = v3;
                        var4_7 = false;
                        var5_8 = false;
                        state = var3_6;
                        $i$a$-let-ChatDomainImpl$setUser$2$1 = false;
                        $this$forEach$iv = state.getActiveChannelIds();
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (String)element$iv;
                            $i$a$-forEach-ChatDomainImpl$setUser$2$1$1 = false;
                            this.this$0.channel$stream_chat_android_offline_release(it);
                        }
                        this.L$0 = state;
                        this.L$1 = null;
                        this.label = 3;
                        v4 = this.this$0.getRepos$stream_chat_android_offline_release().getQueryChannels().selectById(state.getActiveQueryIds(), (Continuation<? super List<QueryChannelsSpec>>)this);
                        if (v4 == var20_2) {
                            return var20_2;
                        }
                        ** GOTO lbl58
                    }
                    case 3: {
                        $i$a$-let-ChatDomainImpl$setUser$2$1 = false;
                        state = (SyncStateEntity)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl58:
                        // 2 sources

                        $this$forEach$iv = (Iterable)v4;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            spec = (QueryChannelsSpec)element$iv;
                            $i$a$-forEach-ChatDomainImpl$setUser$2$1$2 = false;
                            this.this$0.queryChannels(spec.getFilter(), spec.getSort());
                        }
                        v5 = state.getMarkedAllReadAt();
                        if (v5 == null) break;
                        var8_12 = v5;
                        var9_13 = false;
                        var10_15 = false;
                        it = var8_12;
                        $i$a$-let-ChatDomainImpl$setUser$2$1$3 = false;
                        var13_20 = 0;
                        var14_21 = 0;
                        var15_22 = 0;
                        var16_23 = it;
                        var17_24 = this.this$0.getCurrentUser();
                        var8_12 = new MarkAllReadEvent(null, var16_23, var17_24, var15_22, var14_21, var13_20, 57, null);
                        var9_13 = false;
                        var10_15 = false;
                        it = var8_12;
                        $i$a$-let-ChatDomainImpl$setUser$2$1$4 = false;
                        this.L$0 = null;
                        this.label = 4;
                        v6 = this.this$0.getEventHandler$stream_chat_android_offline_release().handleEvent$stream_chat_android_offline_release((ChatEvent)it, (Continuation<? super Unit>)this);
                        if (v6 == var20_2) {
                            return var20_2;
                        }
                        break;
                    }
                    case 4: {
                        $i$a$-let-ChatDomainImpl$setUser$2$1 = false;
                        $i$a$-let-ChatDomainImpl$setUser$2$1$4 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
                    }
                }
                return ChatDomainImpl.access$getSyncState$p(this.this$0);
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = chatDomainImpl;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super SyncStateEntity>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (this.client.isSocketConnected()) {
            this.setOnline$stream_chat_android_offline_release();
        }
        this.startListening();
        this.initClean();
    }

    @NotNull
    public final CompletableJob getJob$stream_chat_android_offline_release() {
        return this.job;
    }

    @NotNull
    public final CoroutineScope getScope$stream_chat_android_offline_release() {
        return this.scope;
    }

    public final void setScope$stream_chat_android_offline_release(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"<set-?>");
        this.scope = coroutineScope;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateCurrentUser$stream_chat_android_offline_release(@NotNull User var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof updateCurrentUser.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateCurrentUser$stream_chat_android_offline_release(null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (Intrinsics.areEqual((Object)me.getId(), (Object)this.getCurrentUser().getId()) ^ true) {
                    throw (Throwable)new InputMismatchException("received connect event for user with id " + me.getId() + " while chat domain is configured for user with id " + this.getCurrentUser().getId() + ". create a new chatdomain when connecting a different user.");
                }
                this.setCurrentUser(me);
                v0 = this.repos;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = me;
                $continuation.label = 1;
                v1 = v0.getUsers().insertMe(me, (Continuation<? super Unit>)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                me = (User)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl30:
                // 2 sources

                this._mutedUsers.setValue((Object)me.getMutes());
                this.setTotalUnreadCount(me.getTotalUnreadCount());
                this.setChannelUnreadCount(me.getUnreadChannels());
                this.setBanned(me.getBanned());
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object storeSyncState$stream_chat_android_offline_release(@NotNull Continuation<? super SyncStateEntity> var1_1) {
        if (!(var1_1 instanceof storeSyncState.1)) ** GOTO lbl-1000
        var20_2 = var1_1;
        if ((var20_2.label & -2147483648) != 0) {
            var20_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.storeSyncState$stream_chat_android_offline_release((Continuation<? super SyncStateEntity>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var21_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.syncState;
                if (v0 == null) break;
                var2_5 = v0;
                var3_6 = false;
                var4_7 = false;
                syncState = var2_5;
                $i$a$-let-ChatDomainImpl$storeSyncState$2 = false;
                v1 = this.activeChannelMapImpl.keys();
                Intrinsics.checkNotNullExpressionValue(v1, (String)"activeChannelMapImpl.keys()");
                var7_11 = v1;
                var8_12 = false;
                v2 = Collections.list(var7_11);
                Intrinsics.checkNotNullExpressionValue(v2, (String)"java.util.Collections.list(this)");
                syncState.setActiveChannelIds((List<String>)v2);
                v3 = this.activeQueryMapImpl.values();
                Intrinsics.checkNotNullExpressionValue(v3, (String)"activeQueryMapImpl.values");
                var7_11 = CollectionsKt.toList((Iterable)v3);
                var9_13 = syncState;
                $i$f$map = false;
                var10_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var15_19 = (QueryChannelsControllerImpl)item$iv$iv;
                    var16_20 = destination$iv$iv;
                    $i$a$-map-ChatDomainImpl$storeSyncState$2$1 = false;
                    var18_22 = QueryChannelsRepository.Companion.getId$stream_chat_android_offline_release(it.getQueryChannelsSpec());
                    var16_20.add(var18_22);
                }
                var16_20 = (List)destination$iv$iv;
                var9_13.setActiveQueryIds((List<String>)var16_20);
                v4 = this.repos;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v5 = v4.getSyncState().insert(syncState, (Continuation<? super Unit>)$continuation);
                if (v5 == var21_4) {
                    return var21_4;
                }
                break;
            }
            case 1: {
                $i$a$-let-ChatDomainImpl$storeSyncState$2 = false;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
                break;
            }
        }
        return this.syncState;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object disconnect(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof disconnect.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.disconnect((Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.storeSyncState$stream_chat_android_offline_release((Continuation<? super SyncStateEntity>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                JobKt.cancelChildren$default((Job)((Job)this.job), null, (int)1, null);
                this.stopListening();
                this.stopClean();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public String getVersion() {
        return "4.4.7-release";
    }

    private final void stopClean() {
        this.mainHandler.removeCallbacks((Runnable)this.cleanTask);
    }

    private final void initClean() {
        this.mainHandler.postDelayed((Runnable)this.cleanTask, 5000L);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final <T> Object runAndRetry(@NotNull Function0<? extends Call<T>> var1_1, @NotNull Continuation<? super Result<T>> var2_2) {
        block8: {
            if (!(var2_2 instanceof runAndRetry.1)) ** GOTO lbl-1000
            var8_3 = var2_2;
            if ((var8_3.label & -2147483648) != 0) {
                var8_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    /* synthetic */ Object result;
                    int label;
                    final /* synthetic */ ChatDomainImpl this$0;
                    Object L$0;
                    Object L$1;
                    int I$0;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runAndRetry(null, this);
                    }
                    {
                        this.this$0 = chatDomainImpl;
                        super(continuation);
                    }
                };
            }
            $result = $continuation.result;
            var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block0 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    attempt = 1;
                    var4_7 = null;
lbl15:
                    // 2 sources

                    while (!(result = ((Call)runnable.invoke()).execute()).isSuccess() && !ClientExtensionsKt.isPermanent(result.error())) {
                        shouldRetry = this.getRetryPolicy().shouldRetry(this.client, attempt, result.error());
                        timeout = this.getRetryPolicy().retryTimeout(this.client, attempt, result.error());
                        if (!shouldRetry) break block0;
                        this.logger.logI("API call failed (attempt " + attempt + "), retrying in " + timeout + " seconds. Error was " + result.error());
                        $continuation.L$0 = this;
                        $continuation.L$1 = runnable;
                        $continuation.I$0 = attempt;
                        $continuation.label = 1;
                        v0 = DelayKt.delay((long)timeout, (Continuation)$continuation);
                        if (v0 == var9_5) {
                            return var9_5;
                        }
                        ** GOTO lbl35
                    }
                    break block8;
                }
                case 1: {
                    attempt = $continuation.I$0;
                    runnable = (Function0)$continuation.L$1;
                    this = (ChatDomainImpl)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl35:
                    // 2 sources

                    ++attempt;
                    ** GOTO lbl15
                }
            }
            this.logger.logI("API call failed (attempt " + attempt + "). Giving up for now, will retry when connection recovers. Error was " + result.error());
        }
        return result;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object createChannel(@NotNull Channel var1_1, @NotNull Continuation<? super Result<Channel>> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void addError(@NotNull ChatError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this._errorEvent.setValue(new Event<ChatError>(error));
    }

    public final boolean isActiveChannel(@NotNull String cid) {
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        return this.activeChannelMapImpl.containsKey(cid);
    }

    public final void setChannelUnreadCount(int newCount) {
        this._channelUnreadCount.setValue((Object)newCount);
    }

    public final void setBanned(boolean newBanned) {
        this._banned.setValue((Object)newBanned);
    }

    public final void setTotalUnreadCount(int newCount) {
        this._totalUnreadCount.setValue((Object)newCount);
    }

    private final void startListening() {
        if (this.eventSubscription.isDisposed()) {
            this.eventSubscription = this.client.subscribe((Function1)new Function1<ChatEvent, Unit>(this){
                final /* synthetic */ ChatDomainImpl this$0;

                public final void invoke(@NotNull ChatEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.getEventHandler$stream_chat_android_offline_release().handleEvents$stream_chat_android_offline_release(CollectionsKt.listOf((Object)it));
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(1);
                }
            });
        }
    }

    private final void stopListening() {
        this.eventSubscription.dispose();
    }

    @NotNull
    public final ChannelControllerImpl channel$stream_chat_android_offline_release(@NotNull Channel c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return this.channel$stream_chat_android_offline_release(c.getType(), c.getId());
    }

    @NotNull
    public final ChannelControllerImpl channel$stream_chat_android_offline_release(@NotNull String cid) {
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        if (!ChatDomainImplKt.access$getCHANNEL_CID_REGEX$p().matches((CharSequence)cid)) {
            throw (Throwable)new IllegalArgumentException("Received invalid cid, expected format messaging:123, got " + cid);
        }
        List parts = StringsKt.split$default((CharSequence)cid, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        return this.channel$stream_chat_android_offline_release((String)parts.get(0), (String)parts.get(1));
    }

    @NotNull
    public final ChannelControllerImpl channel$stream_chat_android_offline_release(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String string = "%s:%s";
        Object[] objectArray = new Object[]{channelType, channelId};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        String cid = string2;
        if (!this.activeChannelMapImpl.containsKey(cid)) {
            ChannelControllerImpl channelRepo = new ChannelControllerImpl(channelType, channelId, this.client, this);
            ((Map)this.activeChannelMapImpl).put(cid, channelRepo);
            BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, channelRepo, null){
                int label;
                final /* synthetic */ ChatDomainImpl this$0;
                final /* synthetic */ ChannelControllerImpl $channelRepo;

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ChatDomainImpl.access$addTypingChannel(this.this$0, this.$channelRepo);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = chatDomainImpl;
                    this.$channelRepo = channelControllerImpl;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return (ChannelControllerImpl)MapsKt.getValue((Map)this.activeChannelMapImpl, (Object)cid);
    }

    @NotNull
    public final List<ChannelControllerImpl> allActiveChannels$stream_chat_android_offline_release() {
        Collection<ChannelControllerImpl> collection = this.activeChannelMapImpl.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"activeChannelMapImpl.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    @NotNull
    public final String generateMessageId() {
        return this.getCurrentUser().getId() + "-" + UUID.randomUUID().toString();
    }

    private final void addTypingChannel(ChannelControllerImpl channelController) {
        Function1 function1 = (Function1)new Function1<TypingEvent, Unit>(this._typingChannels){

            public final void invoke(TypingEvent p1) {
                ((MediatorLiveData)this.receiver).postValue((Object)p1);
            }
        };
        this._typingChannels.addSource(channelController.getTyping(), (Observer)new ChatDomainImplKt$sam$androidx_lifecycle_Observer$0(function1));
    }

    public final void setOffline$stream_chat_android_offline_release() {
        this._online.setValue((Object)false);
    }

    public final void setOnline$stream_chat_android_offline_release() {
        this._online.setValue((Object)true);
    }

    public final void setInitialized$stream_chat_android_offline_release() {
        this._initialized.setValue((Object)true);
    }

    @Override
    public boolean isOnline() {
        return (Boolean)this._online.getValue();
    }

    @Override
    public boolean isOffline() {
        return (Boolean)this._online.getValue() == false;
    }

    @Override
    public boolean isInitialized() {
        return (Boolean)this._initialized.getValue();
    }

    @NotNull
    public List<QueryChannelsControllerImpl> getActiveQueries() {
        Collection<QueryChannelsControllerImpl> collection = this.activeQueryMapImpl.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"activeQueryMapImpl.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QueryChannelsControllerImpl queryChannels(@NotNull FilterObject filter, @NotNull QuerySort<Channel> sort) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        ConcurrentMap concurrentMap = this.activeQueryMapImpl;
        String key$iv = "" + filter.hashCode() + '-' + sort.hashCode();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            QueryChannelsControllerImpl queryChannelsControllerImpl = new QueryChannelsControllerImpl(filter, sort, this.client, this);
            boolean bl2 = false;
            boolean bl3 = false;
            QueryChannelsControllerImpl default$iv = queryChannelsControllerImpl;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"activeQueryMapImpl.getOr\u2026s\n            )\n        }");
        return (QueryChannelsControllerImpl)object;
    }

    private final Result<List<ChatEvent>> queryEvents(List<String> cids2) {
        Object object = this.syncState;
        if (object == null || (object = ((SyncStateEntity)object).getLastSyncedAt()) == null) {
            object = new Date();
        }
        return this.client.getSyncHistory(cids2, (Date)object).execute();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object replayEventsForActiveChannels(@Nullable String var1_1, @NotNull Continuation<? super Result<List<ChatEvent>>> var2_2) {
        block12: {
            if (!(var2_2 instanceof replayEventsForActiveChannels.1)) ** GOTO lbl-1000
            var16_3 = var2_2;
            if ((var16_3.label & -2147483648) != 0) {
                var16_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    /* synthetic */ Object result;
                    int label;
                    final /* synthetic */ ChatDomainImpl this$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.replayEventsForActiveChannels(null, (Continuation<? super Result<List<ChatEvent>>>)this);
                    }
                    {
                        this.this$0 = chatDomainImpl;
                        super(continuation);
                    }
                };
            }
            $result = $continuation.result;
            var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.initJob;
                    if (v0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"initJob");
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = cid;
                    $continuation.label = 1;
                    v1 = v0.join((Continuation)$continuation);
                    if (v1 == var17_5) {
                        return var17_5;
                    }
                    ** GOTO lbl27
                }
                case 1: {
                    cid = (String)$continuation.L$1;
                    this = (ChatDomainImpl)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl27:
                    // 2 sources

                    v2 = this.activeChannelMapImpl.keys();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"activeChannelMapImpl.keys()");
                    var4_6 = v2;
                    var5_7 = false;
                    v3 = Collections.list(var4_6);
                    Intrinsics.checkNotNullExpressionValue(v3, (String)"java.util.Collections.list(this)");
                    cids = CollectionsKt.toMutableList((Collection)v3);
                    v4 = cid;
                    if (v4 != null) {
                        var4_6 = v4;
                        var5_7 = false;
                        var6_10 = false;
                        it = var4_6;
                        $i$a$-let-ChatDomainImpl$replayEventsForActiveChannels$2 = false;
                        this.channel$stream_chat_android_offline_release((String)it);
                        Boxing.boxBoolean((boolean)cids.add(it));
                    }
                    now = new Date();
                    var5_8 = cids;
                    var6_10 = false;
                    if (!(var5_8.isEmpty() == false)) break;
                    var5_8 = this.queryEvents(cids);
                    var6_10 = false;
                    var7_12 = false;
                    resultChatEvent = var5_8;
                    $i$a$-also-ChatDomainImpl$replayEventsForActiveChannels$3 = false;
                    if (!resultChatEvent.isSuccess()) ** GOTO lbl80
                    $continuation.L$0 = this;
                    $continuation.L$1 = now;
                    $continuation.L$2 = var5_8;
                    $continuation.label = 2;
                    v5 = this.eventHandler.updateOfflineStorageFromEvents$stream_chat_android_offline_release((List)resultChatEvent.data(), (Continuation<? super Unit>)$continuation);
                    if (v5 == var17_5) {
                        return var17_5;
                    }
                    ** GOTO lbl71
                }
                case 2: {
                    $i$a$-also-ChatDomainImpl$replayEventsForActiveChannels$3 = false;
                    var5_8 = (Result)$continuation.L$2;
                    now = (Date)$continuation.L$1;
                    this = (ChatDomainImpl)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl71:
                    // 2 sources

                    v6 = this.syncState;
                    if (v6 != null) {
                        var10_17 = v6;
                        var11_18 = false;
                        var12_19 = false;
                        it = var10_17;
                        $i$a$-let-ChatDomainImpl$replayEventsForActiveChannels$3$1 = false;
                        it.setLastSyncedAt(now);
                    }
lbl80:
                    // 4 sources

                    v7 = var5_8;
                    break block12;
                }
            }
            v7 = new Result((Object)CollectionsKt.emptyList(), null);
        }
        return v7;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object replayEventsForActiveChannels$default(ChatDomainImpl chatDomainImpl, String string, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return chatDomainImpl.replayEventsForActiveChannels(string, (Continuation<? super Result<List<ChatEvent>>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object connectionRecovered(boolean var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof connectionRecovered.1)) ** GOTO lbl-1000
        var22_3 = var2_2;
        if ((var22_3.label & -2147483648) != 0) {
            var22_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                boolean Z$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.connectionRecovered(false, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var23_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.initJob;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"initJob");
                }
                $continuation.L$0 = this;
                $continuation.Z$0 = recoveryNeeded;
                $continuation.label = 1;
                v1 = v0.join((Continuation)$continuation);
                if (v1 == var23_5) {
                    return var23_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                recoveryNeeded = $continuation.Z$0;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                var4_6 = false;
                updatedChannelIds = new LinkedHashSet<E>();
                v2 = this.activeQueryMapImpl.values();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"activeQueryMapImpl.values");
                $this$filter$iv = CollectionsKt.toList((Iterable)v2);
                $i$f$filter = false;
                var7_12 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (QueryChannelsControllerImpl)element$iv$iv;
                    $i$a$-filter-ChatDomainImpl$connectionRecovered$queriesToRetry$1 = false;
                    if (!Boxing.boxBoolean((boolean)(it.getRecoveryNeeded() != false || recoveryNeeded != false)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                queriesToRetry = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)3);
                $i$f$filter = queriesToRetry.iterator();
lbl45:
                // 3 sources

                while ($i$f$filter.hasNext()) {
                    queryRepo = (QueryChannelsControllerImpl)$i$f$filter.next();
                    pagination = new QueryChannelsPaginationRequest((QuerySort<Channel>)new QuerySort(), 0, 30, 30, 30);
                    $continuation.L$0 = this;
                    $continuation.L$1 = updatedChannelIds;
                    $continuation.L$2 = queriesToRetry;
                    $continuation.L$3 = queryRepo;
                    $continuation.L$4 = $i$f$filter;
                    $continuation.L$5 = pagination;
                    $continuation.Z$0 = recoveryNeeded;
                    $continuation.label = 2;
                    v3 = queryRepo.runQueryOnline(pagination, (Continuation<? super Result<List<Channel>>>)$continuation);
                    if (v3 == var23_5) {
                        return var23_5;
                    }
                    ** GOTO lbl71
                }
                break;
            }
            case 2: {
                recoveryNeeded = $continuation.Z$0;
                pagination = (QueryChannelsPaginationRequest)$continuation.L$5;
                $i$f$filter = (Iterator<E>)$continuation.L$4;
                queryRepo = (QueryChannelsControllerImpl)$continuation.L$3;
                queriesToRetry = (List)$continuation.L$2;
                updatedChannelIds = (Set)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl71:
                // 2 sources

                if (!(response = (Result)v3).isSuccess()) ** GOTO lbl45
                $continuation.L$0 = this;
                $continuation.L$1 = updatedChannelIds;
                $continuation.L$2 = queriesToRetry;
                $continuation.L$3 = $i$f$filter;
                $continuation.L$4 = response;
                $continuation.L$5 = null;
                $continuation.Z$0 = recoveryNeeded;
                $continuation.label = 3;
                v4 = queryRepo.updateChannelsAndQueryResults$stream_chat_android_offline_release((List)response.data(), pagination.isFirstPage(), (Continuation<? super Unit>)$continuation);
                if (v4 == var23_5) {
                    return var23_5;
                }
                ** GOTO lbl93
            }
            case 3: {
                recoveryNeeded = $continuation.Z$0;
                response = (Result)$continuation.L$4;
                $i$f$filter = (Iterator)$continuation.L$3;
                queriesToRetry = (List)$continuation.L$2;
                updatedChannelIds = (Set)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl93:
                // 2 sources

                $i$f$filterTo = (Iterable)response.data();
                var18_28 = updatedChannelIds;
                $i$f$map = false;
                element$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var16_26 = (Channel)item$iv$iv;
                    var19_29 = destination$iv$iv;
                    $i$a$-map-ChatDomainImpl$connectionRecovered$2 = false;
                    var20_30 = it.getCid();
                    var19_29.add(var20_30);
                }
                var19_29 = (List)destination$iv$iv;
                var18_28.addAll((Collection)var19_29);
                ** GOTO lbl45
            }
        }
        v5 = this.activeChannelMapImpl.entrySet();
        Intrinsics.checkNotNullExpressionValue(v5, (String)"activeChannelMapImpl\n            .entries");
        cids = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)v5), (Function1)((Function1)new Function1<Map.Entry<String, ChannelControllerImpl>, Boolean>(recoveryNeeded != false){
            final /* synthetic */ boolean $recoveryNeeded;

            public final boolean invoke(@NotNull Map.Entry<String, ChannelControllerImpl> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.getValue().getRecoveryNeeded() || this.$recoveryNeeded;
            }
            {
                this.$recoveryNeeded = bl;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Map.Entry<String, ChannelControllerImpl>, Boolean>(updatedChannelIds){
            final /* synthetic */ Set $updatedChannelIds;

            public final boolean invoke(@NotNull Map.Entry<String, ChannelControllerImpl> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$updatedChannelIds.contains(it.getKey());
            }
            {
                this.$updatedChannelIds = set;
                super(1);
            }
        })), (int)30), (Function1)connectionRecovered.cids.3.INSTANCE));
        this.logger.logI("connection established: recoveryNeeded= " + (recoveryNeeded != false) + ", retrying " + queriesToRetry.size() + " queries and " + cids.size() + " channels");
        $i$f$filter = cids;
        pagination = false;
        if ($i$f$filter.isEmpty() == false && (result = this.client.queryChannels(request = new QueryChannelsRequest(filter = Filters.in((String)"cid", (List)cids), 0, 30, null, 0, 0, 56, null)).execute()).isSuccess()) {
            channels = (List)result.data();
            for (Channel c : channels) {
                channelRepo = this.channel$stream_chat_android_offline_release(c);
                channelRepo.updateLiveDataFromChannel(c);
            }
            $continuation.L$0 = this;
            $continuation.L$1 = null;
            $continuation.L$2 = null;
            $continuation.L$3 = null;
            $continuation.L$4 = null;
            $continuation.L$5 = null;
            $continuation.label = 4;
            v6 = this.storeStateForChannels(channels, (Continuation<? super Unit>)$continuation);
            if (v6 == var23_5) {
                return var23_5;
            }
        }
        ** GOTO lbl139
        {
            case 4: {
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl139:
                // 2 sources

                if (this.isOnline()) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.L$5 = null;
                    $continuation.label = 5;
                    v7 = this.retryFailedEntities((Continuation<? super Unit>)$continuation);
                    if (v7 == var23_5) {
                        return var23_5;
                    }
                }
                ** GOTO lbl155
            }
            case 5: {
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl155:
                // 2 sources

                if (this.isOnline()) {
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.L$5 = null;
                    $continuation.label = 6;
                    v8 = ChatDomainImpl.replayEventsForActiveChannels$default(this, null, (Continuation)$continuation, 1, null);
                    if (v8 == var23_5) {
                        return var23_5;
                    }
                }
                ** GOTO lbl170
            }
            case 6: {
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl170:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object connectionRecovered$default(ChatDomainImpl chatDomainImpl, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return chatDomainImpl.connectionRecovered(bl, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ Object retryFailedEntities(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof retryFailedEntities.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;
                Object L$0;
                Object L$1;
                Object L$2;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retryFailedEntities((Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = this.repos;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = this;
                $continuation.label = 2;
                v2 = v1.getChannels().retryChannels((Continuation<? super List<ChannelEntity>>)$continuation);
                if (v2 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl35
            }
            case 2: {
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl35:
                // 2 sources

                channelEntities = (List)v2;
                $continuation.L$0 = this;
                $continuation.L$1 = channelEntities;
                $continuation.label = 3;
                v3 = this.retryMessages$stream_chat_android_offline_release((Continuation<? super List<Message>>)$continuation);
                if (v3 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl48
            }
            case 3: {
                channelEntities = (List)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl48:
                // 2 sources

                messages = (List)v3;
                v4 = this.repos;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = channelEntities;
                $continuation.L$2 = messages;
                $continuation.label = 4;
                v5 = v4.getReactions().retryReactions((Continuation<? super List<ReactionEntity>>)$continuation);
                if (v5 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl66
            }
            case 4: {
                messages = (List)$continuation.L$2;
                channelEntities = (List)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl66:
                // 2 sources

                reactionEntities = (List)v5;
                this.logger.logI("Retried " + channelEntities.size() + " channel entities, " + messages.size() + " messages and " + reactionEntities.size() + " reaction entities");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @Nullable
    public final Object retryMessages$stream_chat_android_offline_release(@NotNull Continuation<? super List<Message>> var1_1) {
        if (!(var1_1 instanceof retryMessages.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;
                Object L$0;
                Object L$1;
                Object L$2;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retryMessages$stream_chat_android_offline_release((Continuation<? super List<Message>>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                userMap = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)this.getCurrentUser().getId(), (Object)this.getCurrentUser())});
                v0 = this.repos;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = v0.getMessages().selectSyncNeeded$stream_chat_android_offline_release(userMap, (Continuation<? super List<Message>>)$continuation);
                if (v1 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl26:
                // 2 sources

                messages = (List)v1;
                var5_7 = messages.iterator();
lbl28:
                // 6 sources

                while (var5_7.hasNext()) {
                    message = (Message)var5_7.next();
                    channelClient = this.client.channel(message.getCid());
                    v2 = message.getDeletedAt() != null ? channelClient.deleteMessage(message.getId()).execute() : (result = message.getUpdatedAt() != null || message.getUpdatedLocallyAt() != null ? this.client.updateMessage(message).execute() : channelClient.sendMessage(message).execute());
                    if (!result.isSuccess()) break block0;
                    v3 = this.repos;
                    if (v3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = messages;
                    $continuation.L$2 = var5_7;
                    $continuation.label = 2;
                    v4 = MessageRepository.insert$default(v3.getMessages(), Message.copy$default((Message)message, null, null, null, null, null, null, null, null, null, (int)0, null, null, (SyncStatus)SyncStatus.COMPLETED, null, null, null, null, null, null, null, null, null, null, (boolean)false, null, (boolean)false, null, (int)0x7FFEFFF, null), false, (Continuation)$continuation, 2, null);
                    if (v4 != var10_4) continue;
                    return var10_4;
                }
                break;
            }
            case 2: {
                var5_7 = (Iterator<E>)$continuation.L$2;
                messages = (List)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                ** GOTO lbl28
            }
        }
        if (!result.isError() || !ClientExtensionsKt.isPermanent(result.error())) ** GOTO lbl28
        v5 = this.repos;
        if (v5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
        }
        $continuation.L$0 = this;
        $continuation.L$1 = messages;
        $continuation.L$2 = var5_7;
        $continuation.label = 3;
        v6 = MessageRepository.insert$default(v5.getMessages(), Message.copy$default((Message)message, null, null, null, null, null, null, null, null, null, (int)0, null, null, (SyncStatus)SyncStatus.FAILED_PERMANENTLY, null, null, null, null, null, null, null, null, null, null, (boolean)false, null, (boolean)false, null, (int)0x7FFEFFF, null), false, (Continuation)$continuation, 2, null);
        if (v6 != var10_4) ** GOTO lbl28
        return var10_4;
        {
            case 3: {
                var5_7 = (Iterator)$continuation.L$2;
                messages = (List)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
                ** GOTO lbl28
            }
        }
        return messages;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object storeStateForChannel(@NotNull Channel channel2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.storeStateForChannels(CollectionsKt.listOf((Object)channel2), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object storeStateForChannels(@NotNull List<Channel> var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof storeStateForChannels.1)) ** GOTO lbl-1000
        var24_3 = var2_2;
        if ((var24_3.label & -2147483648) != 0) {
            var24_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.storeStateForChannels(null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = false;
                users = new LinkedHashMap<K, V>();
                var5_9 = false;
                configs = new LinkedHashMap<K, V>();
                var6_11 = false;
                messages = new ArrayList<E>();
                for (Channel channel : channelsResponse) {
                    var8_14 = ClientExtensionsKt.users(channel);
                    var20_33 = users;
                    $i$f$associateBy = false;
                    capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    var11_19 = $this$associateBy$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    $i$f$associateByTo = false;
                    for (T element$iv$iv : $this$associateByTo$iv$iv) {
                        var16_28 = (User)element$iv$iv;
                        var21_34 = destination$iv$iv;
                        $i$a$-associateBy-ChatDomainImpl$storeStateForChannels$2 = false;
                        var22_35 = it.getId();
                        var21_34.put(var22_35, element$iv$iv);
                    }
                    var21_34 = destination$iv$iv;
                    var20_33.putAll(var21_34);
                    configs.put(channel.getType(), channel.getConfig());
                    for (Message message : channel.getMessages()) {
                        message.setCid(channel.getCid());
                        capacity$iv = ClientExtensionsKt.users(message);
                        var20_33 = users;
                        $i$f$associateBy = false;
                        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        $i$f$associateByTo = $this$associateBy$iv;
                        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                        $i$f$associateByTo = false;
                        for (E element$iv$iv : $this$associateByTo$iv$iv) {
                            var18_31 = (User)element$iv$iv;
                            var21_34 = destination$iv$iv;
                            $i$a$-associateBy-ChatDomainImpl$storeStateForChannels$3 = false;
                            var22_35 = it.getId();
                            var21_34.put(var22_35, element$iv$iv);
                        }
                        var21_34 = destination$iv$iv;
                        var20_33.putAll(var21_34);
                    }
                    messages.addAll(channel.getMessages());
                }
                v0 = this.repos;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = channelsResponse;
                $continuation.L$2 = users;
                $continuation.L$3 = configs;
                $continuation.L$4 = messages;
                $continuation.label = 1;
                v1 = v0.getConfigs().insertConfigs(configs, (Continuation<? super Unit>)$continuation);
                if (v1 == var25_5) {
                    return var25_5;
                }
                ** GOTO lbl84
            }
            case 1: {
                messages = (List)$continuation.L$4;
                configs = (Map)$continuation.L$3;
                users = (Map)$continuation.L$2;
                channelsResponse = (List)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl84:
                // 2 sources

                v2 = this.repos;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = channelsResponse;
                $continuation.L$2 = users;
                $continuation.L$3 = configs;
                $continuation.L$4 = messages;
                $continuation.label = 2;
                v3 = v2.getUsers().insert(CollectionsKt.toList((Iterable)users.values()), (Continuation<? super Unit>)$continuation);
                if (v3 == var25_5) {
                    return var25_5;
                }
                ** GOTO lbl105
            }
            case 2: {
                messages = (List)$continuation.L$4;
                configs = (Map)$continuation.L$3;
                users = (Map)$continuation.L$2;
                channelsResponse = (List)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl105:
                // 2 sources

                v4 = this.repos;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = channelsResponse;
                $continuation.L$2 = users;
                $continuation.L$3 = configs;
                $continuation.L$4 = messages;
                $continuation.label = 3;
                v5 = v4.insertChannels(channelsResponse, (Continuation<? super Unit>)$continuation);
                if (v5 == var25_5) {
                    return var25_5;
                }
                ** GOTO lbl126
            }
            case 3: {
                messages = (List)$continuation.L$4;
                configs = (Map)$continuation.L$3;
                users = (Map)$continuation.L$2;
                channelsResponse = (List)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl126:
                // 2 sources

                v6 = this.repos;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = channelsResponse;
                $continuation.L$2 = users;
                $continuation.L$3 = configs;
                $continuation.L$4 = messages;
                $continuation.label = 4;
                v7 = MessageRepository.insert$default(v6.getMessages(), messages, false, (Continuation)$continuation, 2, null);
                if (v7 == var25_5) {
                    return var25_5;
                }
                ** GOTO lbl147
            }
            case 4: {
                messages = (List)$continuation.L$4;
                configs = (Map)$continuation.L$3;
                users = (Map)$continuation.L$2;
                channelsResponse = (List)$continuation.L$1;
                this = (ChatDomainImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl147:
                // 2 sources

                this.logger.logI("storeStateForChannels stored " + channelsResponse.size() + " channels, " + configs.size() + " configs, " + users.size() + " users and " + messages.size() + " messages");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object selectAndEnrichChannel(@NotNull String var1_1, @NotNull QueryChannelPaginationRequest var2_2, @NotNull Continuation<? super Channel> var3_3) {
        if (!(var3_3 instanceof selectAndEnrichChannel.1)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.selectAndEnrichChannel((String)null, (QueryChannelPaginationRequest)null, (Continuation<? super Channel>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.selectAndEnrichChannels((List<String>)CollectionsKt.listOf((Object)channelId), pagination.toAnyChannelPaginationRequest$stream_chat_android_offline_release(), (Continuation<? super List<Channel>>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return CollectionsKt.getOrNull((List)((List)v0), (int)0);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object selectAndEnrichChannel(@NotNull String var1_1, @NotNull QueryChannelsPaginationRequest var2_2, @NotNull Continuation<? super Channel> var3_3) {
        if (!(var3_3 instanceof selectAndEnrichChannel.2)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.selectAndEnrichChannel((String)null, (QueryChannelsPaginationRequest)null, (Continuation<? super Channel>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.selectAndEnrichChannels((List<String>)CollectionsKt.listOf((Object)channelId), MapperKt.toAnyChannelPaginationRequest((QueryChannelsPaginationRequest)pagination), (Continuation<? super List<Channel>>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return CollectionsKt.getOrNull((List)((List)v0), (int)0);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object selectAndEnrichChannels(@NotNull List<String> channelIds, @NotNull QueryChannelsPaginationRequest pagination, @NotNull Continuation<? super List<Channel>> $completion) {
        return this.selectAndEnrichChannels(channelIds, MapperKt.toAnyChannelPaginationRequest(pagination), $completion);
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ Object selectAndEnrichChannels(List<String> var1_1, AnyChannelPaginationRequest var2_2, Continuation<? super List<Channel>> var3_3) {
        if (!(var3_3 instanceof selectAndEnrichChannels.2)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ChatDomainImpl this$0;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.selectAndEnrichChannels((List<String>)null, (AnyChannelPaginationRequest)null, (Continuation<? super List<Channel>>)this);
                }
                {
                    this.this$0 = chatDomainImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.repos;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
                }
                $continuation.L$0 = pagination;
                $continuation.label = 1;
                v1 = v0.selectChannels$stream_chat_android_offline_release((List<String>)channelIds, this.defaultConfig, pagination, (Continuation<? super List<Channel>>)$continuation);
                if (v1 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                pagination = (AnyChannelPaginationRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl25:
                // 2 sources

                return ClientExtensionsKt.applyPagination((Collection)v1, pagination);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void clean() {
        Collection<ChannelControllerImpl> collection = this.activeChannelMapImpl.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"activeChannelMapImpl.values");
        for (ChannelControllerImpl channelRepo : CollectionsKt.toList((Iterable)collection)) {
            channelRepo.clean();
        }
    }

    @Override
    @NotNull
    public Config getChannelConfig(@NotNull String channelType) {
        Config config;
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        RepositoryHelper repositoryHelper = this.repos;
        if (repositoryHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repos");
        }
        if ((config = repositoryHelper.getConfigs().select(channelType)) == null) {
            config = this.defaultConfig;
        }
        return config;
    }

    @NotNull
    public final ChatClient getClient$stream_chat_android_offline_release() {
        return this.client;
    }

    public final void setClient$stream_chat_android_offline_release(@NotNull ChatClient chatClient) {
        Intrinsics.checkNotNullParameter((Object)chatClient, (String)"<set-?>");
        this.client = chatClient;
    }

    @Nullable
    public final User getUserOverwrite$stream_chat_android_offline_release() {
        return this.userOverwrite;
    }

    public final void setUserOverwrite$stream_chat_android_offline_release(@Nullable User user) {
        this.userOverwrite = user;
    }

    @Nullable
    public final ChatDatabase getDb$stream_chat_android_offline_release() {
        return this.db;
    }

    public final void setDb$stream_chat_android_offline_release(@Nullable ChatDatabase chatDatabase) {
        this.db = chatDatabase;
    }

    @Override
    public boolean getOfflineEnabled() {
        return this.offlineEnabled;
    }

    @Override
    public void setOfflineEnabled(boolean bl) {
        this.offlineEnabled = bl;
    }

    public final boolean getRecoveryEnabled$stream_chat_android_offline_release() {
        return this.recoveryEnabled;
    }

    public final void setRecoveryEnabled$stream_chat_android_offline_release(boolean bl) {
        this.recoveryEnabled = bl;
    }

    @Override
    public boolean getUserPresence() {
        return this.userPresence;
    }

    @Override
    public void setUserPresence(boolean bl) {
        this.userPresence = bl;
    }

    public final boolean getBackgroundSyncEnabled$stream_chat_android_offline_release() {
        return this.backgroundSyncEnabled;
    }

    public final void setBackgroundSyncEnabled$stream_chat_android_offline_release(boolean bl) {
        this.backgroundSyncEnabled = bl;
    }

    @NotNull
    public final Context getAppContext$stream_chat_android_offline_release() {
        return this.appContext;
    }

    public final void setAppContext$stream_chat_android_offline_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.appContext = context;
    }

    public ChatDomainImpl(@NotNull ChatClient client, @Nullable User userOverwrite, @Nullable ChatDatabase db2, @NotNull Handler mainHandler, boolean offlineEnabled, boolean recoveryEnabled, boolean userPresence, boolean backgroundSyncEnabled, @NotNull Context appContext) {
        User current;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)mainHandler, (String)"mainHandler");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.client = client;
        this.userOverwrite = userOverwrite;
        this.db = db2;
        this.mainHandler = mainHandler;
        this.offlineEnabled = offlineEnabled;
        this.recoveryEnabled = recoveryEnabled;
        this.userPresence = userPresence;
        this.backgroundSyncEnabled = backgroundSyncEnabled;
        this.appContext = appContext;
        this._initialized = StateFlowKt.MutableStateFlow((Object)false);
        this._online = StateFlowKt.MutableStateFlow((Object)false);
        this._totalUnreadCount = StateFlowKt.MutableStateFlow((Object)0);
        this._channelUnreadCount = StateFlowKt.MutableStateFlow((Object)0);
        this._errorEvent = StateFlowKt.MutableStateFlow(null);
        this._banned = StateFlowKt.MutableStateFlow((Object)false);
        this._mutedUsers = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this._typingChannels = new MediatorLiveData();
        this.syncModule$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SyncProvider>(this){
            final /* synthetic */ ChatDomainImpl this$0;

            @NotNull
            public final SyncProvider invoke() {
                return new SyncProvider(this.this$0.getAppContext$stream_chat_android_offline_release());
            }
            {
                this.this$0 = chatDomainImpl;
                super(0);
            }
        }));
        this.useCases = new UseCaseHelper(this);
        this.defaultConfig = new Config(null, null, false, false, true, false, false, false, true, 0, null, null, null, null, 16111, null);
        this.initialized = FlowLiveDataConversions.asLiveData$default((Flow)((Flow)this._initialized), null, (long)0L, (int)3, null);
        this.online = FlowLiveDataConversions.asLiveData$default((Flow)((Flow)this._online), null, (long)0L, (int)3, null);
        this.totalUnreadCount = FlowLiveDataConversions.asLiveData$default((Flow)((Flow)this._totalUnreadCount), null, (long)0L, (int)3, null);
        this.channelUnreadCount = FlowLiveDataConversions.asLiveData$default((Flow)((Flow)this._channelUnreadCount), null, (long)0L, (int)3, null);
        this.muted = FlowLiveDataConversions.asLiveData$default((Flow)((Flow)this._mutedUsers), null, (long)0L, (int)3, null);
        this.banned = FlowLiveDataConversions.asLiveData$default((Flow)((Flow)this._banned), null, (long)0L, (int)3, null);
        this.errorEvents = FlowLiveDataConversions.asLiveData$default((Flow)FlowKt.filterNotNull((Flow)((Flow)this._errorEvent)), null, (long)0L, (int)3, null);
        this.eventSubscription = EMPTY_DISPOSABLE;
        this.activeChannelMapImpl = new ConcurrentHashMap();
        this.typingUpdates = (LiveData)this._typingChannels;
        this.activeQueryMapImpl = new ConcurrentHashMap();
        this.eventHandler = new EventHandlerImpl(this);
        this.logger = ChatLogger.Companion.get((Object)"Domain");
        this.cleanTask = new Runnable(this){
            final /* synthetic */ ChatDomainImpl this$0;

            public void run() {
                this.this$0.clean();
                ChatDomainImpl.access$getMainHandler$p(this.this$0).postDelayed((Runnable)this, 1000L);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.retryPolicy = new DefaultRetryPolicy();
        this.job = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.job.plus((CoroutineContext)DispatcherProvider.INSTANCE.getIO()));
        this.logger.logI("Initializing ChatDomain with version " + this.getVersion());
        User user = this.userOverwrite;
        if (user == null) {
            user = current = this.client.getCurrentUser();
        }
        if (current != null) {
            this.setUser$stream_chat_android_offline_release(current);
        }
        if (this.userOverwrite == null) {
            this.client.getPreSetUserListeners().add(new Function1<User, Unit>(){

                public final void invoke(@NotNull User it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.setUser$stream_chat_android_offline_release(it);
                }
            });
            this.client.getDisconnectListeners().add(new Function1<User, Unit>(){

                public final void invoke(@Nullable User it) {
                    BuildersKt.launch$default((CoroutineScope)this.getScope$stream_chat_android_offline_release(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ 2 this$0;

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = this.this$0.this.disconnect((Continuation<? super Unit>)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                        {
                            this.this$0 = var1_1;
                            super(2, continuation);
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                            Intrinsics.checkNotNullParameter(completion, (String)"completion");
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            return function2;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            });
        }
    }

    public /* synthetic */ ChatDomainImpl(ChatClient chatClient, User user, ChatDatabase chatDatabase, Handler handler, boolean bl, boolean bl2, boolean bl3, boolean bl4, Context context, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            user = null;
        }
        if ((n & 4) != 0) {
            chatDatabase = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        if ((n & 0x80) != 0) {
            bl4 = false;
        }
        this(chatClient, user, chatDatabase, handler, bl, bl2, bl3, bl4, context);
    }

    public ChatDomainImpl(@NotNull ChatClient client, @NotNull Handler handler, boolean offlineEnabled, boolean recoveryEnabled, boolean userPresence, boolean backgroundSyncEnabled, @NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this(client, null, null, handler, offlineEnabled, recoveryEnabled, userPresence, backgroundSyncEnabled, appContext);
    }

    static {
        Companion = new Companion(null);
        EMPTY_DISPOSABLE = new Disposable(){
            private final boolean isDisposed;

            public boolean isDisposed() {
                return this.isDisposed;
            }

            public void dispose() {
            }
            {
                this.isDisposed = true;
            }
        };
    }

    public static final /* synthetic */ SyncStateEntity access$getSyncState$p(ChatDomainImpl $this) {
        return $this.syncState;
    }

    public static final /* synthetic */ void access$setSyncState$p(ChatDomainImpl $this, SyncStateEntity syncStateEntity) {
        $this.syncState = syncStateEntity;
    }

    public static final /* synthetic */ void access$addTypingChannel(ChatDomainImpl $this, ChannelControllerImpl channelController) {
        $this.addTypingChannel(channelController);
    }

    public static final /* synthetic */ Handler access$getMainHandler$p(ChatDomainImpl $this) {
        return $this.mainHandler;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/livedata/ChatDomainImpl$Companion;", "", "()V", "EMPTY_DISPOSABLE", "Lio/getstream/chat/android/client/utils/observable/Disposable;", "getEMPTY_DISPOSABLE", "()Lio/getstream/chat/android/client/utils/observable/Disposable;", "stream-chat-android-offline_release"})
    public static final class Companion {
        @NotNull
        public final Disposable getEMPTY_DISPOSABLE() {
            return EMPTY_DISPOSABLE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

