/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.livedata.converter.DateConverter;
import io.getstream.chat.android.livedata.converter.ExtraDataConverter;
import io.getstream.chat.android.livedata.converter.ListConverter;
import io.getstream.chat.android.livedata.converter.MapConverter;
import io.getstream.chat.android.livedata.converter.SyncStatusConverter;
import io.getstream.chat.android.livedata.dao.ChannelDao;
import io.getstream.chat.android.livedata.entity.ChannelEntity;
import io.getstream.chat.android.livedata.entity.ChannelUserReadEntity;
import io.getstream.chat.android.livedata.entity.MemberEntity;
import io.getstream.chat.android.livedata.entity.MessageEntity;
import io.getstream.chat.android.livedata.entity.ReactionEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ChannelDao_Impl
implements ChannelDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelEntity> __insertionAdapterOfChannelEntity;
    private final DateConverter __dateConverter = new DateConverter();
    private final MapConverter __mapConverter = new MapConverter();
    private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();
    private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();
    private final ListConverter __listConverter = new ListConverter();
    private final SharedSQLiteStatement __preparedStmtOfDelete;

    public ChannelDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelEntity = new EntityInsertionAdapter<ChannelEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_channel_state` (`cid`,`createdByUserId`,`frozen`,`hidden`,`hideMessagesBefore`,`mutedTill`,`members`,`reads`,`lastMessageAt`,`createdAt`,`updatedAt`,`deletedAt`,`extraData`,`syncStatus`,`type`,`channelId`,`cooldown`,`last_messageid`,`last_messagecid`,`last_messageuserId`,`last_messagetext`,`last_messageattachments`,`last_messagetype`,`last_messagesyncStatus`,`last_messagereplyCount`,`last_messagecreatedAt`,`last_messagecreatedLocallyAt`,`last_messageupdatedAt`,`last_messageupdatedLocallyAt`,`last_messagedeletedAt`,`last_messagelatestReactions`,`last_messageownReactions`,`last_messagementionedUsersId`,`last_messagereactionCounts`,`last_messagereactionScores`,`last_messageparentId`,`last_messagecommand`,`last_messageextraData`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelEntity value) {
                Integer _tmp_1;
                if (value.getCid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCid());
                }
                if (value.getCreatedByUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getCreatedByUserId());
                }
                int _tmp = value.getFrozen() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                Integer n = value.getHidden() == null ? null : (_tmp_1 = Integer.valueOf(value.getHidden() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)_tmp_1.intValue());
                }
                Long _tmp_2 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getHideMessagesBefore());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, _tmp_2.longValue());
                }
                Long _tmp_3 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getMutedTill());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp_3.longValue());
                }
                String _tmp_4 = ChannelDao_Impl.this.__mapConverter.memberMapToString(value.getMembers());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
                String _tmp_5 = ChannelDao_Impl.this.__mapConverter.readMapToString(value.getReads());
                if (_tmp_5 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_5);
                }
                Long _tmp_6 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getLastMessageAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, _tmp_6.longValue());
                }
                Long _tmp_7 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, _tmp_7.longValue());
                }
                Long _tmp_8 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, _tmp_8.longValue());
                }
                Long _tmp_9 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, _tmp_9.longValue());
                }
                String _tmp_10 = ChannelDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_10 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_10);
                }
                int _tmp_11 = ChannelDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(14, (long)_tmp_11);
                if (value.getType() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getType());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getChannelId());
                }
                stmt.bindLong(17, (long)value.getCooldown());
                MessageEntity _tmpLastMessage = value.getLastMessage();
                if (_tmpLastMessage != null) {
                    if (_tmpLastMessage.getId() == null) {
                        stmt.bindNull(18);
                    } else {
                        stmt.bindString(18, _tmpLastMessage.getId());
                    }
                    if (_tmpLastMessage.getCid() == null) {
                        stmt.bindNull(19);
                    } else {
                        stmt.bindString(19, _tmpLastMessage.getCid());
                    }
                    if (_tmpLastMessage.getUserId() == null) {
                        stmt.bindNull(20);
                    } else {
                        stmt.bindString(20, _tmpLastMessage.getUserId());
                    }
                    if (_tmpLastMessage.getText() == null) {
                        stmt.bindNull(21);
                    } else {
                        stmt.bindString(21, _tmpLastMessage.getText());
                    }
                    String _tmp_12 = ChannelDao_Impl.this.__listConverter.attachmentListToString(_tmpLastMessage.getAttachments());
                    if (_tmp_12 == null) {
                        stmt.bindNull(22);
                    } else {
                        stmt.bindString(22, _tmp_12);
                    }
                    if (_tmpLastMessage.getType() == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindString(23, _tmpLastMessage.getType());
                    }
                    int _tmp_13 = ChannelDao_Impl.this.__syncStatusConverter.syncStatusToString(_tmpLastMessage.getSyncStatus());
                    stmt.bindLong(24, (long)_tmp_13);
                    stmt.bindLong(25, (long)_tmpLastMessage.getReplyCount());
                    Long _tmp_14 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(_tmpLastMessage.getCreatedAt());
                    if (_tmp_14 == null) {
                        stmt.bindNull(26);
                    } else {
                        stmt.bindLong(26, _tmp_14.longValue());
                    }
                    Long _tmp_15 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(_tmpLastMessage.getCreatedLocallyAt());
                    if (_tmp_15 == null) {
                        stmt.bindNull(27);
                    } else {
                        stmt.bindLong(27, _tmp_15.longValue());
                    }
                    Long _tmp_16 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(_tmpLastMessage.getUpdatedAt());
                    if (_tmp_16 == null) {
                        stmt.bindNull(28);
                    } else {
                        stmt.bindLong(28, _tmp_16.longValue());
                    }
                    Long _tmp_17 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(_tmpLastMessage.getUpdatedLocallyAt());
                    if (_tmp_17 == null) {
                        stmt.bindNull(29);
                    } else {
                        stmt.bindLong(29, _tmp_17.longValue());
                    }
                    Long _tmp_18 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(_tmpLastMessage.getDeletedAt());
                    if (_tmp_18 == null) {
                        stmt.bindNull(30);
                    } else {
                        stmt.bindLong(30, _tmp_18.longValue());
                    }
                    String _tmp_19 = ChannelDao_Impl.this.__listConverter.reactionListToString(_tmpLastMessage.getLatestReactions());
                    if (_tmp_19 == null) {
                        stmt.bindNull(31);
                    } else {
                        stmt.bindString(31, _tmp_19);
                    }
                    String _tmp_20 = ChannelDao_Impl.this.__listConverter.reactionListToString(_tmpLastMessage.getOwnReactions());
                    if (_tmp_20 == null) {
                        stmt.bindNull(32);
                    } else {
                        stmt.bindString(32, _tmp_20);
                    }
                    String _tmp_21 = ChannelDao_Impl.this.__listConverter.stringListToString(_tmpLastMessage.getMentionedUsersId());
                    if (_tmp_21 == null) {
                        stmt.bindNull(33);
                    } else {
                        stmt.bindString(33, _tmp_21);
                    }
                    String _tmp_22 = ChannelDao_Impl.this.__mapConverter.mapToString(_tmpLastMessage.getReactionCounts());
                    if (_tmp_22 == null) {
                        stmt.bindNull(34);
                    } else {
                        stmt.bindString(34, _tmp_22);
                    }
                    String _tmp_23 = ChannelDao_Impl.this.__mapConverter.mapToString(_tmpLastMessage.getReactionScores());
                    if (_tmp_23 == null) {
                        stmt.bindNull(35);
                    } else {
                        stmt.bindString(35, _tmp_23);
                    }
                    if (_tmpLastMessage.getParentId() == null) {
                        stmt.bindNull(36);
                    } else {
                        stmt.bindString(36, _tmpLastMessage.getParentId());
                    }
                    if (_tmpLastMessage.getCommand() == null) {
                        stmt.bindNull(37);
                    } else {
                        stmt.bindString(37, _tmpLastMessage.getCommand());
                    }
                    String _tmp_24 = ChannelDao_Impl.this.__extraDataConverter.mapToString(_tmpLastMessage.getExtraData());
                    if (_tmp_24 == null) {
                        stmt.bindNull(38);
                    } else {
                        stmt.bindString(38, _tmp_24);
                    }
                } else {
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                    stmt.bindNull(28);
                    stmt.bindNull(29);
                    stmt.bindNull(30);
                    stmt.bindNull(31);
                    stmt.bindNull(32);
                    stmt.bindNull(33);
                    stmt.bindNull(34);
                    stmt.bindNull(35);
                    stmt.bindNull(36);
                    stmt.bindNull(37);
                    stmt.bindNull(38);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_chat_channel_state WHERE cid = ?";
                return "DELETE from stream_chat_channel_state WHERE cid = ?";
            }
        };
    }

    @Override
    public Object insert(final ChannelEntity channelEntity, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    ChannelDao_Impl.this.__insertionAdapterOfChannelEntity.insert((Object)channelEntity);
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object insertMany(final List<ChannelEntity> channelEntities, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    ChannelDao_Impl.this.__insertionAdapterOfChannelEntity.insert((Iterable)channelEntities);
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object delete(final String cid, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChannelDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                    ChannelDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, p1);
    }

    @Override
    public Object selectSyncNeeded(SyncStatus syncStatus, Continuation<? super List<ChannelEntity>> p1) {
        String _sql = "SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.syncStatus IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.syncStatus IN (?)", (int)1);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<ChannelEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ChannelEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdByUserId");
                    int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frozen");
                    int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hidden");
                    int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hideMessagesBefore");
                    int _cursorIndexOfMutedTill = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mutedTill");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reads");
                    int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageAt");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cooldown");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageid");
                    int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageuserId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagetext");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageattachments");
                    int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagetype");
                    int _cursorIndexOfSyncStatus_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagesyncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagereplyCount");
                    int _cursorIndexOfCreatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecreatedAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecreatedLocallyAt");
                    int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageupdatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageupdatedLocallyAt");
                    int _cursorIndexOfDeletedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagedeletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagelatestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagementionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagereactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagereactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageparentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecommand");
                    int _cursorIndexOfExtraData_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageextraData");
                    ArrayList<ChannelEntity> _result = new ArrayList<ChannelEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        MessageEntity _tmpLastMessage;
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        int _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
                        if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfAttachments) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfSyncStatus_1) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt_1) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt_1) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt_1) && _cursor.isNull(_cursorIndexOfLatestReactions) && _cursor.isNull(_cursorIndexOfOwnReactions) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfExtraData_1))) {
                            String _tmpId = _cursor.getString(_cursorIndexOfId);
                            String _tmpCid = _cursor.getString(_cursorIndexOfCid_1);
                            String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                            String _tmpText = _cursor.getString(_cursorIndexOfText);
                            String _tmp_1 = _cursor.getString(_cursorIndexOfAttachments);
                            List<Attachment> _tmpAttachments = ChannelDao_Impl.this.__listConverter.stringToAttachmentList(_tmp_1);
                            String _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus_1);
                            SyncStatus _tmpSyncStatus = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                            int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                            Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt_1) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt_1));
                            Date _tmpCreatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                            Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                            Date _tmpCreatedLocallyAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                            Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt_1));
                            Date _tmpUpdatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                            Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                            Date _tmpUpdatedLocallyAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                            Long _tmp_7 = _cursor.isNull(_cursorIndexOfDeletedAt_1) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt_1));
                            Date _tmpDeletedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                            String _tmp_8 = _cursor.getString(_cursorIndexOfLatestReactions);
                            List<ReactionEntity> _tmpLatestReactions = ChannelDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                            String _tmp_9 = _cursor.getString(_cursorIndexOfOwnReactions);
                            List<ReactionEntity> _tmpOwnReactions = ChannelDao_Impl.this.__listConverter.stringToReactionList(_tmp_9);
                            String _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                            List<String> _tmpMentionedUsersId = ChannelDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                            String _tmp_11 = _cursor.getString(_cursorIndexOfReactionCounts);
                            Map<String, Integer> _tmpReactionCounts = ChannelDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                            String _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
                            Map<String, Integer> _tmpReactionScores = ChannelDao_Impl.this.__mapConverter.stringToMap(_tmp_12);
                            String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                            String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                            String _tmp_13 = _cursor.getString(_cursorIndexOfExtraData_1);
                            Map<String, Object> _tmpExtraData = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_13);
                            _tmpLastMessage = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType_1, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpExtraData);
                        } else {
                            _tmpLastMessage = null;
                        }
                        ChannelEntity _item = new ChannelEntity(_tmpType, _tmpChannelId, _tmpCooldown);
                        String _tmpCid_1 = _cursor.getString(_cursorIndexOfCid);
                        _item.setCid(_tmpCid_1);
                        String _tmpCreatedByUserId = _cursor.getString(_cursorIndexOfCreatedByUserId);
                        _item.setCreatedByUserId(_tmpCreatedByUserId);
                        int _tmp_14 = _cursor.getInt(_cursorIndexOfFrozen);
                        boolean _tmpFrozen = _tmp_14 != 0;
                        _item.setFrozen(_tmpFrozen);
                        Integer _tmp_15 = _cursor.isNull(_cursorIndexOfHidden) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfHidden));
                        Boolean _tmpHidden = _tmp_15 == null ? null : Boolean.valueOf(_tmp_15 != 0);
                        _item.setHidden(_tmpHidden);
                        Long _tmp_16 = _cursor.isNull(_cursorIndexOfHideMessagesBefore) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfHideMessagesBefore));
                        Date _tmpHideMessagesBefore = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_16);
                        _item.setHideMessagesBefore(_tmpHideMessagesBefore);
                        Long _tmp_17 = _cursor.isNull(_cursorIndexOfMutedTill) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfMutedTill));
                        Date _tmpMutedTill = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_17);
                        _item.setMutedTill(_tmpMutedTill);
                        String _tmp_18 = _cursor.getString(_cursorIndexOfMembers);
                        Map<String, MemberEntity> _tmpMembers = ChannelDao_Impl.this.__mapConverter.stringToMemberMap(_tmp_18);
                        _item.setMembers(_tmpMembers);
                        String _tmp_19 = _cursor.getString(_cursorIndexOfReads);
                        Map<String, ChannelUserReadEntity> _tmpReads = ChannelDao_Impl.this.__mapConverter.stringToReadMap(_tmp_19);
                        _item.setReads(_tmpReads);
                        Long _tmp_20 = _cursor.isNull(_cursorIndexOfLastMessageAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastMessageAt));
                        Date _tmpLastMessageAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_20);
                        _item.setLastMessageAt(_tmpLastMessageAt);
                        Long _tmp_21 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt_1 = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_21);
                        _item.setCreatedAt(_tmpCreatedAt_1);
                        Long _tmp_22 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt_1 = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_22);
                        _item.setUpdatedAt(_tmpUpdatedAt_1);
                        Long _tmp_23 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt_1 = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_23);
                        _item.setDeletedAt(_tmpDeletedAt_1);
                        String _tmp_24 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData_1 = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_24);
                        _item.setExtraData(_tmpExtraData_1);
                        int _tmp_25 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus_1 = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_25);
                        _item.setSyncStatus(_tmpSyncStatus_1);
                        _item.setLastMessage(_tmpLastMessage);
                        _result.add(_item);
                    }
                    ArrayList<ChannelEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object select(List<String> cids2, Continuation<? super List<ChannelEntity>> p1) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (");
        int _inputSize = cids2.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : cids2) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<ChannelEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ChannelEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdByUserId");
                    int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frozen");
                    int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hidden");
                    int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hideMessagesBefore");
                    int _cursorIndexOfMutedTill = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mutedTill");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reads");
                    int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageAt");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cooldown");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageid");
                    int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageuserId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagetext");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageattachments");
                    int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagetype");
                    int _cursorIndexOfSyncStatus_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagesyncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagereplyCount");
                    int _cursorIndexOfCreatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecreatedAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecreatedLocallyAt");
                    int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageupdatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageupdatedLocallyAt");
                    int _cursorIndexOfDeletedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagedeletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagelatestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagementionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagereactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagereactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageparentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecommand");
                    int _cursorIndexOfExtraData_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageextraData");
                    ArrayList<ChannelEntity> _result = new ArrayList<ChannelEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        MessageEntity _tmpLastMessage;
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        int _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
                        if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfAttachments) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfSyncStatus_1) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt_1) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt_1) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt_1) && _cursor.isNull(_cursorIndexOfLatestReactions) && _cursor.isNull(_cursorIndexOfOwnReactions) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfExtraData_1))) {
                            String _tmpId = _cursor.getString(_cursorIndexOfId);
                            String _tmpCid = _cursor.getString(_cursorIndexOfCid_1);
                            String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                            String _tmpText = _cursor.getString(_cursorIndexOfText);
                            String _tmp = _cursor.getString(_cursorIndexOfAttachments);
                            List<Attachment> _tmpAttachments = ChannelDao_Impl.this.__listConverter.stringToAttachmentList(_tmp);
                            String _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus_1);
                            SyncStatus _tmpSyncStatus = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                            int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                            Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt_1) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt_1));
                            Date _tmpCreatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                            Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                            Date _tmpCreatedLocallyAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                            Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt_1));
                            Date _tmpUpdatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                            Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                            Date _tmpUpdatedLocallyAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                            Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt_1) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt_1));
                            Date _tmpDeletedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                            String _tmp_7 = _cursor.getString(_cursorIndexOfLatestReactions);
                            List<ReactionEntity> _tmpLatestReactions = ChannelDao_Impl.this.__listConverter.stringToReactionList(_tmp_7);
                            String _tmp_8 = _cursor.getString(_cursorIndexOfOwnReactions);
                            List<ReactionEntity> _tmpOwnReactions = ChannelDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                            String _tmp_9 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                            List<String> _tmpMentionedUsersId = ChannelDao_Impl.this.__listConverter.stringToStringList(_tmp_9);
                            String _tmp_10 = _cursor.getString(_cursorIndexOfReactionCounts);
                            Map<String, Integer> _tmpReactionCounts = ChannelDao_Impl.this.__mapConverter.stringToMap(_tmp_10);
                            String _tmp_11 = _cursor.getString(_cursorIndexOfReactionScores);
                            Map<String, Integer> _tmpReactionScores = ChannelDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                            String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                            String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                            String _tmp_12 = _cursor.getString(_cursorIndexOfExtraData_1);
                            Map<String, Object> _tmpExtraData = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_12);
                            _tmpLastMessage = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType_1, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpExtraData);
                        } else {
                            _tmpLastMessage = null;
                        }
                        ChannelEntity _item_1 = new ChannelEntity(_tmpType, _tmpChannelId, _tmpCooldown);
                        String _tmpCid_1 = _cursor.getString(_cursorIndexOfCid);
                        _item_1.setCid(_tmpCid_1);
                        String _tmpCreatedByUserId = _cursor.getString(_cursorIndexOfCreatedByUserId);
                        _item_1.setCreatedByUserId(_tmpCreatedByUserId);
                        int _tmp_13 = _cursor.getInt(_cursorIndexOfFrozen);
                        boolean _tmpFrozen = _tmp_13 != 0;
                        _item_1.setFrozen(_tmpFrozen);
                        Integer _tmp_14 = _cursor.isNull(_cursorIndexOfHidden) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfHidden));
                        Boolean _tmpHidden = _tmp_14 == null ? null : Boolean.valueOf(_tmp_14 != 0);
                        _item_1.setHidden(_tmpHidden);
                        Long _tmp_15 = _cursor.isNull(_cursorIndexOfHideMessagesBefore) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfHideMessagesBefore));
                        Date _tmpHideMessagesBefore = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_15);
                        _item_1.setHideMessagesBefore(_tmpHideMessagesBefore);
                        Long _tmp_16 = _cursor.isNull(_cursorIndexOfMutedTill) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfMutedTill));
                        Date _tmpMutedTill = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_16);
                        _item_1.setMutedTill(_tmpMutedTill);
                        String _tmp_17 = _cursor.getString(_cursorIndexOfMembers);
                        Map<String, MemberEntity> _tmpMembers = ChannelDao_Impl.this.__mapConverter.stringToMemberMap(_tmp_17);
                        _item_1.setMembers(_tmpMembers);
                        String _tmp_18 = _cursor.getString(_cursorIndexOfReads);
                        Map<String, ChannelUserReadEntity> _tmpReads = ChannelDao_Impl.this.__mapConverter.stringToReadMap(_tmp_18);
                        _item_1.setReads(_tmpReads);
                        Long _tmp_19 = _cursor.isNull(_cursorIndexOfLastMessageAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastMessageAt));
                        Date _tmpLastMessageAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_19);
                        _item_1.setLastMessageAt(_tmpLastMessageAt);
                        Long _tmp_20 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt_1 = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_20);
                        _item_1.setCreatedAt(_tmpCreatedAt_1);
                        Long _tmp_21 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt_1 = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_21);
                        _item_1.setUpdatedAt(_tmpUpdatedAt_1);
                        Long _tmp_22 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt_1 = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_22);
                        _item_1.setDeletedAt(_tmpDeletedAt_1);
                        String _tmp_23 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData_1 = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_23);
                        _item_1.setExtraData(_tmpExtraData_1);
                        int _tmp_24 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus_1 = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_24);
                        _item_1.setSyncStatus(_tmpSyncStatus_1);
                        _item_1.setLastMessage(_tmpLastMessage);
                        _result.add(_item_1);
                    }
                    ArrayList<ChannelEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object select(String cid, Continuation<? super ChannelEntity> p1) {
        String _sql = "SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (?)", (int)1);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<ChannelEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ChannelEntity _result;
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdByUserId");
                    int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frozen");
                    int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hidden");
                    int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hideMessagesBefore");
                    int _cursorIndexOfMutedTill = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mutedTill");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reads");
                    int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageAt");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cooldown");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageid");
                    int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageuserId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagetext");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageattachments");
                    int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagetype");
                    int _cursorIndexOfSyncStatus_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagesyncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagereplyCount");
                    int _cursorIndexOfCreatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecreatedAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecreatedLocallyAt");
                    int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageupdatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageupdatedLocallyAt");
                    int _cursorIndexOfDeletedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagedeletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagelatestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagementionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagereactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagereactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageparentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messagecommand");
                    int _cursorIndexOfExtraData_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_messageextraData");
                    if (_cursor.moveToFirst()) {
                        MessageEntity _tmpLastMessage;
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        int _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
                        if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfAttachments) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfSyncStatus_1) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt_1) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt_1) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt_1) && _cursor.isNull(_cursorIndexOfLatestReactions) && _cursor.isNull(_cursorIndexOfOwnReactions) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfExtraData_1))) {
                            String _tmpId = _cursor.getString(_cursorIndexOfId);
                            String _tmpCid = _cursor.getString(_cursorIndexOfCid_1);
                            String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                            String _tmpText = _cursor.getString(_cursorIndexOfText);
                            String _tmp = _cursor.getString(_cursorIndexOfAttachments);
                            List<Attachment> _tmpAttachments = ChannelDao_Impl.this.__listConverter.stringToAttachmentList(_tmp);
                            String _tmpType_1 = _cursor.getString(_cursorIndexOfType_1);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus_1);
                            SyncStatus _tmpSyncStatus = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                            int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                            Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt_1) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt_1));
                            Date _tmpCreatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                            Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                            Date _tmpCreatedLocallyAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                            Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt_1));
                            Date _tmpUpdatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                            Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                            Date _tmpUpdatedLocallyAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                            Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt_1) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt_1));
                            Date _tmpDeletedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                            String _tmp_7 = _cursor.getString(_cursorIndexOfLatestReactions);
                            List<ReactionEntity> _tmpLatestReactions = ChannelDao_Impl.this.__listConverter.stringToReactionList(_tmp_7);
                            String _tmp_8 = _cursor.getString(_cursorIndexOfOwnReactions);
                            List<ReactionEntity> _tmpOwnReactions = ChannelDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                            String _tmp_9 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                            List<String> _tmpMentionedUsersId = ChannelDao_Impl.this.__listConverter.stringToStringList(_tmp_9);
                            String _tmp_10 = _cursor.getString(_cursorIndexOfReactionCounts);
                            Map<String, Integer> _tmpReactionCounts = ChannelDao_Impl.this.__mapConverter.stringToMap(_tmp_10);
                            String _tmp_11 = _cursor.getString(_cursorIndexOfReactionScores);
                            Map<String, Integer> _tmpReactionScores = ChannelDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                            String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                            String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                            String _tmp_12 = _cursor.getString(_cursorIndexOfExtraData_1);
                            Map<String, Object> _tmpExtraData = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_12);
                            _tmpLastMessage = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType_1, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpExtraData);
                        } else {
                            _tmpLastMessage = null;
                        }
                        _result = new ChannelEntity(_tmpType, _tmpChannelId, _tmpCooldown);
                        String _tmpCid_1 = _cursor.getString(_cursorIndexOfCid);
                        _result.setCid(_tmpCid_1);
                        String _tmpCreatedByUserId = _cursor.getString(_cursorIndexOfCreatedByUserId);
                        _result.setCreatedByUserId(_tmpCreatedByUserId);
                        int _tmp_13 = _cursor.getInt(_cursorIndexOfFrozen);
                        boolean _tmpFrozen = _tmp_13 != 0;
                        _result.setFrozen(_tmpFrozen);
                        Integer _tmp_14 = _cursor.isNull(_cursorIndexOfHidden) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfHidden));
                        Boolean _tmpHidden = _tmp_14 == null ? null : Boolean.valueOf(_tmp_14 != 0);
                        _result.setHidden(_tmpHidden);
                        Long _tmp_15 = _cursor.isNull(_cursorIndexOfHideMessagesBefore) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfHideMessagesBefore));
                        Date _tmpHideMessagesBefore = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_15);
                        _result.setHideMessagesBefore(_tmpHideMessagesBefore);
                        Long _tmp_16 = _cursor.isNull(_cursorIndexOfMutedTill) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfMutedTill));
                        Date _tmpMutedTill = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_16);
                        _result.setMutedTill(_tmpMutedTill);
                        String _tmp_17 = _cursor.getString(_cursorIndexOfMembers);
                        Map<String, MemberEntity> _tmpMembers = ChannelDao_Impl.this.__mapConverter.stringToMemberMap(_tmp_17);
                        _result.setMembers(_tmpMembers);
                        String _tmp_18 = _cursor.getString(_cursorIndexOfReads);
                        Map<String, ChannelUserReadEntity> _tmpReads = ChannelDao_Impl.this.__mapConverter.stringToReadMap(_tmp_18);
                        _result.setReads(_tmpReads);
                        Long _tmp_19 = _cursor.isNull(_cursorIndexOfLastMessageAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastMessageAt));
                        Date _tmpLastMessageAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_19);
                        _result.setLastMessageAt(_tmpLastMessageAt);
                        Long _tmp_20 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt_1 = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_20);
                        _result.setCreatedAt(_tmpCreatedAt_1);
                        Long _tmp_21 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt_1 = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_21);
                        _result.setUpdatedAt(_tmpUpdatedAt_1);
                        Long _tmp_22 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt_1 = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_22);
                        _result.setDeletedAt(_tmpDeletedAt_1);
                        String _tmp_23 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData_1 = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_23);
                        _result.setExtraData(_tmpExtraData_1);
                        int _tmp_24 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus_1 = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_24);
                        _result.setSyncStatus(_tmpSyncStatus_1);
                        _result.setLastMessage(_tmpLastMessage);
                    } else {
                        _result = null;
                    }
                    ChannelEntity channelEntity = _result;
                    return channelEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }
}

