/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.entity;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.livedata.entity.ChannelUserReadEntity;
import io.getstream.chat.android.livedata.entity.MemberEntity;
import io.getstream.chat.android.livedata.entity.MessageEntity;
import io.getstream.chat.android.livedata.repository.MessageRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010T\u001a\u00020\u0006H\u00c6\u0003J\t\u0010U\u001a\u00020\u0006H\u00c6\u0003J\t\u0010V\u001a\u00020\tH\u00c6\u0003J'\u0010W\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010X\u001a\u00020'2\b\u0010Y\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010Z\u001a\u00020\tH\u00d6\u0001J\u001e\u0010[\u001a\u0004\u0018\u00010\u00152\b\u0010\\\u001a\u0004\u0018\u00010\u00152\b\u0010]\u001a\u0004\u0018\u00010\u0015H\u0002J\u001a\u0010^\u001a\u00020\u00032\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020a0`J\t\u0010b\u001a\u00020\u0006H\u00d6\u0001J\u0015\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u000206H\u0000\u00a2\u0006\u0002\bfJ\u000e\u0010g\u001a\u00020d2\u0006\u0010h\u001a\u00020iR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\f\"\u0004\b\u001c\u0010\u000eR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R&\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001e\u0010,\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00101\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001c\u00102\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0017\"\u0004\b4\u0010\u0019R \u00105\u001a\u0004\u0018\u0001068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001c\u0010;\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0017\"\u0004\b=\u0010\u0019R&\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020?0!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010#\"\u0004\bA\u0010%R\u001c\u0010B\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0017\"\u0004\bD\u0010\u0019R&\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020F0!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010#\"\u0004\bH\u0010%R\u001a\u0010I\u001a\u00020JX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010\f\"\u0004\bP\u0010\u000eR\u001c\u0010Q\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010\u0017\"\u0004\bS\u0010\u0019\u00a8\u0006j"}, d2={"Lio/getstream/chat/android/livedata/entity/ChannelEntity;", "", "c", "Lio/getstream/chat/android/client/models/Channel;", "(Lio/getstream/chat/android/client/models/Channel;)V", "type", "", "channelId", "cooldown", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "getChannelId", "()Ljava/lang/String;", "setChannelId", "(Ljava/lang/String;)V", "cid", "getCid", "setCid", "getCooldown", "()I", "createdAt", "Ljava/util/Date;", "getCreatedAt", "()Ljava/util/Date;", "setCreatedAt", "(Ljava/util/Date;)V", "createdByUserId", "getCreatedByUserId", "setCreatedByUserId", "deletedAt", "getDeletedAt", "setDeletedAt", "extraData", "", "getExtraData", "()Ljava/util/Map;", "setExtraData", "(Ljava/util/Map;)V", "frozen", "", "getFrozen", "()Z", "setFrozen", "(Z)V", "hidden", "getHidden", "()Ljava/lang/Boolean;", "setHidden", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "hideMessagesBefore", "getHideMessagesBefore", "setHideMessagesBefore", "lastMessage", "Lio/getstream/chat/android/livedata/entity/MessageEntity;", "getLastMessage", "()Lio/getstream/chat/android/livedata/entity/MessageEntity;", "setLastMessage", "(Lio/getstream/chat/android/livedata/entity/MessageEntity;)V", "lastMessageAt", "getLastMessageAt", "setLastMessageAt", "members", "Lio/getstream/chat/android/livedata/entity/MemberEntity;", "getMembers", "setMembers", "mutedTill", "getMutedTill", "setMutedTill", "reads", "Lio/getstream/chat/android/livedata/entity/ChannelUserReadEntity;", "getReads", "setReads", "syncStatus", "Lio/getstream/chat/android/client/utils/SyncStatus;", "getSyncStatus", "()Lio/getstream/chat/android/client/utils/SyncStatus;", "setSyncStatus", "(Lio/getstream/chat/android/client/utils/SyncStatus;)V", "getType", "setType", "updatedAt", "getUpdatedAt", "setUpdatedAt", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "max", "date", "otherDate", "toChannel", "userMap", "", "Lio/getstream/chat/android/client/models/User;", "toString", "updateLastMessage", "", "messageEntity", "updateLastMessage$stream_chat_android_offline_release", "updateReads", "read", "Lio/getstream/chat/android/client/models/ChannelUserRead;", "stream-chat-android-offline_release"})
@Entity(tableName="stream_chat_channel_state", indices={@Index(value={"syncStatus"})})
public final class ChannelEntity {
    @PrimaryKey
    @NotNull
    private String cid;
    @Nullable
    private String createdByUserId;
    private boolean frozen;
    @Nullable
    private Boolean hidden;
    @Nullable
    private Date hideMessagesBefore;
    @Nullable
    private Date mutedTill;
    @NotNull
    private Map<String, MemberEntity> members;
    @NotNull
    private Map<String, ChannelUserReadEntity> reads;
    @Nullable
    private Date lastMessageAt;
    @Embedded(prefix="last_message")
    @Nullable
    private MessageEntity lastMessage;
    @Nullable
    private Date createdAt;
    @Nullable
    private Date updatedAt;
    @Nullable
    private Date deletedAt;
    @NotNull
    private Map<String, Object> extraData;
    @NotNull
    private SyncStatus syncStatus;
    @NotNull
    private String type;
    @NotNull
    private String channelId;
    private final int cooldown;

    @NotNull
    public final String getCid() {
        return this.cid;
    }

    public final void setCid(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.cid = string;
    }

    @Nullable
    public final String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public final void setCreatedByUserId(@Nullable String string) {
        this.createdByUserId = string;
    }

    public final boolean getFrozen() {
        return this.frozen;
    }

    public final void setFrozen(boolean bl) {
        this.frozen = bl;
    }

    @Nullable
    public final Boolean getHidden() {
        return this.hidden;
    }

    public final void setHidden(@Nullable Boolean bl) {
        this.hidden = bl;
    }

    @Nullable
    public final Date getHideMessagesBefore() {
        return this.hideMessagesBefore;
    }

    public final void setHideMessagesBefore(@Nullable Date date) {
        this.hideMessagesBefore = date;
    }

    @Nullable
    public final Date getMutedTill() {
        return this.mutedTill;
    }

    public final void setMutedTill(@Nullable Date date) {
        this.mutedTill = date;
    }

    @NotNull
    public final Map<String, MemberEntity> getMembers() {
        return this.members;
    }

    public final void setMembers(@NotNull Map<String, MemberEntity> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.members = map2;
    }

    @NotNull
    public final Map<String, ChannelUserReadEntity> getReads() {
        return this.reads;
    }

    public final void setReads(@NotNull Map<String, ChannelUserReadEntity> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.reads = map2;
    }

    @Nullable
    public final Date getLastMessageAt() {
        return this.lastMessageAt;
    }

    public final void setLastMessageAt(@Nullable Date date) {
        this.lastMessageAt = date;
    }

    @Nullable
    public final MessageEntity getLastMessage() {
        return this.lastMessage;
    }

    public final void setLastMessage(@Nullable MessageEntity messageEntity) {
        this.lastMessage = messageEntity;
    }

    @Nullable
    public final Date getCreatedAt() {
        return this.createdAt;
    }

    public final void setCreatedAt(@Nullable Date date) {
        this.createdAt = date;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    public final void setUpdatedAt(@Nullable Date date) {
        this.updatedAt = date;
    }

    @Nullable
    public final Date getDeletedAt() {
        return this.deletedAt;
    }

    public final void setDeletedAt(@Nullable Date date) {
        this.deletedAt = date;
    }

    @NotNull
    public final Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public final void setExtraData(@NotNull Map<String, Object> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.extraData = map2;
    }

    @NotNull
    public final SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public final void setSyncStatus(@NotNull SyncStatus syncStatus) {
        Intrinsics.checkNotNullParameter((Object)syncStatus, (String)"<set-?>");
        this.syncStatus = syncStatus;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Channel toChannel(@NotNull Map<String, User> userMap) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv2;
        Object $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(userMap, (String)"userMap");
        Channel c = new Channel(null, null, null, 0, false, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, this.cooldown, 0x3FFFFF, null);
        c.setType(this.type);
        c.setId(this.channelId);
        c.setCid(this.cid);
        c.setFrozen(this.frozen);
        c.setCreatedAt(this.createdAt);
        c.setUpdatedAt(this.updatedAt);
        c.setDeletedAt(this.deletedAt);
        c.setExtraData(this.extraData);
        c.setLastMessageAt(this.lastMessageAt);
        c.setSyncStatus(this.syncStatus);
        c.setHidden(this.hidden);
        c.setHiddenMessagesBefore(this.hideMessagesBefore);
        Object object = this.members.values();
        Channel channel2 = c;
        boolean $i$f$mapNotNull = false;
        void var5_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv$iv.iterator();
        while (object2.hasNext()) {
            Member member;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object2.next();
            boolean bl = false;
            MemberEntity it = (MemberEntity)element$iv$iv;
            boolean bl2 = false;
            if (it.toMember(userMap) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Member it$iv$iv = member;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection<ChannelUserRead> collection = (List)destination$iv$iv;
        channel2.setMembers((List)collection);
        MessageEntity messageEntity = this.lastMessage;
        if (messageEntity != null) {
            $this$mapNotNull$iv = messageEntity;
            $i$f$mapNotNull = false;
            boolean $this$mapNotNullTo$iv$iv2 = false;
            MessageEntity it = $this$mapNotNull$iv;
            boolean bl = false;
            c.setMessages(CollectionsKt.listOf((Object)MessageRepository.Companion.toModel$stream_chat_android_offline_release(it, userMap)));
        }
        $this$mapNotNull$iv = this.reads.values();
        channel2 = c;
        boolean $i$f$map = false;
        void $this$mapNotNullTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object2 = (ChannelUserReadEntity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ChannelUserRead channelUserRead = it.toChannelUserRead(userMap);
            collection.add(channelUserRead);
        }
        collection = (List)destination$iv$iv;
        channel2.setRead((List)collection);
        object = userMap;
        String string = this.createdByUserId;
        boolean bl = false;
        User user = (User)object.get(string);
        if (user == null) {
            object = "userMap doesnt contain the user " + this.createdByUserId + " for the channel.created_by channel " + this.cid;
            boolean bl6 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        c.setCreatedBy(user);
        return c;
    }

    public final void updateLastMessage$stream_chat_android_offline_release(@NotNull MessageEntity messageEntity) {
        boolean newLastMessage;
        Intrinsics.checkNotNullParameter((Object)messageEntity, (String)"messageEntity");
        Date date = messageEntity.getCreatedAt();
        if (date == null) {
            date = messageEntity.getCreatedLocallyAt();
        }
        Date createdAt = date;
        boolean bl = false;
        boolean bl2 = false;
        if (createdAt == null) {
            boolean bl3 = false;
            String string = "created at cant be null, be sure to set message.createdAt";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Date messageEntityCreatedAt = createdAt;
        MessageEntity messageEntity2 = this.lastMessage;
        boolean updateNeeded = Intrinsics.areEqual((Object)messageEntity.getId(), (Object)(messageEntity2 != null ? messageEntity2.getId() : null));
        boolean bl4 = newLastMessage = this.lastMessageAt == null || messageEntityCreatedAt.after(this.lastMessageAt);
        if (newLastMessage || updateNeeded) {
            this.lastMessageAt = messageEntityCreatedAt;
            this.lastMessage = messageEntity;
        }
    }

    public final void updateReads(@NotNull ChannelUserRead read) {
        Intrinsics.checkNotNullParameter((Object)read, (String)"read");
        ChannelUserReadEntity readEntity = new ChannelUserReadEntity(read);
        this.reads.put(read.getUserId(), readEntity);
    }

    private final Date max(Date date, Date otherDate) {
        Date date2;
        block3: {
            block2: {
                date2 = date;
                if (date2 == null) break block2;
                Date date3 = date2;
                boolean bl = false;
                boolean bl2 = false;
                Date it = date3;
                boolean bl3 = false;
                date2 = otherDate == null || it.after(otherDate) ? date3 : null;
                if (date2 != null) break block3;
            }
            date2 = otherDate;
        }
        return date2;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final void setType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.type = string;
    }

    @NotNull
    public final String getChannelId() {
        return this.channelId;
    }

    public final void setChannelId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.channelId = string;
    }

    public final int getCooldown() {
        return this.cooldown;
    }

    public ChannelEntity(@NotNull String type, @NotNull String channelId, int cooldown) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.type = type;
        this.channelId = channelId;
        this.cooldown = cooldown;
        String string = "%s:%s";
        Object[] objectArray = new Object[]{this.type, this.channelId};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        this.cid = string2;
        boolean bl2 = false;
        this.members = new LinkedHashMap();
        bl2 = false;
        this.reads = new LinkedHashMap();
        bl2 = false;
        this.extraData = new LinkedHashMap();
        this.syncStatus = SyncStatus.COMPLETED;
    }

    public /* synthetic */ ChannelEntity(String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(string, string2, n);
    }

    public ChannelEntity(@NotNull Channel c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this(c.getType(), c.getId(), c.getCooldown());
        this.frozen = c.getFrozen();
        this.createdAt = c.getCreatedAt();
        this.updatedAt = c.getUpdatedAt();
        this.deletedAt = c.getDeletedAt();
        this.extraData = c.getExtraData();
        this.syncStatus = c.getSyncStatus();
        this.hidden = c.getHidden();
        this.hideMessagesBefore = c.getHiddenMessagesBefore();
        boolean bl = false;
        this.members = new LinkedHashMap();
        for (Member m : c.getMembers()) {
            this.members.put(m.getUserId(), new MemberEntity(m));
        }
        boolean m = false;
        this.reads = new LinkedHashMap();
        for (ChannelUserRead r : c.getRead()) {
            this.reads.put(r.getUserId(), new ChannelUserReadEntity(r));
        }
        Message message = (Message)CollectionsKt.lastOrNull((List)c.getMessages());
        if (message != null) {
            Message message2 = message;
            boolean bl2 = false;
            boolean bl3 = false;
            Message message3 = message2;
            boolean bl4 = false;
            this.lastMessage = MessageRepository.Companion.toEntity$stream_chat_android_offline_release(message3);
            this.lastMessageAt = message3.getCreatedAt();
        }
        this.createdByUserId = c.getCreatedBy().getId();
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.channelId;
    }

    public final int component3() {
        return this.cooldown;
    }

    @NotNull
    public final ChannelEntity copy(@NotNull String type, @NotNull String channelId, int cooldown) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new ChannelEntity(type, channelId, cooldown);
    }

    public static /* synthetic */ ChannelEntity copy$default(ChannelEntity channelEntity, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = channelEntity.type;
        }
        if ((n2 & 2) != 0) {
            string2 = channelEntity.channelId;
        }
        if ((n2 & 4) != 0) {
            n = channelEntity.cooldown;
        }
        return channelEntity.copy(string, string2, n);
    }

    @NotNull
    public String toString() {
        return "ChannelEntity(type=" + this.type + ", channelId=" + this.channelId + ", cooldown=" + this.cooldown + ")";
    }

    public int hashCode() {
        String string = this.type;
        String string2 = this.channelId;
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Integer.hashCode(this.cooldown);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ChannelEntity)) break block3;
                ChannelEntity channelEntity = (ChannelEntity)object;
                if (!Intrinsics.areEqual((Object)this.type, (Object)channelEntity.type) || !Intrinsics.areEqual((Object)this.channelId, (Object)channelEntity.channelId) || this.cooldown != channelEntity.cooldown) break block3;
            }
            return true;
        }
        return false;
    }
}

