/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.entity;

import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.User;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010$\u001a\u00020\u00152\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u001c\u0010(\u001a\u0004\u0018\u00010\u00032\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020+0*J\t\u0010,\u001a\u00020\u0006H\u00d6\u0001R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u0007R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000b\"\u0004\b\u001f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u0007\u00a8\u0006-"}, d2={"Lio/getstream/chat/android/livedata/entity/MemberEntity;", "", "r", "Lio/getstream/chat/android/client/models/Member;", "(Lio/getstream/chat/android/client/models/Member;)V", "userId", "", "(Ljava/lang/String;)V", "createdAt", "Ljava/util/Date;", "getCreatedAt", "()Ljava/util/Date;", "setCreatedAt", "(Ljava/util/Date;)V", "inviteAcceptedAt", "getInviteAcceptedAt", "setInviteAcceptedAt", "inviteRejectedAt", "getInviteRejectedAt", "setInviteRejectedAt", "isInvited", "", "()Z", "setInvited", "(Z)V", "role", "getRole", "()Ljava/lang/String;", "setRole", "updatedAt", "getUpdatedAt", "setUpdatedAt", "getUserId", "setUserId", "component1", "copy", "equals", "other", "hashCode", "", "toMember", "userMap", "", "Lio/getstream/chat/android/client/models/User;", "toString", "stream-chat-android-offline_release"})
public final class MemberEntity {
    @NotNull
    private String role;
    @Nullable
    private Date createdAt;
    @Nullable
    private Date updatedAt;
    private boolean isInvited;
    @Nullable
    private Date inviteAcceptedAt;
    @Nullable
    private Date inviteRejectedAt;
    @NotNull
    private String userId;

    @NotNull
    public final String getRole() {
        return this.role;
    }

    public final void setRole(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.role = string;
    }

    @Nullable
    public final Date getCreatedAt() {
        return this.createdAt;
    }

    public final void setCreatedAt(@Nullable Date date) {
        this.createdAt = date;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    public final void setUpdatedAt(@Nullable Date date) {
        this.updatedAt = date;
    }

    public final boolean isInvited() {
        return this.isInvited;
    }

    public final void setInvited(boolean bl) {
        this.isInvited = bl;
    }

    @Nullable
    public final Date getInviteAcceptedAt() {
        return this.inviteAcceptedAt;
    }

    public final void setInviteAcceptedAt(@Nullable Date date) {
        this.inviteAcceptedAt = date;
    }

    @Nullable
    public final Date getInviteRejectedAt() {
        return this.inviteRejectedAt;
    }

    public final void setInviteRejectedAt(@Nullable Date date) {
        this.inviteRejectedAt = date;
    }

    @Nullable
    public final Member toMember(@NotNull Map<String, User> userMap) {
        Intrinsics.checkNotNullParameter(userMap, (String)"userMap");
        User user = userMap.get(this.userId);
        if (user == null) {
            ChatLogger.Companion.get((Object)"MemberEntity").logE("userMap is missing the user with id='" + this.userId + "` needed to create this member");
            return null;
        }
        return new Member(user, this.role, this.createdAt, this.updatedAt, Boolean.valueOf(this.isInvited), this.inviteAcceptedAt, this.inviteRejectedAt);
    }

    @NotNull
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.userId = string;
    }

    public MemberEntity(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.userId = userId;
        this.role = "";
    }

    public MemberEntity(@NotNull Member r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this(r.getUserId());
        String string = r.getRole();
        if (string == null) {
            string = r.getUser().getRole();
        }
        this.role = string;
        this.createdAt = r.getCreatedAt();
        this.updatedAt = r.getUpdatedAt();
        Boolean bl = r.isInvited();
        this.isInvited = bl != null ? bl : false;
        this.inviteAcceptedAt = r.getInviteAcceptedAt();
        this.inviteRejectedAt = r.getInviteRejectedAt();
    }

    @NotNull
    public final String component1() {
        return this.userId;
    }

    @NotNull
    public final MemberEntity copy(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new MemberEntity(userId);
    }

    public static /* synthetic */ MemberEntity copy$default(MemberEntity memberEntity, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = memberEntity.userId;
        }
        return memberEntity.copy(string);
    }

    @NotNull
    public String toString() {
        return "MemberEntity(userId=" + this.userId + ")";
    }

    public int hashCode() {
        String string = this.userId;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MemberEntity)) break block3;
                MemberEntity memberEntity = (MemberEntity)object;
                if (!Intrinsics.areEqual((Object)this.userId, (Object)memberEntity.userId)) break block3;
            }
            return true;
        }
        return false;
    }
}

