/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.livedata.converter.DateConverter;
import io.getstream.chat.android.livedata.converter.ExtraDataConverter;
import io.getstream.chat.android.livedata.converter.ListConverter;
import io.getstream.chat.android.livedata.converter.MapConverter;
import io.getstream.chat.android.livedata.converter.SyncStatusConverter;
import io.getstream.chat.android.livedata.dao.MessageDao;
import io.getstream.chat.android.livedata.entity.MessageEntity;
import io.getstream.chat.android.livedata.entity.ReactionEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class MessageDao_Impl
implements MessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MessageEntity> __insertionAdapterOfMessageEntity;
    private final ListConverter __listConverter = new ListConverter();
    private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();
    private final DateConverter __dateConverter = new DateConverter();
    private final MapConverter __mapConverter = new MapConverter();
    private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();
    private final SharedSQLiteStatement __preparedStmtOfDeleteChannelMessagesBefore;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessage;

    public MessageDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMessageEntity = new EntityInsertionAdapter<MessageEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_message` (`id`,`cid`,`userId`,`text`,`attachments`,`type`,`syncStatus`,`replyCount`,`createdAt`,`createdLocallyAt`,`updatedAt`,`updatedLocallyAt`,`deletedAt`,`latestReactions`,`ownReactions`,`mentionedUsersId`,`reactionCounts`,`reactionScores`,`parentId`,`command`,`shadowed`,`extraData`,`replyToId`,`threadParticipantsIds`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MessageEntity value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getCid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getCid());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getText() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getText());
                }
                String _tmp = MessageDao_Impl.this.__listConverter.attachmentListToString(value.getAttachments());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                if (value.getType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getType());
                }
                int _tmp_1 = MessageDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(7, (long)_tmp_1);
                stmt.bindLong(8, (long)value.getReplyCount());
                Long _tmp_2 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, _tmp_2.longValue());
                }
                Long _tmp_3 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedLocallyAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, _tmp_3.longValue());
                }
                Long _tmp_4 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, _tmp_4.longValue());
                }
                Long _tmp_5 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedLocallyAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, _tmp_5.longValue());
                }
                Long _tmp_6 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, _tmp_6.longValue());
                }
                String _tmp_7 = MessageDao_Impl.this.__listConverter.reactionListToString(value.getLatestReactions());
                if (_tmp_7 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_7);
                }
                String _tmp_8 = MessageDao_Impl.this.__listConverter.reactionListToString(value.getOwnReactions());
                if (_tmp_8 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_8);
                }
                String _tmp_9 = MessageDao_Impl.this.__listConverter.stringListToString(value.getMentionedUsersId());
                if (_tmp_9 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_9);
                }
                String _tmp_10 = MessageDao_Impl.this.__mapConverter.mapToString(value.getReactionCounts());
                if (_tmp_10 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_10);
                }
                String _tmp_11 = MessageDao_Impl.this.__mapConverter.mapToString(value.getReactionScores());
                if (_tmp_11 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_11);
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getParentId());
                }
                if (value.getCommand() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getCommand());
                }
                int _tmp_12 = value.getShadowed() ? 1 : 0;
                stmt.bindLong(21, (long)_tmp_12);
                String _tmp_13 = MessageDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_13 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_13);
                }
                if (value.getReplyToId() == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, value.getReplyToId());
                }
                String _tmp_14 = MessageDao_Impl.this.__listConverter.stringListToString(value.getThreadParticipantsIds());
                if (_tmp_14 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_14);
                }
            }
        };
        this.__preparedStmtOfDeleteChannelMessagesBefore = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_chat_message WHERE cid = ? AND createdAt < ?";
                return "DELETE from stream_chat_message WHERE cid = ? AND createdAt < ?";
            }
        };
        this.__preparedStmtOfDeleteMessage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_chat_message WHERE cid = ? AND id = ?";
                return "DELETE from stream_chat_message WHERE cid = ? AND id = ?";
            }
        };
    }

    @Override
    public Object insertMany(final List<MessageEntity> messageEntities, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageDao_Impl.this.__insertionAdapterOfMessageEntity.insert((Iterable)messageEntities);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object insert(final MessageEntity messageEntity, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageDao_Impl.this.__insertionAdapterOfMessageEntity.insert((Object)messageEntity);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object deleteChannelMessagesBefore(final String cid, final Date deleteMessagesBefore, Continuation<? super Unit> p2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = MessageDao_Impl.this.__preparedStmtOfDeleteChannelMessagesBefore.acquire();
                int _argIndex = 1;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                _argIndex = 2;
                Long _tmp = MessageDao_Impl.this.__dateConverter.dateToTimestamp(deleteMessagesBefore);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, _tmp.longValue());
                }
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                    MessageDao_Impl.this.__preparedStmtOfDeleteChannelMessagesBefore.release(_stmt);
                }
            }
        }, p2);
    }

    @Override
    public Object deleteMessage(final String cid, final String messageId, Continuation<? super Unit> p2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = MessageDao_Impl.this.__preparedStmtOfDeleteMessage.acquire();
                int _argIndex = 1;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                _argIndex = 2;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, messageId);
                }
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                    MessageDao_Impl.this.__preparedStmtOfDeleteMessage.release(_stmt);
                }
            }
        }, p2);
    }

    @Override
    public Object messagesForChannelNewerThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> p3) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND createdAt > ? ORDER BY createdAt ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND createdAt > ? ORDER BY createdAt ASC LIMIT ?", (int)3);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                    int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                    int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                    ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpText = _cursor.getString(_cursorIndexOfText);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfAttachments);
                        List<Attachment> _tmpAttachments = MessageDao_Impl.this.__listConverter.stringToAttachmentList(_tmp_1);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                        int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                        Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                        Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfLatestReactions);
                        List<ReactionEntity> _tmpLatestReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfOwnReactions);
                        List<ReactionEntity> _tmpOwnReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_9);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                        List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                        String _tmp_11 = _cursor.getString(_cursorIndexOfReactionCounts);
                        Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                        String _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
                        Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_12);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                        int _tmp_13 = _cursor.getInt(_cursorIndexOfShadowed);
                        boolean _tmpShadowed = _tmp_13 != 0;
                        String _tmp_14 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_14);
                        String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                        String _tmp_15 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                        List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_15);
                        MessageEntity _item = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                        _result.add(_item);
                    }
                    ArrayList<MessageEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p3);
    }

    @Override
    public Object messagesForChannelEqualOrNewerThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> p3) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND createdAt >= ? ORDER BY createdAt ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND createdAt >= ? ORDER BY createdAt ASC LIMIT ?", (int)3);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                    int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                    int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                    ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpText = _cursor.getString(_cursorIndexOfText);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfAttachments);
                        List<Attachment> _tmpAttachments = MessageDao_Impl.this.__listConverter.stringToAttachmentList(_tmp_1);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                        int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                        Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                        Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfLatestReactions);
                        List<ReactionEntity> _tmpLatestReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfOwnReactions);
                        List<ReactionEntity> _tmpOwnReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_9);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                        List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                        String _tmp_11 = _cursor.getString(_cursorIndexOfReactionCounts);
                        Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                        String _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
                        Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_12);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                        int _tmp_13 = _cursor.getInt(_cursorIndexOfShadowed);
                        boolean _tmpShadowed = _tmp_13 != 0;
                        String _tmp_14 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_14);
                        String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                        String _tmp_15 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                        List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_15);
                        MessageEntity _item = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                        _result.add(_item);
                    }
                    ArrayList<MessageEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p3);
    }

    @Override
    public Object messagesForChannelOlderThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> p3) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND createdAt < ? ORDER BY createdAt DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND createdAt < ? ORDER BY createdAt DESC LIMIT ?", (int)3);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                    int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                    int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                    ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpText = _cursor.getString(_cursorIndexOfText);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfAttachments);
                        List<Attachment> _tmpAttachments = MessageDao_Impl.this.__listConverter.stringToAttachmentList(_tmp_1);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                        int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                        Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                        Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfLatestReactions);
                        List<ReactionEntity> _tmpLatestReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfOwnReactions);
                        List<ReactionEntity> _tmpOwnReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_9);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                        List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                        String _tmp_11 = _cursor.getString(_cursorIndexOfReactionCounts);
                        Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                        String _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
                        Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_12);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                        int _tmp_13 = _cursor.getInt(_cursorIndexOfShadowed);
                        boolean _tmpShadowed = _tmp_13 != 0;
                        String _tmp_14 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_14);
                        String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                        String _tmp_15 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                        List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_15);
                        MessageEntity _item = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                        _result.add(_item);
                    }
                    ArrayList<MessageEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p3);
    }

    @Override
    public Object messagesForChannelEqualOrOlderThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> p3) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND createdAt <= ? ORDER BY createdAt DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND createdAt <= ? ORDER BY createdAt DESC LIMIT ?", (int)3);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                    int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                    int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                    ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpText = _cursor.getString(_cursorIndexOfText);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfAttachments);
                        List<Attachment> _tmpAttachments = MessageDao_Impl.this.__listConverter.stringToAttachmentList(_tmp_1);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                        int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                        Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                        Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfLatestReactions);
                        List<ReactionEntity> _tmpLatestReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfOwnReactions);
                        List<ReactionEntity> _tmpOwnReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_9);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                        List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                        String _tmp_11 = _cursor.getString(_cursorIndexOfReactionCounts);
                        Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                        String _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
                        Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_12);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                        int _tmp_13 = _cursor.getInt(_cursorIndexOfShadowed);
                        boolean _tmpShadowed = _tmp_13 != 0;
                        String _tmp_14 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_14);
                        String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                        String _tmp_15 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                        List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_15);
                        MessageEntity _item = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                        _result.add(_item);
                    }
                    ArrayList<MessageEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p3);
    }

    @Override
    public Object messagesForChannel(String cid, int limit, Continuation<? super List<MessageEntity>> p2) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? ORDER BY createdAt DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? ORDER BY createdAt DESC LIMIT ?", (int)2);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                    int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                    int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                    ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpText = _cursor.getString(_cursorIndexOfText);
                        String _tmp = _cursor.getString(_cursorIndexOfAttachments);
                        List<Attachment> _tmpAttachments = MessageDao_Impl.this.__listConverter.stringToAttachmentList(_tmp);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                        int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                        Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                        Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfLatestReactions);
                        List<ReactionEntity> _tmpLatestReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_7);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfOwnReactions);
                        List<ReactionEntity> _tmpOwnReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                        List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_9);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfReactionCounts);
                        Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_10);
                        String _tmp_11 = _cursor.getString(_cursorIndexOfReactionScores);
                        Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                        int _tmp_12 = _cursor.getInt(_cursorIndexOfShadowed);
                        boolean _tmpShadowed = _tmp_12 != 0;
                        String _tmp_13 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_13);
                        String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                        String _tmp_14 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                        List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_14);
                        MessageEntity _item = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                        _result.add(_item);
                    }
                    ArrayList<MessageEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p2);
    }

    @Override
    public Object select(List<String> ids, Continuation<? super List<MessageEntity>> p1) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" FROM stream_chat_message WHERE stream_chat_message.id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                    int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                    int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                    ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpText = _cursor.getString(_cursorIndexOfText);
                        String _tmp = _cursor.getString(_cursorIndexOfAttachments);
                        List<Attachment> _tmpAttachments = MessageDao_Impl.this.__listConverter.stringToAttachmentList(_tmp);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                        int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                        Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                        Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfLatestReactions);
                        List<ReactionEntity> _tmpLatestReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_7);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfOwnReactions);
                        List<ReactionEntity> _tmpOwnReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                        List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_9);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfReactionCounts);
                        Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_10);
                        String _tmp_11 = _cursor.getString(_cursorIndexOfReactionScores);
                        Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                        int _tmp_12 = _cursor.getInt(_cursorIndexOfShadowed);
                        boolean _tmpShadowed = _tmp_12 != 0;
                        String _tmp_13 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_13);
                        String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                        String _tmp_14 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                        List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_14);
                        MessageEntity _item_1 = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                        _result.add(_item_1);
                    }
                    ArrayList<MessageEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object select(String id, Continuation<? super MessageEntity> p1) {
        String _sql = "SELECT * FROM stream_chat_message WHERE stream_chat_message.id IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_message WHERE stream_chat_message.id IN (?)", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<MessageEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MessageEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    MessageEntity _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                    int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                    int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpText = _cursor.getString(_cursorIndexOfText);
                        String _tmp = _cursor.getString(_cursorIndexOfAttachments);
                        List<Attachment> _tmpAttachments = MessageDao_Impl.this.__listConverter.stringToAttachmentList(_tmp);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                        int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                        Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                        Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfLatestReactions);
                        List<ReactionEntity> _tmpLatestReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_7);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfOwnReactions);
                        List<ReactionEntity> _tmpOwnReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                        List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_9);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfReactionCounts);
                        Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_10);
                        String _tmp_11 = _cursor.getString(_cursorIndexOfReactionScores);
                        Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                        int _tmp_12 = _cursor.getInt(_cursorIndexOfShadowed);
                        boolean _tmpShadowed = _tmp_12 != 0;
                        String _tmp_13 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_13);
                        String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                        String _tmp_14 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                        List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_14);
                        _result = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                    } else {
                        _result = null;
                    }
                    MessageEntity messageEntity = _result;
                    return messageEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object selectSyncNeeded(SyncStatus syncStatus, Continuation<? super List<MessageEntity>> p1) {
        String _sql = "SELECT * FROM stream_chat_message WHERE stream_chat_message.syncStatus IN (?) ORDER BY createdAt ASC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_message WHERE stream_chat_message.syncStatus IN (?) ORDER BY createdAt ASC", (int)1);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfLatestReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestReactions");
                    int _cursorIndexOfOwnReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownReactions");
                    int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                    int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                    int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                    int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                    int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                    ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpText = _cursor.getString(_cursorIndexOfText);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfAttachments);
                        List<Attachment> _tmpAttachments = MessageDao_Impl.this.__listConverter.stringToAttachmentList(_tmp_1);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                        int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                        Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                        Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfLatestReactions);
                        List<ReactionEntity> _tmpLatestReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfOwnReactions);
                        List<ReactionEntity> _tmpOwnReactions = MessageDao_Impl.this.__listConverter.stringToReactionList(_tmp_9);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                        List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                        String _tmp_11 = _cursor.getString(_cursorIndexOfReactionCounts);
                        Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_11);
                        String _tmp_12 = _cursor.getString(_cursorIndexOfReactionScores);
                        Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_12);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                        int _tmp_13 = _cursor.getInt(_cursorIndexOfShadowed);
                        boolean _tmpShadowed = _tmp_13 != 0;
                        String _tmp_14 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_14);
                        String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                        String _tmp_15 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                        List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_15);
                        MessageEntity _item = new MessageEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpAttachments, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpLatestReactions, _tmpOwnReactions, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                        _result.add(_item);
                    }
                    ArrayList<MessageEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }
}

