/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.livedata.converter.DateConverter;
import io.getstream.chat.android.livedata.converter.ExtraDataConverter;
import io.getstream.chat.android.livedata.converter.SyncStatusConverter;
import io.getstream.chat.android.livedata.dao.ReactionDao;
import io.getstream.chat.android.livedata.entity.ReactionEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ReactionDao_Impl
implements ReactionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ReactionEntity> __insertionAdapterOfReactionEntity;
    private final DateConverter __dateConverter = new DateConverter();
    private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();
    private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();

    public ReactionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfReactionEntity = new EntityInsertionAdapter<ReactionEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_reaction` (`score`,`createdAt`,`updatedAt`,`deletedAt`,`extraData`,`syncStatus`,`messageId`,`userId`,`type`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ReactionEntity value) {
                stmt.bindLong(1, (long)value.getScore());
                Long _tmp = ReactionDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, _tmp.longValue());
                }
                Long _tmp_1 = ReactionDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, _tmp_1.longValue());
                }
                Long _tmp_2 = ReactionDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, _tmp_2.longValue());
                }
                String _tmp_3 = ReactionDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                int _tmp_4 = ReactionDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(6, (long)_tmp_4);
                if (value.getMessageId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMessageId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getUserId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getType());
                }
            }
        };
    }

    @Override
    public Object insert(final ReactionEntity reactionEntity, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ReactionDao_Impl.this.__db.beginTransaction();
                try {
                    ReactionDao_Impl.this.__insertionAdapterOfReactionEntity.insert((Object)reactionEntity);
                    ReactionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ReactionDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object insert(final List<ReactionEntity> reactionEntities, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ReactionDao_Impl.this.__db.beginTransaction();
                try {
                    ReactionDao_Impl.this.__insertionAdapterOfReactionEntity.insert((Iterable)reactionEntities);
                    ReactionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ReactionDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object selectSyncNeeded(SyncStatus syncStatus, Continuation<? super List<ReactionEntity>> p1) {
        String _sql = "SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.syncStatus IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.syncStatus IN (?)", (int)1);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<ReactionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ReactionEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"score");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    ArrayList<ReactionEntity> _result = new ArrayList<ReactionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        ReactionEntity _item = new ReactionEntity(_tmpMessageId, _tmpUserId, _tmpType);
                        int _tmpScore = _cursor.getInt(_cursorIndexOfScore);
                        _item.setScore(_tmpScore);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        _item.setCreatedAt(_tmpCreatedAt);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        _item.setDeletedAt(_tmpDeletedAt);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = ReactionDao_Impl.this.__extraDataConverter.stringToMap(_tmp_4);
                        _item.setExtraData(_tmpExtraData);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ReactionDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_5);
                        _item.setSyncStatus(_tmpSyncStatus);
                        _result.add(_item);
                    }
                    ArrayList<ReactionEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object select(String messageId, String userId, String type, Continuation<? super ReactionEntity> p3) {
        String _sql = "SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.messageid = ? AND userId = ? AND type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.messageid = ? AND userId = ? AND type = ?", (int)3);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 3;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<ReactionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReactionEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ReactionEntity _result;
                    int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"score");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    if (_cursor.moveToFirst()) {
                        String _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        _result = new ReactionEntity(_tmpMessageId, _tmpUserId, _tmpType);
                        int _tmpScore = _cursor.getInt(_cursorIndexOfScore);
                        _result.setScore(_tmpScore);
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        _result.setDeletedAt(_tmpDeletedAt);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = ReactionDao_Impl.this.__extraDataConverter.stringToMap(_tmp_3);
                        _result.setExtraData(_tmpExtraData);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ReactionDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_4);
                        _result.setSyncStatus(_tmpSyncStatus);
                    } else {
                        _result = null;
                    }
                    ReactionEntity reactionEntity = _result;
                    return reactionEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p3);
    }
}

