/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.extensions;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.Reaction;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.livedata.request.AnyChannelPaginationRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t*\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u000e\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u0010H\u0000\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u0012*\u0004\u0018\u00010\u0010H\u0000\u001a\u001e\u0010\u0016\u001a\u00020\u000e*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u001a\u0014\u0010\u001a\u001a\u00020\u0012*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u000e*\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u001d\u001a\u00020\u000e*\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u001a\u0012\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\t*\u00020\u0005H\u0000\u001a\u0012\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\t*\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"HTTP_TIMEOUT", "", "HTTP_TOO_MANY_REQUESTS", "lastMessage", "Lio/getstream/chat/android/client/models/Message;", "Lio/getstream/chat/android/client/models/Channel;", "getLastMessage", "(Lio/getstream/chat/android/client/models/Channel;)Lio/getstream/chat/android/client/models/Message;", "applyPagination", "", "", "pagination", "Lio/getstream/chat/android/livedata/request/AnyChannelPaginationRequest;", "incrementUnreadCount", "", "currentUserId", "", "isImageMimetype", "", "isPermanent", "Lio/getstream/chat/android/client/errors/ChatError;", "isVideoMimetype", "setMember", "userId", "member", "Lio/getstream/chat/android/client/models/Member;", "shouldIncrementUnreadCount", "updateLastMessage", "message", "updateReads", "newRead", "Lio/getstream/chat/android/client/models/ChannelUserRead;", "users", "Lio/getstream/chat/android/client/models/User;", "stream-chat-android-offline_release"})
public final class ClientExtensionsKt {
    private static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final int HTTP_TIMEOUT = 408;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<User> users(@NotNull Message $this$users) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$users, (String)"$this$users");
        Iterable $this$mapNotNull$iv = $this$users.getLatestReactions();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            User user;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object receiver = element$iv$iv;
            boolean bl2 = false;
            if (((Reaction)receiver).getUser() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            User it$iv$iv = user;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection collection = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)$this$users.getUser());
        Message message = $this$users.getReplyTo();
        List list = message != null ? ClientExtensionsKt.users(message) : null;
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<User> users(@NotNull Channel $this$users) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        Object receiver;
        boolean bl;
        Collection collection;
        Object item$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$users, (String)"$this$users");
        Iterable $this$map$iv = $this$users.getMembers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            bl = false;
            object = ((Member)receiver).getUser();
            collection.add(object);
        }
        $this$map$iv = $this$users.getRead();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            receiver = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            bl = false;
            User user = ((ChannelUserRead)receiver).getUser();
            object.add(user);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = $this$users.getMessages();
        collection = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)), (Object)$this$users.getCreatedBy());
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Message it = (Message)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = ClientExtensionsKt.users(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        object = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
    }

    @Nullable
    public static final Message getLastMessage(@NotNull Channel $this$lastMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$lastMessage, (String)"$this$lastMessage");
        return (Message)CollectionsKt.lastOrNull((List)$this$lastMessage.getMessages());
    }

    public static final void updateLastMessage(@NotNull Channel $this$updateLastMessage, @NotNull Message message) {
        boolean newLastMessage;
        Intrinsics.checkNotNullParameter((Object)$this$updateLastMessage, (String)"$this$updateLastMessage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Date date = message.getCreatedAt();
        if (date == null) {
            date = message.getCreatedLocallyAt();
        }
        Date createdAt = date;
        boolean bl = false;
        boolean bl2 = false;
        if (createdAt == null) {
            boolean bl3 = false;
            String string = "created at cant be null, be sure to set message.createdAt";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Date messageCreatedAt = createdAt;
        Message message2 = ClientExtensionsKt.getLastMessage($this$updateLastMessage);
        boolean updateNeeded = Intrinsics.areEqual((Object)message.getId(), (Object)(message2 != null ? message2.getId() : null));
        boolean bl4 = newLastMessage = $this$updateLastMessage.getLastMessageAt() == null || messageCreatedAt.after($this$updateLastMessage.getLastMessageAt());
        if (newLastMessage || updateNeeded) {
            $this$updateLastMessage.setLastMessageAt(messageCreatedAt);
            $this$updateLastMessage.setMessages(CollectionsKt.plus((Collection)$this$updateLastMessage.getMessages(), (Object)message));
        }
    }

    public static final void setMember(@NotNull Channel $this$setMember, @NotNull String userId, @Nullable Member member) {
        Intrinsics.checkNotNullParameter((Object)$this$setMember, (String)"$this$setMember");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (member == null) {
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = $this$setMember.getMembers();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Member it = (Member)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUser().getId(), (Object)userId)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Member member2 = v0;
            if (member2 != null) {
                Member member3 = member2;
                boolean bl = false;
                boolean bl2 = false;
                Member foundMember = member3;
                boolean bl3 = false;
                $this$setMember.setMembers(CollectionsKt.minus((Iterable)$this$setMember.getMembers(), (Object)foundMember));
            }
        } else {
            $this$setMember.setMembers(CollectionsKt.plus((Collection)$this$setMember.getMembers(), (Object)member));
        }
    }

    public static final void updateReads(@NotNull Channel $this$updateReads, @NotNull ChannelUserRead newRead) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$updateReads, (String)"$this$updateReads");
            Intrinsics.checkNotNullParameter((Object)newRead, (String)"newRead");
            Iterable $this$firstOrNull$iv = $this$updateReads.getRead();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ChannelUserRead it = (ChannelUserRead)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUser(), (Object)newRead.getUser())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        ChannelUserRead oldRead = v0;
        $this$updateReads.setRead(oldRead != null ? CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)$this$updateReads.getRead(), (Object)oldRead), (Object)newRead) : CollectionsKt.plus((Collection)$this$updateReads.getRead(), (Object)newRead));
    }

    public static final void incrementUnreadCount(@NotNull Channel $this$incrementUnreadCount, @NotNull String currentUserId) {
        block2: {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)$this$incrementUnreadCount, (String)"$this$incrementUnreadCount");
                Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
                Iterable $this$firstOrNull$iv = $this$incrementUnreadCount.getRead();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ChannelUserRead it = (ChannelUserRead)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUser().getId(), (Object)currentUserId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            ChannelUserRead channelUserRead = v0;
            if (channelUserRead == null) break block2;
            ChannelUserRead channelUserRead2 = channelUserRead;
            boolean bl = false;
            boolean bl2 = false;
            ChannelUserRead it = channelUserRead2;
            boolean bl3 = false;
            ChannelUserRead channelUserRead3 = it;
            int n = channelUserRead3.getUnreadMessages();
            channelUserRead3.setUnreadMessages(n + 1);
        }
    }

    public static final boolean shouldIncrementUnreadCount(@NotNull Message $this$shouldIncrementUnreadCount, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldIncrementUnreadCount, (String)"$this$shouldIncrementUnreadCount");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return Intrinsics.areEqual((Object)$this$shouldIncrementUnreadCount.getUser().getId(), (Object)currentUserId) ^ true && !$this$shouldIncrementUnreadCount.getSilent() && !$this$shouldIncrementUnreadCount.getShadowed();
    }

    public static final boolean isPermanent(@NotNull ChatError $this$isPermanent) {
        Intrinsics.checkNotNullParameter((Object)$this$isPermanent, (String)"$this$isPermanent");
        boolean isPermanent = false;
        if ($this$isPermanent instanceof ChatNetworkError) {
            ChatNetworkError networkError = (ChatNetworkError)$this$isPermanent;
            List temporaryStreamErrors = CollectionsKt.listOf((Object[])new Integer[]{429, 408});
            if (networkError.getStreamCode() > 0) {
                isPermanent = true;
                if (temporaryStreamErrors.contains(networkError.getStatusCode())) {
                    isPermanent = false;
                }
            }
        }
        return isPermanent;
    }

    @NotNull
    public static final List<Channel> applyPagination(@NotNull Collection<Channel> $this$applyPagination, @NotNull AnyChannelPaginationRequest pagination) {
        Intrinsics.checkNotNullParameter($this$applyPagination, (String)"$this$applyPagination");
        Intrinsics.checkNotNullParameter((Object)pagination, (String)"pagination");
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.drop((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)$this$applyPagination), (Comparator)pagination.getSort().getComparator()), (int)pagination.getChannelOffset()), (int)pagination.getChannelLimit()));
    }

    public static final boolean isImageMimetype(@Nullable String $this$isImageMimetype) {
        String string = $this$isImageMimetype;
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"image", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isVideoMimetype(@Nullable String $this$isVideoMimetype) {
        String string = $this$isVideoMimetype;
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"video", (boolean)false, (int)2, null) : false;
    }
}

