/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.service.sync;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import io.getstream.chat.android.livedata.service.sync.BackgroundSyncConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/getstream/chat/android/livedata/service/sync/EncryptedBackgroundSyncConfigStore;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "prefs", "Landroid/content/SharedPreferences;", "clear", "", "get", "Lio/getstream/chat/android/livedata/service/sync/BackgroundSyncConfig;", "put", "config", "stream-chat-android-offline_release"})
public final class EncryptedBackgroundSyncConfigStore {
    private final SharedPreferences prefs;

    public final void put(@NotNull BackgroundSyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SharedPreferences.Editor editor = this.prefs.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$apply = editor;
        boolean bl3 = false;
        $this$apply.putString("api_key", config.getApiKey());
        $this$apply.putString("user_id", config.getUserId());
        $this$apply.putString("user_token", config.getUserToken());
        editor.apply();
    }

    @Nullable
    public final BackgroundSyncConfig get() {
        SharedPreferences sharedPreferences = this.prefs;
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences $this$run = sharedPreferences;
        boolean bl3 = false;
        String string = $this$run.getString("api_key", "");
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(KEY_API_KEY, \"\") ?: \"\"");
        String apiKey = string;
        String string2 = $this$run.getString("user_id", "");
        if (string2 == null) {
            string2 = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(KEY_USER_ID, \"\") ?: \"\"");
        String userId = string2;
        String string3 = $this$run.getString("user_token", "");
        if (string3 == null) {
            string3 = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(KEY_USER_TOKEN, \"\") ?: \"\"");
        String userToken = string3;
        BackgroundSyncConfig config = new BackgroundSyncConfig(apiKey, userId, userToken);
        return config.isValid() ? config : null;
    }

    public final void clear() {
        this.prefs.edit().clear().apply();
    }

    public EncryptedBackgroundSyncConfigStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MasterKey masterKey = new MasterKey.Builder(context, "_stream_sync_config_master_key_").setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"MasterKey.Builder(contex\u2026GCM)\n            .build()");
        MasterKey masterKey2 = masterKey;
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((Context)context, (String)"stream_livedata_sync_config_store", (MasterKey)masterKey2, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"EncryptedSharedPreferenc\u2026heme.AES256_GCM\n        )");
        this.prefs = sharedPreferences;
    }
}

