/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.repository.domain.message;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.livedata.repository.database.converter.DateConverter;
import io.getstream.chat.android.livedata.repository.database.converter.ExtraDataConverter;
import io.getstream.chat.android.livedata.repository.database.converter.ListConverter;
import io.getstream.chat.android.livedata.repository.database.converter.MapConverter;
import io.getstream.chat.android.livedata.repository.database.converter.SyncStatusConverter;
import io.getstream.chat.android.livedata.repository.domain.message.MessageDao;
import io.getstream.chat.android.livedata.repository.domain.message.MessageEntity;
import io.getstream.chat.android.livedata.repository.domain.message.MessageInnerEntity;
import io.getstream.chat.android.livedata.repository.domain.message.attachment.AttachmentEntity;
import io.getstream.chat.android.livedata.repository.domain.message.attachment.UploadStateEntity;
import io.getstream.chat.android.livedata.repository.domain.reaction.ReactionEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;

public final class MessageDao_Impl
extends MessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MessageInnerEntity> __insertionAdapterOfMessageInnerEntity;
    private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();
    private final DateConverter __dateConverter = new DateConverter();
    private final ListConverter __listConverter = new ListConverter();
    private final MapConverter __mapConverter = new MapConverter();
    private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();
    private final EntityInsertionAdapter<AttachmentEntity> __insertionAdapterOfAttachmentEntity;
    private final EntityInsertionAdapter<ReactionEntity> __insertionAdapterOfReactionEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChannelMessagesBefore;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessage;

    public MessageDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMessageInnerEntity = new EntityInsertionAdapter<MessageInnerEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_message` (`id`,`cid`,`userId`,`text`,`type`,`syncStatus`,`replyCount`,`createdAt`,`createdLocallyAt`,`updatedAt`,`updatedLocallyAt`,`deletedAt`,`mentionedUsersId`,`reactionCounts`,`reactionScores`,`parentId`,`command`,`shadowed`,`extraData`,`replyToId`,`threadParticipantsIds`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MessageInnerEntity value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getCid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getCid());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getText() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getText());
                }
                if (value.getType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getType());
                }
                int _tmp = MessageDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(6, (long)_tmp);
                stmt.bindLong(7, (long)value.getReplyCount());
                Long _tmp_1 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, _tmp_1.longValue());
                }
                Long _tmp_2 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedLocallyAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, _tmp_2.longValue());
                }
                Long _tmp_3 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, _tmp_3.longValue());
                }
                Long _tmp_4 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedLocallyAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, _tmp_4.longValue());
                }
                Long _tmp_5 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, _tmp_5.longValue());
                }
                String _tmp_6 = MessageDao_Impl.this.__listConverter.stringListToString(value.getMentionedUsersId());
                if (_tmp_6 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_6);
                }
                String _tmp_7 = MessageDao_Impl.this.__mapConverter.mapToString(value.getReactionCounts());
                if (_tmp_7 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_7);
                }
                String _tmp_8 = MessageDao_Impl.this.__mapConverter.mapToString(value.getReactionScores());
                if (_tmp_8 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_8);
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getParentId());
                }
                if (value.getCommand() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getCommand());
                }
                int _tmp_9 = value.getShadowed() ? 1 : 0;
                stmt.bindLong(18, (long)_tmp_9);
                String _tmp_10 = MessageDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_10 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_10);
                }
                if (value.getReplyToId() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getReplyToId());
                }
                String _tmp_11 = MessageDao_Impl.this.__listConverter.stringListToString(value.getThreadParticipantsIds());
                if (_tmp_11 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_11);
                }
            }
        };
        this.__insertionAdapterOfAttachmentEntity = new EntityInsertionAdapter<AttachmentEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `attachment_inner_entity` (`id`,`messageId`,`authorName`,`titleLink`,`thumbUrl`,`imageUrl`,`assetUrl`,`ogUrl`,`mimeType`,`fileSize`,`title`,`text`,`type`,`image`,`url`,`name`,`fallback`,`uploadFilePath`,`extraData`,`statusCode`,`errorMessage`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AttachmentEntity value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getMessageId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMessageId());
                }
                if (value.getAuthorName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAuthorName());
                }
                if (value.getTitleLink() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTitleLink());
                }
                if (value.getThumbUrl() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getThumbUrl());
                }
                if (value.getImageUrl() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getImageUrl());
                }
                if (value.getAssetUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getAssetUrl());
                }
                if (value.getOgUrl() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getOgUrl());
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getMimeType());
                }
                stmt.bindLong(10, (long)value.getFileSize());
                if (value.getTitle() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getTitle());
                }
                if (value.getText() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getText());
                }
                if (value.getType() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getType());
                }
                if (value.getImage() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getImage());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getUrl());
                }
                if (value.getName() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getName());
                }
                if (value.getFallback() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getFallback());
                }
                if (value.getUploadFilePath() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getUploadFilePath());
                }
                String _tmp = MessageDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp);
                }
                UploadStateEntity _tmpUploadState = value.getUploadState();
                if (_tmpUploadState != null) {
                    stmt.bindLong(20, (long)_tmpUploadState.getStatusCode());
                    if (_tmpUploadState.getErrorMessage() == null) {
                        stmt.bindNull(21);
                    } else {
                        stmt.bindString(21, _tmpUploadState.getErrorMessage());
                    }
                } else {
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                }
            }
        };
        this.__insertionAdapterOfReactionEntity = new EntityInsertionAdapter<ReactionEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_reaction` (`id`,`messageId`,`userId`,`type`,`score`,`createdAt`,`updatedAt`,`deletedAt`,`enforceUnique`,`extraData`,`syncStatus`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ReactionEntity value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getMessageId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMessageId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getType());
                }
                stmt.bindLong(5, (long)value.getScore());
                Long _tmp = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp.longValue());
                }
                Long _tmp_1 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, _tmp_1.longValue());
                }
                Long _tmp_2 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, _tmp_2.longValue());
                }
                int _tmp_3 = value.getEnforceUnique() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_3);
                String _tmp_4 = MessageDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                int _tmp_5 = MessageDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(11, (long)_tmp_5);
            }
        };
        this.__preparedStmtOfDeleteChannelMessagesBefore = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_chat_message WHERE cid = ? AND createdAt < ?";
                return "DELETE from stream_chat_message WHERE cid = ? AND createdAt < ?";
            }
        };
        this.__preparedStmtOfDeleteMessage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_chat_message WHERE cid = ? AND id = ?";
                return "DELETE from stream_chat_message WHERE cid = ? AND id = ?";
            }
        };
    }

    @Override
    protected Object insertMessageInnerEntity(final MessageInnerEntity messageInnerEntity, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageDao_Impl.this.__insertionAdapterOfMessageInnerEntity.insert((Object)messageInnerEntity);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    protected Object insertMessageInnerEntities(final List<MessageInnerEntity> messageInnerEntities, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageDao_Impl.this.__insertionAdapterOfMessageInnerEntity.insert((Iterable)messageInnerEntities);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    protected Object insertAttachments(final List<AttachmentEntity> attachmentEntities, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageDao_Impl.this.__insertionAdapterOfAttachmentEntity.insert((Iterable)attachmentEntities);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    protected Object insertReactions(final List<ReactionEntity> reactions, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageDao_Impl.this.__insertionAdapterOfReactionEntity.insert((Iterable)reactions);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object insert(final List<MessageEntity> p0, Continuation<? super Unit> p1) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return MessageDao_Impl.access$901(MessageDao_Impl.this, p0, __cont);
            }
        }, p1);
    }

    @Override
    public Object insert(final MessageEntity p0, Continuation<? super Unit> p1) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return MessageDao_Impl.access$1001(MessageDao_Impl.this, p0, __cont);
            }
        }, p1);
    }

    @Override
    public Object deleteChannelMessagesBefore(final String cid, final Date deleteMessagesBefore, Continuation<? super Unit> p2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = MessageDao_Impl.this.__preparedStmtOfDeleteChannelMessagesBefore.acquire();
                int _argIndex = 1;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                _argIndex = 2;
                Long _tmp = MessageDao_Impl.this.__dateConverter.dateToTimestamp(deleteMessagesBefore);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, _tmp.longValue());
                }
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                    MessageDao_Impl.this.__preparedStmtOfDeleteChannelMessagesBefore.release(_stmt);
                }
            }
        }, p2);
    }

    @Override
    public Object deleteMessage(final String cid, final String messageId, Continuation<? super Unit> p2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = MessageDao_Impl.this.__preparedStmtOfDeleteMessage.acquire();
                int _argIndex = 1;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                _argIndex = 2;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, messageId);
                }
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                    MessageDao_Impl.this.__preparedStmtOfDeleteMessage.release(_stmt);
                }
            }
        }, p2);
    }

    @Override
    public Object messagesForChannelNewerThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> p3) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND createdAt > ? ORDER BY createdAt ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND createdAt > ? ORDER BY createdAt ASC LIMIT ?", (int)3);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds))) {
                                String _tmpId = _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.getString(_cursorIndexOfText);
                                String _tmpType = _cursor.getString(_cursorIndexOfType);
                                int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                String _tmp_7 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_7);
                                String _tmp_8 = _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_8);
                                String _tmp_9 = _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_9);
                                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_10 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_10 != 0;
                                String _tmp_11 = _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_11);
                                String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                                String _tmp_12 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_12);
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p3);
    }

    @Override
    public Object messagesForChannelEqualOrNewerThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> p3) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND createdAt >= ? ORDER BY createdAt ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND createdAt >= ? ORDER BY createdAt ASC LIMIT ?", (int)3);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds))) {
                                String _tmpId = _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.getString(_cursorIndexOfText);
                                String _tmpType = _cursor.getString(_cursorIndexOfType);
                                int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                String _tmp_7 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_7);
                                String _tmp_8 = _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_8);
                                String _tmp_9 = _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_9);
                                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_10 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_10 != 0;
                                String _tmp_11 = _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_11);
                                String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                                String _tmp_12 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_12);
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p3);
    }

    @Override
    public Object messagesForChannelOlderThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> p3) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND createdAt < ? ORDER BY createdAt DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND createdAt < ? ORDER BY createdAt DESC LIMIT ?", (int)3);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds))) {
                                String _tmpId = _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.getString(_cursorIndexOfText);
                                String _tmpType = _cursor.getString(_cursorIndexOfType);
                                int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                String _tmp_7 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_7);
                                String _tmp_8 = _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_8);
                                String _tmp_9 = _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_9);
                                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_10 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_10 != 0;
                                String _tmp_11 = _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_11);
                                String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                                String _tmp_12 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_12);
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p3);
    }

    @Override
    public Object messagesForChannelEqualOrOlderThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> p3) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND createdAt <= ? ORDER BY createdAt DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND createdAt <= ? ORDER BY createdAt DESC LIMIT ?", (int)3);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds))) {
                                String _tmpId = _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.getString(_cursorIndexOfText);
                                String _tmpType = _cursor.getString(_cursorIndexOfType);
                                int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                String _tmp_7 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_7);
                                String _tmp_8 = _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_8);
                                String _tmp_9 = _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_9);
                                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_10 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_10 != 0;
                                String _tmp_11 = _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_11);
                                String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                                String _tmp_12 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_12);
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p3);
    }

    @Override
    public Object messagesForChannel(String cid, int limit, Continuation<? super List<MessageEntity>> p2) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? ORDER BY createdAt DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? ORDER BY createdAt DESC LIMIT ?", (int)2);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds))) {
                                String _tmpId = _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.getString(_cursorIndexOfText);
                                String _tmpType = _cursor.getString(_cursorIndexOfType);
                                int _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                                Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                String _tmp_6 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_6);
                                String _tmp_7 = _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_7);
                                String _tmp_8 = _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_8);
                                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_9 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_9 != 0;
                                String _tmp_10 = _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_10);
                                String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                                String _tmp_11 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_11);
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p2);
    }

    @Override
    public Object select(List<String> ids, Continuation<? super List<MessageEntity>> p1) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" FROM stream_chat_message WHERE stream_chat_message.id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds))) {
                                String _tmpId = _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.getString(_cursorIndexOfText);
                                String _tmpType = _cursor.getString(_cursorIndexOfType);
                                int _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                                Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                String _tmp_6 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_6);
                                String _tmp_7 = _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_7);
                                String _tmp_8 = _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_8);
                                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_9 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_9 != 0;
                                String _tmp_10 = _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_10);
                                String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                                String _tmp_11 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_11);
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item_1 = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item_1);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object select(String id, Continuation<? super MessageEntity> p1) {
        String _sql = "SELECT * FROM stream_chat_message WHERE stream_chat_message.id IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_message WHERE stream_chat_message.id IN (?)", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<MessageEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MessageEntity call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageEntity messageEntity;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        MessageEntity _result;
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        if (_cursor.moveToFirst()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds))) {
                                String _tmpId = _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.getString(_cursorIndexOfText);
                                String _tmpType = _cursor.getString(_cursorIndexOfType);
                                int _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                                Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                String _tmp_6 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_6);
                                String _tmp_7 = _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_7);
                                String _tmp_8 = _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_8);
                                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_9 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_9 != 0;
                                String _tmp_10 = _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_10);
                                String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                                String _tmp_11 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_11);
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            _result = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                        } else {
                            _result = null;
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        messageEntity = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return messageEntity;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object selectSyncNeeded(SyncStatus syncStatus, Continuation<? super List<MessageEntity>> p1) {
        String _sql = "SELECT * FROM stream_chat_message WHERE stream_chat_message.syncStatus IN (?) ORDER BY createdAt ASC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_message WHERE stream_chat_message.syncStatus IN (?) ORDER BY createdAt ASC", (int)1);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds))) {
                                String _tmpId = _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.getString(_cursorIndexOfText);
                                String _tmpType = _cursor.getString(_cursorIndexOfType);
                                int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                String _tmp_7 = _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmpMentionedUsersId = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_7);
                                String _tmp_8 = _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmpReactionCounts = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_8);
                                String _tmp_9 = _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmpReactionScores = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_9);
                                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_10 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_10 != 0;
                                String _tmp_11 = _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmpExtraData = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_11);
                                String _tmpReplyToId = _cursor.getString(_cursorIndexOfReplyToId);
                                String _tmp_12 = _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmpThreadParticipantsIds = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_12);
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpType, _tmpSyncStatus, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpExtraData, _tmpReplyToId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity(ArrayMap<String, ArrayList<AttachmentEntity>> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidLivedataRepositoryDomainMessageAttachmentAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `id`,`messageId`,`authorName`,`titleLink`,`thumbUrl`,`imageUrl`,`assetUrl`,`ogUrl`,`mimeType`,`fileSize`,`title`,`text`,`type`,`image`,`url`,`name`,`fallback`,`uploadFilePath`,`extraData`,`statusCode`,`errorMessage` FROM `attachment_inner_entity` WHERE `messageId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"messageId");
            if (_itemKeyIndex == -1) {
                return;
            }
            int _cursorIndexOfId = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"id");
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfAuthorName = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"authorName");
            int _cursorIndexOfTitleLink = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"titleLink");
            int _cursorIndexOfThumbUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"thumbUrl");
            int _cursorIndexOfImageUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"imageUrl");
            int _cursorIndexOfAssetUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"assetUrl");
            int _cursorIndexOfOgUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"ogUrl");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"title");
            int _cursorIndexOfText = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"text");
            int _cursorIndexOfType = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"type");
            int _cursorIndexOfImage = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"image");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"url");
            int _cursorIndexOfName = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"name");
            int _cursorIndexOfFallback = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"fallback");
            int _cursorIndexOfUploadFilePath = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"uploadFilePath");
            int _cursorIndexOfExtraData = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"extraData");
            int _cursorIndexOfStatusCode = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"statusCode");
            int _cursorIndexOfErrorMessage = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"errorMessage");
            while (_cursor.moveToNext()) {
                UploadStateEntity _tmpUploadState;
                Map<String, Object> _tmpExtraData;
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList _tmpRelation = (ArrayList)_map.get((Object)_tmpKey);
                if (_tmpRelation == null) continue;
                String _tmpMessageId = _cursorIndexOfMessageId == -1 ? null : _cursor.getString(_cursorIndexOfMessageId);
                String _tmpAuthorName = _cursorIndexOfAuthorName == -1 ? null : _cursor.getString(_cursorIndexOfAuthorName);
                String _tmpTitleLink = _cursorIndexOfTitleLink == -1 ? null : _cursor.getString(_cursorIndexOfTitleLink);
                String _tmpThumbUrl = _cursorIndexOfThumbUrl == -1 ? null : _cursor.getString(_cursorIndexOfThumbUrl);
                String _tmpImageUrl = _cursorIndexOfImageUrl == -1 ? null : _cursor.getString(_cursorIndexOfImageUrl);
                String _tmpAssetUrl = _cursorIndexOfAssetUrl == -1 ? null : _cursor.getString(_cursorIndexOfAssetUrl);
                String _tmpOgUrl = _cursorIndexOfOgUrl == -1 ? null : _cursor.getString(_cursorIndexOfOgUrl);
                String _tmpMimeType = _cursorIndexOfMimeType == -1 ? null : _cursor.getString(_cursorIndexOfMimeType);
                int _tmpFileSize = _cursorIndexOfFileSize == -1 ? 0 : _cursor.getInt(_cursorIndexOfFileSize);
                String _tmpTitle = _cursorIndexOfTitle == -1 ? null : _cursor.getString(_cursorIndexOfTitle);
                String _tmpText = _cursorIndexOfText == -1 ? null : _cursor.getString(_cursorIndexOfText);
                String _tmpType = _cursorIndexOfType == -1 ? null : _cursor.getString(_cursorIndexOfType);
                String _tmpImage = _cursorIndexOfImage == -1 ? null : _cursor.getString(_cursorIndexOfImage);
                String _tmpUrl = _cursorIndexOfUrl == -1 ? null : _cursor.getString(_cursorIndexOfUrl);
                String _tmpName = _cursorIndexOfName == -1 ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpFallback = _cursorIndexOfFallback == -1 ? null : _cursor.getString(_cursorIndexOfFallback);
                String _tmpUploadFilePath = _cursorIndexOfUploadFilePath == -1 ? null : _cursor.getString(_cursorIndexOfUploadFilePath);
                if (_cursorIndexOfExtraData == -1) {
                    _tmpExtraData = null;
                } else {
                    String _tmp = _cursor.getString(_cursorIndexOfExtraData);
                    _tmpExtraData = this.__extraDataConverter.stringToMap(_tmp);
                }
                if (_cursorIndexOfStatusCode != -1 && !_cursor.isNull(_cursorIndexOfStatusCode) || _cursorIndexOfErrorMessage != -1 && !_cursor.isNull(_cursorIndexOfErrorMessage)) {
                    int _tmpStatusCode = _cursorIndexOfStatusCode == -1 ? 0 : _cursor.getInt(_cursorIndexOfStatusCode);
                    String _tmpErrorMessage = _cursorIndexOfErrorMessage == -1 ? null : _cursor.getString(_cursorIndexOfErrorMessage);
                    _tmpUploadState = new UploadStateEntity(_tmpStatusCode, _tmpErrorMessage);
                } else {
                    _tmpUploadState = null;
                }
                AttachmentEntity _item_1 = new AttachmentEntity(_tmpMessageId, _tmpAuthorName, _tmpTitleLink, _tmpThumbUrl, _tmpImageUrl, _tmpAssetUrl, _tmpOgUrl, _tmpMimeType, _tmpFileSize, _tmpTitle, _tmpText, _tmpType, _tmpImage, _tmpUrl, _tmpName, _tmpFallback, _tmpUploadFilePath, _tmpUploadState, _tmpExtraData);
                if (_cursorIndexOfId != -1) {
                    int _tmpId = _cursor.getInt(_cursorIndexOfId);
                    _item_1.setId(_tmpId);
                }
                _tmpRelation.add(_item_1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity(ArrayMap<String, ArrayList<ReactionEntity>> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidLivedataRepositoryDomainReactionReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `id`,`messageId`,`userId`,`type`,`score`,`createdAt`,`updatedAt`,`deletedAt`,`enforceUnique`,`extraData`,`syncStatus` FROM `stream_chat_reaction` WHERE `messageId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"messageId");
            if (_itemKeyIndex == -1) {
                return;
            }
            int _cursorIndexOfId = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"id");
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfType = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"type");
            int _cursorIndexOfScore = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"score");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"deletedAt");
            int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"enforceUnique");
            int _cursorIndexOfExtraData = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"extraData");
            int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"syncStatus");
            while (_cursor.moveToNext()) {
                SyncStatus _tmpSyncStatus;
                Map<String, Object> _tmpExtraData;
                boolean _tmpEnforceUnique;
                Date _tmpDeletedAt;
                Date _tmpUpdatedAt;
                Date _tmpCreatedAt;
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList _tmpRelation = (ArrayList)_map.get((Object)_tmpKey);
                if (_tmpRelation == null) continue;
                String _tmpMessageId = _cursorIndexOfMessageId == -1 ? null : _cursor.getString(_cursorIndexOfMessageId);
                String _tmpUserId = _cursorIndexOfUserId == -1 ? null : _cursor.getString(_cursorIndexOfUserId);
                String _tmpType = _cursorIndexOfType == -1 ? null : _cursor.getString(_cursorIndexOfType);
                int _tmpScore = _cursorIndexOfScore == -1 ? 0 : _cursor.getInt(_cursorIndexOfScore);
                if (_cursorIndexOfCreatedAt == -1) {
                    _tmpCreatedAt = null;
                } else {
                    Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                    _tmpCreatedAt = this.__dateConverter.fromTimestamp(_tmp);
                }
                if (_cursorIndexOfUpdatedAt == -1) {
                    _tmpUpdatedAt = null;
                } else {
                    Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                    _tmpUpdatedAt = this.__dateConverter.fromTimestamp(_tmp_1);
                }
                if (_cursorIndexOfDeletedAt == -1) {
                    _tmpDeletedAt = null;
                } else {
                    Long _tmp_2 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                    _tmpDeletedAt = this.__dateConverter.fromTimestamp(_tmp_2);
                }
                if (_cursorIndexOfEnforceUnique == -1) {
                    _tmpEnforceUnique = false;
                } else {
                    int _tmp_3 = _cursor.getInt(_cursorIndexOfEnforceUnique);
                    boolean bl = _tmpEnforceUnique = _tmp_3 != 0;
                }
                if (_cursorIndexOfExtraData == -1) {
                    _tmpExtraData = null;
                } else {
                    String _tmp_4 = _cursor.getString(_cursorIndexOfExtraData);
                    _tmpExtraData = this.__extraDataConverter.stringToMap(_tmp_4);
                }
                if (_cursorIndexOfSyncStatus == -1) {
                    _tmpSyncStatus = null;
                } else {
                    int _tmp_5 = _cursor.getInt(_cursorIndexOfSyncStatus);
                    _tmpSyncStatus = this.__syncStatusConverter.stringToSyncStatus(_tmp_5);
                }
                ReactionEntity _item_1 = new ReactionEntity(_tmpMessageId, _tmpUserId, _tmpType, _tmpScore, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpEnforceUnique, _tmpExtraData, _tmpSyncStatus);
                if (_cursorIndexOfId != -1) {
                    int _tmpId = _cursor.getInt(_cursorIndexOfId);
                    _item_1.setId(_tmpId);
                }
                _tmpRelation.add(_item_1);
            }
        }
    }

    static /* synthetic */ Object access$901(MessageDao_Impl x0, List x1, Continuation x2) {
        return super.insert(x1, (Continuation<? super Unit>)x2);
    }

    static /* synthetic */ Object access$1001(MessageDao_Impl x0, MessageEntity x1, Continuation x2) {
        return super.insert(x1, (Continuation<? super Unit>)x2);
    }
}

