/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.service.sync;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.livedata.service.sync.BackgroundSyncConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/getstream/chat/android/livedata/service/sync/EncryptedBackgroundSyncConfigStore;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "prefs", "Landroid/content/SharedPreferences;", "clear", "", "get", "Lio/getstream/chat/android/livedata/service/sync/BackgroundSyncConfig;", "put", "config", "stream-chat-android-offline_release"})
public final class EncryptedBackgroundSyncConfigStore {
    private final SharedPreferences prefs;
    private final TaggedLogger logger;

    public final void put(@NotNull BackgroundSyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SharedPreferences.Editor editor = this.prefs.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$apply = editor;
        boolean bl3 = false;
        $this$apply.putString("api_key", config.getApiKey());
        $this$apply.putString("user_id", config.getUserId());
        $this$apply.putString("user_token", config.getUserToken());
        editor.apply();
    }

    @Nullable
    public final BackgroundSyncConfig get() {
        SharedPreferences sharedPreferences = this.prefs;
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences $this$run = sharedPreferences;
        boolean bl3 = false;
        String string = $this$run.getString("api_key", "");
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(KEY_API_KEY, \"\") ?: \"\"");
        String apiKey = string;
        String string2 = $this$run.getString("user_id", "");
        if (string2 == null) {
            string2 = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(KEY_USER_ID, \"\") ?: \"\"");
        String userId = string2;
        String string3 = $this$run.getString("user_token", "");
        if (string3 == null) {
            string3 = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(KEY_USER_TOKEN, \"\") ?: \"\"");
        String userToken = string3;
        BackgroundSyncConfig config = new BackgroundSyncConfig(apiKey, userId, userToken);
        return config.isValid() ? config : null;
    }

    public final void clear() {
        this.prefs.edit().clear().apply();
    }

    /*
     * WARNING - void declaration
     */
    public EncryptedBackgroundSyncConfigStore(@NotNull Context context) {
        SharedPreferences sharedPreferences;
        EncryptedBackgroundSyncConfigStore encryptedBackgroundSyncConfigStore2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger = ChatLogger.Companion.get((Object)"EncryptedBackgroundSyncConfigStore");
        MasterKey masterKey = new MasterKey.Builder(context, "_stream_sync_config_master_key_").setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"MasterKey.Builder(contex\u2026GCM)\n            .build()");
        MasterKey masterKey2 = masterKey;
        EncryptedBackgroundSyncConfigStore encryptedBackgroundSyncConfigStore3 = this;
        try {
            encryptedBackgroundSyncConfigStore2 = encryptedBackgroundSyncConfigStore3;
            SharedPreferences sharedPreferences2 = EncryptedSharedPreferences.create((Context)context, (String)"stream_livedata_sync_config_store", (MasterKey)masterKey2, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences2, (String)"EncryptedSharedPreferenc\u2026.AES256_GCM\n            )");
            sharedPreferences = sharedPreferences2;
        }
        catch (Exception exception) {
            void e;
            encryptedBackgroundSyncConfigStore2 = encryptedBackgroundSyncConfigStore3;
            this.logger.logE("Error creating encrypted shared preferences", (Throwable)e);
            SharedPreferences sharedPreferences3 = context.getApplicationContext().getSharedPreferences(".stream_livedata_sync_config_store", 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences3, (String)"context.applicationConte\u2026ODE_PRIVATE\n            )");
            sharedPreferences = sharedPreferences3;
        }
        encryptedBackgroundSyncConfigStore2.prefs = sharedPreferences;
    }
}

