/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.repository.domain.channel;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.livedata.repository.database.converter.DateConverter;
import io.getstream.chat.android.livedata.repository.database.converter.ExtraDataConverter;
import io.getstream.chat.android.livedata.repository.database.converter.MapConverter;
import io.getstream.chat.android.livedata.repository.database.converter.SyncStatusConverter;
import io.getstream.chat.android.livedata.repository.domain.channel.ChannelDao;
import io.getstream.chat.android.livedata.repository.domain.channel.ChannelEntity;
import io.getstream.chat.android.livedata.repository.domain.channel.member.MemberEntity;
import io.getstream.chat.android.livedata.repository.domain.channel.userread.ChannelUserReadEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ChannelDao_Impl
implements ChannelDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelEntity> __insertionAdapterOfChannelEntity;
    private final DateConverter __dateConverter = new DateConverter();
    private final MapConverter __mapConverter = new MapConverter();
    private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();
    private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfSetDeletedAt;
    private final SharedSQLiteStatement __preparedStmtOfSetHidden;
    private final SharedSQLiteStatement __preparedStmtOfSetHidden_1;

    public ChannelDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelEntity = new EntityInsertionAdapter<ChannelEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_channel_state` (`cid`,`type`,`channelId`,`cooldown`,`createdByUserId`,`frozen`,`hidden`,`hideMessagesBefore`,`members`,`reads`,`lastMessageAt`,`lastMessageId`,`createdAt`,`updatedAt`,`deletedAt`,`extraData`,`syncStatus`,`team`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelEntity value) {
                Integer _tmp_1;
                if (value.getCid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCid());
                }
                if (value.getType() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getType());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getChannelId());
                }
                stmt.bindLong(4, (long)value.getCooldown());
                if (value.getCreatedByUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getCreatedByUserId());
                }
                int _tmp = value.getFrozen() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                Integer n = value.getHidden() == null ? null : (_tmp_1 = Integer.valueOf(value.getHidden() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, (long)_tmp_1.intValue());
                }
                Long _tmp_2 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getHideMessagesBefore());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, _tmp_2.longValue());
                }
                String _tmp_3 = ChannelDao_Impl.this.__mapConverter.memberMapToString(value.getMembers());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                String _tmp_4 = ChannelDao_Impl.this.__mapConverter.readMapToString(value.getReads());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                Long _tmp_5 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getLastMessageAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, _tmp_5.longValue());
                }
                if (value.getLastMessageId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getLastMessageId());
                }
                Long _tmp_6 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, _tmp_6.longValue());
                }
                Long _tmp_7 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, _tmp_7.longValue());
                }
                Long _tmp_8 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, _tmp_8.longValue());
                }
                String _tmp_9 = ChannelDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_9 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_9);
                }
                int _tmp_10 = ChannelDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(17, (long)_tmp_10);
                if (value.getTeam() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getTeam());
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_chat_channel_state WHERE cid = ?";
                return "DELETE from stream_chat_channel_state WHERE cid = ?";
            }
        };
        this.__preparedStmtOfSetDeletedAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE stream_chat_channel_state SET deletedAt = ? WHERE cid = ?";
                return "UPDATE stream_chat_channel_state SET deletedAt = ? WHERE cid = ?";
            }
        };
        this.__preparedStmtOfSetHidden = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE stream_chat_channel_state SET hidden = ?, hideMessagesBefore = ? WHERE cid = ?";
                return "UPDATE stream_chat_channel_state SET hidden = ?, hideMessagesBefore = ? WHERE cid = ?";
            }
        };
        this.__preparedStmtOfSetHidden_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE stream_chat_channel_state SET hidden = ? WHERE cid = ?";
                return "UPDATE stream_chat_channel_state SET hidden = ? WHERE cid = ?";
            }
        };
    }

    @Override
    public Object insert(final ChannelEntity channelEntity, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    ChannelDao_Impl.this.__insertionAdapterOfChannelEntity.insert((Object)channelEntity);
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object insertMany(final List<ChannelEntity> channelEntities, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    ChannelDao_Impl.this.__insertionAdapterOfChannelEntity.insert((Iterable)channelEntities);
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object delete(final String cid, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChannelDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                    ChannelDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, p1);
    }

    @Override
    public Object setDeletedAt(final String cid, final Date deletedAt, Continuation<? super Unit> p2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChannelDao_Impl.this.__preparedStmtOfSetDeletedAt.acquire();
                int _argIndex = 1;
                Long _tmp = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(deletedAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, _tmp.longValue());
                }
                _argIndex = 2;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                    ChannelDao_Impl.this.__preparedStmtOfSetDeletedAt.release(_stmt);
                }
            }
        }, p2);
    }

    @Override
    public Object setHidden(final String cid, final boolean hidden, final Date hideMessagesBefore, Continuation<? super Unit> p3) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChannelDao_Impl.this.__preparedStmtOfSetHidden.acquire();
                int _argIndex = 1;
                int _tmp = hidden ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                Long _tmp_1 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(hideMessagesBefore);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, _tmp_1.longValue());
                }
                _argIndex = 3;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                    ChannelDao_Impl.this.__preparedStmtOfSetHidden.release(_stmt);
                }
            }
        }, p3);
    }

    @Override
    public Object setHidden(final String cid, final boolean hidden, Continuation<? super Unit> p2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChannelDao_Impl.this.__preparedStmtOfSetHidden_1.acquire();
                int _argIndex = 1;
                int _tmp = hidden ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                    ChannelDao_Impl.this.__preparedStmtOfSetHidden_1.release(_stmt);
                }
            }
        }, p2);
    }

    @Override
    public Object selectSyncNeeded(SyncStatus syncStatus, Continuation<? super List<ChannelEntity>> p1) {
        String _sql = "SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.syncStatus IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.syncStatus IN (?)", (int)1);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<ChannelEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ChannelEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cooldown");
                    int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdByUserId");
                    int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frozen");
                    int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hidden");
                    int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hideMessagesBefore");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reads");
                    int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageAt");
                    int _cursorIndexOfLastMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfTeam = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"team");
                    ArrayList<ChannelEntity> _result = new ArrayList<ChannelEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        int _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
                        String _tmpCreatedByUserId = _cursor.getString(_cursorIndexOfCreatedByUserId);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfFrozen);
                        boolean _tmpFrozen = _tmp_1 != 0;
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfHidden) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfHidden));
                        Boolean _tmpHidden = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfHideMessagesBefore) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfHideMessagesBefore));
                        Date _tmpHideMessagesBefore = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfMembers);
                        Map<String, MemberEntity> _tmpMembers = ChannelDao_Impl.this.__mapConverter.stringToMemberMap(_tmp_4);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfReads);
                        Map<String, ChannelUserReadEntity> _tmpReads = ChannelDao_Impl.this.__mapConverter.stringToReadMap(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfLastMessageAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastMessageAt));
                        Date _tmpLastMessageAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        String _tmpLastMessageId = _cursor.getString(_cursorIndexOfLastMessageId);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        Long _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                        Long _tmp_9 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_9);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_10);
                        int _tmp_11 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_11);
                        String _tmpTeam = _cursor.getString(_cursorIndexOfTeam);
                        ChannelEntity _item = new ChannelEntity(_tmpType, _tmpChannelId, _tmpCooldown, _tmpCreatedByUserId, _tmpFrozen, _tmpHidden, _tmpHideMessagesBefore, _tmpMembers, _tmpReads, _tmpLastMessageAt, _tmpLastMessageId, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpExtraData, _tmpSyncStatus, _tmpTeam);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        _item.setCid(_tmpCid);
                        _result.add(_item);
                    }
                    ArrayList<ChannelEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object select(List<String> cids2, Continuation<? super List<ChannelEntity>> p1) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (");
        int _inputSize = cids2.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : cids2) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<ChannelEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ChannelEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cooldown");
                    int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdByUserId");
                    int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frozen");
                    int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hidden");
                    int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hideMessagesBefore");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reads");
                    int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageAt");
                    int _cursorIndexOfLastMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfTeam = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"team");
                    ArrayList<ChannelEntity> _result = new ArrayList<ChannelEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        int _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
                        String _tmpCreatedByUserId = _cursor.getString(_cursorIndexOfCreatedByUserId);
                        int _tmp = _cursor.getInt(_cursorIndexOfFrozen);
                        boolean _tmpFrozen = _tmp != 0;
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfHidden) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfHidden));
                        Boolean _tmpHidden = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfHideMessagesBefore) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfHideMessagesBefore));
                        Date _tmpHideMessagesBefore = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfMembers);
                        Map<String, MemberEntity> _tmpMembers = ChannelDao_Impl.this.__mapConverter.stringToMemberMap(_tmp_3);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfReads);
                        Map<String, ChannelUserReadEntity> _tmpReads = ChannelDao_Impl.this.__mapConverter.stringToReadMap(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfLastMessageAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastMessageAt));
                        Date _tmpLastMessageAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        String _tmpLastMessageId = _cursor.getString(_cursorIndexOfLastMessageId);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        Long _tmp_8 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_9);
                        int _tmp_10 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_10);
                        String _tmpTeam = _cursor.getString(_cursorIndexOfTeam);
                        ChannelEntity _item_1 = new ChannelEntity(_tmpType, _tmpChannelId, _tmpCooldown, _tmpCreatedByUserId, _tmpFrozen, _tmpHidden, _tmpHideMessagesBefore, _tmpMembers, _tmpReads, _tmpLastMessageAt, _tmpLastMessageId, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpExtraData, _tmpSyncStatus, _tmpTeam);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        _item_1.setCid(_tmpCid);
                        _result.add(_item_1);
                    }
                    ArrayList<ChannelEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object select(String cid, Continuation<? super ChannelEntity> p1) {
        String _sql = "SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (?)", (int)1);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<ChannelEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ChannelEntity _result;
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cooldown");
                    int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdByUserId");
                    int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frozen");
                    int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hidden");
                    int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hideMessagesBefore");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reads");
                    int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageAt");
                    int _cursorIndexOfLastMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfTeam = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"team");
                    if (_cursor.moveToFirst()) {
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        int _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
                        String _tmpCreatedByUserId = _cursor.getString(_cursorIndexOfCreatedByUserId);
                        int _tmp = _cursor.getInt(_cursorIndexOfFrozen);
                        boolean _tmpFrozen = _tmp != 0;
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfHidden) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfHidden));
                        Boolean _tmpHidden = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfHideMessagesBefore) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfHideMessagesBefore));
                        Date _tmpHideMessagesBefore = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfMembers);
                        Map<String, MemberEntity> _tmpMembers = ChannelDao_Impl.this.__mapConverter.stringToMemberMap(_tmp_3);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfReads);
                        Map<String, ChannelUserReadEntity> _tmpReads = ChannelDao_Impl.this.__mapConverter.stringToReadMap(_tmp_4);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfLastMessageAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastMessageAt));
                        Date _tmpLastMessageAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                        String _tmpLastMessageId = _cursor.getString(_cursorIndexOfLastMessageId);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        Long _tmp_8 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_9);
                        int _tmp_10 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_10);
                        String _tmpTeam = _cursor.getString(_cursorIndexOfTeam);
                        _result = new ChannelEntity(_tmpType, _tmpChannelId, _tmpCooldown, _tmpCreatedByUserId, _tmpFrozen, _tmpHidden, _tmpHideMessagesBefore, _tmpMembers, _tmpReads, _tmpLastMessageAt, _tmpLastMessageId, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpExtraData, _tmpSyncStatus, _tmpTeam);
                        String _tmpCid = _cursor.getString(_cursorIndexOfCid);
                        _result.setCid(_tmpCid);
                    } else {
                        _result = null;
                    }
                    ChannelEntity channelEntity = _result;
                    return channelEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }
}

