/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.livedata.service.sync;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.os.Build;
import androidx.annotation.WorkerThread;
import androidx.core.app.NotificationCompat;
import com.google.firebase.messaging.RemoteMessage;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.notifications.FirebaseMessageParser;
import io.getstream.chat.android.client.notifications.FirebaseMessageParserImpl;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.notifications.handler.NotificationConfig;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.livedata.ChatDomain;
import io.getstream.chat.android.livedata.service.sync.BackgroundSyncConfig;
import io.getstream.chat.android.livedata.service.sync.SyncProvider;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001aH\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0007J\u000e\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020 J(\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\n\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00063"}, d2={"Lio/getstream/chat/android/livedata/service/sync/PushMessageSyncHandler;", "", "service", "Landroid/app/Service;", "(Landroid/app/Service;)V", "firebaseMessageParser", "Lio/getstream/chat/android/client/notifications/FirebaseMessageParser;", "getFirebaseMessageParser", "()Lio/getstream/chat/android/client/notifications/FirebaseMessageParser;", "firebaseMessageParser$delegate", "Lkotlin/Lazy;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "notificationConfig", "Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "getNotificationConfig", "()Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "notificationConfig$delegate", "syncModule", "Lio/getstream/chat/android/livedata/service/sync/SyncProvider;", "getSyncModule", "()Lio/getstream/chat/android/livedata/service/sync/SyncProvider;", "syncModule$delegate", "createSyncNotificationChannel", "", "initClient", "Lio/getstream/chat/android/client/ChatClient;", "context", "Landroid/content/Context;", "user", "Lio/getstream/chat/android/client/models/User;", "userToken", "", "apiKey", "initDomain", "Lio/getstream/chat/android/livedata/ChatDomain;", "client", "isStreamMessage", "", "message", "Lcom/google/firebase/messaging/RemoteMessage;", "onMessageReceived", "onNewToken", "token", "performSync", "domain", "cid", "startForegroundExecution", "smallIcon", "", "Companion", "stream-chat-android-offline_release"})
public final class PushMessageSyncHandler {
    private final TaggedLogger logger;
    private final Lazy syncModule$delegate;
    private final Lazy notificationConfig$delegate;
    private final Lazy firebaseMessageParser$delegate;
    private final Service service;
    @Deprecated
    private static final String CHANNEL_ID = "notification_channel_id";
    @Deprecated
    private static final String CHANNEL_NAME = "Chat messages sync";
    @Deprecated
    private static final int NOTIFICATION_ID = 1;
    @NotNull
    private static final Companion Companion = new Companion(null);

    private final SyncProvider getSyncModule() {
        Lazy lazy = this.syncModule$delegate;
        PushMessageSyncHandler pushMessageSyncHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SyncProvider)lazy.getValue();
    }

    private final NotificationConfig getNotificationConfig() {
        Lazy lazy = this.notificationConfig$delegate;
        PushMessageSyncHandler pushMessageSyncHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NotificationConfig)lazy.getValue();
    }

    private final FirebaseMessageParser getFirebaseMessageParser() {
        Lazy lazy = this.firebaseMessageParser$delegate;
        PushMessageSyncHandler pushMessageSyncHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FirebaseMessageParser)lazy.getValue();
    }

    public final void onNewToken(@NotNull String token) {
        block1: {
            BackgroundSyncConfig syncConfig;
            block0: {
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                if (!ChatClient.Companion.isInitialized()) break block0;
                ChatClient.Companion.instance().onNewTokenReceived(token);
                break block1;
            }
            BackgroundSyncConfig backgroundSyncConfig = syncConfig = this.getSyncModule().getEncryptedBackgroundSyncConfigStore$stream_chat_android_offline_release().get();
            if (backgroundSyncConfig == null) break block1;
            BackgroundSyncConfig backgroundSyncConfig2 = backgroundSyncConfig;
            boolean bl = false;
            boolean bl2 = false;
            BackgroundSyncConfig it = backgroundSyncConfig2;
            boolean bl3 = false;
            BackgroundSyncConfig config = it;
            User user = new User(config.getUserId(), null, false, false, null, false, null, null, null, 0, 0, null, null, null, null, 32766, null);
            String userToken = config.getUserToken();
            ChatClient client = this.initClient((Context)this.service, user, userToken, config.getApiKey());
            client.onNewTokenReceived(token);
        }
    }

    @WorkerThread
    public final void onMessageReceived(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.isStreamMessage(message)) {
            return;
        }
        this.createSyncNotificationChannel();
        this.startForegroundExecution(this.getNotificationConfig().getSmallIcon());
        FirebaseMessageParser.Data data = this.getFirebaseMessageParser().parse(message);
        boolean bl = false;
        boolean bl2 = false;
        FirebaseMessageParser.Data it = data;
        boolean bl3 = false;
        String cid = it.getChannelType() + ':' + it.getChannelId();
        if (ChatDomain.Companion.isInitialized() && ChatClient.Companion.isInitialized()) {
            this.logger.logD("Starting the sync");
            this.performSync(ChatDomain.Companion.instance(), cid, ChatClient.Companion.instance(), message);
        } else {
            BackgroundSyncConfig syncConfig;
            BackgroundSyncConfig backgroundSyncConfig = syncConfig = this.getSyncModule().getEncryptedBackgroundSyncConfigStore$stream_chat_android_offline_release().get();
            if (backgroundSyncConfig != null) {
                BackgroundSyncConfig backgroundSyncConfig2 = backgroundSyncConfig;
                bl2 = false;
                boolean bl4 = false;
                BackgroundSyncConfig it2 = backgroundSyncConfig2;
                boolean bl5 = false;
                BackgroundSyncConfig config = it2;
                User user = new User(config.getUserId(), null, false, false, null, false, null, null, null, 0, 0, null, null, null, null, 32766, null);
                String token = config.getUserToken();
                ChatClient client = this.initClient((Context)this.service, user, token, config.getApiKey());
                ChatDomain domain = this.initDomain(user, client);
                this.logger.logD("Starting the sync, config: " + syncConfig);
                this.performSync(domain, cid, client, message);
            }
        }
        this.service.stopForeground(true);
    }

    public final boolean isStreamMessage(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return ChatClient.Companion.isValidRemoteMessage(message, this.getNotificationConfig());
    }

    private final void performSync(ChatDomain domain, String cid, ChatClient client, RemoteMessage message) {
        Result result2 = domain.replayEventsForActiveChannels(cid).execute();
        if (result2.isSuccess()) {
            this.logger.logD("Sync success.");
        } else {
            this.logger.logD("Sync failed.");
        }
        client.onMessageReceived(message);
    }

    private final void startForegroundExecution(int smallIcon) {
        Notification notification = new NotificationCompat.Builder((Context)this.service, CHANNEL_ID).setAutoCancel(true).setSmallIcon(smallIcon).build();
        boolean bl = false;
        boolean bl2 = false;
        Notification $this$apply = notification;
        boolean bl3 = false;
        this.service.startForeground(1, $this$apply);
    }

    private final void createSyncNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, 4);
            boolean bl = false;
            boolean bl2 = false;
            NotificationChannel $this$run = notificationChannel;
            boolean bl3 = false;
            $this$run.setImportance(2);
            ((NotificationManager)this.service.getSystemService(NotificationManager.class)).createNotificationChannel($this$run);
        }
    }

    private final ChatDomain initDomain(User user, ChatClient client) {
        ChatDomain chatDomain = new ChatDomain.Builder((Context)this.service, client).build();
        boolean bl = false;
        boolean bl2 = false;
        ChatDomain $this$apply = chatDomain;
        boolean bl3 = false;
        $this$apply.setCurrentUser(user);
        return chatDomain;
    }

    private final ChatClient initClient(Context context, User user, String userToken, String apiKey) {
        NotificationConfig notificationConfig2 = this.getSyncModule().getNotificationConfigStore$stream_chat_android_offline_release().get();
        ChatNotificationHandler notificationHandler = new ChatNotificationHandler(context, notificationConfig2);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        ChatClient client = new ChatClient.Builder(apiKey, context2).notifications(notificationHandler).build();
        client.setUserWithoutConnecting(user, userToken);
        return client;
    }

    public PushMessageSyncHandler(@NotNull Service service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
        this.logger = ChatLogger.Companion.get((Object)"PushMessageSyncHandler");
        this.syncModule$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SyncProvider>(this){
            final /* synthetic */ PushMessageSyncHandler this$0;

            @NotNull
            public final SyncProvider invoke() {
                return new SyncProvider((Context)PushMessageSyncHandler.access$getService$p(this.this$0));
            }
            {
                this.this$0 = pushMessageSyncHandler;
                super(0);
            }
        }));
        this.notificationConfig$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationConfig>(this){
            final /* synthetic */ PushMessageSyncHandler this$0;

            @NotNull
            public final NotificationConfig invoke() {
                return PushMessageSyncHandler.access$getSyncModule$p(this.this$0).getNotificationConfigStore$stream_chat_android_offline_release().get();
            }
            {
                this.this$0 = pushMessageSyncHandler;
                super(0);
            }
        }));
        this.firebaseMessageParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirebaseMessageParserImpl>(this){
            final /* synthetic */ PushMessageSyncHandler this$0;

            @NotNull
            public final FirebaseMessageParserImpl invoke() {
                return new FirebaseMessageParserImpl(PushMessageSyncHandler.access$getNotificationConfig$p(this.this$0));
            }
            {
                this.this$0 = pushMessageSyncHandler;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Service access$getService$p(PushMessageSyncHandler $this) {
        return $this.service;
    }

    public static final /* synthetic */ SyncProvider access$getSyncModule$p(PushMessageSyncHandler $this) {
        return $this.getSyncModule();
    }

    public static final /* synthetic */ NotificationConfig access$getNotificationConfig$p(PushMessageSyncHandler $this) {
        return $this.getNotificationConfig();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/getstream/chat/android/livedata/service/sync/PushMessageSyncHandler$Companion;", "", "()V", "CHANNEL_ID", "", "CHANNEL_NAME", "NOTIFICATION_ID", "", "stream-chat-android-offline_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

