/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.listener.internal;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.experimental.plugin.listeners.EditMessageListener;
import io.getstream.chat.android.client.extensions.ChatErrorKt;
import io.getstream.chat.android.client.extensions.StringExtensionsKt;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.offline.plugin.logic.channel.internal.ChannelLogic;
import io.getstream.chat.android.offline.plugin.logic.internal.LogicRegistry;
import io.getstream.chat.android.offline.plugin.state.global.GlobalState;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0019\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u0013\u001a\u00020\n*\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\n*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lio/getstream/chat/android/offline/plugin/listener/internal/EditMessageListenerImpl;", "Lio/getstream/chat/android/client/experimental/plugin/listeners/EditMessageListener;", "logic", "Lio/getstream/chat/android/offline/plugin/logic/internal/LogicRegistry;", "globalState", "Lio/getstream/chat/android/offline/plugin/state/global/GlobalState;", "(Lio/getstream/chat/android/offline/plugin/logic/internal/LogicRegistry;Lio/getstream/chat/android/offline/plugin/state/global/GlobalState;)V", "channelLogicForMessage", "Lio/getstream/chat/android/offline/plugin/logic/channel/internal/ChannelLogic;", "message", "Lio/getstream/chat/android/client/models/Message;", "onMessageEditRequest", "", "(Lio/getstream/chat/android/client/models/Message;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onMessageEditResult", "originalMessage", "result", "Lio/getstream/chat/android/client/utils/Result;", "(Lio/getstream/chat/android/client/models/Message;Lio/getstream/chat/android/client/utils/Result;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateFailedMessage", "chatError", "Lio/getstream/chat/android/client/errors/ChatError;", "updateMessageOnlineState", "isOnline", "", "stream-chat-android-offline_release"})
public final class EditMessageListenerImpl
implements EditMessageListener {
    @NotNull
    private final LogicRegistry logic;
    @NotNull
    private final GlobalState globalState;

    public EditMessageListenerImpl(@NotNull LogicRegistry logic, @NotNull GlobalState globalState) {
        Intrinsics.checkNotNullParameter((Object)logic, (String)"logic");
        Intrinsics.checkNotNullParameter((Object)globalState, (String)"globalState");
        this.logic = logic;
        this.globalState = globalState;
    }

    @Nullable
    public Object onMessageEditRequest(@NotNull Message message, @NotNull Continuation<? super Unit> $completion) {
        Pair pair = StringExtensionsKt.cidToTypeAndId((String)message.getCid());
        String channelType = (String)pair.component1();
        String channelId = (String)pair.component2();
        ChannelLogic channelLogic = this.logic.channel(channelType, channelId);
        boolean isOnline = this.globalState.isOnline();
        Message p0 = this.updateMessageOnlineState(message, isOnline);
        boolean bl = false;
        List messagesToEdit = CollectionsKt.listOf((Object)p0);
        Object object = channelLogic.updateAndSaveMessages$stream_chat_android_offline_release(messagesToEdit, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object onMessageEditResult(@NotNull Message originalMessage, @NotNull Result<Message> result, @NotNull Continuation<? super Unit> $completion) {
        if (result.isSuccess()) {
            Message message = (Message)result.data();
            ChannelLogic channelLogic = this.channelLogicForMessage(message);
            Message p0 = Message.copy$default((Message)message, null, null, null, null, null, null, null, null, null, (int)0, null, null, (SyncStatus)SyncStatus.COMPLETED, null, null, null, null, null, null, null, null, null, null, (boolean)false, (boolean)false, null, (boolean)false, null, null, null, (boolean)false, null, null, null, null, (int)-4097, (int)7, null);
            boolean bl = false;
            List messages = CollectionsKt.listOf((Object)p0);
            Object object = channelLogic.updateAndSaveMessages$stream_chat_android_offline_release(messages, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        ChannelLogic channelLogic = this.channelLogicForMessage(originalMessage);
        Message p0 = this.updateFailedMessage(originalMessage, result.error());
        boolean bl = false;
        List failedMessage = CollectionsKt.listOf((Object)p0);
        Object object = channelLogic.updateAndSaveMessages$stream_chat_android_offline_release(failedMessage, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final ChannelLogic channelLogicForMessage(Message message) {
        Pair pair = StringExtensionsKt.cidToTypeAndId((String)message.getCid());
        String channelType = (String)pair.component1();
        String channelId = (String)pair.component2();
        return this.logic.channel(channelType, channelId);
    }

    private final Message updateFailedMessage(Message $this$updateFailedMessage, ChatError chatError) {
        return Message.copy$default((Message)$this$updateFailedMessage, null, null, null, null, null, null, null, null, null, (int)0, null, null, (SyncStatus)(ChatErrorKt.isPermanent((ChatError)chatError) ? SyncStatus.FAILED_PERMANENTLY : SyncStatus.SYNC_NEEDED), null, null, null, null, null, null, (Date)new Date(), null, null, null, (boolean)false, (boolean)false, null, (boolean)false, null, null, null, (boolean)false, null, null, null, null, (int)-528385, (int)7, null);
    }

    private final Message updateMessageOnlineState(Message $this$updateMessageOnlineState, boolean isOnline) {
        return Message.copy$default((Message)$this$updateMessageOnlineState, null, null, null, null, null, null, null, null, null, (int)0, null, null, (SyncStatus)(isOnline ? SyncStatus.IN_PROGRESS : SyncStatus.SYNC_NEEDED), null, null, null, null, null, null, (Date)new Date(), null, null, null, (boolean)false, (boolean)false, null, (boolean)false, null, null, null, (boolean)false, null, null, null, null, (int)-528385, (int)7, null);
    }
}

