/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.repository.domain.reaction.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.offline.repository.database.converter.internal.DateConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ExtraDataConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.SyncStatusConverter;
import io.getstream.chat.android.offline.repository.domain.reaction.internal.ReactionDao;
import io.getstream.chat.android.offline.repository.domain.reaction.internal.ReactionEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ReactionDao_Impl
implements ReactionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ReactionEntity> __insertionAdapterOfReactionEntity;
    private final DateConverter __dateConverter = new DateConverter();
    private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();
    private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();
    private final SharedSQLiteStatement __preparedStmtOfSetDeleteAt;

    public ReactionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfReactionEntity = new EntityInsertionAdapter<ReactionEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_reaction` (`messageId`,`userId`,`type`,`score`,`createdAt`,`updatedAt`,`deletedAt`,`enforceUnique`,`extraData`,`syncStatus`,`id`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ReactionEntity value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getType());
                }
                stmt.bindLong(4, (long)value.getScore());
                Long _tmp = ReactionDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, _tmp.longValue());
                }
                Long _tmp_1 = ReactionDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp_1.longValue());
                }
                Long _tmp_2 = ReactionDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, _tmp_2.longValue());
                }
                int _tmp_3 = value.getEnforceUnique() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                String _tmp_4 = ReactionDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_4);
                }
                int _tmp_5 = ReactionDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(10, (long)_tmp_5);
                stmt.bindLong(11, (long)value.getId());
            }
        };
        this.__preparedStmtOfSetDeleteAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE stream_chat_reaction SET deletedAt = ? WHERE userId = ? AND messageId = ?";
                return "UPDATE stream_chat_reaction SET deletedAt = ? WHERE userId = ? AND messageId = ?";
            }
        };
    }

    @Override
    public Object insert(final ReactionEntity reactionEntity, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ReactionDao_Impl.this.__db.beginTransaction();
                try {
                    ReactionDao_Impl.this.__insertionAdapterOfReactionEntity.insert((Object)reactionEntity);
                    ReactionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ReactionDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object setDeleteAt(final String userId, final String messageId, final Date deletedAt, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ReactionDao_Impl.this.__preparedStmtOfSetDeleteAt.acquire();
                int _argIndex = 1;
                Long _tmp = ReactionDao_Impl.this.__dateConverter.dateToTimestamp(deletedAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, _tmp.longValue());
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, userId);
                }
                _argIndex = 3;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, messageId);
                }
                ReactionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ReactionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ReactionDao_Impl.this.__db.endTransaction();
                    ReactionDao_Impl.this.__preparedStmtOfSetDeleteAt.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object selectReactionById(int id, Continuation<? super ReactionEntity> continuation) {
        String _sql = "SELECT * FROM stream_chat_reaction WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_reaction WHERE id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)id);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ReactionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReactionEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ReactionEntity _result;
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"score");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enforceUnique");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        int _tmpScore = _cursor.getInt(_cursorIndexOfScore);
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfEnforceUnique);
                        boolean _tmpEnforceUnique = _tmp_3 != 0;
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmp_5 = ReactionDao_Impl.this.__extraDataConverter.stringToMap(_tmp_4);
                        if (_tmp_5 == null) {
                            throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                        }
                        Map<String, Object> _tmpExtraData = _tmp_5;
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ReactionDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_6);
                        _result = new ReactionEntity(_tmpMessageId, _tmpUserId, _tmpType, _tmpScore, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpEnforceUnique, _tmpExtraData, _tmpSyncStatus);
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        _result.setId(_tmpId);
                    } else {
                        _result = null;
                    }
                    ReactionEntity reactionEntity = _result;
                    return reactionEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object selectReactionsByIds(List<Integer> ids, Continuation<? super List<ReactionEntity>> continuation) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM stream_chat_reaction WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (int _item : ids) {
            _statement.bindLong(_argIndex, (long)_item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ReactionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ReactionEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"score");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enforceUnique");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<ReactionEntity> _result = new ArrayList<ReactionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        int _tmpScore = _cursor.getInt(_cursorIndexOfScore);
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfEnforceUnique);
                        boolean _tmpEnforceUnique = _tmp_3 != 0;
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmp_5 = ReactionDao_Impl.this.__extraDataConverter.stringToMap(_tmp_4);
                        if (_tmp_5 == null) {
                            throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                        }
                        Map<String, Object> _tmpExtraData = _tmp_5;
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ReactionDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_6);
                        ReactionEntity _item_1 = new ReactionEntity(_tmpMessageId, _tmpUserId, _tmpType, _tmpScore, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpEnforceUnique, _tmpExtraData, _tmpSyncStatus);
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        _item_1.setId(_tmpId);
                        _result.add(_item_1);
                    }
                    ArrayList<ReactionEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object selectIdsSyncStatus(SyncStatus syncStatus, int limit, Continuation<? super List<Integer>> continuation) {
        String _sql = "SELECT id FROM stream_chat_reaction WHERE syncStatus = ? ORDER BY syncStatus ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM stream_chat_reaction WHERE syncStatus = ? ORDER BY syncStatus ASC LIMIT ?", (int)2);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Integer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Integer> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<Integer> _result = new ArrayList<Integer>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Integer _item = _cursor.getInt(0);
                        _result.add(_item);
                    }
                    ArrayList<Integer> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object selectSyncStatus(SyncStatus syncStatus, int limit, Continuation<? super List<ReactionEntity>> continuation) {
        String _sql = "SELECT * FROM stream_chat_reaction WHERE syncStatus = ? ORDER BY syncStatus ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_reaction WHERE syncStatus = ? ORDER BY syncStatus ASC LIMIT ?", (int)2);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ReactionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ReactionEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"score");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enforceUnique");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<ReactionEntity> _result = new ArrayList<ReactionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        int _tmpScore = _cursor.getInt(_cursorIndexOfScore);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfEnforceUnique);
                        boolean _tmpEnforceUnique = _tmp_4 != 0;
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmp_6 = ReactionDao_Impl.this.__extraDataConverter.stringToMap(_tmp_5);
                        if (_tmp_6 == null) {
                            throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                        }
                        Map<String, Object> _tmpExtraData = _tmp_6;
                        int _tmp_7 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ReactionDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_7);
                        ReactionEntity _item = new ReactionEntity(_tmpMessageId, _tmpUserId, _tmpType, _tmpScore, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpEnforceUnique, _tmpExtraData, _tmpSyncStatus);
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        _result.add(_item);
                    }
                    ArrayList<ReactionEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object selectUserReactionToMessage(String reactionType, String messageId, String userId, Continuation<? super ReactionEntity> continuation) {
        String _sql = "SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.type = ? AND stream_chat_reaction.messageid = ? AND userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.type = ? AND stream_chat_reaction.messageid = ? AND userId = ?", (int)3);
        int _argIndex = 1;
        if (reactionType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reactionType);
        }
        _argIndex = 2;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        _argIndex = 3;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ReactionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReactionEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ReactionEntity _result;
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"score");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enforceUnique");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        int _tmpScore = _cursor.getInt(_cursorIndexOfScore);
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfEnforceUnique);
                        boolean _tmpEnforceUnique = _tmp_3 != 0;
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmp_5 = ReactionDao_Impl.this.__extraDataConverter.stringToMap(_tmp_4);
                        if (_tmp_5 == null) {
                            throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                        }
                        Map<String, Object> _tmpExtraData = _tmp_5;
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ReactionDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_6);
                        _result = new ReactionEntity(_tmpMessageId, _tmpUserId, _tmpType, _tmpScore, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpEnforceUnique, _tmpExtraData, _tmpSyncStatus);
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        _result.setId(_tmpId);
                    } else {
                        _result = null;
                    }
                    ReactionEntity reactionEntity = _result;
                    return reactionEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object selectUserReactionsToMessage(String messageId, String userId, Continuation<? super List<ReactionEntity>> continuation) {
        String _sql = "SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.messageid = ? AND userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_reaction WHERE stream_chat_reaction.messageid = ? AND userId = ?", (int)2);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ReactionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ReactionEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"score");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfEnforceUnique = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enforceUnique");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<ReactionEntity> _result = new ArrayList<ReactionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        int _tmpScore = _cursor.getInt(_cursorIndexOfScore);
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ReactionDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfEnforceUnique);
                        boolean _tmpEnforceUnique = _tmp_3 != 0;
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmp_5 = ReactionDao_Impl.this.__extraDataConverter.stringToMap(_tmp_4);
                        if (_tmp_5 == null) {
                            throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                        }
                        Map<String, Object> _tmpExtraData = _tmp_5;
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ReactionDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_6);
                        ReactionEntity _item = new ReactionEntity(_tmpMessageId, _tmpUserId, _tmpType, _tmpScore, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpEnforceUnique, _tmpExtraData, _tmpSyncStatus);
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        _result.add(_item);
                    }
                    ArrayList<ReactionEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

