/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.factory;

import android.content.Context;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.persistance.repository.ChannelRepository;
import io.getstream.chat.android.client.persistance.repository.MessageRepository;
import io.getstream.chat.android.client.persistance.repository.ReactionRepository;
import io.getstream.chat.android.client.persistance.repository.RepositoryFacade;
import io.getstream.chat.android.client.persistance.repository.UserRepository;
import io.getstream.chat.android.client.persistance.repository.factory.RepositoryFactory;
import io.getstream.chat.android.client.plugin.DependencyResolver;
import io.getstream.chat.android.client.plugin.Plugin;
import io.getstream.chat.android.client.plugin.factory.PluginFactory;
import io.getstream.chat.android.client.plugin.listeners.ChannelMarkReadListener;
import io.getstream.chat.android.client.plugin.listeners.CreateChannelListener;
import io.getstream.chat.android.client.plugin.listeners.DeleteMessageListener;
import io.getstream.chat.android.client.plugin.listeners.DeleteReactionListener;
import io.getstream.chat.android.client.plugin.listeners.EditMessageListener;
import io.getstream.chat.android.client.plugin.listeners.HideChannelListener;
import io.getstream.chat.android.client.plugin.listeners.MarkAllReadListener;
import io.getstream.chat.android.client.plugin.listeners.QueryChannelListener;
import io.getstream.chat.android.client.plugin.listeners.QueryChannelsListener;
import io.getstream.chat.android.client.plugin.listeners.QueryMembersListener;
import io.getstream.chat.android.client.plugin.listeners.SendGiphyListener;
import io.getstream.chat.android.client.plugin.listeners.SendMessageListener;
import io.getstream.chat.android.client.plugin.listeners.SendReactionListener;
import io.getstream.chat.android.client.plugin.listeners.ShuffleGiphyListener;
import io.getstream.chat.android.client.plugin.listeners.ThreadQueryListener;
import io.getstream.chat.android.client.plugin.listeners.TypingEventListener;
import io.getstream.chat.android.client.setup.InitializationCoordinator;
import io.getstream.chat.android.client.setup.state.ClientState;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.chat.android.offline.plugin.configuration.Config;
import io.getstream.chat.android.offline.plugin.internal.OfflinePlugin;
import io.getstream.chat.android.offline.plugin.listener.internal.CreateChannelListenerImpl;
import io.getstream.chat.android.offline.plugin.listener.internal.DeleteMessageListenerComposite;
import io.getstream.chat.android.offline.plugin.listener.internal.DeleteMessageListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.DeleteReactionListenerComposite;
import io.getstream.chat.android.offline.plugin.listener.internal.DeleteReactionListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.EditMessageListenerComposite;
import io.getstream.chat.android.offline.plugin.listener.internal.EditMessageListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.HideChannelListenerComposite;
import io.getstream.chat.android.offline.plugin.listener.internal.HideChannelListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.QueryMembersListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.SendMessageListenerComposite;
import io.getstream.chat.android.offline.plugin.listener.internal.SendMessageListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.SendReactionListenerComposite;
import io.getstream.chat.android.offline.plugin.listener.internal.SendReactionListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.ShuffleGiphyListenerComposite;
import io.getstream.chat.android.offline.plugin.listener.internal.ShuffleGiphyListenerDatabase;
import io.getstream.chat.android.offline.repository.database.internal.ChatDatabase;
import io.getstream.chat.android.offline.repository.factory.internal.DatabaseRepositoryFactory;
import io.getstream.chat.android.state.plugin.configuration.StatePluginConfig;
import io.getstream.chat.android.state.plugin.factory.StreamStatePluginFactory;
import io.getstream.chat.android.state.plugin.internal.StatePlugin;
import io.getstream.logging.Priority;
import io.getstream.logging.StreamLog;
import io.getstream.logging.StreamLogger;
import io.getstream.logging.TaggedLogger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J \u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J \u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J \u00102\u001a\u0002032\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u00104\u001a\u0002052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/getstream/chat/android/offline/plugin/factory/StreamOfflinePluginFactory;", "Lio/getstream/chat/android/client/plugin/factory/PluginFactory;", "Lio/getstream/chat/android/client/persistance/repository/factory/RepositoryFactory$Provider;", "config", "Lio/getstream/chat/android/offline/plugin/configuration/Config;", "appContext", "Landroid/content/Context;", "(Lio/getstream/chat/android/offline/plugin/configuration/Config;Landroid/content/Context;)V", "_scope", "Lkotlinx/coroutines/CoroutineScope;", "cachedOfflinePluginInstance", "Lio/getstream/chat/android/offline/plugin/internal/OfflinePlugin;", "exceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "logger", "Lio/getstream/logging/TaggedLogger;", "statePluginFactory", "Lio/getstream/chat/android/state/plugin/factory/StreamStatePluginFactory;", "clearCachedInstance", "", "createDatabase", "Lio/getstream/chat/android/offline/repository/database/internal/ChatDatabase;", "scope", "context", "user", "Lio/getstream/chat/android/client/models/User;", "offlineEnabled", "", "createRepositoryFactory", "Lio/getstream/chat/android/client/persistance/repository/factory/RepositoryFactory;", "ensureScope", "get", "Lio/getstream/chat/android/client/plugin/Plugin;", "getDeleteMessageListenerDatabase", "Lio/getstream/chat/android/client/plugin/listeners/DeleteMessageListener;", "clientState", "Lio/getstream/chat/android/client/setup/state/ClientState;", "repositoryFacade", "Lio/getstream/chat/android/client/persistance/repository/RepositoryFacade;", "statePlugin", "Lio/getstream/chat/android/state/plugin/internal/StatePlugin;", "getDeleteReactionListener", "Lio/getstream/chat/android/client/plugin/listeners/DeleteReactionListener;", "getEditMessageListener", "Lio/getstream/chat/android/offline/plugin/listener/internal/EditMessageListenerComposite;", "getHideChannelListener", "Lio/getstream/chat/android/client/plugin/listeners/HideChannelListener;", "getOrCreateOfflinePlugin", "getSendMessageListener", "Lio/getstream/chat/android/client/plugin/listeners/SendMessageListener;", "getSendReactionListener", "Lio/getstream/chat/android/client/plugin/listeners/SendReactionListener;", "getShuffleGiphyListener", "Lio/getstream/chat/android/client/plugin/listeners/ShuffleGiphyListener;", "stream-chat-android-offline_release"})
public final class StreamOfflinePluginFactory
implements PluginFactory,
RepositoryFactory.Provider {
    @NotNull
    private final Config config;
    @NotNull
    private final Context appContext;
    @NotNull
    private final TaggedLogger logger;
    @Nullable
    private OfflinePlugin cachedOfflinePluginInstance;
    @NotNull
    private final CoroutineExceptionHandler exceptionHandler;
    @NotNull
    private final StreamStatePluginFactory statePluginFactory;
    @Nullable
    private volatile CoroutineScope _scope;

    public StreamOfflinePluginFactory(@NotNull Config config, @NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.config = config;
        this.appContext = appContext;
        this.logger = StreamLog.getLogger((String)"Chat:OfflinePluginFactory");
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        this.exceptionHandler = new CoroutineExceptionHandler(key){

            /*
             * WARNING - void declaration
             */
            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable throwable = exception;
                CoroutineContext context2 = context;
                boolean bl = false;
                String tag$iv = "StreamOfflinePlugin";
                boolean $i$f$e = false;
                if (StreamLog.INSTANCE.getInternalValidator().isLoggable(Priority.ERROR, tag$iv)) {
                    void throwable2;
                    String string = tag$iv;
                    Priority priority = Priority.ERROR;
                    StreamLogger streamLogger = StreamLog.INSTANCE.getInternalLogger();
                    boolean bl2 = false;
                    String string2 = "[uncaughtCoroutineException] throwable: " + throwable2 + ", context: " + context2;
                    streamLogger.log(priority, string, string2, (Throwable)throwable2);
                }
            }
        };
        this.statePluginFactory = new StreamStatePluginFactory(new StatePluginConfig(this.config.getBackgroundSyncEnabled(), this.config.getUserPresence(), this.config.getUploadAttachmentsNetworkType(), this.config.getUseSequentialEventHandler()), this.appContext);
    }

    @NotNull
    public RepositoryFactory createRepositoryFactory(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "[createRepositoryFactory] user.id: '" + user.getId() + '\'';
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        CoroutineScope scope = this.ensureScope(user);
        return new DatabaseRepositoryFactory(this.createDatabase(scope, this.appContext, user, this.config.getPersistenceEnabled()), user);
    }

    @NotNull
    public Plugin get(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return (Plugin)this.getOrCreateOfflinePlugin(user);
    }

    private final OfflinePlugin getOrCreateOfflinePlugin(User user) {
        OfflinePlugin offlinePlugin;
        String string;
        StreamLogger streamLogger;
        Priority priority;
        String string2;
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            string2 = this_$iv.getTag();
            priority = Priority.INFO;
            streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            string = "[getOrCreateOfflinePlugin] user.id: '" + user.getId() + '\'';
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
        }
        OfflinePlugin cachedPlugin = this.cachedOfflinePluginInstance;
        if (cachedPlugin != null && Intrinsics.areEqual((Object)cachedPlugin.getActiveUser$stream_chat_android_offline_release().getId(), (Object)user.getId())) {
            TaggedLogger this_$iv2 = this.logger;
            boolean $i$f$i2 = false;
            if (this_$iv2.getValidator().isLoggable(Priority.INFO, this_$iv2.getTag())) {
                string2 = this_$iv2.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv2.getDelegate();
                boolean bl = false;
                string = "OfflinePlugin for the user is already initialized. Returning cached instance.";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
            return cachedPlugin;
        }
        this.clearCachedInstance();
        ChatClient.Companion.setOFFLINE_SUPPORT_ENABLED(true);
        CoroutineScope scope = this.ensureScope(user);
        StatePlugin statePlugin = this.statePluginFactory.createStatePlugin(user, scope);
        InitializationCoordinator.Companion.getOrCreate().addUserDisconnectedListener((Function1)new Function1<User, Unit>(this){
            final /* synthetic */ StreamOfflinePluginFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable User it) {
                TaggedLogger this_$iv = StreamOfflinePluginFactory.access$getLogger$p(this.this$0);
                boolean $i$f$i = false;
                if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                    String string = this_$iv.getTag();
                    Priority priority = Priority.INFO;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    User user = it;
                    String string2 = "[onUserDisconnected] user.id: '" + (user != null ? user.getId() : null) + '\'';
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
                }
                StreamOfflinePluginFactory.access$clearCachedInstance(this.this$0);
                CoroutineScope coroutineScope = StreamOfflinePluginFactory.access$get_scope$p(this.this$0);
                if (coroutineScope != null) {
                    CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, null, (int)1, null);
                }
                StreamOfflinePluginFactory.access$set_scope$p(this.this$0, null);
            }
        });
        ChatClient chatClient = ChatClient.Companion.instance();
        ClientState clientState = chatClient.getClientState();
        RepositoryFacade repositoryFacade = chatClient.getRepositoryFacade();
        EditMessageListenerComposite editMessageListener = this.getEditMessageListener(clientState, repositoryFacade, statePlugin);
        HideChannelListener hideChannelListener = this.getHideChannelListener(repositoryFacade, statePlugin);
        DeleteReactionListener deleteReactionListener = this.getDeleteReactionListener(clientState, repositoryFacade, statePlugin);
        SendReactionListener sendReactionListener = this.getSendReactionListener(clientState, repositoryFacade, statePlugin);
        DeleteMessageListener deleteMessageListener = this.getDeleteMessageListenerDatabase(clientState, repositoryFacade, statePlugin);
        SendMessageListener sendMessageListener = this.getSendMessageListener(repositoryFacade, statePlugin);
        ShuffleGiphyListener shuffleGiphyListener = this.getShuffleGiphyListener(repositoryFacade, statePlugin);
        QueryMembersListener queryMembersListener = new QueryMembersListenerDatabase((UserRepository)repositoryFacade, (ChannelRepository)repositoryFacade);
        CreateChannelListener createChannelListener = new CreateChannelListenerImpl(clientState, (ChannelRepository)repositoryFacade, (UserRepository)repositoryFacade);
        OfflinePlugin offlinePlugin2 = offlinePlugin = new OfflinePlugin(user, (QueryChannelsListener)statePlugin, (QueryChannelListener)statePlugin, (ThreadQueryListener)statePlugin, (ChannelMarkReadListener)statePlugin, editMessageListener, hideChannelListener, (MarkAllReadListener)statePlugin, deleteReactionListener, sendReactionListener, deleteMessageListener, (SendGiphyListener)statePlugin, shuffleGiphyListener, sendMessageListener, queryMembersListener, (TypingEventListener)statePlugin, createChannelListener, (DependencyResolver)statePlugin, null, 262144, null);
        boolean bl = false;
        this.cachedOfflinePluginInstance = offlinePlugin2;
        return offlinePlugin;
    }

    private final CoroutineScope ensureScope(User user) {
        CoroutineScope coroutineScope;
        CoroutineScope currentScope = this._scope;
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            CoroutineScope coroutineScope2 = currentScope;
            String string2 = "[ensureScope] user.id: '" + user.getId() + "', hasScope: " + (currentScope != null) + ", isScopeActive: " + (coroutineScope2 != null ? Boolean.valueOf(CoroutineScopeKt.isActive((CoroutineScope)coroutineScope2)) : null);
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        if (currentScope == null || !CoroutineScopeKt.isActive((CoroutineScope)currentScope)) {
            CoroutineScope coroutineScope3;
            CoroutineScope it = coroutineScope3 = ChatClient.Companion.instance().inheritScope((Function1)new Function1<Job, CoroutineContext>(this){
                final /* synthetic */ StreamOfflinePluginFactory this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CoroutineContext invoke(@NotNull Job parentJob) {
                    Intrinsics.checkNotNullParameter((Object)parentJob, (String)"parentJob");
                    return SupervisorKt.SupervisorJob((Job)parentJob).plus((CoroutineContext)DispatcherProvider.INSTANCE.getIO()).plus((CoroutineContext)StreamOfflinePluginFactory.access$getExceptionHandler$p(this.this$0));
                }
            });
            boolean bl = false;
            TaggedLogger this_$iv2 = this.logger;
            boolean $i$f$v = false;
            if (this_$iv2.getValidator().isLoggable(Priority.VERBOSE, this_$iv2.getTag())) {
                String string = this_$iv2.getTag();
                Priority priority = Priority.VERBOSE;
                StreamLogger streamLogger = this_$iv2.getDelegate();
                boolean bl2 = false;
                String string3 = "[ensureScope] create new scope: '" + user.getId() + '\'';
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string3, null, (int)8, null);
            }
            this._scope = it;
            coroutineScope = coroutineScope3;
        } else {
            CoroutineScope coroutineScope4;
            CoroutineScope it = coroutineScope4 = currentScope;
            boolean bl = false;
            TaggedLogger this_$iv3 = this.logger;
            boolean $i$f$v = false;
            if (this_$iv3.getValidator().isLoggable(Priority.VERBOSE, this_$iv3.getTag())) {
                String string = this_$iv3.getTag();
                Priority priority = Priority.VERBOSE;
                StreamLogger streamLogger = this_$iv3.getDelegate();
                boolean bl3 = false;
                String string4 = "[ensureScope] reuse existing scope: '" + user.getId() + '\'';
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string4, null, (int)8, null);
            }
            coroutineScope = coroutineScope4;
        }
        return coroutineScope;
    }

    private final EditMessageListenerComposite getEditMessageListener(ClientState clientState, RepositoryFacade repositoryFacade, StatePlugin statePlugin) {
        EditMessageListenerDatabase editMessageListenerDatabase = new EditMessageListenerDatabase((UserRepository)repositoryFacade, (MessageRepository)repositoryFacade, clientState);
        Object[] objectArray = new EditMessageListener[]{(EditMessageListener)statePlugin, editMessageListenerDatabase};
        return new EditMessageListenerComposite(CollectionsKt.listOf((Object[])objectArray));
    }

    private final HideChannelListener getHideChannelListener(RepositoryFacade repositoryFacade, StatePlugin statePlugin) {
        HideChannelListenerDatabase hideChannelListenerDatabase = new HideChannelListenerDatabase((ChannelRepository)repositoryFacade, (MessageRepository)repositoryFacade);
        Object[] objectArray = new HideChannelListener[]{(HideChannelListener)statePlugin, hideChannelListenerDatabase};
        return new HideChannelListenerComposite(CollectionsKt.listOf((Object[])objectArray));
    }

    private final DeleteReactionListener getDeleteReactionListener(ClientState clientState, RepositoryFacade repositoryFacade, StatePlugin statePlugin) {
        DeleteReactionListenerDatabase deleteReactionListenerDatabase = new DeleteReactionListenerDatabase(clientState, (ReactionRepository)repositoryFacade, (MessageRepository)repositoryFacade);
        Object[] objectArray = new DeleteReactionListener[]{deleteReactionListenerDatabase, (DeleteReactionListener)statePlugin};
        return new DeleteReactionListenerComposite(CollectionsKt.listOf((Object[])objectArray));
    }

    private final SendReactionListener getSendReactionListener(ClientState clientState, RepositoryFacade repositoryFacade, StatePlugin statePlugin) {
        SendReactionListenerDatabase sendReactionListenerDatabase = new SendReactionListenerDatabase(clientState, (ReactionRepository)repositoryFacade, (MessageRepository)repositoryFacade, (UserRepository)repositoryFacade);
        Object[] objectArray = new SendReactionListener[]{(SendReactionListener)statePlugin, sendReactionListenerDatabase};
        return new SendReactionListenerComposite(CollectionsKt.listOf((Object[])objectArray));
    }

    private final SendMessageListener getSendMessageListener(RepositoryFacade repositoryFacade, StatePlugin statePlugin) {
        SendMessageListenerDatabase sendMessageListenerDatabase = new SendMessageListenerDatabase((UserRepository)repositoryFacade, (MessageRepository)repositoryFacade);
        Object[] objectArray = new SendMessageListener[]{(SendMessageListener)statePlugin, sendMessageListenerDatabase};
        return new SendMessageListenerComposite(CollectionsKt.listOf((Object[])objectArray));
    }

    private final ShuffleGiphyListener getShuffleGiphyListener(RepositoryFacade repositoryFacade, StatePlugin statePlugin) {
        ShuffleGiphyListenerDatabase shuffleGiphyListenerDatabase = new ShuffleGiphyListenerDatabase((UserRepository)repositoryFacade, (MessageRepository)repositoryFacade);
        Object[] objectArray = new ShuffleGiphyListener[]{shuffleGiphyListenerDatabase, (ShuffleGiphyListener)statePlugin};
        return new ShuffleGiphyListenerComposite(CollectionsKt.listOf((Object[])objectArray));
    }

    private final DeleteMessageListener getDeleteMessageListenerDatabase(ClientState clientState, RepositoryFacade repositoryFacade, StatePlugin statePlugin) {
        DeleteMessageListenerDatabase deleteMessageListenerDatabase = new DeleteMessageListenerDatabase(clientState, (MessageRepository)repositoryFacade, (UserRepository)repositoryFacade);
        Object[] objectArray = new DeleteMessageListener[]{(DeleteMessageListener)statePlugin, deleteMessageListenerDatabase};
        return new DeleteMessageListenerComposite(CollectionsKt.listOf((Object[])objectArray));
    }

    private final void clearCachedInstance() {
        this.cachedOfflinePluginInstance = null;
    }

    private final ChatDatabase createDatabase(CoroutineScope scope, Context context, User user, boolean offlineEnabled) {
        ChatDatabase chatDatabase;
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            User user2 = user;
            String string2 = "[createDatabase] user.id: '" + (user2 != null ? user2.getId() : null) + "', offlineEnabled: " + offlineEnabled;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        if (offlineEnabled && user != null) {
            chatDatabase = ChatDatabase.Companion.getDatabase(context, user.getId());
        } else {
            RoomDatabase roomDatabase = Room.inMemoryDatabaseBuilder((Context)context, ChatDatabase.class).build();
            ChatDatabase inMemoryDatabase = (ChatDatabase)roomDatabase;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(inMemoryDatabase, null){
                int label;
                final /* synthetic */ ChatDatabase $inMemoryDatabase;
                {
                    this.$inMemoryDatabase = $inMemoryDatabase;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.$inMemoryDatabase.clearAllTables();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            RoomDatabase roomDatabase2 = roomDatabase;
            Intrinsics.checkNotNullExpressionValue((Object)roomDatabase2, (String)"{\n            Room.inMem\u2026}\n            }\n        }");
            chatDatabase = (ChatDatabase)roomDatabase2;
        }
        return chatDatabase;
    }

    public static final /* synthetic */ TaggedLogger access$getLogger$p(StreamOfflinePluginFactory $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$clearCachedInstance(StreamOfflinePluginFactory $this) {
        $this.clearCachedInstance();
    }

    public static final /* synthetic */ CoroutineScope access$get_scope$p(StreamOfflinePluginFactory $this) {
        return $this._scope;
    }

    public static final /* synthetic */ void access$set_scope$p(StreamOfflinePluginFactory $this, CoroutineScope coroutineScope) {
        $this._scope = coroutineScope;
    }

    public static final /* synthetic */ CoroutineExceptionHandler access$getExceptionHandler$p(StreamOfflinePluginFactory $this) {
        return $this.exceptionHandler;
    }
}

