/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.state.internal;

import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.api.models.QueryChannelRequest;
import io.getstream.chat.android.client.api.models.QueryChannelsRequest;
import io.getstream.chat.android.client.api.models.QuerySort;
import io.getstream.chat.android.client.api.models.WatchChannelRequest;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.call.CallKt;
import io.getstream.chat.android.client.extensions.StringExtensionsKt;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.offline.model.querychannels.pagination.internal.QueryChannelPaginationRequest;
import io.getstream.chat.android.offline.plugin.state.StateRegistry;
import io.getstream.chat.android.offline.plugin.state.channel.ChannelState;
import io.getstream.chat.android.offline.plugin.state.channel.thread.ThreadState;
import io.getstream.chat.android.offline.plugin.state.querychannels.QueryChannelsState;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/getstream/chat/android/offline/plugin/state/internal/ChatClientStateCalls;", "", "chatClient", "Lio/getstream/chat/android/client/ChatClient;", "state", "Lio/getstream/chat/android/offline/plugin/state/StateRegistry;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lio/getstream/chat/android/client/ChatClient;Lio/getstream/chat/android/offline/plugin/state/StateRegistry;Lkotlinx/coroutines/CoroutineScope;)V", "getReplies", "Lio/getstream/chat/android/offline/plugin/state/channel/thread/ThreadState;", "messageId", "", "messageLimit", "", "getReplies$stream_chat_android_offline_release", "queryChannel", "Lio/getstream/chat/android/offline/plugin/state/channel/ChannelState;", "channelType", "channelId", "request", "Lio/getstream/chat/android/client/api/models/QueryChannelRequest;", "queryChannels", "Lio/getstream/chat/android/offline/plugin/state/querychannels/QueryChannelsState;", "Lio/getstream/chat/android/client/api/models/QueryChannelsRequest;", "queryChannels$stream_chat_android_offline_release", "watchChannel", "cid", "watchChannel$stream_chat_android_offline_release", "stream-chat-android-offline_release"})
public final class ChatClientStateCalls {
    @NotNull
    private final ChatClient chatClient;
    @NotNull
    private final StateRegistry state;
    @NotNull
    private final CoroutineScope scope;

    public ChatClientStateCalls(@NotNull ChatClient chatClient, @NotNull StateRegistry state, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)chatClient, (String)"chatClient");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.chatClient = chatClient;
        this.state = state;
        this.scope = scope;
    }

    @NotNull
    public final QueryChannelsState queryChannels$stream_chat_android_offline_release(@NotNull QueryChannelsRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CallKt.launch((Call)this.chatClient.queryChannels(request), (CoroutineScope)this.scope);
        return this.state.queryChannels(request.getFilter(), (QuerySort<Channel>)request.getQuerySort());
    }

    private final ChannelState queryChannel(String channelType, String channelId, QueryChannelRequest request) {
        CallKt.launch((Call)this.chatClient.queryChannel(channelType, channelId, request), (CoroutineScope)this.scope);
        return this.state.channel(channelType, channelId);
    }

    @NotNull
    public final ChannelState watchChannel$stream_chat_android_offline_release(@NotNull String cid, int messageLimit) {
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        Pair pair = StringExtensionsKt.cidToTypeAndId((String)cid);
        String channelType = (String)pair.component1();
        String channelId = (String)pair.component2();
        boolean userPresence = true;
        WatchChannelRequest request = new QueryChannelPaginationRequest(messageLimit).toWatchChannelRequest(userPresence);
        return this.queryChannel(channelType, channelId, (QueryChannelRequest)request);
    }

    @NotNull
    public final ThreadState getReplies$stream_chat_android_offline_release(@NotNull String messageId, int messageLimit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        CallKt.launch((Call)this.chatClient.getReplies(messageId, messageLimit), (CoroutineScope)this.scope);
        return this.state.thread(messageId);
    }
}

