/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.event.handler.chat;

import io.getstream.chat.android.client.api.models.FilterObject;
import io.getstream.chat.android.client.events.ChannelUpdatedByUserEvent;
import io.getstream.chat.android.client.events.ChannelUpdatedEvent;
import io.getstream.chat.android.client.events.MemberAddedEvent;
import io.getstream.chat.android.client.events.MemberRemovedEvent;
import io.getstream.chat.android.client.events.NotificationAddedToChannelEvent;
import io.getstream.chat.android.client.events.NotificationMessageNewEvent;
import io.getstream.chat.android.client.events.NotificationRemovedFromChannelEvent;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.offline.event.handler.chat.BaseChatEventHandler;
import io.getstream.chat.android.offline.event.handler.chat.ChatEventHandlerKt;
import io.getstream.chat.android.offline.event.handler.chat.EventHandlingResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\"\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/getstream/chat/android/offline/event/handler/chat/DefaultChatEventHandler;", "Lio/getstream/chat/android/offline/event/handler/chat/BaseChatEventHandler;", "channels", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lio/getstream/chat/android/client/models/Channel;", "(Lkotlinx/coroutines/flow/StateFlow;)V", "handleChannelUpdatedByUserEvent", "Lio/getstream/chat/android/offline/event/handler/chat/EventHandlingResult;", "event", "Lio/getstream/chat/android/client/events/ChannelUpdatedByUserEvent;", "filter", "Lio/getstream/chat/android/client/api/models/FilterObject;", "handleChannelUpdatedEvent", "Lio/getstream/chat/android/client/events/ChannelUpdatedEvent;", "handleMemberAddedEvent", "Lio/getstream/chat/android/client/events/MemberAddedEvent;", "cachedChannel", "handleMemberRemovedEvent", "Lio/getstream/chat/android/client/events/MemberRemovedEvent;", "handleNotificationAddedToChannelEvent", "Lio/getstream/chat/android/client/events/NotificationAddedToChannelEvent;", "handleNotificationMessageNewEvent", "Lio/getstream/chat/android/client/events/NotificationMessageNewEvent;", "handleNotificationRemovedFromChannelEvent", "Lio/getstream/chat/android/client/events/NotificationRemovedFromChannelEvent;", "stream-chat-android-offline_release"})
public final class DefaultChatEventHandler
extends BaseChatEventHandler {
    @NotNull
    private final StateFlow<List<Channel>> channels;

    public DefaultChatEventHandler(@NotNull StateFlow<? extends List<Channel>> channels) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        this.channels = channels;
    }

    @Override
    @NotNull
    public EventHandlingResult handleNotificationAddedToChannelEvent(@NotNull NotificationAddedToChannelEvent event, @NotNull FilterObject filter2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        return ChatEventHandlerKt.addIfChannelIsAbsent(this.channels, event.getChannel());
    }

    @Override
    @NotNull
    public EventHandlingResult handleMemberAddedEvent(@NotNull MemberAddedEvent event, @NotNull FilterObject filter2, @Nullable Channel cachedChannel) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        return ChatEventHandlerKt.addIfChannelIsAbsent(this.channels, cachedChannel);
    }

    @Override
    @NotNull
    public EventHandlingResult handleChannelUpdatedByUserEvent(@NotNull ChannelUpdatedByUserEvent event, @NotNull FilterObject filter2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        return EventHandlingResult.Skip.INSTANCE;
    }

    @Override
    @NotNull
    public EventHandlingResult handleChannelUpdatedEvent(@NotNull ChannelUpdatedEvent event, @NotNull FilterObject filter2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        return EventHandlingResult.Skip.INSTANCE;
    }

    @Override
    @NotNull
    public EventHandlingResult handleNotificationMessageNewEvent(@NotNull NotificationMessageNewEvent event, @NotNull FilterObject filter2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        return ChatEventHandlerKt.addIfChannelIsAbsent(this.channels, event.getChannel());
    }

    @Override
    @NotNull
    public EventHandlingResult handleMemberRemovedEvent(@NotNull MemberRemovedEvent event, @NotNull FilterObject filter2, @Nullable Channel cachedChannel) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        return ChatEventHandlerKt.removeIfCurrentUserLeftChannel(this.channels, cachedChannel, event.getMember());
    }

    @Override
    @NotNull
    public EventHandlingResult handleNotificationRemovedFromChannelEvent(@NotNull NotificationRemovedFromChannelEvent event, @NotNull FilterObject filter2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        return ChatEventHandlerKt.removeIfCurrentUserLeftChannel(this.channels, event.getChannel(), event.getMember());
    }
}

