/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.factory;

import android.content.Context;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.persistance.repository.factory.RepositoryFactory;
import io.getstream.chat.android.client.persistance.repository.factory.RepositoryProvider;
import io.getstream.chat.android.client.plugin.Plugin;
import io.getstream.chat.android.client.plugin.factory.PluginFactory;
import io.getstream.chat.android.client.plugin.listeners.ChannelMarkReadListener;
import io.getstream.chat.android.client.plugin.listeners.CreateChannelListener;
import io.getstream.chat.android.client.plugin.listeners.DeleteMessageListener;
import io.getstream.chat.android.client.plugin.listeners.DeleteReactionListener;
import io.getstream.chat.android.client.plugin.listeners.EditMessageListener;
import io.getstream.chat.android.client.plugin.listeners.HideChannelListener;
import io.getstream.chat.android.client.plugin.listeners.MarkAllReadListener;
import io.getstream.chat.android.client.plugin.listeners.QueryChannelListener;
import io.getstream.chat.android.client.plugin.listeners.QueryChannelsListener;
import io.getstream.chat.android.client.plugin.listeners.QueryMembersListener;
import io.getstream.chat.android.client.plugin.listeners.SendGiphyListener;
import io.getstream.chat.android.client.plugin.listeners.SendMessageListener;
import io.getstream.chat.android.client.plugin.listeners.SendReactionListener;
import io.getstream.chat.android.client.plugin.listeners.ShuffleGiphyListener;
import io.getstream.chat.android.client.plugin.listeners.ThreadQueryListener;
import io.getstream.chat.android.client.plugin.listeners.TypingEventListener;
import io.getstream.chat.android.client.setup.InitializationCoordinator;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.chat.android.offline.plugin.configuration.Config;
import io.getstream.chat.android.offline.plugin.internal.OfflinePlugin;
import io.getstream.chat.android.offline.repository.database.internal.ChatDatabase;
import io.getstream.chat.android.offline.repository.factory.internal.DatabaseRepositoryFactory;
import io.getstream.chat.android.state.plugin.configuration.StatePluginConfig;
import io.getstream.chat.android.state.plugin.factory.StreamStatePluginFactory;
import io.getstream.chat.android.state.plugin.internal.StatePlugin;
import io.getstream.logging.Priority;
import io.getstream.logging.StreamLog;
import io.getstream.logging.StreamLogger;
import io.getstream.logging.TaggedLogger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/getstream/chat/android/offline/plugin/factory/StreamOfflinePluginFactory;", "Lio/getstream/chat/android/client/plugin/factory/PluginFactory;", "config", "Lio/getstream/chat/android/offline/plugin/configuration/Config;", "appContext", "Landroid/content/Context;", "(Lio/getstream/chat/android/offline/plugin/configuration/Config;Landroid/content/Context;)V", "cachedOfflinePluginInstance", "Lio/getstream/chat/android/offline/plugin/internal/OfflinePlugin;", "logger", "Lio/getstream/logging/TaggedLogger;", "repositoryFactory", "Lio/getstream/chat/android/client/persistance/repository/factory/RepositoryFactory;", "statePluginFactory", "Lio/getstream/chat/android/state/plugin/factory/StreamStatePluginFactory;", "clearCachedInstance", "", "createDatabase", "Lio/getstream/chat/android/offline/repository/database/internal/ChatDatabase;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "context", "user", "Lio/getstream/chat/android/client/models/User;", "offlineEnabled", "", "createRepositoryFactory", "get", "Lio/getstream/chat/android/client/plugin/Plugin;", "getOrCreateOfflinePlugin", "setRepositoryFactory", "stream-chat-android-offline_release"})
public final class StreamOfflinePluginFactory
implements PluginFactory {
    @NotNull
    private final Config config;
    @NotNull
    private final Context appContext;
    @Nullable
    private OfflinePlugin cachedOfflinePluginInstance;
    @NotNull
    private final TaggedLogger logger;
    @Nullable
    private RepositoryFactory repositoryFactory;
    @NotNull
    private final StreamStatePluginFactory statePluginFactory;

    public StreamOfflinePluginFactory(@NotNull Config config, @NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.config = config;
        this.appContext = appContext;
        this.logger = StreamLog.getLogger((String)"Chat:StreamOfflinePluginFactory");
        this.statePluginFactory = new StreamStatePluginFactory(new StatePluginConfig(this.config.getBackgroundSyncEnabled(), this.config.getUserPresence(), this.config.getUploadAttachmentsNetworkType(), false, 8, null), this.appContext);
    }

    @NotNull
    public Plugin get(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.getOrCreateOfflinePlugin(user);
    }

    public final void setRepositoryFactory(@NotNull RepositoryFactory repositoryFactory) {
        Intrinsics.checkNotNullParameter((Object)repositoryFactory, (String)"repositoryFactory");
        this.repositoryFactory = repositoryFactory;
    }

    private final OfflinePlugin getOrCreateOfflinePlugin(User user) {
        OfflinePlugin offlinePlugin;
        OfflinePlugin cachedPlugin = this.cachedOfflinePluginInstance;
        if (cachedPlugin != null && Intrinsics.areEqual((Object)cachedPlugin.getActiveUser$stream_chat_android_offline_release().getId(), (Object)user.getId())) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                String string = this_$iv.getTag();
                Priority priority = Priority.INFO;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string2 = "OfflinePlugin for the user is already initialized. Returning cached instance.";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
            }
            return cachedPlugin;
        }
        this.clearCachedInstance();
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key bl = CoroutineExceptionHandler.Key;
        CoroutineExceptionHandler exceptionHandler = new CoroutineExceptionHandler(bl){

            /*
             * WARNING - void declaration
             */
            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable throwable = exception;
                CoroutineContext context2 = context;
                boolean bl = false;
                String tag$iv = "StreamOfflinePlugin";
                boolean $i$f$e = false;
                if (StreamLog.INSTANCE.getInternalValidator().isLoggable(Priority.ERROR, tag$iv)) {
                    void throwable2;
                    String string = tag$iv;
                    Priority priority = Priority.ERROR;
                    StreamLogger streamLogger = StreamLog.INSTANCE.getInternalLogger();
                    boolean bl2 = false;
                    String string2 = "[uncaughtCoroutineException] throwable: " + throwable2 + ", context: " + context2;
                    streamLogger.log(priority, string, string2, (Throwable)throwable2);
                }
            }
        };
        CompletableJob job = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)job.plus((CoroutineContext)DispatcherProvider.INSTANCE.getIO()).plus((CoroutineContext)exceptionHandler));
        RepositoryFactory repositoryFactory = this.repositoryFactory;
        RepositoryFactory repositoryFactory2 = repositoryFactory == null ? this.createRepositoryFactory(scope, this.appContext, user, this.config.getPersistenceEnabled()) : repositoryFactory;
        RepositoryProvider.Companion.changeRepositoryFactory(repositoryFactory2);
        ChatClient.Companion.setOFFLINE_SUPPORT_ENABLED(true);
        StatePlugin statePlugin = this.statePluginFactory.createStatePlugin(user, scope, repositoryFactory2);
        InitializationCoordinator.Companion.getOrCreate().addUserDisconnectedListener((Function1)new Function1<User, Unit>(this){
            final /* synthetic */ StreamOfflinePluginFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable User it) {
                StreamOfflinePluginFactory.access$clearCachedInstance(this.this$0);
            }
        });
        OfflinePlugin offlinePlugin2 = offlinePlugin = new OfflinePlugin((QueryChannelsListener)statePlugin, (QueryChannelListener)statePlugin, (ThreadQueryListener)statePlugin, (ChannelMarkReadListener)statePlugin, (EditMessageListener)statePlugin, (HideChannelListener)statePlugin, (MarkAllReadListener)statePlugin, (DeleteReactionListener)statePlugin, (SendReactionListener)statePlugin, (DeleteMessageListener)statePlugin, (SendGiphyListener)statePlugin, (ShuffleGiphyListener)statePlugin, (SendMessageListener)statePlugin, (QueryMembersListener)statePlugin, (TypingEventListener)statePlugin, (CreateChannelListener)statePlugin, user);
        boolean bl2 = false;
        this.cachedOfflinePluginInstance = offlinePlugin2;
        return offlinePlugin;
    }

    private final void clearCachedInstance() {
        this.cachedOfflinePluginInstance = null;
    }

    private final RepositoryFactory createRepositoryFactory(CoroutineScope scope, Context context, User user, boolean offlineEnabled) {
        return new DatabaseRepositoryFactory(this.createDatabase(scope, context, user, offlineEnabled), user);
    }

    private final ChatDatabase createDatabase(CoroutineScope scope, Context context, User user, boolean offlineEnabled) {
        ChatDatabase chatDatabase;
        if (offlineEnabled && user != null) {
            chatDatabase = ChatDatabase.Companion.getDatabase(context, user.getId());
        } else {
            RoomDatabase roomDatabase = Room.inMemoryDatabaseBuilder((Context)context, ChatDatabase.class).build();
            ChatDatabase inMemoryDatabase = (ChatDatabase)roomDatabase;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(inMemoryDatabase, null){
                int label;
                final /* synthetic */ ChatDatabase $inMemoryDatabase;
                {
                    this.$inMemoryDatabase = $inMemoryDatabase;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.$inMemoryDatabase.clearAllTables();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            RoomDatabase roomDatabase2 = roomDatabase;
            Intrinsics.checkNotNullExpressionValue((Object)roomDatabase2, (String)"{\n            Room.inMem\u2026}\n            }\n        }");
            chatDatabase = (ChatDatabase)roomDatabase2;
        }
        return chatDatabase;
    }

    public static final /* synthetic */ void access$clearCachedInstance(StreamOfflinePluginFactory $this) {
        $this.clearCachedInstance();
    }
}

