/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.repository.domain.message.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.models.MessageSyncType;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.offline.repository.database.converter.internal.DateConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ExtraDataConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ListConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.MapConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.MessageSyncDescriptionConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.MessageSyncTypeConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.SyncStatusConverter;
import io.getstream.chat.android.offline.repository.domain.message.attachment.internal.AttachmentEntity;
import io.getstream.chat.android.offline.repository.domain.message.attachment.internal.UploadStateEntity;
import io.getstream.chat.android.offline.repository.domain.message.channelinfo.internal.ChannelInfoEntity;
import io.getstream.chat.android.offline.repository.domain.message.internal.MessageDao;
import io.getstream.chat.android.offline.repository.domain.message.internal.MessageEntity;
import io.getstream.chat.android.offline.repository.domain.message.internal.MessageInnerEntity;
import io.getstream.chat.android.offline.repository.domain.message.internal.MessageSyncContentEntity;
import io.getstream.chat.android.offline.repository.domain.reaction.internal.ReactionEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;

public final class MessageDao_Impl
extends MessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MessageInnerEntity> __insertionAdapterOfMessageInnerEntity;
    private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();
    private final MessageSyncTypeConverter __messageSyncTypeConverter = new MessageSyncTypeConverter();
    private final MessageSyncDescriptionConverter __messageSyncDescriptionConverter = new MessageSyncDescriptionConverter();
    private final DateConverter __dateConverter = new DateConverter();
    private final ListConverter __listConverter = new ListConverter();
    private final MapConverter __mapConverter = new MapConverter();
    private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();
    private final EntityInsertionAdapter<AttachmentEntity> __insertionAdapterOfAttachmentEntity;
    private final EntityInsertionAdapter<ReactionEntity> __insertionAdapterOfReactionEntity;
    private final EntityDeletionOrUpdateAdapter<MessageInnerEntity> __updateAdapterOfMessageInnerEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChannelMessagesBefore;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessage;

    public MessageDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMessageInnerEntity = new EntityInsertionAdapter<MessageInnerEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `stream_chat_message` (`id`,`cid`,`userId`,`text`,`html`,`type`,`syncStatus`,`syncType`,`syncContent`,`replyCount`,`createdAt`,`createdLocallyAt`,`updatedAt`,`updatedLocallyAt`,`deletedAt`,`remoteMentionedUserIds`,`mentionedUsersId`,`reactionCounts`,`reactionScores`,`parentId`,`command`,`shadowed`,`showInChannel`,`silent`,`extraData`,`replyToId`,`pinned`,`pinnedAt`,`pinExpires`,`pinnedByUserId`,`threadParticipantsIds`,`channel_infocid`,`channel_infoid`,`channel_infotype`,`channel_infomemberCount`,`channel_infoname`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MessageInnerEntity value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getCid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getCid());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getText() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getText());
                }
                if (value.getHtml() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getHtml());
                }
                if (value.getType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getType());
                }
                int _tmp = MessageDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(7, (long)_tmp);
                Integer _tmp_1 = value.getSyncType() == null ? null : Integer.valueOf(MessageDao_Impl.this.__messageSyncTypeConverter.messageSyncTypeToString(value.getSyncType()));
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, (long)_tmp_1.intValue());
                }
                String _tmp_2 = MessageDao_Impl.this.__messageSyncDescriptionConverter.messageSyncDescriptionToString(value.getSyncContent());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_2);
                }
                stmt.bindLong(10, (long)value.getReplyCount());
                Long _tmp_3 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, _tmp_3.longValue());
                }
                Long _tmp_4 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedLocallyAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, _tmp_4.longValue());
                }
                Long _tmp_5 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, _tmp_5.longValue());
                }
                Long _tmp_6 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedLocallyAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, _tmp_6.longValue());
                }
                Long _tmp_7 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, _tmp_7.longValue());
                }
                String _tmp_8 = MessageDao_Impl.this.__listConverter.stringListToString(value.getRemoteMentionedUserIds());
                if (_tmp_8 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_8);
                }
                String _tmp_9 = MessageDao_Impl.this.__listConverter.stringListToString(value.getMentionedUsersId());
                if (_tmp_9 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_9);
                }
                String _tmp_10 = MessageDao_Impl.this.__mapConverter.mapToString(value.getReactionCounts());
                if (_tmp_10 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_10);
                }
                String _tmp_11 = MessageDao_Impl.this.__mapConverter.mapToString(value.getReactionScores());
                if (_tmp_11 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_11);
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getParentId());
                }
                if (value.getCommand() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.getCommand());
                }
                int _tmp_12 = value.getShadowed() ? 1 : 0;
                stmt.bindLong(22, (long)_tmp_12);
                int _tmp_13 = value.getShowInChannel() ? 1 : 0;
                stmt.bindLong(23, (long)_tmp_13);
                int _tmp_14 = value.getSilent() ? 1 : 0;
                stmt.bindLong(24, (long)_tmp_14);
                String _tmp_15 = MessageDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_15 == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, _tmp_15);
                }
                if (value.getReplyToId() == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindString(26, value.getReplyToId());
                }
                int _tmp_16 = value.getPinned() ? 1 : 0;
                stmt.bindLong(27, (long)_tmp_16);
                Long _tmp_17 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getPinnedAt());
                if (_tmp_17 == null) {
                    stmt.bindNull(28);
                } else {
                    stmt.bindLong(28, _tmp_17.longValue());
                }
                Long _tmp_18 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getPinExpires());
                if (_tmp_18 == null) {
                    stmt.bindNull(29);
                } else {
                    stmt.bindLong(29, _tmp_18.longValue());
                }
                if (value.getPinnedByUserId() == null) {
                    stmt.bindNull(30);
                } else {
                    stmt.bindString(30, value.getPinnedByUserId());
                }
                String _tmp_19 = MessageDao_Impl.this.__listConverter.stringListToString(value.getThreadParticipantsIds());
                if (_tmp_19 == null) {
                    stmt.bindNull(31);
                } else {
                    stmt.bindString(31, _tmp_19);
                }
                ChannelInfoEntity _tmpChannelInfo = value.getChannelInfo();
                if (_tmpChannelInfo != null) {
                    if (_tmpChannelInfo.getCid() == null) {
                        stmt.bindNull(32);
                    } else {
                        stmt.bindString(32, _tmpChannelInfo.getCid());
                    }
                    if (_tmpChannelInfo.getId() == null) {
                        stmt.bindNull(33);
                    } else {
                        stmt.bindString(33, _tmpChannelInfo.getId());
                    }
                    if (_tmpChannelInfo.getType() == null) {
                        stmt.bindNull(34);
                    } else {
                        stmt.bindString(34, _tmpChannelInfo.getType());
                    }
                    if (_tmpChannelInfo.getMemberCount() == null) {
                        stmt.bindNull(35);
                    } else {
                        stmt.bindLong(35, (long)_tmpChannelInfo.getMemberCount().intValue());
                    }
                    if (_tmpChannelInfo.getName() == null) {
                        stmt.bindNull(36);
                    } else {
                        stmt.bindString(36, _tmpChannelInfo.getName());
                    }
                } else {
                    stmt.bindNull(32);
                    stmt.bindNull(33);
                    stmt.bindNull(34);
                    stmt.bindNull(35);
                    stmt.bindNull(36);
                }
            }
        };
        this.__insertionAdapterOfAttachmentEntity = new EntityInsertionAdapter<AttachmentEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `attachment_inner_entity` (`id`,`messageId`,`authorName`,`titleLink`,`authorLink`,`thumbUrl`,`imageUrl`,`assetUrl`,`ogUrl`,`mimeType`,`fileSize`,`title`,`text`,`type`,`image`,`url`,`name`,`fallback`,`uploadFilePath`,`extraData`,`statusCode`,`errorMessage`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AttachmentEntity value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getMessageId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMessageId());
                }
                if (value.getAuthorName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAuthorName());
                }
                if (value.getTitleLink() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTitleLink());
                }
                if (value.getAuthorLink() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAuthorLink());
                }
                if (value.getThumbUrl() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getThumbUrl());
                }
                if (value.getImageUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getImageUrl());
                }
                if (value.getAssetUrl() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getAssetUrl());
                }
                if (value.getOgUrl() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getOgUrl());
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getMimeType());
                }
                stmt.bindLong(11, (long)value.getFileSize());
                if (value.getTitle() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getTitle());
                }
                if (value.getText() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getText());
                }
                if (value.getType() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getType());
                }
                if (value.getImage() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getImage());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getUrl());
                }
                if (value.getName() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getName());
                }
                if (value.getFallback() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getFallback());
                }
                if (value.getUploadFilePath() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getUploadFilePath());
                }
                String _tmp = MessageDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp);
                }
                UploadStateEntity _tmpUploadState = value.getUploadState();
                if (_tmpUploadState != null) {
                    stmt.bindLong(21, (long)_tmpUploadState.getStatusCode());
                    if (_tmpUploadState.getErrorMessage() == null) {
                        stmt.bindNull(22);
                    } else {
                        stmt.bindString(22, _tmpUploadState.getErrorMessage());
                    }
                } else {
                    stmt.bindNull(21);
                    stmt.bindNull(22);
                }
            }
        };
        this.__insertionAdapterOfReactionEntity = new EntityInsertionAdapter<ReactionEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_reaction` (`messageId`,`userId`,`type`,`score`,`createdAt`,`updatedAt`,`deletedAt`,`enforceUnique`,`extraData`,`syncStatus`,`id`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ReactionEntity value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getType());
                }
                stmt.bindLong(4, (long)value.getScore());
                Long _tmp = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, _tmp.longValue());
                }
                Long _tmp_1 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp_1.longValue());
                }
                Long _tmp_2 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, _tmp_2.longValue());
                }
                int _tmp_3 = value.getEnforceUnique() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                String _tmp_4 = MessageDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_4);
                }
                int _tmp_5 = MessageDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(10, (long)_tmp_5);
                stmt.bindLong(11, (long)value.getId());
            }
        };
        this.__updateAdapterOfMessageInnerEntity = new EntityDeletionOrUpdateAdapter<MessageInnerEntity>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `stream_chat_message` SET `id` = ?,`cid` = ?,`userId` = ?,`text` = ?,`html` = ?,`type` = ?,`syncStatus` = ?,`syncType` = ?,`syncContent` = ?,`replyCount` = ?,`createdAt` = ?,`createdLocallyAt` = ?,`updatedAt` = ?,`updatedLocallyAt` = ?,`deletedAt` = ?,`remoteMentionedUserIds` = ?,`mentionedUsersId` = ?,`reactionCounts` = ?,`reactionScores` = ?,`parentId` = ?,`command` = ?,`shadowed` = ?,`showInChannel` = ?,`silent` = ?,`extraData` = ?,`replyToId` = ?,`pinned` = ?,`pinnedAt` = ?,`pinExpires` = ?,`pinnedByUserId` = ?,`threadParticipantsIds` = ?,`channel_infocid` = ?,`channel_infoid` = ?,`channel_infotype` = ?,`channel_infomemberCount` = ?,`channel_infoname` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MessageInnerEntity value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getCid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getCid());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getText() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getText());
                }
                if (value.getHtml() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getHtml());
                }
                if (value.getType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getType());
                }
                int _tmp = MessageDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(7, (long)_tmp);
                Integer _tmp_1 = value.getSyncType() == null ? null : Integer.valueOf(MessageDao_Impl.this.__messageSyncTypeConverter.messageSyncTypeToString(value.getSyncType()));
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, (long)_tmp_1.intValue());
                }
                String _tmp_2 = MessageDao_Impl.this.__messageSyncDescriptionConverter.messageSyncDescriptionToString(value.getSyncContent());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_2);
                }
                stmt.bindLong(10, (long)value.getReplyCount());
                Long _tmp_3 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, _tmp_3.longValue());
                }
                Long _tmp_4 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedLocallyAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, _tmp_4.longValue());
                }
                Long _tmp_5 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, _tmp_5.longValue());
                }
                Long _tmp_6 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedLocallyAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, _tmp_6.longValue());
                }
                Long _tmp_7 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, _tmp_7.longValue());
                }
                String _tmp_8 = MessageDao_Impl.this.__listConverter.stringListToString(value.getRemoteMentionedUserIds());
                if (_tmp_8 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_8);
                }
                String _tmp_9 = MessageDao_Impl.this.__listConverter.stringListToString(value.getMentionedUsersId());
                if (_tmp_9 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_9);
                }
                String _tmp_10 = MessageDao_Impl.this.__mapConverter.mapToString(value.getReactionCounts());
                if (_tmp_10 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_10);
                }
                String _tmp_11 = MessageDao_Impl.this.__mapConverter.mapToString(value.getReactionScores());
                if (_tmp_11 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_11);
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getParentId());
                }
                if (value.getCommand() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.getCommand());
                }
                int _tmp_12 = value.getShadowed() ? 1 : 0;
                stmt.bindLong(22, (long)_tmp_12);
                int _tmp_13 = value.getShowInChannel() ? 1 : 0;
                stmt.bindLong(23, (long)_tmp_13);
                int _tmp_14 = value.getSilent() ? 1 : 0;
                stmt.bindLong(24, (long)_tmp_14);
                String _tmp_15 = MessageDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_15 == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, _tmp_15);
                }
                if (value.getReplyToId() == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindString(26, value.getReplyToId());
                }
                int _tmp_16 = value.getPinned() ? 1 : 0;
                stmt.bindLong(27, (long)_tmp_16);
                Long _tmp_17 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getPinnedAt());
                if (_tmp_17 == null) {
                    stmt.bindNull(28);
                } else {
                    stmt.bindLong(28, _tmp_17.longValue());
                }
                Long _tmp_18 = MessageDao_Impl.this.__dateConverter.dateToTimestamp(value.getPinExpires());
                if (_tmp_18 == null) {
                    stmt.bindNull(29);
                } else {
                    stmt.bindLong(29, _tmp_18.longValue());
                }
                if (value.getPinnedByUserId() == null) {
                    stmt.bindNull(30);
                } else {
                    stmt.bindString(30, value.getPinnedByUserId());
                }
                String _tmp_19 = MessageDao_Impl.this.__listConverter.stringListToString(value.getThreadParticipantsIds());
                if (_tmp_19 == null) {
                    stmt.bindNull(31);
                } else {
                    stmt.bindString(31, _tmp_19);
                }
                ChannelInfoEntity _tmpChannelInfo = value.getChannelInfo();
                if (_tmpChannelInfo != null) {
                    if (_tmpChannelInfo.getCid() == null) {
                        stmt.bindNull(32);
                    } else {
                        stmt.bindString(32, _tmpChannelInfo.getCid());
                    }
                    if (_tmpChannelInfo.getId() == null) {
                        stmt.bindNull(33);
                    } else {
                        stmt.bindString(33, _tmpChannelInfo.getId());
                    }
                    if (_tmpChannelInfo.getType() == null) {
                        stmt.bindNull(34);
                    } else {
                        stmt.bindString(34, _tmpChannelInfo.getType());
                    }
                    if (_tmpChannelInfo.getMemberCount() == null) {
                        stmt.bindNull(35);
                    } else {
                        stmt.bindLong(35, (long)_tmpChannelInfo.getMemberCount().intValue());
                    }
                    if (_tmpChannelInfo.getName() == null) {
                        stmt.bindNull(36);
                    } else {
                        stmt.bindString(36, _tmpChannelInfo.getName());
                    }
                } else {
                    stmt.bindNull(32);
                    stmt.bindNull(33);
                    stmt.bindNull(34);
                    stmt.bindNull(35);
                    stmt.bindNull(36);
                }
                if (value.getId() == null) {
                    stmt.bindNull(37);
                } else {
                    stmt.bindString(37, value.getId());
                }
            }
        };
        this.__preparedStmtOfDeleteChannelMessagesBefore = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_chat_message WHERE cid = ? AND createdAt < ?";
                return "DELETE from stream_chat_message WHERE cid = ? AND createdAt < ?";
            }
        };
        this.__preparedStmtOfDeleteMessage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_chat_message WHERE cid = ? AND id = ?";
                return "DELETE from stream_chat_message WHERE cid = ? AND id = ?";
            }
        };
    }

    @Override
    protected Object insertMessageInnerEntity(final MessageInnerEntity messageInnerEntity, Continuation<? super Long> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    long _result = MessageDao_Impl.this.__insertionAdapterOfMessageInnerEntity.insertAndReturnId((Object)messageInnerEntity);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result;
                    return l;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    protected Object insertMessageInnerEntities(final List<MessageInnerEntity> messageInnerEntities, Continuation<? super List<Long>> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<Long>>(){

            @Override
            public List<Long> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    List _result = MessageDao_Impl.this.__insertionAdapterOfMessageInnerEntity.insertAndReturnIdsList((Collection)messageInnerEntities);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    List list = _result;
                    return list;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    protected Object insertAttachments(final List<AttachmentEntity> attachmentEntities, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageDao_Impl.this.__insertionAdapterOfAttachmentEntity.insert((Iterable)attachmentEntities);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    protected Object insertReactions(final List<ReactionEntity> reactions, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageDao_Impl.this.__insertionAdapterOfReactionEntity.insert((Iterable)reactions);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    protected void updateMessageInnerEntity(MessageInnerEntity messageInnerEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMessageInnerEntity.handle((Object)messageInnerEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insert(final List<MessageEntity> messageEntities, Continuation<? super Unit> continuation) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return MessageDao_Impl.access$1101(MessageDao_Impl.this, messageEntities, __cont);
            }
        }, continuation);
    }

    @Override
    public Object insert(final MessageEntity messageEntity, Continuation<? super Unit> continuation) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return MessageDao_Impl.access$1201(MessageDao_Impl.this, messageEntity, __cont);
            }
        }, continuation);
    }

    @Override
    public void deleteAttachments(List<String> messageIds) {
        this.__db.beginTransaction();
        try {
            MessageDao_Impl.super.deleteAttachments(messageIds);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object upsertMessageInnerEntity(final MessageInnerEntity messageInnerEntity, Continuation<? super Unit> continuation) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return MessageDao_Impl.access$1401(MessageDao_Impl.this, messageInnerEntity, __cont);
            }
        }, continuation);
    }

    @Override
    public Object upsertMessageInnerEntities(final List<MessageInnerEntity> messageInnerEntities, Continuation<? super Unit> continuation) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return MessageDao_Impl.access$1501(MessageDao_Impl.this, messageInnerEntities, __cont);
            }
        }, continuation);
    }

    @Override
    public Object select(final List<String> ids, Continuation<? super List<MessageEntity>> continuation) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super List<MessageEntity>>, Object>(){

            public Object invoke(Continuation<? super List<MessageEntity>> __cont) {
                return MessageDao_Impl.access$1601(MessageDao_Impl.this, ids, __cont);
            }
        }, continuation);
    }

    @Override
    public Object selectWaitForAttachments(Continuation<? super List<MessageEntity>> continuation) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super List<MessageEntity>>, Object>(){

            public Object invoke(Continuation<? super List<MessageEntity>> __cont) {
                return MessageDao_Impl.access$1701(MessageDao_Impl.this, __cont);
            }
        }, continuation);
    }

    @Override
    public Object deleteChannelMessagesBefore(final String cid, final Date deleteMessagesBefore, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = MessageDao_Impl.this.__preparedStmtOfDeleteChannelMessagesBefore.acquire();
                int _argIndex = 1;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                _argIndex = 2;
                Long _tmp = MessageDao_Impl.this.__dateConverter.dateToTimestamp(deleteMessagesBefore);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, _tmp.longValue());
                }
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                    MessageDao_Impl.this.__preparedStmtOfDeleteChannelMessagesBefore.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object deleteMessage(final String cid, final String messageId, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = MessageDao_Impl.this.__preparedStmtOfDeleteMessage.acquire();
                int _argIndex = 1;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                _argIndex = 2;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, messageId);
                }
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                    MessageDao_Impl.this.__preparedStmtOfDeleteMessage.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object messagesForChannelNewerThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> continuation) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND (createdAt > ? || createdLocallyAt > ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND (createdAt > ? || createdLocallyAt > ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?", (int)4);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        Long _tmp_1 = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp_1.longValue());
        }
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"html");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfSyncType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncType");
                        int _cursorIndexOfSyncContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncContent");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteMentionedUserIds");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"showInChannel");
                        int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"silent");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                        int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedAt");
                        int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinExpires");
                        int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedByUserId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infocid");
                        int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoid");
                        int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infotype");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infomemberCount");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoname");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfHtml) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfSyncType) && _cursor.isNull(_cursorIndexOfSyncContent) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfShowInChannel) && _cursor.isNull(_cursorIndexOfSilent) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfPinned) && _cursor.isNull(_cursorIndexOfPinnedAt) && _cursor.isNull(_cursorIndexOfPinExpires) && _cursor.isNull(_cursorIndexOfPinnedByUserId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                ChannelInfoEntity _tmpChannelInfo;
                                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.isNull(_cursorIndexOfText) ? null : _cursor.getString(_cursorIndexOfText);
                                String _tmpHtml = _cursor.isNull(_cursorIndexOfHtml) ? null : _cursor.getString(_cursorIndexOfHtml);
                                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                                int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfSyncType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSyncType));
                                MessageSyncType _tmpSyncType = _tmp_3 == null ? null : MessageDao_Impl.this.__messageSyncTypeConverter.stringToMessageSyncType(_tmp_3);
                                String _tmp_4 = _cursor.isNull(_cursorIndexOfSyncContent) ? null : _cursor.getString(_cursorIndexOfSyncContent);
                                MessageSyncContentEntity _tmpSyncContent = MessageDao_Impl.this.__messageSyncDescriptionConverter.stringToSyncDescription(_tmp_4);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                Long _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                                Long _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                                Long _tmp_9 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_9);
                                String _tmp_10 = _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) ? null : _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
                                List<String> _tmp_11 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                                if (_tmp_11 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpRemoteMentionedUserIds = _tmp_11;
                                String _tmp_12 = _cursor.isNull(_cursorIndexOfMentionedUsersId) ? null : _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmp_13 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_12);
                                if (_tmp_13 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpMentionedUsersId = _tmp_13;
                                String _tmp_14 = _cursor.isNull(_cursorIndexOfReactionCounts) ? null : _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmp_15 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_14);
                                if (_tmp_15 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionCounts = _tmp_15;
                                String _tmp_16 = _cursor.isNull(_cursorIndexOfReactionScores) ? null : _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmp_17 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_16);
                                if (_tmp_17 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionScores = _tmp_17;
                                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.isNull(_cursorIndexOfCommand) ? null : _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_18 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_18 != 0;
                                int _tmp_19 = _cursor.getInt(_cursorIndexOfShowInChannel);
                                boolean _tmpShowInChannel = _tmp_19 != 0;
                                int _tmp_20 = _cursor.getInt(_cursorIndexOfSilent);
                                boolean _tmpSilent = _tmp_20 != 0;
                                String _tmp_21 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmp_22 = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_21);
                                if (_tmp_22 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                                }
                                Map<String, Object> _tmpExtraData = _tmp_22;
                                String _tmpReplyToId = _cursor.isNull(_cursorIndexOfReplyToId) ? null : _cursor.getString(_cursorIndexOfReplyToId);
                                int _tmp_23 = _cursor.getInt(_cursorIndexOfPinned);
                                boolean _tmpPinned = _tmp_23 != 0;
                                Long _tmp_24 = _cursor.isNull(_cursorIndexOfPinnedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinnedAt));
                                Date _tmpPinnedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_24);
                                Long _tmp_25 = _cursor.isNull(_cursorIndexOfPinExpires) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinExpires));
                                Date _tmpPinExpires = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_25);
                                String _tmpPinnedByUserId = _cursor.isNull(_cursorIndexOfPinnedByUserId) ? null : _cursor.getString(_cursorIndexOfPinnedByUserId);
                                String _tmp_26 = _cursor.isNull(_cursorIndexOfThreadParticipantsIds) ? null : _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmp_27 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_26);
                                if (_tmp_27 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpThreadParticipantsIds = _tmp_27;
                                if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                    String _tmpCid_1 = _cursor.isNull(_cursorIndexOfCid_1) ? null : _cursor.getString(_cursorIndexOfCid_1);
                                    String _tmpId_1 = _cursor.isNull(_cursorIndexOfId_1) ? null : _cursor.getString(_cursorIndexOfId_1);
                                    String _tmpType_1 = _cursor.isNull(_cursorIndexOfType_1) ? null : _cursor.getString(_cursorIndexOfType_1);
                                    Integer _tmpMemberCount = _cursor.isNull(_cursorIndexOfMemberCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMemberCount));
                                    String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                    _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1, _tmpId_1, _tmpType_1, _tmpMemberCount, _tmpName);
                                } else {
                                    _tmpChannelInfo = null;
                                }
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpHtml, _tmpType, _tmpSyncStatus, _tmpSyncType, _tmpSyncContent, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpRemoteMentionedUserIds, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpShowInChannel, _tmpChannelInfo, _tmpSilent, _tmpExtraData, _tmpReplyToId, _tmpPinned, _tmpPinnedAt, _tmpPinExpires, _tmpPinnedByUserId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object messagesForChannelEqualOrNewerThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> continuation) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND (createdAt >= ? || createdLocallyAt >= ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND (createdAt >= ? || createdLocallyAt >= ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?", (int)4);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        Long _tmp_1 = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp_1.longValue());
        }
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"html");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfSyncType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncType");
                        int _cursorIndexOfSyncContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncContent");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteMentionedUserIds");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"showInChannel");
                        int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"silent");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                        int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedAt");
                        int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinExpires");
                        int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedByUserId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infocid");
                        int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoid");
                        int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infotype");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infomemberCount");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoname");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfHtml) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfSyncType) && _cursor.isNull(_cursorIndexOfSyncContent) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfShowInChannel) && _cursor.isNull(_cursorIndexOfSilent) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfPinned) && _cursor.isNull(_cursorIndexOfPinnedAt) && _cursor.isNull(_cursorIndexOfPinExpires) && _cursor.isNull(_cursorIndexOfPinnedByUserId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                ChannelInfoEntity _tmpChannelInfo;
                                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.isNull(_cursorIndexOfText) ? null : _cursor.getString(_cursorIndexOfText);
                                String _tmpHtml = _cursor.isNull(_cursorIndexOfHtml) ? null : _cursor.getString(_cursorIndexOfHtml);
                                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                                int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfSyncType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSyncType));
                                MessageSyncType _tmpSyncType = _tmp_3 == null ? null : MessageDao_Impl.this.__messageSyncTypeConverter.stringToMessageSyncType(_tmp_3);
                                String _tmp_4 = _cursor.isNull(_cursorIndexOfSyncContent) ? null : _cursor.getString(_cursorIndexOfSyncContent);
                                MessageSyncContentEntity _tmpSyncContent = MessageDao_Impl.this.__messageSyncDescriptionConverter.stringToSyncDescription(_tmp_4);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                Long _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                                Long _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                                Long _tmp_9 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_9);
                                String _tmp_10 = _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) ? null : _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
                                List<String> _tmp_11 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                                if (_tmp_11 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpRemoteMentionedUserIds = _tmp_11;
                                String _tmp_12 = _cursor.isNull(_cursorIndexOfMentionedUsersId) ? null : _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmp_13 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_12);
                                if (_tmp_13 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpMentionedUsersId = _tmp_13;
                                String _tmp_14 = _cursor.isNull(_cursorIndexOfReactionCounts) ? null : _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmp_15 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_14);
                                if (_tmp_15 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionCounts = _tmp_15;
                                String _tmp_16 = _cursor.isNull(_cursorIndexOfReactionScores) ? null : _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmp_17 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_16);
                                if (_tmp_17 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionScores = _tmp_17;
                                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.isNull(_cursorIndexOfCommand) ? null : _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_18 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_18 != 0;
                                int _tmp_19 = _cursor.getInt(_cursorIndexOfShowInChannel);
                                boolean _tmpShowInChannel = _tmp_19 != 0;
                                int _tmp_20 = _cursor.getInt(_cursorIndexOfSilent);
                                boolean _tmpSilent = _tmp_20 != 0;
                                String _tmp_21 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmp_22 = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_21);
                                if (_tmp_22 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                                }
                                Map<String, Object> _tmpExtraData = _tmp_22;
                                String _tmpReplyToId = _cursor.isNull(_cursorIndexOfReplyToId) ? null : _cursor.getString(_cursorIndexOfReplyToId);
                                int _tmp_23 = _cursor.getInt(_cursorIndexOfPinned);
                                boolean _tmpPinned = _tmp_23 != 0;
                                Long _tmp_24 = _cursor.isNull(_cursorIndexOfPinnedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinnedAt));
                                Date _tmpPinnedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_24);
                                Long _tmp_25 = _cursor.isNull(_cursorIndexOfPinExpires) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinExpires));
                                Date _tmpPinExpires = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_25);
                                String _tmpPinnedByUserId = _cursor.isNull(_cursorIndexOfPinnedByUserId) ? null : _cursor.getString(_cursorIndexOfPinnedByUserId);
                                String _tmp_26 = _cursor.isNull(_cursorIndexOfThreadParticipantsIds) ? null : _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmp_27 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_26);
                                if (_tmp_27 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpThreadParticipantsIds = _tmp_27;
                                if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                    String _tmpCid_1 = _cursor.isNull(_cursorIndexOfCid_1) ? null : _cursor.getString(_cursorIndexOfCid_1);
                                    String _tmpId_1 = _cursor.isNull(_cursorIndexOfId_1) ? null : _cursor.getString(_cursorIndexOfId_1);
                                    String _tmpType_1 = _cursor.isNull(_cursorIndexOfType_1) ? null : _cursor.getString(_cursorIndexOfType_1);
                                    Integer _tmpMemberCount = _cursor.isNull(_cursorIndexOfMemberCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMemberCount));
                                    String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                    _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1, _tmpId_1, _tmpType_1, _tmpMemberCount, _tmpName);
                                } else {
                                    _tmpChannelInfo = null;
                                }
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpHtml, _tmpType, _tmpSyncStatus, _tmpSyncType, _tmpSyncContent, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpRemoteMentionedUserIds, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpShowInChannel, _tmpChannelInfo, _tmpSilent, _tmpExtraData, _tmpReplyToId, _tmpPinned, _tmpPinnedAt, _tmpPinExpires, _tmpPinnedByUserId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object messagesForChannelOlderThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> continuation) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND (createdAt < ? || createdLocallyAt < ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND (createdAt < ? || createdLocallyAt < ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?", (int)4);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        Long _tmp_1 = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp_1.longValue());
        }
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"html");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfSyncType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncType");
                        int _cursorIndexOfSyncContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncContent");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteMentionedUserIds");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"showInChannel");
                        int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"silent");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                        int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedAt");
                        int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinExpires");
                        int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedByUserId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infocid");
                        int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoid");
                        int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infotype");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infomemberCount");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoname");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfHtml) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfSyncType) && _cursor.isNull(_cursorIndexOfSyncContent) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfShowInChannel) && _cursor.isNull(_cursorIndexOfSilent) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfPinned) && _cursor.isNull(_cursorIndexOfPinnedAt) && _cursor.isNull(_cursorIndexOfPinExpires) && _cursor.isNull(_cursorIndexOfPinnedByUserId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                ChannelInfoEntity _tmpChannelInfo;
                                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.isNull(_cursorIndexOfText) ? null : _cursor.getString(_cursorIndexOfText);
                                String _tmpHtml = _cursor.isNull(_cursorIndexOfHtml) ? null : _cursor.getString(_cursorIndexOfHtml);
                                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                                int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfSyncType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSyncType));
                                MessageSyncType _tmpSyncType = _tmp_3 == null ? null : MessageDao_Impl.this.__messageSyncTypeConverter.stringToMessageSyncType(_tmp_3);
                                String _tmp_4 = _cursor.isNull(_cursorIndexOfSyncContent) ? null : _cursor.getString(_cursorIndexOfSyncContent);
                                MessageSyncContentEntity _tmpSyncContent = MessageDao_Impl.this.__messageSyncDescriptionConverter.stringToSyncDescription(_tmp_4);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                Long _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                                Long _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                                Long _tmp_9 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_9);
                                String _tmp_10 = _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) ? null : _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
                                List<String> _tmp_11 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                                if (_tmp_11 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpRemoteMentionedUserIds = _tmp_11;
                                String _tmp_12 = _cursor.isNull(_cursorIndexOfMentionedUsersId) ? null : _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmp_13 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_12);
                                if (_tmp_13 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpMentionedUsersId = _tmp_13;
                                String _tmp_14 = _cursor.isNull(_cursorIndexOfReactionCounts) ? null : _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmp_15 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_14);
                                if (_tmp_15 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionCounts = _tmp_15;
                                String _tmp_16 = _cursor.isNull(_cursorIndexOfReactionScores) ? null : _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmp_17 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_16);
                                if (_tmp_17 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionScores = _tmp_17;
                                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.isNull(_cursorIndexOfCommand) ? null : _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_18 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_18 != 0;
                                int _tmp_19 = _cursor.getInt(_cursorIndexOfShowInChannel);
                                boolean _tmpShowInChannel = _tmp_19 != 0;
                                int _tmp_20 = _cursor.getInt(_cursorIndexOfSilent);
                                boolean _tmpSilent = _tmp_20 != 0;
                                String _tmp_21 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmp_22 = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_21);
                                if (_tmp_22 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                                }
                                Map<String, Object> _tmpExtraData = _tmp_22;
                                String _tmpReplyToId = _cursor.isNull(_cursorIndexOfReplyToId) ? null : _cursor.getString(_cursorIndexOfReplyToId);
                                int _tmp_23 = _cursor.getInt(_cursorIndexOfPinned);
                                boolean _tmpPinned = _tmp_23 != 0;
                                Long _tmp_24 = _cursor.isNull(_cursorIndexOfPinnedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinnedAt));
                                Date _tmpPinnedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_24);
                                Long _tmp_25 = _cursor.isNull(_cursorIndexOfPinExpires) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinExpires));
                                Date _tmpPinExpires = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_25);
                                String _tmpPinnedByUserId = _cursor.isNull(_cursorIndexOfPinnedByUserId) ? null : _cursor.getString(_cursorIndexOfPinnedByUserId);
                                String _tmp_26 = _cursor.isNull(_cursorIndexOfThreadParticipantsIds) ? null : _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmp_27 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_26);
                                if (_tmp_27 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpThreadParticipantsIds = _tmp_27;
                                if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                    String _tmpCid_1 = _cursor.isNull(_cursorIndexOfCid_1) ? null : _cursor.getString(_cursorIndexOfCid_1);
                                    String _tmpId_1 = _cursor.isNull(_cursorIndexOfId_1) ? null : _cursor.getString(_cursorIndexOfId_1);
                                    String _tmpType_1 = _cursor.isNull(_cursorIndexOfType_1) ? null : _cursor.getString(_cursorIndexOfType_1);
                                    Integer _tmpMemberCount = _cursor.isNull(_cursorIndexOfMemberCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMemberCount));
                                    String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                    _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1, _tmpId_1, _tmpType_1, _tmpMemberCount, _tmpName);
                                } else {
                                    _tmpChannelInfo = null;
                                }
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpHtml, _tmpType, _tmpSyncStatus, _tmpSyncType, _tmpSyncContent, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpRemoteMentionedUserIds, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpShowInChannel, _tmpChannelInfo, _tmpSilent, _tmpExtraData, _tmpReplyToId, _tmpPinned, _tmpPinnedAt, _tmpPinExpires, _tmpPinnedByUserId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object messagesForChannelEqualOrOlderThan(String cid, int limit, Date dateFilter, Continuation<? super List<MessageEntity>> continuation) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? AND (createdAt <= ? || createdLocallyAt <= ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? AND (createdAt <= ? || createdLocallyAt <= ?) ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?", (int)4);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        Long _tmp = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        Long _tmp_1 = this.__dateConverter.dateToTimestamp(dateFilter);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp_1.longValue());
        }
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"html");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfSyncType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncType");
                        int _cursorIndexOfSyncContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncContent");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteMentionedUserIds");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"showInChannel");
                        int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"silent");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                        int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedAt");
                        int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinExpires");
                        int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedByUserId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infocid");
                        int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoid");
                        int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infotype");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infomemberCount");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoname");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfHtml) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfSyncType) && _cursor.isNull(_cursorIndexOfSyncContent) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfShowInChannel) && _cursor.isNull(_cursorIndexOfSilent) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfPinned) && _cursor.isNull(_cursorIndexOfPinnedAt) && _cursor.isNull(_cursorIndexOfPinExpires) && _cursor.isNull(_cursorIndexOfPinnedByUserId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                ChannelInfoEntity _tmpChannelInfo;
                                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.isNull(_cursorIndexOfText) ? null : _cursor.getString(_cursorIndexOfText);
                                String _tmpHtml = _cursor.isNull(_cursorIndexOfHtml) ? null : _cursor.getString(_cursorIndexOfHtml);
                                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                                int _tmp_2 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_2);
                                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfSyncType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSyncType));
                                MessageSyncType _tmpSyncType = _tmp_3 == null ? null : MessageDao_Impl.this.__messageSyncTypeConverter.stringToMessageSyncType(_tmp_3);
                                String _tmp_4 = _cursor.isNull(_cursorIndexOfSyncContent) ? null : _cursor.getString(_cursorIndexOfSyncContent);
                                MessageSyncContentEntity _tmpSyncContent = MessageDao_Impl.this.__messageSyncDescriptionConverter.stringToSyncDescription(_tmp_4);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                Long _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                                Long _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                                Long _tmp_9 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_9);
                                String _tmp_10 = _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) ? null : _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
                                List<String> _tmp_11 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                                if (_tmp_11 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpRemoteMentionedUserIds = _tmp_11;
                                String _tmp_12 = _cursor.isNull(_cursorIndexOfMentionedUsersId) ? null : _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmp_13 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_12);
                                if (_tmp_13 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpMentionedUsersId = _tmp_13;
                                String _tmp_14 = _cursor.isNull(_cursorIndexOfReactionCounts) ? null : _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmp_15 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_14);
                                if (_tmp_15 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionCounts = _tmp_15;
                                String _tmp_16 = _cursor.isNull(_cursorIndexOfReactionScores) ? null : _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmp_17 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_16);
                                if (_tmp_17 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionScores = _tmp_17;
                                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.isNull(_cursorIndexOfCommand) ? null : _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_18 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_18 != 0;
                                int _tmp_19 = _cursor.getInt(_cursorIndexOfShowInChannel);
                                boolean _tmpShowInChannel = _tmp_19 != 0;
                                int _tmp_20 = _cursor.getInt(_cursorIndexOfSilent);
                                boolean _tmpSilent = _tmp_20 != 0;
                                String _tmp_21 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmp_22 = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_21);
                                if (_tmp_22 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                                }
                                Map<String, Object> _tmpExtraData = _tmp_22;
                                String _tmpReplyToId = _cursor.isNull(_cursorIndexOfReplyToId) ? null : _cursor.getString(_cursorIndexOfReplyToId);
                                int _tmp_23 = _cursor.getInt(_cursorIndexOfPinned);
                                boolean _tmpPinned = _tmp_23 != 0;
                                Long _tmp_24 = _cursor.isNull(_cursorIndexOfPinnedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinnedAt));
                                Date _tmpPinnedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_24);
                                Long _tmp_25 = _cursor.isNull(_cursorIndexOfPinExpires) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinExpires));
                                Date _tmpPinExpires = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_25);
                                String _tmpPinnedByUserId = _cursor.isNull(_cursorIndexOfPinnedByUserId) ? null : _cursor.getString(_cursorIndexOfPinnedByUserId);
                                String _tmp_26 = _cursor.isNull(_cursorIndexOfThreadParticipantsIds) ? null : _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmp_27 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_26);
                                if (_tmp_27 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpThreadParticipantsIds = _tmp_27;
                                if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                    String _tmpCid_1 = _cursor.isNull(_cursorIndexOfCid_1) ? null : _cursor.getString(_cursorIndexOfCid_1);
                                    String _tmpId_1 = _cursor.isNull(_cursorIndexOfId_1) ? null : _cursor.getString(_cursorIndexOfId_1);
                                    String _tmpType_1 = _cursor.isNull(_cursorIndexOfType_1) ? null : _cursor.getString(_cursorIndexOfType_1);
                                    Integer _tmpMemberCount = _cursor.isNull(_cursorIndexOfMemberCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMemberCount));
                                    String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                    _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1, _tmpId_1, _tmpType_1, _tmpMemberCount, _tmpName);
                                } else {
                                    _tmpChannelInfo = null;
                                }
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpHtml, _tmpType, _tmpSyncStatus, _tmpSyncType, _tmpSyncContent, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpRemoteMentionedUserIds, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpShowInChannel, _tmpChannelInfo, _tmpSilent, _tmpExtraData, _tmpReplyToId, _tmpPinned, _tmpPinnedAt, _tmpPinExpires, _tmpPinnedByUserId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object messagesForChannel(String cid, int limit, Continuation<? super List<MessageEntity>> continuation) {
        String _sql = "SELECT * from stream_chat_message WHERE cid = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream_chat_message WHERE cid = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END DESC LIMIT ?", (int)2);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"html");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfSyncType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncType");
                        int _cursorIndexOfSyncContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncContent");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteMentionedUserIds");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"showInChannel");
                        int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"silent");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                        int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedAt");
                        int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinExpires");
                        int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedByUserId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infocid");
                        int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoid");
                        int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infotype");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infomemberCount");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoname");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfHtml) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfSyncType) && _cursor.isNull(_cursorIndexOfSyncContent) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfShowInChannel) && _cursor.isNull(_cursorIndexOfSilent) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfPinned) && _cursor.isNull(_cursorIndexOfPinnedAt) && _cursor.isNull(_cursorIndexOfPinExpires) && _cursor.isNull(_cursorIndexOfPinnedByUserId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                ChannelInfoEntity _tmpChannelInfo;
                                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.isNull(_cursorIndexOfText) ? null : _cursor.getString(_cursorIndexOfText);
                                String _tmpHtml = _cursor.isNull(_cursorIndexOfHtml) ? null : _cursor.getString(_cursorIndexOfHtml);
                                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                                int _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp);
                                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfSyncType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSyncType));
                                MessageSyncType _tmpSyncType = _tmp_1 == null ? null : MessageDao_Impl.this.__messageSyncTypeConverter.stringToMessageSyncType(_tmp_1);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfSyncContent) ? null : _cursor.getString(_cursorIndexOfSyncContent);
                                MessageSyncContentEntity _tmpSyncContent = MessageDao_Impl.this.__messageSyncDescriptionConverter.stringToSyncDescription(_tmp_2);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                Long _tmp_7 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                                String _tmp_8 = _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) ? null : _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
                                List<String> _tmp_9 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_8);
                                if (_tmp_9 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpRemoteMentionedUserIds = _tmp_9;
                                String _tmp_10 = _cursor.isNull(_cursorIndexOfMentionedUsersId) ? null : _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmp_11 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                                if (_tmp_11 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpMentionedUsersId = _tmp_11;
                                String _tmp_12 = _cursor.isNull(_cursorIndexOfReactionCounts) ? null : _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmp_13 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_12);
                                if (_tmp_13 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionCounts = _tmp_13;
                                String _tmp_14 = _cursor.isNull(_cursorIndexOfReactionScores) ? null : _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmp_15 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_14);
                                if (_tmp_15 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionScores = _tmp_15;
                                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.isNull(_cursorIndexOfCommand) ? null : _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_16 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_16 != 0;
                                int _tmp_17 = _cursor.getInt(_cursorIndexOfShowInChannel);
                                boolean _tmpShowInChannel = _tmp_17 != 0;
                                int _tmp_18 = _cursor.getInt(_cursorIndexOfSilent);
                                boolean _tmpSilent = _tmp_18 != 0;
                                String _tmp_19 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmp_20 = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_19);
                                if (_tmp_20 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                                }
                                Map<String, Object> _tmpExtraData = _tmp_20;
                                String _tmpReplyToId = _cursor.isNull(_cursorIndexOfReplyToId) ? null : _cursor.getString(_cursorIndexOfReplyToId);
                                int _tmp_21 = _cursor.getInt(_cursorIndexOfPinned);
                                boolean _tmpPinned = _tmp_21 != 0;
                                Long _tmp_22 = _cursor.isNull(_cursorIndexOfPinnedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinnedAt));
                                Date _tmpPinnedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_22);
                                Long _tmp_23 = _cursor.isNull(_cursorIndexOfPinExpires) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinExpires));
                                Date _tmpPinExpires = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_23);
                                String _tmpPinnedByUserId = _cursor.isNull(_cursorIndexOfPinnedByUserId) ? null : _cursor.getString(_cursorIndexOfPinnedByUserId);
                                String _tmp_24 = _cursor.isNull(_cursorIndexOfThreadParticipantsIds) ? null : _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmp_25 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_24);
                                if (_tmp_25 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpThreadParticipantsIds = _tmp_25;
                                if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                    String _tmpCid_1 = _cursor.isNull(_cursorIndexOfCid_1) ? null : _cursor.getString(_cursorIndexOfCid_1);
                                    String _tmpId_1 = _cursor.isNull(_cursorIndexOfId_1) ? null : _cursor.getString(_cursorIndexOfId_1);
                                    String _tmpType_1 = _cursor.isNull(_cursorIndexOfType_1) ? null : _cursor.getString(_cursorIndexOfType_1);
                                    Integer _tmpMemberCount = _cursor.isNull(_cursorIndexOfMemberCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMemberCount));
                                    String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                    _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1, _tmpId_1, _tmpType_1, _tmpMemberCount, _tmpName);
                                } else {
                                    _tmpChannelInfo = null;
                                }
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpHtml, _tmpType, _tmpSyncStatus, _tmpSyncType, _tmpSyncContent, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpRemoteMentionedUserIds, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpShowInChannel, _tmpChannelInfo, _tmpSilent, _tmpExtraData, _tmpReplyToId, _tmpPinned, _tmpPinnedAt, _tmpPinExpires, _tmpPinnedByUserId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object select(String id, Continuation<? super MessageEntity> continuation) {
        String _sql = "SELECT * FROM stream_chat_message WHERE id IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_message WHERE id IN (?)", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<MessageEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MessageEntity call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageEntity messageEntity;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        MessageEntity _result;
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"html");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfSyncType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncType");
                        int _cursorIndexOfSyncContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncContent");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteMentionedUserIds");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"showInChannel");
                        int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"silent");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                        int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedAt");
                        int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinExpires");
                        int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedByUserId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infocid");
                        int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoid");
                        int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infotype");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infomemberCount");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoname");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        if (_cursor.moveToFirst()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfHtml) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfSyncType) && _cursor.isNull(_cursorIndexOfSyncContent) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfShowInChannel) && _cursor.isNull(_cursorIndexOfSilent) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfPinned) && _cursor.isNull(_cursorIndexOfPinnedAt) && _cursor.isNull(_cursorIndexOfPinExpires) && _cursor.isNull(_cursorIndexOfPinnedByUserId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                ChannelInfoEntity _tmpChannelInfo;
                                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.isNull(_cursorIndexOfText) ? null : _cursor.getString(_cursorIndexOfText);
                                String _tmpHtml = _cursor.isNull(_cursorIndexOfHtml) ? null : _cursor.getString(_cursorIndexOfHtml);
                                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                                int _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp);
                                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfSyncType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSyncType));
                                MessageSyncType _tmpSyncType = _tmp_1 == null ? null : MessageDao_Impl.this.__messageSyncTypeConverter.stringToMessageSyncType(_tmp_1);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfSyncContent) ? null : _cursor.getString(_cursorIndexOfSyncContent);
                                MessageSyncContentEntity _tmpSyncContent = MessageDao_Impl.this.__messageSyncDescriptionConverter.stringToSyncDescription(_tmp_2);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                Long _tmp_7 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                                String _tmp_8 = _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) ? null : _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
                                List<String> _tmp_9 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_8);
                                if (_tmp_9 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpRemoteMentionedUserIds = _tmp_9;
                                String _tmp_10 = _cursor.isNull(_cursorIndexOfMentionedUsersId) ? null : _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmp_11 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                                if (_tmp_11 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpMentionedUsersId = _tmp_11;
                                String _tmp_12 = _cursor.isNull(_cursorIndexOfReactionCounts) ? null : _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmp_13 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_12);
                                if (_tmp_13 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionCounts = _tmp_13;
                                String _tmp_14 = _cursor.isNull(_cursorIndexOfReactionScores) ? null : _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmp_15 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_14);
                                if (_tmp_15 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionScores = _tmp_15;
                                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.isNull(_cursorIndexOfCommand) ? null : _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_16 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_16 != 0;
                                int _tmp_17 = _cursor.getInt(_cursorIndexOfShowInChannel);
                                boolean _tmpShowInChannel = _tmp_17 != 0;
                                int _tmp_18 = _cursor.getInt(_cursorIndexOfSilent);
                                boolean _tmpSilent = _tmp_18 != 0;
                                String _tmp_19 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmp_20 = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_19);
                                if (_tmp_20 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                                }
                                Map<String, Object> _tmpExtraData = _tmp_20;
                                String _tmpReplyToId = _cursor.isNull(_cursorIndexOfReplyToId) ? null : _cursor.getString(_cursorIndexOfReplyToId);
                                int _tmp_21 = _cursor.getInt(_cursorIndexOfPinned);
                                boolean _tmpPinned = _tmp_21 != 0;
                                Long _tmp_22 = _cursor.isNull(_cursorIndexOfPinnedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinnedAt));
                                Date _tmpPinnedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_22);
                                Long _tmp_23 = _cursor.isNull(_cursorIndexOfPinExpires) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinExpires));
                                Date _tmpPinExpires = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_23);
                                String _tmpPinnedByUserId = _cursor.isNull(_cursorIndexOfPinnedByUserId) ? null : _cursor.getString(_cursorIndexOfPinnedByUserId);
                                String _tmp_24 = _cursor.isNull(_cursorIndexOfThreadParticipantsIds) ? null : _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmp_25 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_24);
                                if (_tmp_25 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpThreadParticipantsIds = _tmp_25;
                                if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                    String _tmpCid_1 = _cursor.isNull(_cursorIndexOfCid_1) ? null : _cursor.getString(_cursorIndexOfCid_1);
                                    String _tmpId_1 = _cursor.isNull(_cursorIndexOfId_1) ? null : _cursor.getString(_cursorIndexOfId_1);
                                    String _tmpType_1 = _cursor.isNull(_cursorIndexOfType_1) ? null : _cursor.getString(_cursorIndexOfType_1);
                                    Integer _tmpMemberCount = _cursor.isNull(_cursorIndexOfMemberCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMemberCount));
                                    String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                    _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1, _tmpId_1, _tmpType_1, _tmpMemberCount, _tmpName);
                                } else {
                                    _tmpChannelInfo = null;
                                }
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpHtml, _tmpType, _tmpSyncStatus, _tmpSyncType, _tmpSyncContent, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpRemoteMentionedUserIds, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpShowInChannel, _tmpChannelInfo, _tmpSilent, _tmpExtraData, _tmpReplyToId, _tmpPinned, _tmpPinnedAt, _tmpPinExpires, _tmpPinnedByUserId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            _result = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                        } else {
                            _result = null;
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        messageEntity = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return messageEntity;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    protected Object selectChunked(List<String> ids, Continuation<? super List<MessageEntity>> continuation) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM stream_chat_message WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"html");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfSyncType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncType");
                        int _cursorIndexOfSyncContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncContent");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteMentionedUserIds");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"showInChannel");
                        int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"silent");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                        int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedAt");
                        int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinExpires");
                        int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedByUserId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infocid");
                        int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoid");
                        int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infotype");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infomemberCount");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoname");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfHtml) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfSyncType) && _cursor.isNull(_cursorIndexOfSyncContent) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfShowInChannel) && _cursor.isNull(_cursorIndexOfSilent) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfPinned) && _cursor.isNull(_cursorIndexOfPinnedAt) && _cursor.isNull(_cursorIndexOfPinExpires) && _cursor.isNull(_cursorIndexOfPinnedByUserId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                ChannelInfoEntity _tmpChannelInfo;
                                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.isNull(_cursorIndexOfText) ? null : _cursor.getString(_cursorIndexOfText);
                                String _tmpHtml = _cursor.isNull(_cursorIndexOfHtml) ? null : _cursor.getString(_cursorIndexOfHtml);
                                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                                int _tmp = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp);
                                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfSyncType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSyncType));
                                MessageSyncType _tmpSyncType = _tmp_1 == null ? null : MessageDao_Impl.this.__messageSyncTypeConverter.stringToMessageSyncType(_tmp_1);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfSyncContent) ? null : _cursor.getString(_cursorIndexOfSyncContent);
                                MessageSyncContentEntity _tmpSyncContent = MessageDao_Impl.this.__messageSyncDescriptionConverter.stringToSyncDescription(_tmp_2);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                Long _tmp_7 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                                String _tmp_8 = _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) ? null : _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
                                List<String> _tmp_9 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_8);
                                if (_tmp_9 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpRemoteMentionedUserIds = _tmp_9;
                                String _tmp_10 = _cursor.isNull(_cursorIndexOfMentionedUsersId) ? null : _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmp_11 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_10);
                                if (_tmp_11 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpMentionedUsersId = _tmp_11;
                                String _tmp_12 = _cursor.isNull(_cursorIndexOfReactionCounts) ? null : _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmp_13 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_12);
                                if (_tmp_13 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionCounts = _tmp_13;
                                String _tmp_14 = _cursor.isNull(_cursorIndexOfReactionScores) ? null : _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmp_15 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_14);
                                if (_tmp_15 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionScores = _tmp_15;
                                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.isNull(_cursorIndexOfCommand) ? null : _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_16 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_16 != 0;
                                int _tmp_17 = _cursor.getInt(_cursorIndexOfShowInChannel);
                                boolean _tmpShowInChannel = _tmp_17 != 0;
                                int _tmp_18 = _cursor.getInt(_cursorIndexOfSilent);
                                boolean _tmpSilent = _tmp_18 != 0;
                                String _tmp_19 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmp_20 = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_19);
                                if (_tmp_20 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                                }
                                Map<String, Object> _tmpExtraData = _tmp_20;
                                String _tmpReplyToId = _cursor.isNull(_cursorIndexOfReplyToId) ? null : _cursor.getString(_cursorIndexOfReplyToId);
                                int _tmp_21 = _cursor.getInt(_cursorIndexOfPinned);
                                boolean _tmpPinned = _tmp_21 != 0;
                                Long _tmp_22 = _cursor.isNull(_cursorIndexOfPinnedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinnedAt));
                                Date _tmpPinnedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_22);
                                Long _tmp_23 = _cursor.isNull(_cursorIndexOfPinExpires) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinExpires));
                                Date _tmpPinExpires = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_23);
                                String _tmpPinnedByUserId = _cursor.isNull(_cursorIndexOfPinnedByUserId) ? null : _cursor.getString(_cursorIndexOfPinnedByUserId);
                                String _tmp_24 = _cursor.isNull(_cursorIndexOfThreadParticipantsIds) ? null : _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmp_25 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_24);
                                if (_tmp_25 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpThreadParticipantsIds = _tmp_25;
                                if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                    String _tmpCid_1 = _cursor.isNull(_cursorIndexOfCid_1) ? null : _cursor.getString(_cursorIndexOfCid_1);
                                    String _tmpId_1 = _cursor.isNull(_cursorIndexOfId_1) ? null : _cursor.getString(_cursorIndexOfId_1);
                                    String _tmpType_1 = _cursor.isNull(_cursorIndexOfType_1) ? null : _cursor.getString(_cursorIndexOfType_1);
                                    Integer _tmpMemberCount = _cursor.isNull(_cursorIndexOfMemberCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMemberCount));
                                    String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                    _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1, _tmpId_1, _tmpType_1, _tmpMemberCount, _tmpName);
                                } else {
                                    _tmpChannelInfo = null;
                                }
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpHtml, _tmpType, _tmpSyncStatus, _tmpSyncType, _tmpSyncContent, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpRemoteMentionedUserIds, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpShowInChannel, _tmpChannelInfo, _tmpSilent, _tmpExtraData, _tmpReplyToId, _tmpPinned, _tmpPinnedAt, _tmpPinExpires, _tmpPinnedByUserId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item_1 = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item_1);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object selectBySyncStatus(SyncStatus syncStatus, int limit, Continuation<? super List<MessageEntity>> continuation) {
        String _sql = "SELECT * FROM stream_chat_message WHERE syncStatus = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_message WHERE syncStatus = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?", (int)2);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<MessageEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MessageEntity> call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<MessageEntity> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
                        int _cursorIndexOfHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"html");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                        int _cursorIndexOfSyncType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncType");
                        int _cursorIndexOfSyncContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncContent");
                        int _cursorIndexOfReplyCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyCount");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                        int _cursorIndexOfCreatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdLocallyAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                        int _cursorIndexOfUpdatedLocallyAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedLocallyAt");
                        int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                        int _cursorIndexOfRemoteMentionedUserIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"remoteMentionedUserIds");
                        int _cursorIndexOfMentionedUsersId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionedUsersId");
                        int _cursorIndexOfReactionCounts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCounts");
                        int _cursorIndexOfReactionScores = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionScores");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                        int _cursorIndexOfCommand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"command");
                        int _cursorIndexOfShadowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shadowed");
                        int _cursorIndexOfShowInChannel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"showInChannel");
                        int _cursorIndexOfSilent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"silent");
                        int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                        int _cursorIndexOfReplyToId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"replyToId");
                        int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                        int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedAt");
                        int _cursorIndexOfPinExpires = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinExpires");
                        int _cursorIndexOfPinnedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedByUserId");
                        int _cursorIndexOfThreadParticipantsIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"threadParticipantsIds");
                        int _cursorIndexOfCid_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infocid");
                        int _cursorIndexOfId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoid");
                        int _cursorIndexOfType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infotype");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infomemberCount");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channel_infoname");
                        ArrayMap _collectionAttachments = new ArrayMap();
                        ArrayMap _collectionOwnReactions = new ArrayMap();
                        ArrayMap _collectionLatestReactions = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_2;
                            ArrayList _tmpLatestReactionsCollection;
                            String _tmpKey_1;
                            ArrayList _tmpOwnReactionsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfId);
                            ArrayList _tmpAttachmentsCollection = (ArrayList)_collectionAttachments.get((Object)_tmpKey);
                            if (_tmpAttachmentsCollection == null) {
                                _tmpAttachmentsCollection = new ArrayList();
                                _collectionAttachments.put((Object)_tmpKey, _tmpAttachmentsCollection);
                            }
                            if ((_tmpOwnReactionsCollection = (ArrayList)_collectionOwnReactions.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfId)))) == null) {
                                _tmpOwnReactionsCollection = new ArrayList();
                                _collectionOwnReactions.put((Object)_tmpKey_1, _tmpOwnReactionsCollection);
                            }
                            if ((_tmpLatestReactionsCollection = (ArrayList)_collectionLatestReactions.get((Object)(_tmpKey_2 = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpLatestReactionsCollection = new ArrayList();
                            _collectionLatestReactions.put((Object)_tmpKey_2, _tmpLatestReactionsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        MessageDao_Impl.this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_collectionAttachments);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionOwnReactions);
                        MessageDao_Impl.this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_collectionLatestReactions);
                        ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            MessageInnerEntity _tmpMessageInnerEntity;
                            if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfCid) && _cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfText) && _cursor.isNull(_cursorIndexOfHtml) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfSyncStatus) && _cursor.isNull(_cursorIndexOfSyncType) && _cursor.isNull(_cursorIndexOfSyncContent) && _cursor.isNull(_cursorIndexOfReplyCount) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfCreatedLocallyAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) && _cursor.isNull(_cursorIndexOfDeletedAt) && _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) && _cursor.isNull(_cursorIndexOfMentionedUsersId) && _cursor.isNull(_cursorIndexOfReactionCounts) && _cursor.isNull(_cursorIndexOfReactionScores) && _cursor.isNull(_cursorIndexOfParentId) && _cursor.isNull(_cursorIndexOfCommand) && _cursor.isNull(_cursorIndexOfShadowed) && _cursor.isNull(_cursorIndexOfShowInChannel) && _cursor.isNull(_cursorIndexOfSilent) && _cursor.isNull(_cursorIndexOfExtraData) && _cursor.isNull(_cursorIndexOfReplyToId) && _cursor.isNull(_cursorIndexOfPinned) && _cursor.isNull(_cursorIndexOfPinnedAt) && _cursor.isNull(_cursorIndexOfPinExpires) && _cursor.isNull(_cursorIndexOfPinnedByUserId) && _cursor.isNull(_cursorIndexOfThreadParticipantsIds) && _cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                ChannelInfoEntity _tmpChannelInfo;
                                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                                String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                String _tmpText = _cursor.isNull(_cursorIndexOfText) ? null : _cursor.getString(_cursorIndexOfText);
                                String _tmpHtml = _cursor.isNull(_cursorIndexOfHtml) ? null : _cursor.getString(_cursorIndexOfHtml);
                                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                                int _tmp_1 = _cursor.getInt(_cursorIndexOfSyncStatus);
                                SyncStatus _tmpSyncStatus = MessageDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_1);
                                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfSyncType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSyncType));
                                MessageSyncType _tmpSyncType = _tmp_2 == null ? null : MessageDao_Impl.this.__messageSyncTypeConverter.stringToMessageSyncType(_tmp_2);
                                String _tmp_3 = _cursor.isNull(_cursorIndexOfSyncContent) ? null : _cursor.getString(_cursorIndexOfSyncContent);
                                MessageSyncContentEntity _tmpSyncContent = MessageDao_Impl.this.__messageSyncDescriptionConverter.stringToSyncDescription(_tmp_3);
                                int _tmpReplyCount = _cursor.getInt(_cursorIndexOfReplyCount);
                                Long _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                                Date _tmpCreatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_4);
                                Long _tmp_5 = _cursor.isNull(_cursorIndexOfCreatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedLocallyAt));
                                Date _tmpCreatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_5);
                                Long _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                                Date _tmpUpdatedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                                Long _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedLocallyAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedLocallyAt));
                                Date _tmpUpdatedLocallyAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                                Long _tmp_8 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                                Date _tmpDeletedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                                String _tmp_9 = _cursor.isNull(_cursorIndexOfRemoteMentionedUserIds) ? null : _cursor.getString(_cursorIndexOfRemoteMentionedUserIds);
                                List<String> _tmp_10 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_9);
                                if (_tmp_10 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpRemoteMentionedUserIds = _tmp_10;
                                String _tmp_11 = _cursor.isNull(_cursorIndexOfMentionedUsersId) ? null : _cursor.getString(_cursorIndexOfMentionedUsersId);
                                List<String> _tmp_12 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_11);
                                if (_tmp_12 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpMentionedUsersId = _tmp_12;
                                String _tmp_13 = _cursor.isNull(_cursorIndexOfReactionCounts) ? null : _cursor.getString(_cursorIndexOfReactionCounts);
                                Map<String, Integer> _tmp_14 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_13);
                                if (_tmp_14 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionCounts = _tmp_14;
                                String _tmp_15 = _cursor.isNull(_cursorIndexOfReactionScores) ? null : _cursor.getString(_cursorIndexOfReactionScores);
                                Map<String, Integer> _tmp_16 = MessageDao_Impl.this.__mapConverter.stringToMap(_tmp_15);
                                if (_tmp_16 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Integer>, but it was null.");
                                }
                                Map<String, Integer> _tmpReactionScores = _tmp_16;
                                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                                String _tmpCommand = _cursor.isNull(_cursorIndexOfCommand) ? null : _cursor.getString(_cursorIndexOfCommand);
                                int _tmp_17 = _cursor.getInt(_cursorIndexOfShadowed);
                                boolean _tmpShadowed = _tmp_17 != 0;
                                int _tmp_18 = _cursor.getInt(_cursorIndexOfShowInChannel);
                                boolean _tmpShowInChannel = _tmp_18 != 0;
                                int _tmp_19 = _cursor.getInt(_cursorIndexOfSilent);
                                boolean _tmpSilent = _tmp_19 != 0;
                                String _tmp_20 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                                Map<String, Object> _tmp_21 = MessageDao_Impl.this.__extraDataConverter.stringToMap(_tmp_20);
                                if (_tmp_21 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                                }
                                Map<String, Object> _tmpExtraData = _tmp_21;
                                String _tmpReplyToId = _cursor.isNull(_cursorIndexOfReplyToId) ? null : _cursor.getString(_cursorIndexOfReplyToId);
                                int _tmp_22 = _cursor.getInt(_cursorIndexOfPinned);
                                boolean _tmpPinned = _tmp_22 != 0;
                                Long _tmp_23 = _cursor.isNull(_cursorIndexOfPinnedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinnedAt));
                                Date _tmpPinnedAt = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_23);
                                Long _tmp_24 = _cursor.isNull(_cursorIndexOfPinExpires) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfPinExpires));
                                Date _tmpPinExpires = MessageDao_Impl.this.__dateConverter.fromTimestamp(_tmp_24);
                                String _tmpPinnedByUserId = _cursor.isNull(_cursorIndexOfPinnedByUserId) ? null : _cursor.getString(_cursorIndexOfPinnedByUserId);
                                String _tmp_25 = _cursor.isNull(_cursorIndexOfThreadParticipantsIds) ? null : _cursor.getString(_cursorIndexOfThreadParticipantsIds);
                                List<String> _tmp_26 = MessageDao_Impl.this.__listConverter.stringToStringList(_tmp_25);
                                if (_tmp_26 == null) {
                                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                                }
                                List<String> _tmpThreadParticipantsIds = _tmp_26;
                                if (!(_cursor.isNull(_cursorIndexOfCid_1) && _cursor.isNull(_cursorIndexOfId_1) && _cursor.isNull(_cursorIndexOfType_1) && _cursor.isNull(_cursorIndexOfMemberCount) && _cursor.isNull(_cursorIndexOfName))) {
                                    String _tmpCid_1 = _cursor.isNull(_cursorIndexOfCid_1) ? null : _cursor.getString(_cursorIndexOfCid_1);
                                    String _tmpId_1 = _cursor.isNull(_cursorIndexOfId_1) ? null : _cursor.getString(_cursorIndexOfId_1);
                                    String _tmpType_1 = _cursor.isNull(_cursorIndexOfType_1) ? null : _cursor.getString(_cursorIndexOfType_1);
                                    Integer _tmpMemberCount = _cursor.isNull(_cursorIndexOfMemberCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMemberCount));
                                    String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                    _tmpChannelInfo = new ChannelInfoEntity(_tmpCid_1, _tmpId_1, _tmpType_1, _tmpMemberCount, _tmpName);
                                } else {
                                    _tmpChannelInfo = null;
                                }
                                _tmpMessageInnerEntity = new MessageInnerEntity(_tmpId, _tmpCid, _tmpUserId, _tmpText, _tmpHtml, _tmpType, _tmpSyncStatus, _tmpSyncType, _tmpSyncContent, _tmpReplyCount, _tmpCreatedAt, _tmpCreatedLocallyAt, _tmpUpdatedAt, _tmpUpdatedLocallyAt, _tmpDeletedAt, _tmpRemoteMentionedUserIds, _tmpMentionedUsersId, _tmpReactionCounts, _tmpReactionScores, _tmpParentId, _tmpCommand, _tmpShadowed, _tmpShowInChannel, _tmpChannelInfo, _tmpSilent, _tmpExtraData, _tmpReplyToId, _tmpPinned, _tmpPinnedAt, _tmpPinExpires, _tmpPinnedByUserId, _tmpThreadParticipantsIds);
                            } else {
                                _tmpMessageInnerEntity = null;
                            }
                            ArrayList<AttachmentEntity> _tmpAttachmentsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfId);
                            _tmpAttachmentsCollection_1 = (ArrayList<AttachmentEntity>)_collectionAttachments.get((Object)_tmpKey_3);
                            if (_tmpAttachmentsCollection_1 == null) {
                                _tmpAttachmentsCollection_1 = new ArrayList<AttachmentEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpOwnReactionsCollection_1 = null;
                            String _tmpKey_4 = _cursor.getString(_cursorIndexOfId);
                            _tmpOwnReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionOwnReactions.get((Object)_tmpKey_4);
                            if (_tmpOwnReactionsCollection_1 == null) {
                                _tmpOwnReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            ArrayList<ReactionEntity> _tmpLatestReactionsCollection_1 = null;
                            String _tmpKey_5 = _cursor.getString(_cursorIndexOfId);
                            _tmpLatestReactionsCollection_1 = (ArrayList<ReactionEntity>)_collectionLatestReactions.get((Object)_tmpKey_5);
                            if (_tmpLatestReactionsCollection_1 == null) {
                                _tmpLatestReactionsCollection_1 = new ArrayList<ReactionEntity>();
                            }
                            MessageEntity _item = new MessageEntity(_tmpMessageInnerEntity, _tmpAttachmentsCollection_1, _tmpOwnReactionsCollection_1, _tmpLatestReactionsCollection_1);
                            _result.add(_item);
                        }
                        MessageDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object selectIdsBySyncStatus(SyncStatus syncStatus, int limit, Continuation<? super List<String>> continuation) {
        String _sql = "SELECT id FROM stream_chat_message WHERE syncStatus = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM stream_chat_message WHERE syncStatus = ? ORDER BY CASE WHEN createdAt IS NULL THEN createdLocallyAt ELSE createdAt END ASC LIMIT ?", (int)2);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                        _result.add(_item);
                    }
                    ArrayList<String> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteAttachmentsChunked(List<String> messageIds) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM attachment_inner_entity WHERE messageId in (");
        int _inputSize = messageIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : messageIds) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity(ArrayMap<String, ArrayList<AttachmentEntity>> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put((Object)((String)_map.keyAt(_mapIndex)), (Object)((ArrayList)_map.valueAt(_mapIndex)));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipattachmentInnerEntityAsioGetstreamChatAndroidOfflineRepositoryDomainMessageAttachmentInternalAttachmentEntity((ArrayMap<String, ArrayList<AttachmentEntity>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `id`,`messageId`,`authorName`,`titleLink`,`authorLink`,`thumbUrl`,`imageUrl`,`assetUrl`,`ogUrl`,`mimeType`,`fileSize`,`title`,`text`,`type`,`image`,`url`,`name`,`fallback`,`uploadFilePath`,`extraData`,`statusCode`,`errorMessage` FROM `attachment_inner_entity` WHERE `messageId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"messageId");
            if (_itemKeyIndex == -1) {
                return;
            }
            boolean _cursorIndexOfId = false;
            boolean _cursorIndexOfMessageId = true;
            int _cursorIndexOfAuthorName = 2;
            int _cursorIndexOfTitleLink = 3;
            int _cursorIndexOfAuthorLink = 4;
            int _cursorIndexOfThumbUrl = 5;
            int _cursorIndexOfImageUrl = 6;
            int _cursorIndexOfAssetUrl = 7;
            int _cursorIndexOfOgUrl = 8;
            int _cursorIndexOfMimeType = 9;
            int _cursorIndexOfFileSize = 10;
            int _cursorIndexOfTitle = 11;
            int _cursorIndexOfText = 12;
            int _cursorIndexOfType = 13;
            int _cursorIndexOfImage = 14;
            int _cursorIndexOfUrl = 15;
            int _cursorIndexOfName = 16;
            int _cursorIndexOfFallback = 17;
            int _cursorIndexOfUploadFilePath = 18;
            int _cursorIndexOfExtraData = 19;
            int _cursorIndexOfStatusCode = 20;
            int _cursorIndexOfErrorMessage = 21;
            while (_cursor.moveToNext()) {
                UploadStateEntity _tmpUploadState;
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList _tmpRelation = (ArrayList)_map.get((Object)_tmpKey);
                if (_tmpRelation == null) continue;
                String _tmpId = _cursor.isNull(0) ? null : _cursor.getString(0);
                String _tmpMessageId = _cursor.isNull(1) ? null : _cursor.getString(1);
                String _tmpAuthorName = _cursor.isNull(2) ? null : _cursor.getString(2);
                String _tmpTitleLink = _cursor.isNull(3) ? null : _cursor.getString(3);
                String _tmpAuthorLink = _cursor.isNull(4) ? null : _cursor.getString(4);
                String _tmpThumbUrl = _cursor.isNull(5) ? null : _cursor.getString(5);
                String _tmpImageUrl = _cursor.isNull(6) ? null : _cursor.getString(6);
                String _tmpAssetUrl = _cursor.isNull(7) ? null : _cursor.getString(7);
                String _tmpOgUrl = _cursor.isNull(8) ? null : _cursor.getString(8);
                String _tmpMimeType = _cursor.isNull(9) ? null : _cursor.getString(9);
                int _tmpFileSize = _cursor.getInt(10);
                String _tmpTitle = _cursor.isNull(11) ? null : _cursor.getString(11);
                String _tmpText = _cursor.isNull(12) ? null : _cursor.getString(12);
                String _tmpType = _cursor.isNull(13) ? null : _cursor.getString(13);
                String _tmpImage = _cursor.isNull(14) ? null : _cursor.getString(14);
                String _tmpUrl = _cursor.isNull(15) ? null : _cursor.getString(15);
                String _tmpName = _cursor.isNull(16) ? null : _cursor.getString(16);
                String _tmpFallback = _cursor.isNull(17) ? null : _cursor.getString(17);
                String _tmpUploadFilePath = _cursor.isNull(18) ? null : _cursor.getString(18);
                String _tmp = _cursor.isNull(19) ? null : _cursor.getString(19);
                Map<String, Object> _tmp_1 = this.__extraDataConverter.stringToMap(_tmp);
                if (_tmp_1 == null) {
                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                }
                Map<String, Object> _tmpExtraData = _tmp_1;
                if (!_cursor.isNull(20) || !_cursor.isNull(21)) {
                    int _tmpStatusCode = _cursor.getInt(20);
                    String _tmpErrorMessage = _cursor.isNull(21) ? null : _cursor.getString(21);
                    _tmpUploadState = new UploadStateEntity(_tmpStatusCode, _tmpErrorMessage);
                } else {
                    _tmpUploadState = null;
                }
                AttachmentEntity _item_1 = new AttachmentEntity(_tmpId, _tmpMessageId, _tmpAuthorName, _tmpTitleLink, _tmpAuthorLink, _tmpThumbUrl, _tmpImageUrl, _tmpAssetUrl, _tmpOgUrl, _tmpMimeType, _tmpFileSize, _tmpTitle, _tmpText, _tmpType, _tmpImage, _tmpUrl, _tmpName, _tmpFallback, _tmpUploadFilePath, _tmpUploadState, _tmpExtraData);
                _tmpRelation.add(_item_1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity(ArrayMap<String, ArrayList<ReactionEntity>> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put((Object)((String)_map.keyAt(_mapIndex)), (Object)((ArrayList)_map.valueAt(_mapIndex)));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipstreamChatReactionAsioGetstreamChatAndroidOfflineRepositoryDomainReactionInternalReactionEntity((ArrayMap<String, ArrayList<ReactionEntity>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `messageId`,`userId`,`type`,`score`,`createdAt`,`updatedAt`,`deletedAt`,`enforceUnique`,`extraData`,`syncStatus`,`id` FROM `stream_chat_reaction` WHERE `messageId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"messageId");
            if (_itemKeyIndex == -1) {
                return;
            }
            boolean _cursorIndexOfMessageId = false;
            boolean _cursorIndexOfUserId = true;
            int _cursorIndexOfType = 2;
            int _cursorIndexOfScore = 3;
            int _cursorIndexOfCreatedAt = 4;
            int _cursorIndexOfUpdatedAt = 5;
            int _cursorIndexOfDeletedAt = 6;
            int _cursorIndexOfEnforceUnique = 7;
            int _cursorIndexOfExtraData = 8;
            int _cursorIndexOfSyncStatus = 9;
            int _cursorIndexOfId = 10;
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList _tmpRelation = (ArrayList)_map.get((Object)_tmpKey);
                if (_tmpRelation == null) continue;
                String _tmpMessageId = _cursor.isNull(0) ? null : _cursor.getString(0);
                String _tmpUserId = _cursor.isNull(1) ? null : _cursor.getString(1);
                String _tmpType = _cursor.isNull(2) ? null : _cursor.getString(2);
                int _tmpScore = _cursor.getInt(3);
                Long _tmp = _cursor.isNull(4) ? null : Long.valueOf(_cursor.getLong(4));
                Date _tmpCreatedAt = this.__dateConverter.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(5) ? null : Long.valueOf(_cursor.getLong(5));
                Date _tmpUpdatedAt = this.__dateConverter.fromTimestamp(_tmp_1);
                Long _tmp_2 = _cursor.isNull(6) ? null : Long.valueOf(_cursor.getLong(6));
                Date _tmpDeletedAt = this.__dateConverter.fromTimestamp(_tmp_2);
                int _tmp_3 = _cursor.getInt(7);
                boolean _tmpEnforceUnique = _tmp_3 != 0;
                String _tmp_4 = _cursor.isNull(8) ? null : _cursor.getString(8);
                Map<String, Object> _tmp_5 = this.__extraDataConverter.stringToMap(_tmp_4);
                if (_tmp_5 == null) {
                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                }
                Map<String, Object> _tmpExtraData = _tmp_5;
                int _tmp_6 = _cursor.getInt(9);
                SyncStatus _tmpSyncStatus = this.__syncStatusConverter.stringToSyncStatus(_tmp_6);
                ReactionEntity _item_1 = new ReactionEntity(_tmpMessageId, _tmpUserId, _tmpType, _tmpScore, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpEnforceUnique, _tmpExtraData, _tmpSyncStatus);
                int _tmpId = _cursor.getInt(10);
                _item_1.setId(_tmpId);
                _tmpRelation.add(_item_1);
            }
        }
    }

    static /* synthetic */ Object access$1101(MessageDao_Impl x0, List x1, Continuation x2) {
        return super.insert(x1, (Continuation<? super Unit>)x2);
    }

    static /* synthetic */ Object access$1201(MessageDao_Impl x0, MessageEntity x1, Continuation x2) {
        return super.insert(x1, (Continuation<? super Unit>)x2);
    }

    static /* synthetic */ Object access$1401(MessageDao_Impl x0, MessageInnerEntity x1, Continuation x2) {
        return super.upsertMessageInnerEntity(x1, (Continuation<? super Unit>)x2);
    }

    static /* synthetic */ Object access$1501(MessageDao_Impl x0, List x1, Continuation x2) {
        return super.upsertMessageInnerEntities(x1, (Continuation<? super Unit>)x2);
    }

    static /* synthetic */ Object access$1601(MessageDao_Impl x0, List x1, Continuation x2) {
        return super.select(x1, (Continuation<? super List<MessageEntity>>)x2);
    }

    static /* synthetic */ Object access$1701(MessageDao_Impl x0, Continuation x1) {
        return super.selectWaitForAttachments((Continuation<? super List<MessageEntity>>)x1);
    }
}

