/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.repository.domain.message.attachment.internal;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.offline.repository.domain.message.attachment.internal.AttachmentEntity;
import io.getstream.chat.android.offline.repository.domain.message.attachment.internal.UploadStateEntity;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\b*\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u0002*\u00020\u0007H\u0000\u001a\u0016\u0010\n\u001a\u00020\t*\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\r"}, d2={"getOrGenerateId", "", "Lio/getstream/chat/android/client/models/Attachment;", "messageId", "index", "", "toEntity", "Lio/getstream/chat/android/offline/repository/domain/message/attachment/internal/AttachmentEntity;", "Lio/getstream/chat/android/offline/repository/domain/message/attachment/internal/UploadStateEntity;", "Lio/getstream/chat/android/client/models/Attachment$UploadState;", "toModel", "uploadFile", "Ljava/io/File;", "stream-chat-android-offline_release"})
public final class AttachmentMapperKt {
    @NotNull
    public static final AttachmentEntity toEntity(@NotNull Attachment $this$toEntity, @NotNull String messageId, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$toEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        File file = $this$toEntity.getUpload();
        Attachment.UploadState uploadState = $this$toEntity.getUploadState();
        return new AttachmentEntity(AttachmentMapperKt.getOrGenerateId($this$toEntity, messageId, index), messageId, $this$toEntity.getAuthorName(), $this$toEntity.getTitleLink(), $this$toEntity.getAuthorLink(), $this$toEntity.getThumbUrl(), $this$toEntity.getImageUrl(), $this$toEntity.getAssetUrl(), $this$toEntity.getOgUrl(), $this$toEntity.getMimeType(), $this$toEntity.getFileSize(), $this$toEntity.getTitle(), $this$toEntity.getText(), $this$toEntity.getType(), $this$toEntity.getImage(), $this$toEntity.getUrl(), $this$toEntity.getName(), $this$toEntity.getFallback(), file != null ? file.getAbsolutePath() : null, uploadState != null ? AttachmentMapperKt.toEntity(uploadState) : null, $this$toEntity.getExtraData());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Attachment toModel(@NotNull AttachmentEntity $this$toModel) {
        Attachment.UploadState uploadState;
        UploadStateEntity uploadStateEntity;
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        String string = $this$toModel.getAuthorName();
        String string2 = $this$toModel.getTitleLink();
        String string3 = $this$toModel.getAuthorLink();
        String string4 = $this$toModel.getThumbUrl();
        String string5 = $this$toModel.getImageUrl();
        String string6 = $this$toModel.getAssetUrl();
        String string7 = $this$toModel.getOgUrl();
        String string8 = $this$toModel.getMimeType();
        int n = $this$toModel.getFileSize();
        String string9 = $this$toModel.getTitle();
        String string10 = $this$toModel.getText();
        String string11 = $this$toModel.getType();
        String string12 = $this$toModel.getImage();
        String string13 = $this$toModel.getUrl();
        String string14 = $this$toModel.getName();
        String string15 = $this$toModel.getFallback();
        String string16 = $this$toModel.getUploadFilePath();
        if (string16 != null) {
            String p0 = string16;
            boolean bl = false;
            file2 = new File(p0);
        } else {
            file2 = file = null;
        }
        if ((uploadStateEntity = $this$toModel.getUploadState()) != null) {
            File file3;
            String string17 = $this$toModel.getUploadFilePath();
            if (string17 != null) {
                void p0;
                String string18 = string17;
                UploadStateEntity uploadStateEntity2 = uploadStateEntity;
                boolean bl = false;
                file3 = new File((String)p0);
                uploadStateEntity = uploadStateEntity2;
            } else {
                file3 = null;
            }
            uploadState = AttachmentMapperKt.toModel(uploadStateEntity, file3);
        } else {
            uploadState = null;
        }
        Attachment.UploadState uploadState2 = uploadState;
        Map map2 = MapsKt.toMutableMap($this$toModel.getExtraData());
        return new Attachment(string, string3, string2, string4, string5, string6, string7, string8, n, string9, string10, string11, string12, string13, string14, string15, file, uploadState2, map2);
    }

    private static final UploadStateEntity toEntity(Attachment.UploadState $this$toEntity) {
        Pair pair;
        Attachment.UploadState uploadState = $this$toEntity;
        if (Intrinsics.areEqual((Object)uploadState, (Object)Attachment.UploadState.Success.INSTANCE)) {
            pair = TuplesKt.to((Object)1, null);
        } else if (Intrinsics.areEqual((Object)uploadState, (Object)Attachment.UploadState.Idle.INSTANCE)) {
            pair = TuplesKt.to((Object)2, null);
        } else if (uploadState instanceof Attachment.UploadState.InProgress) {
            pair = TuplesKt.to((Object)2, null);
        } else if (uploadState instanceof Attachment.UploadState.Failed) {
            Integer n = 3;
            String string = ((Attachment.UploadState.Failed)$this$toEntity).getError().getMessage();
            if (string == null) {
                Throwable throwable = ((Attachment.UploadState.Failed)$this$toEntity).getError().getCause();
                string = throwable != null ? throwable.getLocalizedMessage() : null;
            }
            pair = TuplesKt.to((Object)n, (Object)string);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        int statusCode = ((Number)pair2.component1()).intValue();
        String errorMessage = (String)pair2.component2();
        return new UploadStateEntity(statusCode, errorMessage);
    }

    private static final Attachment.UploadState toModel(UploadStateEntity $this$toModel, File uploadFile) {
        Attachment.UploadState uploadState;
        switch ($this$toModel.getStatusCode()) {
            case 1: {
                uploadState = (Attachment.UploadState)Attachment.UploadState.Success.INSTANCE;
                break;
            }
            case 2: {
                File file = uploadFile;
                uploadState = (Attachment.UploadState)new Attachment.UploadState.InProgress(0L, file != null ? file.length() : 0L);
                break;
            }
            case 3: {
                uploadState = (Attachment.UploadState)new Attachment.UploadState.Failed(new ChatError($this$toModel.getErrorMessage(), null, 2, null));
                break;
            }
            default: {
                throw new IllegalStateException(("Integer value of " + $this$toModel.getStatusCode() + " can't be mapped to UploadState").toString());
            }
        }
        return uploadState;
    }

    private static final String getOrGenerateId(Attachment $this$getOrGenerateId, String messageId, int index) {
        String string;
        if ($this$getOrGenerateId.getExtraData().containsKey("extra_data_id_key")) {
            Object v = $this$getOrGenerateId.getExtraData().get("extra_data_id_key");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)v;
        } else {
            String string2;
            String id = string2 = AttachmentEntity.Companion.generateId$stream_chat_android_offline_release(messageId, index);
            boolean bl = false;
            $this$getOrGenerateId.getExtraData().put("extra_data_id_key", id);
            string = string2;
        }
        return string;
    }
}

