/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.MultiMapJsonDataException;
import com.squareup.moshi.Types;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u0017*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u00040\u0003:\u0001\u0017B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ \u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/squareup/moshi/MultiMapJsonAdapter;", "K", "V", "Lcom/squareup/moshi/JsonAdapter;", "", "moshi", "Lcom/squareup/moshi/Moshi;", "keyType", "Ljava/lang/reflect/Type;", "valueType", "(Lcom/squareup/moshi/Moshi;Ljava/lang/reflect/Type;Ljava/lang/reflect/Type;)V", "keyAdapter", "valueAdapter", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "map", "toString", "", "Companion", "stream-chat-android-offline_release"})
public final class MultiMapJsonAdapter<K, V>
extends JsonAdapter<Map<K, ? extends V>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonAdapter<K> keyAdapter;
    @NotNull
    private final JsonAdapter<V> valueAdapter;
    @NotNull
    private static final String TAG = "CustomMapJsonAdapter";
    @NotNull
    private static final JsonAdapter.Factory FACTORY = MultiMapJsonAdapter::FACTORY$lambda$2;

    public MultiMapJsonAdapter(@NotNull Moshi moshi, @NotNull Type keyType, @NotNull Type valueType) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        JsonAdapter jsonAdapter = moshi.adapter(keyType);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(keyType)");
        this.keyAdapter = jsonAdapter;
        JsonAdapter jsonAdapter2 = moshi.adapter(valueType);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter2, (String)"moshi.adapter(valueType)");
        this.valueAdapter = jsonAdapter2;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable Map<K, ? extends V> map2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (map2 == null) {
            return;
        }
        HashSet<K> keys = new HashSet<K>();
        writer.beginObject();
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null) {
                throw new JsonDataException("Map key is null at " + writer.getPath());
            }
            if (keys.contains(key)) {
                MultiMapJsonDataException exception = new MultiMapJsonDataException("Map key '" + key + "' has multiple values at path " + writer.getPath() + ";\nmap: " + map2);
                String tag$iv = TAG;
                boolean $i$f$e = false;
                if (!StreamLog.INSTANCE.getInternalValidator().isLoggable(Priority.ERROR, tag$iv)) continue;
                String string = tag$iv;
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = StreamLog.INSTANCE.getInternalLogger();
                boolean bl = false;
                String string2 = "[toJson] failed: " + exception;
                streamLogger.log(priority, string, string2, (Throwable)exception);
                continue;
            }
            writer.promoteValueToName();
            this.keyAdapter.toJson(writer, key);
            this.valueAdapter.toJson(writer, value);
            keys.add(key);
        }
        writer.endObject();
    }

    @NotNull
    public Map<K, V> fromJson(@NotNull JsonReader reader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        reader.beginObject();
        while (reader.hasNext()) {
            Object value;
            Object key;
            Object replaced;
            reader.promoteNameToValue();
            if (this.keyAdapter.fromJson(reader) == null || (replaced = result.put(key, value = this.valueAdapter.fromJson(reader))) == null) continue;
            MultiMapJsonDataException exception = new MultiMapJsonDataException("Map key '" + key + "' has multiple values at path " + reader.getPath() + ": " + replaced + " and " + value);
            String tag$iv = TAG;
            boolean $i$f$e = false;
            if (!StreamLog.INSTANCE.getInternalValidator().isLoggable(Priority.ERROR, tag$iv)) continue;
            String string = tag$iv;
            Priority priority = Priority.ERROR;
            StreamLogger streamLogger = StreamLog.INSTANCE.getInternalLogger();
            boolean bl = false;
            String string2 = "[fromJson] failed: " + exception;
            streamLogger.log(priority, string, string2, (Throwable)exception);
        }
        reader.endObject();
        return result;
    }

    @NotNull
    public String toString() {
        return "CustomMapJsonAdapter(" + this.keyAdapter + '=' + this.valueAdapter + ')';
    }

    private static final JsonAdapter FACTORY$lambda$2(Type type, Set annotations, Moshi moshi) {
        Intrinsics.checkNotNullExpressionValue((Object)annotations, (String)"annotations");
        if (!((Collection)annotations).isEmpty()) {
            return null;
        }
        Class rawType = Types.getRawType((Type)type);
        if (!Intrinsics.areEqual((Object)rawType, Map.class)) {
            return null;
        }
        Type[] typeArray = Types.mapKeyAndValueTypes((Type)type, (Class)rawType);
        if (typeArray == null) {
            return null;
        }
        Type[] keyAndValue = typeArray;
        Intrinsics.checkNotNullExpressionValue((Object)moshi, (String)"moshi");
        Type type2 = keyAndValue[0];
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"keyAndValue[0]");
        Type type3 = keyAndValue[1];
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"keyAndValue[1]");
        return new MultiMapJsonAdapter(moshi, type2, type3).nullSafe();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/squareup/moshi/MultiMapJsonAdapter$Companion;", "", "()V", "FACTORY", "Lcom/squareup/moshi/JsonAdapter$Factory;", "getFACTORY", "()Lcom/squareup/moshi/JsonAdapter$Factory;", "TAG", "", "stream-chat-android-offline_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonAdapter.Factory getFACTORY() {
            return FACTORY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

