/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.factory;

import android.content.Context;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.persistance.repository.ChannelRepository;
import io.getstream.chat.android.client.persistance.repository.MessageRepository;
import io.getstream.chat.android.client.persistance.repository.ReactionRepository;
import io.getstream.chat.android.client.persistance.repository.RepositoryFacade;
import io.getstream.chat.android.client.persistance.repository.UserRepository;
import io.getstream.chat.android.client.persistance.repository.factory.RepositoryFactory;
import io.getstream.chat.android.client.plugin.Plugin;
import io.getstream.chat.android.client.plugin.factory.PluginFactory;
import io.getstream.chat.android.client.plugin.listeners.CreateChannelListener;
import io.getstream.chat.android.client.plugin.listeners.DeleteMessageListener;
import io.getstream.chat.android.client.plugin.listeners.DeleteReactionListener;
import io.getstream.chat.android.client.plugin.listeners.HideChannelListener;
import io.getstream.chat.android.client.plugin.listeners.QueryMembersListener;
import io.getstream.chat.android.client.plugin.listeners.SendAttachmentListener;
import io.getstream.chat.android.client.plugin.listeners.SendMessageListener;
import io.getstream.chat.android.client.plugin.listeners.ShuffleGiphyListener;
import io.getstream.chat.android.client.setup.state.ClientState;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.offline.plugin.internal.OfflinePlugin;
import io.getstream.chat.android.offline.plugin.listener.internal.CreateChannelListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.DeleteMessageListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.DeleteReactionListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.EditMessageListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.HideChannelListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.QueryChannelListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.QueryMembersListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.SendAttachmentsListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.SendMessageListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.SendReactionListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.ShuffleGiphyListenerDatabase;
import io.getstream.chat.android.offline.plugin.listener.internal.ThreadQueryListenerDatabase;
import io.getstream.chat.android.offline.repository.database.internal.ChatDatabase;
import io.getstream.chat.android.offline.repository.factory.internal.DatabaseRepositoryFactory;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/getstream/chat/android/offline/plugin/factory/StreamOfflinePluginFactory;", "Lio/getstream/chat/android/client/plugin/factory/PluginFactory;", "Lio/getstream/chat/android/client/persistance/repository/factory/RepositoryFactory$Provider;", "appContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "logger", "Lio/getstream/log/TaggedLogger;", "createDatabase", "Lio/getstream/chat/android/offline/repository/database/internal/ChatDatabase;", "context", "user", "Lio/getstream/chat/android/models/User;", "createOfflinePlugin", "Lio/getstream/chat/android/offline/plugin/internal/OfflinePlugin;", "createRepositoryFactory", "Lio/getstream/chat/android/client/persistance/repository/factory/RepositoryFactory;", "get", "Lio/getstream/chat/android/client/plugin/Plugin;", "stream-chat-android-offline_release"})
public final class StreamOfflinePluginFactory
implements PluginFactory,
RepositoryFactory.Provider {
    @NotNull
    private final Context appContext;
    @NotNull
    private final TaggedLogger logger;

    public StreamOfflinePluginFactory(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.appContext = appContext;
        this.logger = StreamLog.getLogger((String)"Chat:OfflinePluginFactory");
    }

    @NotNull
    public RepositoryFactory createRepositoryFactory(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "[createRepositoryFactory] user.id: '" + user.getId() + '\'';
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        return new DatabaseRepositoryFactory(this.createDatabase(this.appContext, user), user);
    }

    @NotNull
    public Plugin get(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.createOfflinePlugin(user);
    }

    private final OfflinePlugin createOfflinePlugin(User user) {
        ChatClient.Companion.setOFFLINE_SUPPORT_ENABLED(true);
        ChatClient chatClient = ChatClient.Companion.instance();
        ClientState clientState = chatClient.getClientState();
        RepositoryFacade repositoryFacade = chatClient.getRepositoryFacade();
        QueryChannelListenerDatabase queryChannelListener = new QueryChannelListenerDatabase(repositoryFacade);
        ThreadQueryListenerDatabase threadQueryListener = new ThreadQueryListenerDatabase((MessageRepository)repositoryFacade, (UserRepository)repositoryFacade);
        EditMessageListenerDatabase editMessageListener = new EditMessageListenerDatabase((UserRepository)repositoryFacade, (MessageRepository)repositoryFacade, clientState);
        HideChannelListener hideChannelListener = new HideChannelListenerDatabase((ChannelRepository)repositoryFacade, (MessageRepository)repositoryFacade);
        DeleteReactionListener deleteReactionListener = new DeleteReactionListenerDatabase(clientState, (ReactionRepository)repositoryFacade, (MessageRepository)repositoryFacade);
        SendReactionListenerDatabase sendReactionListener = new SendReactionListenerDatabase(clientState, (ReactionRepository)repositoryFacade, (MessageRepository)repositoryFacade, (UserRepository)repositoryFacade);
        User user2 = chatClient.getCurrentUser();
        DeleteMessageListener deleteMessageListener = new DeleteMessageListenerDatabase(clientState, user2 != null ? user2.getId() : null, (MessageRepository)repositoryFacade, (UserRepository)repositoryFacade);
        SendMessageListener sendMessageListener = new SendMessageListenerDatabase((UserRepository)repositoryFacade, (MessageRepository)repositoryFacade);
        SendAttachmentListener sendAttachmentListener = new SendAttachmentsListenerDatabase((MessageRepository)repositoryFacade, (ChannelRepository)repositoryFacade);
        ShuffleGiphyListener shuffleGiphyListener = new ShuffleGiphyListenerDatabase((UserRepository)repositoryFacade, (MessageRepository)repositoryFacade);
        QueryMembersListener queryMembersListener = new QueryMembersListenerDatabase((UserRepository)repositoryFacade, (ChannelRepository)repositoryFacade);
        CreateChannelListener createChannelListener = new CreateChannelListenerDatabase(clientState, (ChannelRepository)repositoryFacade, (UserRepository)repositoryFacade);
        return new OfflinePlugin(user, queryChannelListener, threadQueryListener, editMessageListener, hideChannelListener, deleteReactionListener, sendReactionListener, deleteMessageListener, shuffleGiphyListener, sendMessageListener, sendAttachmentListener, queryMembersListener, createChannelListener, null, 8192, null);
    }

    private final ChatDatabase createDatabase(Context context, User user) {
        return ChatDatabase.Companion.getDatabase(context, user.getId());
    }
}

