/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.repository.domain.user.internal;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.offline.repository.database.converter.internal.DateConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ExtraDataConverter;
import io.getstream.chat.android.offline.repository.database.converter.internal.ListConverter;
import io.getstream.chat.android.offline.repository.domain.user.internal.UserDao;
import io.getstream.chat.android.offline.repository.domain.user.internal.UserEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class UserDao_Impl
implements UserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserEntity> __insertionAdapterOfUserEntity;
    private final DateConverter __dateConverter = new DateConverter();
    private final ListConverter __listConverter = new ListConverter();
    private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public UserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_user` (`id`,`originalId`,`name`,`image`,`role`,`createdAt`,`updatedAt`,`lastActive`,`invisible`,`banned`,`mutes`,`extraData`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getOriginalId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getOriginalId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getImage() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getImage());
                }
                if (value.getRole() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getRole());
                }
                Long _tmp = UserDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp.longValue());
                }
                Long _tmp_1 = UserDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, _tmp_1.longValue());
                }
                Long _tmp_2 = UserDao_Impl.this.__dateConverter.dateToTimestamp(value.getLastActive());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, _tmp_2.longValue());
                }
                int _tmp_3 = value.getInvisible() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_3);
                int _tmp_4 = value.getBanned() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_4);
                String _tmp_5 = UserDao_Impl.this.__listConverter.stringListToString(value.getMutes());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                String _tmp_6 = UserDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_6 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_6);
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM stream_chat_user";
                return "DELETE FROM stream_chat_user";
            }
        };
    }

    @Override
    public Object insertMany(final List<UserEntity> users, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserDao_Impl.this.__db.beginTransaction();
                try {
                    UserDao_Impl.this.__insertionAdapterOfUserEntity.insert((Iterable)users);
                    UserDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object insert(final UserEntity userEntity, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserDao_Impl.this.__db.beginTransaction();
                try {
                    UserDao_Impl.this.__insertionAdapterOfUserEntity.insert((Object)userEntity);
                    UserDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object deleteAll(Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = UserDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                UserDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    UserDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserDao_Impl.this.__db.endTransaction();
                    UserDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object select(List<String> ids, Continuation<? super List<UserEntity>> continuation) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM stream_chat_user WHERE stream_chat_user.id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<UserEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<UserEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfOriginalId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"originalId");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"role");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfLastActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActive");
                    int _cursorIndexOfInvisible = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invisible");
                    int _cursorIndexOfBanned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"banned");
                    int _cursorIndexOfMutes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mutes");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    ArrayList<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpOriginalId = _cursor.isNull(_cursorIndexOfOriginalId) ? null : _cursor.getString(_cursorIndexOfOriginalId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpImage = _cursor.isNull(_cursorIndexOfImage) ? null : _cursor.getString(_cursorIndexOfImage);
                        String _tmpRole = _cursor.isNull(_cursorIndexOfRole) ? null : _cursor.getString(_cursorIndexOfRole);
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = UserDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = UserDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfLastActive) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastActive));
                        Date _tmpLastActive = UserDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfInvisible);
                        boolean _tmpInvisible = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfBanned);
                        boolean _tmpBanned = _tmp_4 != 0;
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfMutes) ? null : _cursor.getString(_cursorIndexOfMutes);
                        List<String> _tmp_6 = UserDao_Impl.this.__listConverter.stringToStringList(_tmp_5);
                        if (_tmp_6 == null) {
                            throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                        }
                        List<String> _tmpMutes = _tmp_6;
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmp_8 = UserDao_Impl.this.__extraDataConverter.stringToMap(_tmp_7);
                        if (_tmp_8 == null) {
                            throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                        }
                        Map<String, Object> _tmpExtraData = _tmp_8;
                        UserEntity _item_1 = new UserEntity(_tmpId, _tmpOriginalId, _tmpName, _tmpImage, _tmpRole, _tmpCreatedAt, _tmpUpdatedAt, _tmpLastActive, _tmpInvisible, _tmpBanned, _tmpMutes, _tmpExtraData);
                        _result.add(_item_1);
                    }
                    ArrayList<UserEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object select(String id, Continuation<? super UserEntity> continuation) {
        String _sql = "SELECT * FROM stream_chat_user WHERE stream_chat_user.id IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_user WHERE stream_chat_user.id IN (?)", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<UserEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    UserEntity _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfOriginalId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"originalId");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"role");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfLastActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActive");
                    int _cursorIndexOfInvisible = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invisible");
                    int _cursorIndexOfBanned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"banned");
                    int _cursorIndexOfMutes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mutes");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpOriginalId = _cursor.isNull(_cursorIndexOfOriginalId) ? null : _cursor.getString(_cursorIndexOfOriginalId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpImage = _cursor.isNull(_cursorIndexOfImage) ? null : _cursor.getString(_cursorIndexOfImage);
                        String _tmpRole = _cursor.isNull(_cursorIndexOfRole) ? null : _cursor.getString(_cursorIndexOfRole);
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = UserDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = UserDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfLastActive) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastActive));
                        Date _tmpLastActive = UserDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfInvisible);
                        boolean _tmpInvisible = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfBanned);
                        boolean _tmpBanned = _tmp_4 != 0;
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfMutes) ? null : _cursor.getString(_cursorIndexOfMutes);
                        List<String> _tmp_6 = UserDao_Impl.this.__listConverter.stringToStringList(_tmp_5);
                        if (_tmp_6 == null) {
                            throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                        }
                        List<String> _tmpMutes = _tmp_6;
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmp_8 = UserDao_Impl.this.__extraDataConverter.stringToMap(_tmp_7);
                        if (_tmp_8 == null) {
                            throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                        }
                        Map<String, Object> _tmpExtraData = _tmp_8;
                        _result = new UserEntity(_tmpId, _tmpOriginalId, _tmpName, _tmpImage, _tmpRole, _tmpCreatedAt, _tmpUpdatedAt, _tmpLastActive, _tmpInvisible, _tmpBanned, _tmpMutes, _tmpExtraData);
                    } else {
                        _result = null;
                    }
                    UserEntity userEntity = _result;
                    return userEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserEntity> selectAllUser(int limit, int offset) {
        String _sql = "SELECT * FROM stream_chat_user ORDER BY name ASC LIMIT ? OFFSET ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_user ORDER BY name ASC LIMIT ? OFFSET ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)offset);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfOriginalId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"originalId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"role");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfLastActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActive");
            int _cursorIndexOfInvisible = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invisible");
            int _cursorIndexOfBanned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"banned");
            int _cursorIndexOfMutes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mutes");
            int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
            ArrayList<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmpOriginalId = _cursor.isNull(_cursorIndexOfOriginalId) ? null : _cursor.getString(_cursorIndexOfOriginalId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpImage = _cursor.isNull(_cursorIndexOfImage) ? null : _cursor.getString(_cursorIndexOfImage);
                String _tmpRole = _cursor.isNull(_cursorIndexOfRole) ? null : _cursor.getString(_cursorIndexOfRole);
                Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                Date _tmpCreatedAt = this.__dateConverter.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                Date _tmpUpdatedAt = this.__dateConverter.fromTimestamp(_tmp_1);
                Long _tmp_2 = _cursor.isNull(_cursorIndexOfLastActive) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastActive));
                Date _tmpLastActive = this.__dateConverter.fromTimestamp(_tmp_2);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfInvisible);
                boolean _tmpInvisible = _tmp_3 != 0;
                int _tmp_4 = _cursor.getInt(_cursorIndexOfBanned);
                boolean _tmpBanned = _tmp_4 != 0;
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMutes) ? null : _cursor.getString(_cursorIndexOfMutes);
                List<String> _tmp_6 = this.__listConverter.stringToStringList(_tmp_5);
                if (_tmp_6 == null) {
                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                }
                List<String> _tmpMutes = _tmp_6;
                String _tmp_7 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                Map<String, Object> _tmp_8 = this.__extraDataConverter.stringToMap(_tmp_7);
                if (_tmp_8 == null) {
                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                }
                Map<String, Object> _tmpExtraData = _tmp_8;
                UserEntity _item = new UserEntity(_tmpId, _tmpOriginalId, _tmpName, _tmpImage, _tmpRole, _tmpCreatedAt, _tmpUpdatedAt, _tmpLastActive, _tmpInvisible, _tmpBanned, _tmpMutes, _tmpExtraData);
                _result.add(_item);
            }
            ArrayList<UserEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserEntity> selectUsersLikeName(String searchString, int limit, int offset) {
        String _sql = "SELECT * FROM stream_chat_user WHERE name LIKE ? ORDER BY name ASC LIMIT ? OFFSET ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_user WHERE name LIKE ? ORDER BY name ASC LIMIT ? OFFSET ?", (int)3);
        int _argIndex = 1;
        if (searchString == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchString);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)offset);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfOriginalId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"originalId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"role");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfLastActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActive");
            int _cursorIndexOfInvisible = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invisible");
            int _cursorIndexOfBanned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"banned");
            int _cursorIndexOfMutes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mutes");
            int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
            ArrayList<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmpOriginalId = _cursor.isNull(_cursorIndexOfOriginalId) ? null : _cursor.getString(_cursorIndexOfOriginalId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpImage = _cursor.isNull(_cursorIndexOfImage) ? null : _cursor.getString(_cursorIndexOfImage);
                String _tmpRole = _cursor.isNull(_cursorIndexOfRole) ? null : _cursor.getString(_cursorIndexOfRole);
                Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                Date _tmpCreatedAt = this.__dateConverter.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                Date _tmpUpdatedAt = this.__dateConverter.fromTimestamp(_tmp_1);
                Long _tmp_2 = _cursor.isNull(_cursorIndexOfLastActive) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastActive));
                Date _tmpLastActive = this.__dateConverter.fromTimestamp(_tmp_2);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfInvisible);
                boolean _tmpInvisible = _tmp_3 != 0;
                int _tmp_4 = _cursor.getInt(_cursorIndexOfBanned);
                boolean _tmpBanned = _tmp_4 != 0;
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMutes) ? null : _cursor.getString(_cursorIndexOfMutes);
                List<String> _tmp_6 = this.__listConverter.stringToStringList(_tmp_5);
                if (_tmp_6 == null) {
                    throw new IllegalStateException("Expected non-null java.util.List<java.lang.String>, but it was null.");
                }
                List<String> _tmpMutes = _tmp_6;
                String _tmp_7 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                Map<String, Object> _tmp_8 = this.__extraDataConverter.stringToMap(_tmp_7);
                if (_tmp_8 == null) {
                    throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.Object>, but it was null.");
                }
                Map<String, Object> _tmpExtraData = _tmp_8;
                UserEntity _item = new UserEntity(_tmpId, _tmpOriginalId, _tmpName, _tmpImage, _tmpRole, _tmpCreatedAt, _tmpUpdatedAt, _tmpLastActive, _tmpInvisible, _tmpBanned, _tmpMutes, _tmpExtraData);
                _result.add(_item);
            }
            ArrayList<UserEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

