/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.listener.internal;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.models.Config;
import io.getstream.chat.android.client.plugin.listeners.TypingEventListener;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.offline.plugin.state.StateRegistry;
import io.getstream.chat.android.offline.plugin.state.channel.internal.ChannelMutableState;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J<\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JJ\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/getstream/chat/android/offline/plugin/listener/internal/TypingEventListenerState;", "Lio/getstream/chat/android/client/plugin/listeners/TypingEventListener;", "state", "Lio/getstream/chat/android/offline/plugin/state/StateRegistry;", "(Lio/getstream/chat/android/offline/plugin/state/StateRegistry;)V", "onTypingEventPrecondition", "Lio/getstream/chat/android/client/utils/Result;", "", "eventType", "", "channelType", "channelId", "extraData", "", "", "eventTime", "Ljava/util/Date;", "onTypingEventRequest", "onTypingEventResult", "result", "Lio/getstream/chat/android/client/events/ChatEvent;", "onTypingStartPrecondition", "channelState", "Lio/getstream/chat/android/offline/plugin/state/channel/internal/ChannelMutableState;", "onTypingStopPrecondition", "Companion", "stream-chat-android-state_release"})
public final class TypingEventListenerState
implements TypingEventListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StateRegistry state;
    @Deprecated
    @NotNull
    private static final String ARG_TYPING_PARENT_ID = "parent_id";
    @Deprecated
    private static final int MILLI_SEC = 1000;
    @Deprecated
    private static final int TYPING_DELAY_SECS = 3;
    @Deprecated
    private static final int TYPING_DELAY = 3000;

    public TypingEventListenerState(@NotNull StateRegistry state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @NotNull
    public Result<Unit> onTypingEventPrecondition(@NotNull String eventType, @NotNull String channelType, @NotNull String channelId, @NotNull Map<Object, ? extends Object> extraData, @NotNull Date eventTime) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        ChannelMutableState channelState = this.state.mutableChannel$stream_chat_android_state_release(channelType, channelId);
        String string = eventType;
        return Intrinsics.areEqual((Object)string, (Object)"typing.start") ? this.onTypingStartPrecondition(channelState, eventTime) : (Intrinsics.areEqual((Object)string, (Object)"typing.stop") ? this.onTypingStopPrecondition(channelState) : Result.Companion.success((Object)Unit.INSTANCE));
    }

    private final Result<Unit> onTypingStopPrecondition(ChannelMutableState channelState) {
        return !((Config)channelState.getChannelConfig().getValue()).getTypingEventsEnabled() ? Result.Companion.error(new ChatError("Typing events are not enabled", null, 2, null)) : (channelState.getLastStartTypingEvent() == null ? Result.Companion.error(new ChatError("lastStartTypingEvent is null. Make sure to send Event.TYPING_START before sending Event.TYPING_STOP", null, 2, null)) : Result.Companion.success((Object)Unit.INSTANCE));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Result<Unit> onTypingStartPrecondition(ChannelMutableState channelState, Date eventTime) {
        Result result;
        if (!((Config)channelState.getChannelConfig().getValue()).getTypingEventsEnabled()) {
            result = Result.Companion.error(new ChatError("Typing events are not enabled", null, 2, null));
            return result;
        }
        if (channelState.getLastStartTypingEvent() != null) {
            long l = eventTime.getTime();
            Date date = channelState.getLastStartTypingEvent();
            Intrinsics.checkNotNull((Object)date);
            if (l - date.getTime() < 3000L) {
                result = Result.Companion.error(new ChatError("Last typing event was sent at " + channelState.getLastStartTypingEvent() + ". There must be a delay of 3 seconds before sending new event", null, 2, null));
                return result;
            }
        }
        result = Result.Companion.success((Object)Unit.INSTANCE);
        return result;
    }

    public void onTypingEventRequest(@NotNull String eventType, @NotNull String channelType, @NotNull String channelId, @NotNull Map<Object, ? extends Object> extraData, @NotNull Date eventTime) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        ChannelMutableState channelState = this.state.mutableChannel$stream_chat_android_state_release(channelType, channelId);
        if (Intrinsics.areEqual((Object)eventType, (Object)"typing.start")) {
            channelState.setLastStartTypingEvent(eventTime);
        } else if (Intrinsics.areEqual((Object)eventType, (Object)"typing.stop")) {
            channelState.setLastStartTypingEvent(null);
        }
    }

    public void onTypingEventResult(@NotNull Result<ChatEvent> result, @NotNull String eventType, @NotNull String channelType, @NotNull String channelId, @NotNull Map<Object, ? extends Object> extraData, @NotNull Date eventTime) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        if (result.isSuccess()) {
            ChannelMutableState channelState = this.state.mutableChannel$stream_chat_android_state_release(channelType, channelId);
            String string = eventType;
            if (Intrinsics.areEqual((Object)string, (Object)"typing.start")) {
                Object object = extraData.get(ARG_TYPING_PARENT_ID);
                channelState.setKeystrokeParentMessageId$stream_chat_android_state_release(object instanceof String ? (String)object : null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"typing.stop")) {
                channelState.setKeystrokeParentMessageId$stream_chat_android_state_release(null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/offline/plugin/listener/internal/TypingEventListenerState$Companion;", "", "()V", "ARG_TYPING_PARENT_ID", "", "MILLI_SEC", "", "TYPING_DELAY", "TYPING_DELAY_SECS", "stream-chat-android-state_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

