/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.listener.internal;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.extensions.ChatErrorKt;
import io.getstream.chat.android.client.extensions.MessageExtensionsKt;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.MessageSyncDescription;
import io.getstream.chat.android.client.plugin.listeners.SendMessageListener;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.client.utils.internal.ChatErrorMapperKt;
import io.getstream.chat.android.offline.plugin.logic.channel.internal.ChannelLogic;
import io.getstream.chat.android.offline.plugin.logic.channel.thread.internal.ThreadLogic;
import io.getstream.chat.android.offline.plugin.logic.internal.LogicRegistry;
import io.getstream.logging.Priority;
import io.getstream.logging.StreamLog;
import io.getstream.logging.StreamLogger;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002J7\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lio/getstream/chat/android/offline/plugin/listener/internal/SendMessageListenerState;", "Lio/getstream/chat/android/client/plugin/listeners/SendMessageListener;", "logic", "Lio/getstream/chat/android/offline/plugin/logic/internal/LogicRegistry;", "(Lio/getstream/chat/android/offline/plugin/logic/internal/LogicRegistry;)V", "handleSendMessageFail", "", "message", "Lio/getstream/chat/android/client/models/Message;", "error", "Lio/getstream/chat/android/client/errors/ChatError;", "handleSendMessageSuccess", "cid", "", "processedMessage", "onMessageSendResult", "result", "Lio/getstream/chat/android/client/utils/Result;", "channelType", "channelId", "(Lio/getstream/chat/android/client/utils/Result;Ljava/lang/String;Ljava/lang/String;Lio/getstream/chat/android/client/models/Message;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stream-chat-android-state_release"})
public final class SendMessageListenerState
implements SendMessageListener {
    @NotNull
    private final LogicRegistry logic;

    public SendMessageListenerState(@NotNull LogicRegistry logic) {
        Intrinsics.checkNotNullParameter((Object)logic, (String)"logic");
        this.logic = logic;
    }

    @Nullable
    public Object onMessageSendResult(@NotNull Result<Message> result, @NotNull String channelType, @NotNull String channelId, @NotNull Message message, @NotNull Continuation<? super Unit> $completion) {
        String cid = channelType + ':' + channelId;
        Message message2 = this.logic.getMessageById(message.getId());
        if ((message2 != null ? message2.getSyncStatus() : null) == SyncStatus.COMPLETED) {
            return Unit.INSTANCE;
        }
        if (result.isSuccess()) {
            this.handleSendMessageSuccess(cid, this.logic, (Message)result.data());
        } else {
            this.handleSendMessageFail(this.logic, message, result.error());
        }
        return Unit.INSTANCE;
    }

    private final void handleSendMessageSuccess(String cid, LogicRegistry logic, Message processedMessage) {
        block1: {
            Message message;
            Message message2 = message = Message.copy$default((Message)MessageExtensionsKt.enrichWithCid((Message)processedMessage, (String)cid), null, null, null, null, null, null, null, null, null, (int)0, null, null, (SyncStatus)SyncStatus.COMPLETED, null, null, null, null, null, null, null, null, null, null, null, (boolean)false, (boolean)false, null, (boolean)false, null, null, null, (boolean)false, null, null, null, null, (int)-12289, (int)15, null);
            boolean bl = false;
            ChannelLogic channelLogic = logic.channelFromMessage(message2);
            if (channelLogic != null) {
                channelLogic.upsertMessage$stream_chat_android_state_release(message2);
            }
            ThreadLogic threadLogic = logic.threadFromMessage(message2);
            if (threadLogic == null) break block1;
            threadLogic.upsertMessage$stream_chat_android_state_release(message2);
        }
    }

    private final void handleSendMessageFail(LogicRegistry logic, Message message, ChatError error) {
        block2: {
            Message message2;
            boolean isPermanentError = ChatErrorKt.isPermanent((ChatError)error);
            boolean isMessageModerationFailed = error instanceof ChatNetworkError && ((ChatNetworkError)error).getStreamCode() == ChatErrorCode.MESSAGE_MODERATION_FAILED.getCode();
            String tag$iv = "Chat:SendMessageHandler";
            boolean $i$f$w = false;
            if (StreamLog.INSTANCE.getInternalValidator().isLoggable(Priority.WARN, tag$iv)) {
                String string = tag$iv;
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = StreamLog.INSTANCE.getInternalLogger();
                boolean bl = false;
                String string2 = "[handleSendMessageFail] isPermanentError: " + isPermanentError + ", isMessageModerationFailed: " + isMessageModerationFailed;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
            }
            Message it = message2 = Message.copy$default((Message)message, null, null, null, null, null, null, null, null, null, (int)0, null, null, (SyncStatus)(isPermanentError ? SyncStatus.FAILED_PERMANENTLY : SyncStatus.SYNC_NEEDED), (MessageSyncDescription)ChatErrorMapperKt.toMessageSyncDescription((ChatError)error), null, null, null, null, null, null, (Date)new Date(), null, null, null, (boolean)false, (boolean)false, null, (boolean)false, null, null, null, (boolean)false, null, null, null, null, (int)-1060865, (int)15, null);
            boolean bl = false;
            ChannelLogic channelLogic = logic.channelFromMessage(it);
            if (channelLogic != null) {
                channelLogic.upsertMessage$stream_chat_android_state_release(it);
            }
            ThreadLogic threadLogic = logic.threadFromMessage(it);
            if (threadLogic == null) break block2;
            threadLogic.upsertMessage$stream_chat_android_state_release(it);
        }
    }
}

