/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.logic.querychannels.internal;

import io.getstream.chat.android.client.api.models.QueryChannelsRequest;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.EventHandlingResult;
import io.getstream.chat.android.client.extensions.StringExtensionsKt;
import io.getstream.chat.android.client.extensions.internal.ChannelKt;
import io.getstream.chat.android.client.extensions.internal.PairKt;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.query.QueryChannelsSpec;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.offline.plugin.logic.internal.LogicRegistry;
import io.getstream.chat.android.offline.plugin.state.StateRegistry;
import io.getstream.chat.android.offline.plugin.state.querychannels.QueryChannelsState;
import io.getstream.chat.android.offline.plugin.state.querychannels.internal.QueryChannelsMutableState;
import io.getstream.logging.Priority;
import io.getstream.logging.StreamLog;
import io.getstream.logging.StreamLogger;
import io.getstream.logging.TaggedLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a2\u0006\u0002\b\u0010J\u001b\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0014J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u001f\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b&J\r\u0010'\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J\u001b\u0010,\u001a\u00020\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130.H\u0000\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020\f2\u0006\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b3J\u001b\u00104\u001a\u00020\f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001306H\u0000\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020*H\u0000\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bCJ\u0015\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020*H\u0000\u00a2\u0006\u0002\bFR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lio/getstream/chat/android/offline/plugin/logic/querychannels/internal/QueryChannelsStateLogic;", "", "mutableState", "Lio/getstream/chat/android/offline/plugin/state/querychannels/internal/QueryChannelsMutableState;", "stateRegistry", "Lio/getstream/chat/android/offline/plugin/state/StateRegistry;", "logicRegistry", "Lio/getstream/chat/android/offline/plugin/logic/internal/LogicRegistry;", "(Lio/getstream/chat/android/offline/plugin/state/querychannels/internal/QueryChannelsMutableState;Lio/getstream/chat/android/offline/plugin/state/StateRegistry;Lio/getstream/chat/android/offline/plugin/logic/internal/LogicRegistry;)V", "logger", "Lio/getstream/logging/TaggedLogger;", "addChannelsState", "", "channels", "", "Lio/getstream/chat/android/client/models/Channel;", "addChannelsState$stream_chat_android_state_release", "getChannels", "", "", "getChannels$stream_chat_android_state_release", "getChannelsOffset", "", "getChannelsOffset$stream_chat_android_state_release", "getQuerySpecs", "Lio/getstream/chat/android/client/query/QueryChannelsSpec;", "getQuerySpecs$stream_chat_android_state_release", "getState", "Lio/getstream/chat/android/offline/plugin/state/querychannels/QueryChannelsState;", "getState$stream_chat_android_state_release", "handleChatEvent", "Lio/getstream/chat/android/client/events/EventHandlingResult;", "event", "Lio/getstream/chat/android/client/events/ChatEvent;", "cachedChannel", "handleChatEvent$stream_chat_android_state_release", "incrementChannelsOffset", "size", "incrementChannelsOffset$stream_chat_android_state_release", "initializeChannelsIfNeeded", "initializeChannelsIfNeeded$stream_chat_android_state_release", "isLoading", "", "isLoading$stream_chat_android_state_release", "refreshChannels", "cidList", "", "refreshChannels$stream_chat_android_state_release", "refreshMembersStateForUser", "newUser", "Lio/getstream/chat/android/client/models/User;", "refreshMembersStateForUser$stream_chat_android_state_release", "removeChannels", "cidSet", "", "removeChannels$stream_chat_android_state_release", "setChannelsOffset", "offset", "setChannelsOffset$stream_chat_android_state_release", "setCurrentRequest", "request", "Lio/getstream/chat/android/client/api/models/QueryChannelsRequest;", "setCurrentRequest$stream_chat_android_state_release", "setEndOfChannels", "isEnd", "setEndOfChannels$stream_chat_android_state_release", "setLoading", "setLoading$stream_chat_android_state_release", "setRecoveryNeeded", "recoveryNeeded", "setRecoveryNeeded$stream_chat_android_state_release", "stream-chat-android-state_release"})
public final class QueryChannelsStateLogic {
    @NotNull
    private final QueryChannelsMutableState mutableState;
    @NotNull
    private final StateRegistry stateRegistry;
    @NotNull
    private final LogicRegistry logicRegistry;
    @NotNull
    private final TaggedLogger logger;

    public QueryChannelsStateLogic(@NotNull QueryChannelsMutableState mutableState, @NotNull StateRegistry stateRegistry, @NotNull LogicRegistry logicRegistry) {
        Intrinsics.checkNotNullParameter((Object)mutableState, (String)"mutableState");
        Intrinsics.checkNotNullParameter((Object)stateRegistry, (String)"stateRegistry");
        Intrinsics.checkNotNullParameter((Object)logicRegistry, (String)"logicRegistry");
        this.mutableState = mutableState;
        this.stateRegistry = stateRegistry;
        this.logicRegistry = logicRegistry;
        this.logger = StreamLog.getLogger((String)"QueryChannelsStateLogic");
    }

    @NotNull
    public final EventHandlingResult handleChatEvent$stream_chat_android_state_release(@NotNull ChatEvent event, @Nullable Channel cachedChannel) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.mutableState.handleChatEvent(event, cachedChannel);
    }

    public final boolean isLoading$stream_chat_android_state_release() {
        return (Boolean)this.mutableState.getCurrentLoading$stream_chat_android_state_release().getValue();
    }

    public final int getChannelsOffset$stream_chat_android_state_release() {
        return ((Number)this.mutableState.getChannelsOffset$stream_chat_android_state_release().getValue()).intValue();
    }

    @Nullable
    public final Map<String, Channel> getChannels$stream_chat_android_state_release() {
        return this.mutableState.getRawChannels$stream_chat_android_state_release();
    }

    @NotNull
    public final QueryChannelsSpec getQuerySpecs$stream_chat_android_state_release() {
        return this.mutableState.getQueryChannelsSpec$stream_chat_android_state_release();
    }

    @NotNull
    public final QueryChannelsState getState$stream_chat_android_state_release() {
        return this.mutableState;
    }

    public final void setLoading$stream_chat_android_state_release(boolean isLoading) {
        this.mutableState.setLoading(isLoading);
    }

    public final void setCurrentRequest$stream_chat_android_state_release(@NotNull QueryChannelsRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "[onQueryChannelsRequest] request: " + request;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        this.mutableState.setCurrentRequest(request);
    }

    public final void setEndOfChannels$stream_chat_android_state_release(boolean isEnd) {
        this.mutableState.setEndOfChannels(isEnd);
    }

    public final void setRecoveryNeeded$stream_chat_android_state_release(boolean recoveryNeeded) {
        this.mutableState.setRecoveryNeeded(recoveryNeeded);
    }

    public final void setChannelsOffset$stream_chat_android_state_release(int offset) {
        this.mutableState.setChannelsOffset(offset);
    }

    public final void incrementChannelsOffset$stream_chat_android_state_release(int size) {
        int currentChannelsOffset = ((Number)this.mutableState.getChannelsOffset$stream_chat_android_state_release().getValue()).intValue();
        int newChannelsOffset = currentChannelsOffset + size;
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "[updateOnlineChannels] newChannelsOffset: " + newChannelsOffset + " <= " + currentChannelsOffset;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        this.mutableState.setChannelsOffset(newChannelsOffset);
    }

    public final void addChannelsState$stream_chat_android_state_release(@NotNull List<Channel> channels) {
        Channel it;
        Collection<Pair> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        QueryChannelsSpec queryChannelsSpec = this.mutableState.getQueryChannelsSpec$stream_chat_android_state_release();
        Iterable iterable = channels;
        Object object = queryChannelsSpec.getCids();
        Object object2 = queryChannelsSpec;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Channel channel = (Channel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Pair)it.getCid());
        }
        collection = (List)destination$iv$iv;
        object2.setCids(SetsKt.plus((Set)object, (Iterable)collection));
        Map existingChannels = this.mutableState.getRawChannels$stream_chat_android_state_release();
        Map map2 = existingChannels;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        $this$map$iv = channels;
        object = map2;
        object2 = this.mutableState;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Channel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getCid(), (Object)it));
        }
        collection = (List)destination$iv$iv;
        ((QueryChannelsMutableState)object2).setChannels(MapsKt.plus((Map)object, (Iterable)collection));
        Iterable $this$forEach$iv = channels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Channel channel = (Channel)element$iv;
            boolean bl = false;
            this.logicRegistry.channelState(channel.getType(), channel.getId()).updateDataFromChannel(channel, false, false);
        }
    }

    public final void removeChannels$stream_chat_android_state_release(@NotNull Set<String> cidSet) {
        Intrinsics.checkNotNullParameter(cidSet, (String)"cidSet");
        Map<String, Channel> existingChannels = this.mutableState.getRawChannels$stream_chat_android_state_release();
        if (existingChannels == null) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string2 = "[removeChannels] rejected (existingChannels is null)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
            }
            return;
        }
        this.mutableState.getQueryChannelsSpec$stream_chat_android_state_release().setCids(SetsKt.minus((Set)this.mutableState.getQueryChannelsSpec$stream_chat_android_state_release().getCids(), (Iterable)cidSet));
        this.mutableState.setChannels(MapsKt.minus(existingChannels, (Iterable)cidSet));
    }

    public final void initializeChannelsIfNeeded$stream_chat_android_state_release() {
        if (this.mutableState.getRawChannels$stream_chat_android_state_release() == null) {
            this.mutableState.setChannels(MapsKt.emptyMap());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshChannels$stream_chat_android_state_release(@NotNull Collection<String> cidList) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Pair cid;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(cidList, (String)"cidList");
        Map<String, Channel> existingChannels = this.mutableState.getRawChannels$stream_chat_android_state_release();
        if (existingChannels == null) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string2 = "[refreshChannels] rejected (existingChannels is null)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
            }
            return;
        }
        Iterable $i$f$w = CollectionsKt.intersect((Iterable)this.mutableState.getQueryChannelsSpec$stream_chat_android_state_release().getCids(), (Iterable)CollectionsKt.toSet((Iterable)cidList));
        Map<String, Channel> map2 = existingChannels;
        boolean $i$f$map = false;
        void var6_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringExtensionsKt.cidToTypeAndId((String)cid));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String channelId;
            cid = (Pair)element$iv$iv;
            boolean bl = false;
            String channelType = (String)cid.component1();
            if (!this.stateRegistry.isActiveChannel$stream_chat_android_state_release(channelType, channelId = (String)cid.component2())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv2;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            String channelType = (String)pair.component1();
            String channelId = (String)pair.component2();
            String cid2 = PairKt.toCid((Pair)TuplesKt.to((Object)channelType, (Object)channelId));
            pair = TuplesKt.to((Object)cid2, (Object)this.stateRegistry.channel(channelType, channelId).toChannel());
            map3.put(pair.getFirst(), pair.getSecond());
        }
        Map newChannels = MapsKt.plus(map2, (Map)destination$iv$iv2);
        this.mutableState.setChannels(newChannels);
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshMembersStateForUser$stream_chat_android_state_release(@NotNull User newUser) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object channel;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)newUser, (String)"newUser");
        String userId = newUser.getId();
        Map<String, Channel> existingChannels = this.mutableState.getRawChannels$stream_chat_android_state_release();
        if (existingChannels == null) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string2 = "[refreshMembersStateForUser] rejected (existingChannels is null)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
            }
            return;
        }
        Map<String, Channel> $i$f$w = existingChannels;
        boolean $i$f$filter = false;
        void var7_17 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            boolean bl;
            block9: {
                Map.Entry entry = element$iv$iv;
                boolean bl2 = false;
                channel = (Channel)entry.getValue();
                Iterable $this$any$iv = ChannelKt.users((Channel)channel);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        User it = (User)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)userId)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Collection<Member> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void it$iv$iv;
            channel = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl4 = false;
            Channel channel2 = (Channel)entry.getValue();
            Iterable bl3 = channel2.getMembers();
            List list = null;
            int n = 0;
            SyncStatus syncStatus = null;
            Date date = null;
            Date date2 = null;
            Date date3 = null;
            Date date4 = null;
            boolean bl5 = false;
            int n2 = 0;
            String string = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            Channel channel3 = channel2;
            boolean $i$f$map = false;
            void var37_51 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void member;
                User user;
                Member member2 = (Member)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl6 = false;
                User user2 = user = member.getUser();
                void var47_61 = member;
                boolean bl7 = false;
                Object object = Boolean.valueOf(Intrinsics.areEqual((Object)it.getId(), (Object)userId)) == false ? user : null;
                if (object == null) {
                    object = newUser;
                }
                collection.add(Member.copy$default((Member)var47_61, (User)object, null, null, null, null, null, (boolean)false, (boolean)false, null, (int)510, null));
            }
            collection = (List)destination$iv$iv2;
            Channel channel4 = Channel.copy$default((Channel)channel3, string6, string5, string4, string3, string, (int)n2, (boolean)bl5, date4, date3, date2, date, syncStatus, (int)n, list, (List)collection, null, null, null, null, null, null, null, null, (int)0, null, null, null, null, (int)0xFFFBFFF, null);
            map3.put(k, channel4);
        }
        Map affectedChannels = destination$iv$iv;
        this.mutableState.setChannels(MapsKt.plus(existingChannels, (Map)affectedChannels));
    }
}

