/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.state.internal;

import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.api.models.QueryChannelRequest;
import io.getstream.chat.android.client.api.models.QueryChannelsRequest;
import io.getstream.chat.android.client.api.models.WatchChannelRequest;
import io.getstream.chat.android.client.api.models.querysort.QuerySorter;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.call.CallKt;
import io.getstream.chat.android.client.extensions.StringExtensionsKt;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.offline.model.querychannels.pagination.internal.QueryChannelPaginationRequest;
import io.getstream.chat.android.offline.plugin.state.StateRegistry;
import io.getstream.chat.android.offline.plugin.state.channel.ChannelState;
import io.getstream.chat.android.offline.plugin.state.channel.thread.ThreadState;
import io.getstream.chat.android.offline.plugin.state.querychannels.QueryChannelsState;
import io.getstream.logging.Priority;
import io.getstream.logging.StreamLog;
import io.getstream.logging.StreamLogger;
import io.getstream.logging.TaggedLogger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u001d\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/getstream/chat/android/offline/plugin/state/internal/ChatClientStateCalls;", "", "chatClient", "Lio/getstream/chat/android/client/ChatClient;", "state", "Lio/getstream/chat/android/offline/plugin/state/StateRegistry;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lio/getstream/chat/android/client/ChatClient;Lio/getstream/chat/android/offline/plugin/state/StateRegistry;Lkotlinx/coroutines/CoroutineScope;)V", "logger", "Lio/getstream/logging/TaggedLogger;", "getReplies", "Lio/getstream/chat/android/offline/plugin/state/channel/thread/ThreadState;", "messageId", "", "messageLimit", "", "getReplies$stream_chat_android_state_release", "queryChannel", "Lio/getstream/chat/android/offline/plugin/state/channel/ChannelState;", "channelType", "channelId", "request", "Lio/getstream/chat/android/client/api/models/QueryChannelRequest;", "queryChannels", "Lio/getstream/chat/android/offline/plugin/state/querychannels/QueryChannelsState;", "Lio/getstream/chat/android/client/api/models/QueryChannelsRequest;", "queryChannels$stream_chat_android_state_release", "watchChannel", "cid", "watchChannel$stream_chat_android_state_release", "stream-chat-android-state_release"})
public final class ChatClientStateCalls {
    @NotNull
    private final ChatClient chatClient;
    @NotNull
    private final StateRegistry state;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final TaggedLogger logger;

    public ChatClientStateCalls(@NotNull ChatClient chatClient, @NotNull StateRegistry state, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)chatClient, (String)"chatClient");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.chatClient = chatClient;
        this.state = state;
        this.scope = scope;
        this.logger = StreamLog.getLogger((String)"ChatClientState");
    }

    @NotNull
    public final QueryChannelsState queryChannels$stream_chat_android_state_release(@NotNull QueryChannelsRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "querying state for channels";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        CallKt.launch((Call)this.chatClient.queryChannels(request), (CoroutineScope)this.scope);
        return this.state.queryChannels(request.getFilter(), (QuerySorter<Channel>)request.getQuerySort());
    }

    private final ChannelState queryChannel(String channelType, String channelId, QueryChannelRequest request) {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = Intrinsics.stringPlus((String)"querying state for channel with id: ", (Object)channelId);
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        CallKt.launch((Call)this.chatClient.queryChannel(channelType, channelId, request), (CoroutineScope)this.scope);
        return this.state.channel(channelType, channelId);
    }

    @NotNull
    public final ChannelState watchChannel$stream_chat_android_state_release(@NotNull String cid, int messageLimit) {
        WatchChannelRequest watchChannelRequest;
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = Intrinsics.stringPlus((String)"watching channel with cid: ", (Object)cid);
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        Pair pair = StringExtensionsKt.cidToTypeAndId((String)cid);
        String channelType = (String)pair.component1();
        String channelId = (String)pair.component2();
        boolean userPresence = true;
        WatchChannelRequest $this$watchChannel_u24lambda_u2d3 = watchChannelRequest = new QueryChannelPaginationRequest(messageLimit).toWatchChannelRequest(userPresence);
        boolean bl = false;
        $this$watchChannel_u24lambda_u2d3.setShouldRefresh(true);
        WatchChannelRequest request = watchChannelRequest;
        return this.queryChannel(channelType, channelId, (QueryChannelRequest)request);
    }

    @NotNull
    public final ThreadState getReplies$stream_chat_android_state_release(@NotNull String messageId, int messageLimit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = Intrinsics.stringPlus((String)"getting replied for message with id: ", (Object)messageId);
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        CallKt.launch((Call)this.chatClient.getReplies(messageId, messageLimit), (CoroutineScope)this.scope);
        return this.state.thread(messageId);
    }
}

