/*
 * Copyright (c) 2014-2022 Stream.io Inc. All rights reserved.
 *
 * Licensed under the Stream License;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://github.com/GetStream/stream-chat-android/blob/main/LICENSE
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.getstream.chat.android.offline.sync.internal

import io.getstream.chat.android.client.events.ChatEvent
import kotlinx.coroutines.flow.Flow

/**
 * Tries to sync, if necessary, when connection is reestablished or when a health check event happens.
 *
 * In addition it is responsible to sync messages, reactions and channel data.
 */
internal interface SyncHistoryManager {

    /**
     * History synced events.
     */
    val syncedEvents: Flow<List<ChatEvent>>

    /**
     * Starts history syncing based on WS events.
     */
    fun start()

    /**
     * Forces immediate history syncing.
     */
    suspend fun sync()

    /**
     * Awaits until history syncing process gets finished.
     */
    suspend fun awaitSyncing()

    /**
     * Stops history syncing based on WS events.
     */
    fun stop()
}
