/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.plugin.logic.channel.thread.internal;

import io.getstream.chat.android.client.extensions.internal.MessageKt;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.offline.plugin.logic.channel.thread.internal.ThreadStateLogic;
import io.getstream.chat.android.offline.plugin.state.channel.thread.internal.ThreadMutableState;
import io.getstream.chat.android.offline.plugin.state.channel.thread.internal.ThreadMutableStateImplKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u0014\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\bH\u0002J\f\u0010\u0018\u001a\u00020\u0017*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/getstream/chat/android/offline/plugin/logic/channel/thread/internal/ThreadStateLogicImpl;", "Lio/getstream/chat/android/offline/plugin/logic/channel/thread/internal/ThreadStateLogic;", "mutableState", "Lio/getstream/chat/android/offline/plugin/state/channel/thread/internal/ThreadMutableState;", "(Lio/getstream/chat/android/offline/plugin/state/channel/thread/internal/ThreadMutableState;)V", "deleteMessage", "", "message", "Lio/getstream/chat/android/client/models/Message;", "isMessageNewerThanCurrent", "", "currentMessage", "newMessage", "parseMessages", "", "", "messages", "", "removeLocalMessage", "upsertMessage", "upsertMessages", "writeThreadState", "lastLocalUpdateTime", "", "lastUpdateTime", "stream-chat-android-state_release"})
public final class ThreadStateLogicImpl
implements ThreadStateLogic {
    @NotNull
    private final ThreadMutableState mutableState;

    public ThreadStateLogicImpl(@NotNull ThreadMutableState mutableState) {
        Intrinsics.checkNotNullParameter((Object)mutableState, (String)"mutableState");
        this.mutableState = mutableState;
    }

    @Override
    @NotNull
    public ThreadMutableState writeThreadState() {
        return ThreadMutableStateImplKt.toMutableState(this.mutableState);
    }

    @Override
    public void deleteMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ThreadMutableState threadMutableState = this.mutableState;
        threadMutableState.setRawMessages(MapsKt.minus(threadMutableState.getRawMessages(), (Object)message.getId()));
    }

    @Override
    public void upsertMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.upsertMessages(CollectionsKt.listOf((Object)message));
    }

    @Override
    public void upsertMessages(@NotNull List<Message> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Map<String, Message> newMessages = this.parseMessages(messages);
        this.mutableState.setRawMessages(newMessages);
    }

    @Override
    public void removeLocalMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ThreadMutableState threadMutableState = this.mutableState;
        threadMutableState.setRawMessages(MapsKt.minus(threadMutableState.getRawMessages(), (Object)message.getId()));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Message> parseMessages(List<Message> messages) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Map<String, Message> currentMessages = this.mutableState.getRawMessages();
        Iterable iterable = messages;
        Map<String, Message> map2 = currentMessages;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Message newMessage = (Message)element$iv$iv;
            boolean bl = false;
            if (!this.isMessageNewerThanCurrent(currentMessages.get(newMessage.getId()), newMessage)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            Message bl = (Message)element$iv$iv;
            Map map3 = destination$iv$iv2;
            boolean bl2 = false;
            map3.put(p0.getId(), element$iv$iv);
        }
        return MapsKt.plus(map2, (Map)destination$iv$iv2);
    }

    private final boolean isMessageNewerThanCurrent(Message currentMessage, Message newMessage) {
        boolean bl;
        if (newMessage.getSyncStatus() == SyncStatus.COMPLETED) {
            Message message = currentMessage;
            bl = (message != null ? this.lastUpdateTime(message) : MessageKt.getNEVER().getTime()) <= this.lastUpdateTime(newMessage);
        } else {
            Message message = currentMessage;
            bl = (message != null ? this.lastLocalUpdateTime(message) : MessageKt.getNEVER().getTime()) <= this.lastLocalUpdateTime(newMessage);
        }
        return bl;
    }

    private final long lastUpdateTime(Message $this$lastUpdateTime) {
        Comparable comparable;
        Object[] objectArray = new Date[]{$this$lastUpdateTime.getCreatedAt(), $this$lastUpdateTime.getUpdatedAt(), $this$lastUpdateTime.getDeletedAt()};
        Iterator iterator = ((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            Date it = (Date)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getTime());
            while (iterator.hasNext()) {
                Date it2 = (Date)iterator.next();
                $i$a$-maxOfOrNull-ThreadStateLogicImpl$lastUpdateTime$1 = false;
                Comparable comparable3 = Long.valueOf(it2.getTime());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Long l = (Long)comparable;
        return l != null ? l.longValue() : MessageKt.getNEVER().getTime();
    }

    private final long lastLocalUpdateTime(Message $this$lastLocalUpdateTime) {
        Comparable comparable;
        Object[] objectArray = new Date[]{$this$lastLocalUpdateTime.getCreatedLocallyAt(), $this$lastLocalUpdateTime.getUpdatedLocallyAt(), $this$lastLocalUpdateTime.getDeletedAt()};
        Iterator iterator = ((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            Date it = (Date)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getTime());
            while (iterator.hasNext()) {
                Date it2 = (Date)iterator.next();
                $i$a$-maxOfOrNull-ThreadStateLogicImpl$lastLocalUpdateTime$1 = false;
                Comparable comparable3 = Long.valueOf(it2.getTime());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Long l = (Long)comparable;
        return l != null ? l.longValue() : MessageKt.getNEVER().getTime();
    }
}

