/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.state.event.handler.chat;

import io.getstream.chat.android.client.events.CidEvent;
import io.getstream.chat.android.client.events.HasChannel;
import io.getstream.chat.android.client.events.MemberAddedEvent;
import io.getstream.chat.android.client.events.MemberRemovedEvent;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.events.NotificationAddedToChannelEvent;
import io.getstream.chat.android.client.events.NotificationMessageNewEvent;
import io.getstream.chat.android.client.events.NotificationRemovedFromChannelEvent;
import io.getstream.chat.android.client.setup.state.ClientState;
import io.getstream.chat.android.models.Channel;
import io.getstream.chat.android.models.FilterObject;
import io.getstream.chat.android.models.Member;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.state.event.handler.chat.BaseChatEventHandler;
import io.getstream.chat.android.state.event.handler.chat.EventHandlingResult;
import io.getstream.chat.android.state.plugin.state.global.GlobalState;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B1\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0004J\u001a\u0010\u0013\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0005H\u0004J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R(\u0010\u0002\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/getstream/chat/android/state/event/handler/chat/DefaultChatEventHandler;", "Lio/getstream/chat/android/state/event/handler/chat/BaseChatEventHandler;", "channels", "Lkotlinx/coroutines/flow/StateFlow;", "", "", "Lio/getstream/chat/android/models/Channel;", "clientState", "Lio/getstream/chat/android/client/setup/state/ClientState;", "globalState", "Lio/getstream/chat/android/state/plugin/state/global/GlobalState;", "(Lkotlinx/coroutines/flow/StateFlow;Lio/getstream/chat/android/client/setup/state/ClientState;Lio/getstream/chat/android/state/plugin/state/global/GlobalState;)V", "getChannels", "()Lkotlinx/coroutines/flow/StateFlow;", "getClientState", "()Lio/getstream/chat/android/client/setup/state/ClientState;", "addIfChannelIsAbsent", "Lio/getstream/chat/android/state/event/handler/chat/EventHandlingResult;", "channel", "addIfCurrentUserJoinedChannel", "member", "Lio/getstream/chat/android/models/Member;", "handleChannelEvent", "event", "Lio/getstream/chat/android/client/events/HasChannel;", "filter", "Lio/getstream/chat/android/models/FilterObject;", "handleCidEvent", "Lio/getstream/chat/android/client/events/CidEvent;", "cachedChannel", "handleNewMessageEvent", "Lio/getstream/chat/android/client/events/NewMessageEvent;", "removeIfChannelExists", "cid", "removeIfCurrentUserLeftChannel", "Companion", "stream-chat-android-state_release"})
public class DefaultChatEventHandler
extends BaseChatEventHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StateFlow<Map<String, Channel>> channels;
    @NotNull
    private final ClientState clientState;
    @NotNull
    private final GlobalState globalState;
    @Deprecated
    @NotNull
    private static final String SYSTEM_MESSAGE = "system";

    public DefaultChatEventHandler(@NotNull StateFlow<? extends Map<String, Channel>> channels, @NotNull ClientState clientState, @NotNull GlobalState globalState) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Intrinsics.checkNotNullParameter((Object)globalState, (String)"globalState");
        this.channels = channels;
        this.clientState = clientState;
        this.globalState = globalState;
    }

    @NotNull
    protected final StateFlow<Map<String, Channel>> getChannels() {
        return this.channels;
    }

    @NotNull
    protected final ClientState getClientState() {
        return this.clientState;
    }

    @Override
    @NotNull
    public EventHandlingResult handleCidEvent(@NotNull CidEvent event, @NotNull FilterObject filter2, @Nullable Channel cachedChannel) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        CidEvent cidEvent = event;
        return cidEvent instanceof NewMessageEvent ? this.handleNewMessageEvent((NewMessageEvent)event, cachedChannel) : (cidEvent instanceof MemberRemovedEvent ? this.removeIfCurrentUserLeftChannel(event.getCid(), ((MemberRemovedEvent)event).getMember()) : (cidEvent instanceof MemberAddedEvent ? this.addIfCurrentUserJoinedChannel(cachedChannel, ((MemberAddedEvent)event).getMember()) : super.handleCidEvent(event, filter2, cachedChannel)));
    }

    @Override
    @NotNull
    public EventHandlingResult handleChannelEvent(@NotNull HasChannel event, @NotNull FilterObject filter2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        HasChannel hasChannel = event;
        return hasChannel instanceof NotificationMessageNewEvent ? (EventHandlingResult)new EventHandlingResult.WatchAndAdd(((NotificationMessageNewEvent)event).getCid()) : (hasChannel instanceof NotificationAddedToChannelEvent ? (EventHandlingResult)new EventHandlingResult.WatchAndAdd(((NotificationAddedToChannelEvent)event).getCid()) : (hasChannel instanceof NotificationRemovedFromChannelEvent ? this.removeIfCurrentUserLeftChannel(((NotificationRemovedFromChannelEvent)event).getCid(), ((NotificationRemovedFromChannelEvent)event).getMember()) : super.handleChannelEvent(event, filter2)));
    }

    private final EventHandlingResult handleNewMessageEvent(NewMessageEvent event, Channel cachedChannel) {
        return Intrinsics.areEqual((Object)event.getMessage().getType(), (Object)SYSTEM_MESSAGE) ? (EventHandlingResult)EventHandlingResult.Skip.INSTANCE : this.addIfChannelIsAbsent(cachedChannel);
    }

    private final EventHandlingResult removeIfCurrentUserLeftChannel(String cid, Member member) {
        User user = (User)this.globalState.getUser().getValue();
        return !Intrinsics.areEqual((Object)member.getUserId(), (Object)(user != null ? user.getId() : null)) ? (EventHandlingResult)EventHandlingResult.Skip.INSTANCE : this.removeIfChannelExists(cid);
    }

    @NotNull
    protected final EventHandlingResult removeIfChannelExists(@NotNull String cid) {
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        Map channelsMap = (Map)this.channels.getValue();
        return channelsMap == null ? (EventHandlingResult)EventHandlingResult.Skip.INSTANCE : (channelsMap.containsKey(cid) ? (EventHandlingResult)new EventHandlingResult.Remove(cid) : (EventHandlingResult)EventHandlingResult.Skip.INSTANCE);
    }

    @NotNull
    protected final EventHandlingResult addIfCurrentUserJoinedChannel(@Nullable Channel channel, @NotNull Member member) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        User user = (User)this.globalState.getUser().getValue();
        return Intrinsics.areEqual((Object)(user != null ? user.getId() : null), (Object)member.getUserId()) ? this.addIfChannelIsAbsent(channel) : (EventHandlingResult)EventHandlingResult.Skip.INSTANCE;
    }

    @NotNull
    protected final EventHandlingResult addIfChannelIsAbsent(@Nullable Channel channel) {
        Map channelsMap = (Map)this.channels.getValue();
        return channelsMap == null || channel == null ? (EventHandlingResult)EventHandlingResult.Skip.INSTANCE : (channelsMap.containsKey(channel.getCid()) ? (EventHandlingResult)EventHandlingResult.Skip.INSTANCE : (EventHandlingResult)new EventHandlingResult.Add(channel));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/state/event/handler/chat/DefaultChatEventHandler$Companion;", "", "()V", "SYSTEM_MESSAGE", "", "stream-chat-android-state_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

