/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.state.plugin.listener.internal;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.cause.MessageModerationDeletedException;
import io.getstream.chat.android.client.plugin.listeners.DeleteMessageListener;
import io.getstream.chat.android.client.setup.state.ClientState;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.MessageSyncType;
import io.getstream.chat.android.models.SyncStatus;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.state.plugin.logic.channel.internal.ChannelLogic;
import io.getstream.chat.android.state.plugin.logic.channel.thread.internal.ThreadLogic;
import io.getstream.chat.android.state.plugin.logic.internal.LogicRegistry;
import io.getstream.chat.android.state.plugin.state.global.GlobalState;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/state/plugin/listener/internal/DeleteMessageListenerState;", "Lio/getstream/chat/android/client/plugin/listeners/DeleteMessageListener;", "logic", "Lio/getstream/chat/android/state/plugin/logic/internal/LogicRegistry;", "clientState", "Lio/getstream/chat/android/client/setup/state/ClientState;", "globalState", "Lio/getstream/chat/android/state/plugin/state/global/GlobalState;", "(Lio/getstream/chat/android/state/plugin/logic/internal/LogicRegistry;Lio/getstream/chat/android/client/setup/state/ClientState;Lio/getstream/chat/android/state/plugin/state/global/GlobalState;)V", "deleteMessage", "", "message", "Lio/getstream/chat/android/models/Message;", "onMessageDeletePrecondition", "Lio/getstream/chat/android/client/utils/Result;", "messageId", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onMessageDeleteRequest", "onMessageDeleteResult", "originalMessageId", "result", "(Ljava/lang/String;Lio/getstream/chat/android/client/utils/Result;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateMessage", "stream-chat-android-state_release"})
public final class DeleteMessageListenerState
implements DeleteMessageListener {
    @NotNull
    private final LogicRegistry logic;
    @NotNull
    private final ClientState clientState;
    @NotNull
    private final GlobalState globalState;

    public DeleteMessageListenerState(@NotNull LogicRegistry logic, @NotNull ClientState clientState, @NotNull GlobalState globalState) {
        Intrinsics.checkNotNullParameter((Object)logic, (String)"logic");
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Intrinsics.checkNotNullParameter((Object)globalState, (String)"globalState");
        this.logic = logic;
        this.clientState = clientState;
        this.globalState = globalState;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object onMessageDeletePrecondition(@NotNull String messageId, @NotNull Continuation<? super Result<Unit>> $completion) {
        block5: {
            block4: {
                channelLogic = this.logic.channelFromMessageId(messageId);
                v0 = channelLogic;
                if (v0 == null || (v0 = v0.getMessage$stream_chat_android_state_release(messageId)) == null) break block4;
                message = v0;
                $i$a$-let-DeleteMessageListenerState$onMessageDeletePrecondition$2 = false;
                v1 = (User)this.globalState.getUser().getValue();
                if (!Intrinsics.areEqual((Object)message.getUser().getId(), (Object)(v1 != null ? v1.getId() : null)) || message.getSyncStatus() != SyncStatus.FAILED_PERMANENTLY) ** GOTO lbl-1000
                v2 = message.getSyncDescription();
                if ((v2 != null ? v2.getType() : null) == MessageSyncType.FAILED_MODERATION) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = isModerationFailed = false;
                }
                if (isModerationFailed) {
                    this.deleteMessage((Message)message);
                    v4 = (Result)new Result.Failure((ChatError)new ChatError.ThrowableError("Message with failed moderation has been deleted locally: " + messageId, (Throwable)new MessageModerationDeletedException("Message with failed moderation has been deleted locally: " + messageId)));
                } else {
                    v4 = (Result)new Result.Success((Object)Unit.INSTANCE);
                }
                break block5;
            }
            v4 = (Result)new Result.Failure((ChatError)new ChatError.GenericError("No message found with id: " + messageId));
        }
        return v4;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object onMessageDeleteRequest(@NotNull String messageId, @NotNull Continuation<? super Unit> $completion) {
        block4: {
            channelLogic = this.logic.channelFromMessageId(messageId);
            v0 = channelLogic;
            if (v0 == null || (v0 = v0.getMessage$stream_chat_android_state_release(messageId)) == null) break block4;
            message = v0;
            $i$a$-let-DeleteMessageListenerState$onMessageDeleteRequest$2 = false;
            v1 = (User)this.globalState.getUser().getValue();
            if (!Intrinsics.areEqual((Object)message.getUser().getId(), (Object)(v1 != null ? v1.getId() : null)) || message.getSyncStatus() != SyncStatus.FAILED_PERMANENTLY) ** GOTO lbl-1000
            v2 = message.getSyncDescription();
            if ((v2 != null ? v2.getType() : null) == MessageSyncType.FAILED_MODERATION) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = isModerationFailed = false;
            }
            if (isModerationFailed) {
                this.deleteMessage((Message)message);
            } else {
                networkAvailable = this.clientState.isNetworkAvailable();
                var8_8 = new Date();
                var9_9 = networkAvailable == false ? SyncStatus.SYNC_NEEDED : SyncStatus.IN_PROGRESS;
                messageToBeDeleted = Message.copy$default((Message)message, null, null, null, null, null, null, null, null, null, (int)0, null, null, (SyncStatus)var9_9, null, null, null, null, null, null, (Date)var8_8, null, null, null, null, (boolean)false, (boolean)false, null, (boolean)false, null, null, null, (boolean)false, null, null, null, null, (int)-528385, (int)15, null);
                this.updateMessage(messageToBeDeleted);
            }
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object onMessageDeleteResult(@NotNull String originalMessageId, @NotNull Result<Message> result, @NotNull Continuation<? super Unit> $completion) {
        block1: {
            Message message;
            ChannelLogic channelLogic;
            Result<Message> result2;
            block0: {
                result2 = result;
                if (!(result2 instanceof Result.Success)) break block0;
                Object object = ((Result.Success)result).getValue();
                Message $this$onMessageDeleteResult_u24lambda_u242 = (Message)object;
                boolean bl = false;
                $this$onMessageDeleteResult_u24lambda_u242.setSyncStatus(SyncStatus.COMPLETED);
                Message deletedMessage = (Message)object;
                this.updateMessage(deletedMessage);
                break block1;
            }
            if (!(result2 instanceof Result.Failure) || (channelLogic = this.logic.channelFromMessageId(originalMessageId)) == null || (message = channelLogic.getMessage$stream_chat_android_state_release(originalMessageId)) == null) break block1;
            Message originalMessage = message;
            boolean bl = false;
            Message failureMessage = Message.copy$default((Message)originalMessage, null, null, null, null, null, null, null, null, null, (int)0, null, null, (SyncStatus)SyncStatus.SYNC_NEEDED, null, null, null, null, null, null, null, (Date)new Date(), null, null, null, (boolean)false, (boolean)false, null, (boolean)false, null, null, null, (boolean)false, null, null, null, null, (int)-1052673, (int)15, null);
            this.updateMessage(failureMessage);
        }
        return Unit.INSTANCE;
    }

    private final void updateMessage(Message message) {
        block1: {
            ChannelLogic channelLogic = this.logic.channelFromMessage(message);
            if (channelLogic != null) {
                channelLogic.upsertMessage$stream_chat_android_state_release(message);
            }
            ThreadLogic threadLogic = this.logic.threadFromMessage(message);
            if (threadLogic == null) break block1;
            threadLogic.upsertMessage$stream_chat_android_state_release(message);
        }
    }

    private final void deleteMessage(Message message) {
        block1: {
            ChannelLogic channelLogic = this.logic.channelFromMessage(message);
            if (channelLogic != null) {
                channelLogic.deleteMessage$stream_chat_android_state_release(message);
            }
            ThreadLogic threadLogic = this.logic.threadFromMessage(message);
            if (threadLogic == null) break block1;
            threadLogic.deleteMessage$stream_chat_android_state_release(message);
        }
    }
}

