/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.BaseChannelListItemViewHolder;
import com.getstream.sdk.chat.adapter.ChannelListItemAdapter;
import com.getstream.sdk.chat.adapter.ChannelListItemViewHolder;
import com.getstream.sdk.chat.view.channels.ChannelListViewStyle;
import io.getstream.chat.android.client.models.Channel;

public class ChannelViewHolderFactory {
    public static int CHANNEL_GENERAL = 0;

    public int getChannelViewType(Channel channel) {
        return CHANNEL_GENERAL;
    }

    protected void configureHolder(BaseChannelListItemViewHolder holder, ChannelListItemAdapter adapter) {
        holder.setStyle(adapter.getStyle());
        holder.setChannelClickListener(adapter.getChannelClickListener());
        holder.setChannelLongClickListener(adapter.getChannelLongClickListener());
        holder.setUserClickListener(adapter.getUserClickListener());
    }

    public BaseChannelListItemViewHolder createChannelViewHolder(ChannelListItemAdapter adapter, ViewGroup parent, int viewType) {
        Drawable itemSeparatorDrawable;
        ChannelListViewStyle style = adapter.getStyle();
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(style.getChannelPreviewLayout(), parent, false);
        ImageView separator = (ImageView)v.findViewById(R.id.iv_separator);
        if (separator != null && (itemSeparatorDrawable = style.getItemSeparatorDrawable()) != null) {
            separator.setImageDrawable(itemSeparatorDrawable);
        }
        ChannelListItemViewHolder holder = new ChannelListItemViewHolder(v);
        this.configureHolder(holder, adapter);
        return holder;
    }
}

