/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.NonNull;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.CommandMentionListItemAdapter;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.User;
import java.util.ArrayList;
import java.util.List;

public class ReadUsersDialog
extends Dialog {
    List<ChannelUserRead> reads;
    MessageListViewStyle style;

    public ReadUsersDialog(@NonNull Context context) {
        super(context);
        Window window = this.getWindow();
        WindowManager.LayoutParams wlp = window.getAttributes();
        wlp.gravity = 80;
        wlp.flags &= 0xFFFFFFFD;
        window.setAttributes(wlp);
    }

    public ReadUsersDialog setReads(List<ChannelUserRead> reads) {
        this.reads = reads;
        this.init();
        return this;
    }

    public ReadUsersDialog setStyle(MessageListViewStyle style) {
        this.style = style;
        this.init();
        return this;
    }

    public void init() {
        if (this.reads == null || this.style == null) {
            return;
        }
        this.setContentView(R.layout.stream_dialog_read_users);
        ListView lv_read_user = (ListView)this.findViewById(R.id.lv_read_user);
        ArrayList<User> users = new ArrayList<User>();
        for (ChannelUserRead read : this.reads) {
            users.add(read.getUser());
        }
        CommandMentionListItemAdapter reactionAdapter = new CommandMentionListItemAdapter(this.getContext(), users, this.style);
        lv_read_user.setAdapter((ListAdapter)reactionAdapter);
    }
}

