/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.logger.ChatLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReactionListItemAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private final String TAG = ReactionListItemAdapter.class.getSimpleName();
    private Context context;
    private List<String> reactions = new ArrayList<String>();
    private int reactionCount;
    private Map<String, String> reactionTypes;
    private MessageListViewStyle style;

    public ReactionListItemAdapter(Context context, Map<String, Integer> reactionCountMap, Map<String, String> reactionTypes, MessageListViewStyle style) {
        this.context = context;
        this.reactionTypes = reactionTypes;
        this.style = style;
        Set<String> keys = reactionCountMap.keySet();
        this.reactionCount = 0;
        for (String key : keys) {
            this.reactions.add(key.toString());
            this.reactionCount += reactionCountMap.get(key).intValue();
        }
    }

    public MyViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.stream_item_reaction, parent, false);
        MyViewHolder vh = new MyViewHolder(itemView);
        return vh;
    }

    public void onBindViewHolder(MyViewHolder holder, int position) {
        String emoji = "";
        if (position == this.reactions.size()) {
            emoji = String.valueOf(this.reactionCount);
        } else {
            String reaction = this.reactions.get(position);
            try {
                emoji = this.reactionTypes.get(reaction);
            }
            catch (Exception e) {
                ChatLogger.Companion.getInstance().logE((Object)"ReactionListItemAdapter", (Throwable)e);
            }
        }
        holder.tv_emoji.setText((CharSequence)emoji);
        holder.tv_emoji.setTextSize(0, (float)this.style.getReactionViewEmojiSize());
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)holder.tv_emoji.getLayoutParams();
        params.leftMargin = this.style.getReactionViewEmojiMargin();
        params.rightMargin = this.style.getReactionViewEmojiMargin();
        params.topMargin = this.style.getReactionViewEmojiMargin();
        params.bottomMargin = this.style.getReactionViewEmojiMargin();
        holder.tv_emoji.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public int getItemCount() {
        return this.reactions.size() + 1;
    }

    public class MyViewHolder
    extends RecyclerView.ViewHolder {
        public TextView tv_emoji;

        public MyViewHolder(View view) {
            super(view);
            this.tv_emoji = (TextView)view.findViewById(R.id.tv_emoji);
        }
    }
}

