/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.R;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;

public class AttachmentMediaActivity
extends AppCompatActivity {
    public static final String TYPE_KEY = "type";
    public static final String URL_KEY = "url";
    VideoView videoView;
    ImageView iv_audio;
    private final TaggedLogger logger = ChatLogger.Companion.get((Object)"AttachmentMediaActivity");

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.stream_activity_attachment_media);
        this.videoView = (VideoView)this.findViewById(R.id.videoView);
        this.iv_audio = (ImageView)this.findViewById(R.id.iv_audio);
        this.init();
    }

    private void init() {
        Intent intent = this.getIntent();
        String type = intent.getStringExtra(TYPE_KEY);
        String url = intent.getStringExtra(URL_KEY);
        if (TextUtils.isEmpty((CharSequence)type) || TextUtils.isEmpty((CharSequence)url)) {
            this.logger.logE("This file can't be displayed. The TYPE or the URL are null");
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.stream_ui_message_list_attachment_display_error), (int)0).show();
            return;
        }
        if (type.contains("audio")) {
            this.iv_audio.setVisibility(0);
        } else {
            this.iv_audio.setVisibility(8);
        }
        this.playVideo(ChatUI.instance().getUrlSigner().signFileUrl(url));
    }

    public void playVideo(String url) {
        this.videoView.isPlaying();
        this.videoView.setVideoURI(Uri.parse((String)ChatUI.instance().getUrlSigner().signFileUrl(url)));
        this.videoView.setOnPreparedListener(() -> this.videoView.start());
    }
}

