/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view.messageinput;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.inputmethod.InputContentInfoCompat;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.CaptureMediaContract;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.SelectFilesContract;
import com.getstream.sdk.chat.adapter.CommandsAdapter;
import com.getstream.sdk.chat.adapter.FileAttachmentSelectedAdapter;
import com.getstream.sdk.chat.adapter.MediaAttachmentAdapter;
import com.getstream.sdk.chat.adapter.MediaAttachmentSelectedAdapter;
import com.getstream.sdk.chat.adapter.MentionsAdapter;
import com.getstream.sdk.chat.databinding.StreamViewMessageInputBinding;
import com.getstream.sdk.chat.enums.MessageInputType;
import com.getstream.sdk.chat.model.AttachmentMetaData;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.GifEditText;
import com.getstream.sdk.chat.utils.GridSpacingItemDecoration;
import com.getstream.sdk.chat.utils.Utils;
import com.getstream.sdk.chat.utils.extensions.ViewKt;
import com.getstream.sdk.chat.view.messageinput.InputMode;
import com.getstream.sdk.chat.view.messageinput.MessageInputController;
import com.getstream.sdk.chat.view.messageinput.MessageInputStyle;
import io.getstream.chat.android.client.models.Command;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import net.yslibrary.android.keyboardvisibilityevent.KeyboardVisibilityEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0006\u0091\u0001\u0092\u0001\u0093\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u00105\u001a\u00020\t2\u0006\u00106\u001a\u000204J\b\u00107\u001a\u00020\tH\u0002J\b\u00108\u001a\u00020\tH\u0016J\b\u00109\u001a\u00020\tH\u0002J\b\u0010:\u001a\u00020\tH\u0002J\b\u0010;\u001a\u00020\tH\u0002J\b\u0010<\u001a\u00020\tH\u0002J\b\u0010=\u001a\u00020\tH\u0002J\u0014\u0010>\u001a\u00020\t2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@03J\u0014\u0010A\u001a\u00020\t2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C03J\u001d\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020)H\u0000\u00a2\u0006\u0002\bHJ\b\u0010I\u001a\u00020\tH\u0002J\r\u0010J\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bKJ\b\u0010L\u001a\u00020\tH\u0002J\b\u0010M\u001a\u00020\u0013H\u0002J\u0010\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020)H\u0002J\b\u0010P\u001a\u00020\tH\u0014J\b\u0010Q\u001a\u00020\tH\u0014J\b\u0010R\u001a\u00020\tH\u0002J\u000e\u0010S\u001a\u00020\t2\u0006\u00106\u001a\u000204J1\u0010T\u001a\u00020\t2\u0006\u0010U\u001a\u00020)2\u001a\u0010V\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020X\u0012\u0006\u0012\u0004\u0018\u00010)0W03H\u0000\u00a2\u0006\u0002\bYJ\u0018\u0010Z\u001a\u00020\u00132\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u0015H\u0002J\u0015\u0010^\u001a\u00020\t2\u0006\u0010U\u001a\u00020)H\u0000\u00a2\u0006\u0002\b_J%\u0010`\u001a\u00020\t2\u0006\u0010a\u001a\u00020F2\u0006\u0010U\u001a\u00020)2\u0006\u0010b\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bcJA\u0010d\u001a\u00020\t2\u0006\u0010a\u001a\u00020F2\u0006\u0010U\u001a\u00020)2\u0006\u0010b\u001a\u00020\u00132\u001a\u0010V\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020X\u0012\u0006\u0012\u0004\u0018\u00010)0W03H\u0000\u00a2\u0006\u0002\beJ\u000e\u0010f\u001a\u00020\t2\u0006\u0010E\u001a\u00020FJ\u0010\u0010g\u001a\u00020\t2\u0006\u0010h\u001a\u00020\u0013H\u0016J\b\u0010i\u001a\u00020\tH\u0002J\u0006\u0010j\u001a\u00020\tJ\u000e\u0010k\u001a\u00020\t2\u0006\u0010a\u001a\u00020FJ\r\u0010l\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bmJ\r\u0010n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\boJ\u0015\u0010p\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\brJ\r\u0010s\u001a\u00020\tH\u0000\u00a2\u0006\u0002\btJ\u0015\u0010u\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bvJ\r\u0010w\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bxJ\u0015\u0010y\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bzJ\u0010\u0010{\u001a\u00020\t2\b\b\u0001\u0010|\u001a\u00020\u0015J\u0015\u0010}\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b~J\u0018\u0010\u007f\u001a\u00020\t2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0000\u00a2\u0006\u0003\b\u0082\u0001J\u0019\u0010\u0083\u0001\u001a\u00020\t2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0000\u00a2\u0006\u0003\b\u0086\u0001J\u001d\u0010\u0087\u0001\u001a\u00020\t2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@03H\u0000\u00a2\u0006\u0003\b\u0088\u0001J\u001f\u0010\u0089\u0001\u001a\u00020\t2\u000e\u0010\u008a\u0001\u001a\t\u0012\u0005\u0012\u00030\u008b\u000103H\u0000\u00a2\u0006\u0003\b\u008c\u0001J\u0019\u0010\u008d\u0001\u001a\u00020\t2\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0000\u00a2\u0006\u0003\b\u0090\u0001R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0016\u0010/\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0094\u0001"}, d2={"Lcom/getstream/sdk/chat/view/messageinput/MessageInputView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "activityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "", "binding", "Lcom/getstream/sdk/chat/databinding/StreamViewMessageInputBinding;", "commandsAdapter", "Lcom/getstream/sdk/chat/adapter/CommandsAdapter;", "gridLayoutManager", "Landroidx/recyclerview/widget/GridLayoutManager;", "gridSpacingItemDecoration", "Lcom/getstream/sdk/chat/utils/GridSpacingItemDecoration;", "isKeyboardEventListenerInitialized", "", "maxMessageLength", "", "getMaxMessageLength", "()I", "setMaxMessageLength", "(I)V", "mentionsAdapter", "Lcom/getstream/sdk/chat/adapter/MentionsAdapter;", "messageInputController", "Lcom/getstream/sdk/chat/view/messageinput/MessageInputController;", "getMessageInputController", "()Lcom/getstream/sdk/chat/view/messageinput/MessageInputController;", "messageInputController$delegate", "Lkotlin/Lazy;", "messageSendHandler", "Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$MessageSendHandler;", "getMessageSendHandler", "()Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$MessageSendHandler;", "setMessageSendHandler", "(Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$MessageSendHandler;)V", "text", "", "messageText", "getMessageText", "()Ljava/lang/String;", "setMessageText", "(Ljava/lang/String;)V", "selectFilesResultLauncher", "style", "Lcom/getstream/sdk/chat/view/messageinput/MessageInputStyle;", "typeListeners", "", "Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$TypeListener;", "addTypeListener", "typeListener", "applyStyle", "clearFocus", "configAttachmentUI", "configInputEditText", "configInputEditTextError", "configOnClickListener", "configSendButtonEnableState", "configureCommands", "commands", "Lio/getstream/chat/android/client/models/Command;", "configureMembers", "members", "Lio/getstream/chat/android/client/models/Member;", "editMessage", "oldMessage", "Lio/getstream/chat/android/client/models/Message;", "newMessageText", "editMessage$stream_chat_android_release", "handleSentMessage", "hideAttachmentsMenu", "hideAttachmentsMenu$stream_chat_android_release", "initSendMessage", "isMessageTooLong", "keyStroke", "inputMessage", "onAttachedToWindow", "onDetachedFromWindow", "onSendMessage", "removeTypeListener", "sendAttachments", "message", "attachmentFilesWithMimeType", "Lkotlin/Pair;", "Ljava/io/File;", "sendAttachments$stream_chat_android_release", "sendGifFromKeyboard", "inputContentInfo", "Landroidx/core/view/inputmethod/InputContentInfoCompat;", "flags", "sendTextMessage", "sendTextMessage$stream_chat_android_release", "sendToThread", "parentMessage", "alsoSendToChannel", "sendToThread$stream_chat_android_release", "sendToThreadWithAttachments", "sendToThreadWithAttachments$stream_chat_android_release", "setEditMode", "setEnabled", "enabled", "setKeyboardEventListener", "setNormalMode", "setThreadMode", "showAttachmentsMenu", "showAttachmentsMenu$stream_chat_android_release", "showCameraOptions", "showCameraOptions$stream_chat_android_release", "showCameraPermissions", "shouldBeVisible", "showCameraPermissions$stream_chat_android_release", "showFileAttachments", "showFileAttachments$stream_chat_android_release", "showLoadingTotalAttachments", "showLoadingTotalAttachments$stream_chat_android_release", "showMediaAttachments", "showMediaAttachments$stream_chat_android_release", "showMediaPermissions", "showMediaPermissions$stream_chat_android_release", "showMessage", "messageResId", "showOpenAttachmentsMenuButton", "showOpenAttachmentsMenuButton$stream_chat_android_release", "showSelectedFileAttachments", "selectedFileAttachmentAdapter", "Lcom/getstream/sdk/chat/adapter/FileAttachmentSelectedAdapter;", "showSelectedFileAttachments$stream_chat_android_release", "showSelectedMediaAttachments", "selectedMediaAttachmentAdapter", "Lcom/getstream/sdk/chat/adapter/MediaAttachmentSelectedAdapter;", "showSelectedMediaAttachments$stream_chat_android_release", "showSuggestedCommand", "showSuggestedCommand$stream_chat_android_release", "showSuggestedMentions", "users", "Lio/getstream/chat/android/client/models/User;", "showSuggestedMentions$stream_chat_android_release", "showTotalMediaAttachments", "totalMediaAttachmentAdapter", "Lcom/getstream/sdk/chat/adapter/MediaAttachmentAdapter;", "showTotalMediaAttachments$stream_chat_android_release", "LauncherRequestsKeys", "MessageSendHandler", "TypeListener", "stream-chat-android_release"})
public final class MessageInputView
extends RelativeLayout {
    @NotNull
    private final StreamViewMessageInputBinding binding;
    @NotNull
    private final MessageInputStyle style;
    @NotNull
    private final GridLayoutManager gridLayoutManager;
    @NotNull
    private final GridSpacingItemDecoration gridSpacingItemDecoration;
    private boolean isKeyboardEventListenerInitialized;
    private int maxMessageLength;
    @NotNull
    private MessageSendHandler messageSendHandler;
    @Nullable
    private ActivityResultLauncher<Unit> activityResultLauncher;
    @Nullable
    private ActivityResultLauncher<Unit> selectFilesResultLauncher;
    @NotNull
    private final CommandsAdapter commandsAdapter;
    @NotNull
    private final MentionsAdapter mentionsAdapter;
    @NotNull
    private List<? extends TypeListener> typeListeners;
    @NotNull
    private final Lazy messageInputController$delegate;

    /*
     * WARNING - void declaration
     */
    public MessageInputView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void $this$isVisible$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        StreamViewMessageInputBinding streamViewMessageInputBinding = StreamViewMessageInputBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamViewMessageInputBinding, (String)"inflate(LayoutInflater.from(context), this, true)");
        this.binding = streamViewMessageInputBinding;
        this.style = new MessageInputStyle(context, attrs);
        this.gridLayoutManager = new GridLayoutManager(context, 4, 1, false);
        this.gridSpacingItemDecoration = new GridSpacingItemDecoration(4, 2, false);
        this.maxMessageLength = Integer.MAX_VALUE;
        this.messageSendHandler = new MessageSendHandler(){

            public void sendMessage(@NotNull String messageText) {
                Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
                throw new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }

            public void sendMessageWithAttachments(@NotNull String message, @NotNull List<? extends Pair<? extends File, String>> attachmentsFilesWithMimeType) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter(attachmentsFilesWithMimeType, (String)"attachmentsFilesWithMimeType");
                throw new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }

            public void sendToThread(@NotNull Message parentMessage, @NotNull String messageText, boolean alsoSendToChannel) {
                Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
                Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
                throw new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }

            public void sendToThreadWithAttachments(@NotNull Message parentMessage, @NotNull String message, boolean alsoSendToChannel, @NotNull List<? extends Pair<? extends File, String>> attachmentsFiles) {
                Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter(attachmentsFiles, (String)"attachmentsFiles");
                throw new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }

            public void editMessage(@NotNull Message oldMessage, @NotNull String newMessageText) {
                Intrinsics.checkNotNullParameter((Object)oldMessage, (String)"oldMessage");
                Intrinsics.checkNotNullParameter((Object)newMessageText, (String)"newMessageText");
                throw new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }
        };
        this.commandsAdapter = new CommandsAdapter(this.style, (Function1<? super Command, Unit>)((Function1)new Function1<Command, Unit>(this){
            final /* synthetic */ MessageInputView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Command it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MessageInputView.access$getMessageInputController(this.this$0).onCommandSelected$stream_chat_android_release(it);
            }
        }));
        this.mentionsAdapter = new MentionsAdapter(this.style, (Function1<? super User, Unit>)((Function1)new Function1<User, Unit>(this){
            final /* synthetic */ MessageInputView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull User it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MessageInputView.access$getMessageInputController(this.this$0).onUserSelected$stream_chat_android_release(this.this$0.getMessageText(), it);
            }
        }));
        boolean bl = false;
        this.typeListeners = CollectionsKt.emptyList();
        this.messageInputController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MessageInputController>(this){
            final /* synthetic */ MessageInputView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MessageInputController invoke() {
                return new MessageInputController(MessageInputView.access$getBinding$p(this.this$0), this.this$0, MessageInputView.access$getStyle$p(this.this$0));
            }
        }));
        this.applyStyle();
        ImageView imageView = new ImageView[]{(RecyclerView.Adapter)this.commandsAdapter, (RecyclerView.Adapter)this.mentionsAdapter};
        this.binding.rvSuggestions.setAdapter((RecyclerView.Adapter)new ConcatAdapter((RecyclerView.Adapter[])imageView));
        imageView = this.binding.sendButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.sendButton");
        imageView = (View)imageView;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.configOnClickListener();
        this.configInputEditText();
        this.configAttachmentUI();
    }

    @NotNull
    public final String getMessageText() {
        return this.binding.messageTextInput.getText().toString();
    }

    public final void setMessageText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.binding.messageTextInput.requestFocus();
        this.binding.messageTextInput.setText(text);
        this.binding.messageTextInput.setSelection(this.binding.messageTextInput.getText().length());
    }

    public final int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public final void setMaxMessageLength(int n) {
        this.maxMessageLength = n;
    }

    @NotNull
    public final MessageSendHandler getMessageSendHandler() {
        return this.messageSendHandler;
    }

    public final void setMessageSendHandler(@NotNull MessageSendHandler messageSendHandler2) {
        Intrinsics.checkNotNullParameter((Object)messageSendHandler2, (String)"<set-?>");
        this.messageSendHandler = messageSendHandler2;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        AppCompatActivity appCompatActivity = ViewKt.getActivity((View)((View)this));
        ActivityResultRegistry activityResultRegistry = appCompatActivity == null ? null : appCompatActivity.getActivityResultRegistry();
        appCompatActivity = activityResultRegistry;
        this.activityResultLauncher = appCompatActivity == null ? null : appCompatActivity.register("capture_media_request_key", (ActivityResultContract)new CaptureMediaContract(), arg_0 -> MessageInputView.onAttachedToWindow$lambda-1(this, arg_0));
        appCompatActivity = activityResultRegistry;
        this.selectFilesResultLauncher = appCompatActivity == null ? null : appCompatActivity.register("select_files_request_key", (ActivityResultContract)new SelectFilesContract(), arg_0 -> MessageInputView.onAttachedToWindow$lambda-2(this, arg_0));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ActivityResultLauncher<Unit> activityResultLauncher = this.activityResultLauncher;
        if (activityResultLauncher != null) {
            activityResultLauncher.unregister();
        }
        activityResultLauncher = this.selectFilesResultLauncher;
        if (activityResultLauncher != null) {
            activityResultLauncher.unregister();
        }
    }

    public final void addTypeListener(@NotNull TypeListener typeListener) {
        Intrinsics.checkNotNullParameter((Object)typeListener, (String)"typeListener");
        this.typeListeners = CollectionsKt.plus((Collection)this.typeListeners, (Object)typeListener);
    }

    public final void removeTypeListener(@NotNull TypeListener typeListener) {
        Intrinsics.checkNotNullParameter((Object)typeListener, (String)"typeListener");
        this.typeListeners = CollectionsKt.minus((Iterable)this.typeListeners, (Object)typeListener);
    }

    private final MessageInputController getMessageInputController() {
        Lazy lazy = this.messageInputController$delegate;
        boolean bl = false;
        return (MessageInputController)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void applyStyle() {
        void $this$isVisible$iv;
        new ActivityResultContracts.GetContent();
        Object object = this.binding.ivOpenAttach;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.ivOpenAttach");
        object = (View)object;
        boolean value$iv = this.style.isShowAttachmentButton();
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        this.binding.ivOpenAttach.setImageDrawable(this.style.getAttachmentButtonIcon(false));
        this.binding.ivOpenAttach.getLayoutParams().width = this.style.getAttachmentButtonWidth();
        this.binding.ivOpenAttach.getLayoutParams().height = this.style.getAttachmentButtonHeight();
        this.binding.btnClose.setBackground(this.style.getAttachmentCloseButtonBackground());
        this.binding.sendButton.setImageDrawable(this.style.getInputButtonIcon(false));
        this.binding.sendButton.getLayoutParams().width = this.style.getInputButtonWidth();
        this.binding.sendButton.getLayoutParams().height = this.style.getInputButtonHeight();
        this.binding.cbSendAlsoToChannel.setTextColor(this.style.getInputSendAlsoToChannelTextColor());
        this.binding.llComposer.setBackground(this.style.getInputBackground());
        TextStyle textStyle = this.style.getInputText();
        object = this.binding.messageTextInput;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.messageTextInput");
        textStyle.apply((TextView)object);
        this.binding.messageTextInput.setHint(this.style.getInputHint());
        this.binding.messageTextInput.setVerticalScrollBarEnabled(this.style.getInputScrollbarEnabled());
        this.binding.messageTextInput.setScrollbarFadingEnabled(this.style.getInputScrollbarFadingEnabled());
        TextStyle textStyle2 = this.style.getInputBackgroundText();
        object = this.binding.tvTitle;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.tvTitle");
        textStyle2.apply((TextView)object);
        TextStyle textStyle3 = this.style.getInputBackgroundText();
        object = this.binding.tvCommand;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.tvCommand");
        textStyle3.apply((TextView)object);
        TextStyle textStyle4 = this.style.getInputBackgroundText();
        object = this.binding.tvUploadPhotoVideo;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.tvUploadPhotoVideo");
        textStyle4.apply((TextView)object);
        TextStyle textStyle5 = this.style.getInputBackgroundText();
        object = this.binding.tvUploadFile;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.tvUploadFile");
        textStyle5.apply((TextView)object);
        TextStyle textStyle6 = this.style.getInputBackgroundText();
        object = this.binding.tvUploadCamera;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.tvUploadCamera");
        textStyle6.apply((TextView)object);
        this.binding.rvMedia.setLayoutManager((RecyclerView.LayoutManager)this.gridLayoutManager);
        this.binding.rvMedia.addItemDecoration((RecyclerView.ItemDecoration)this.gridSpacingItemDecoration);
        this.binding.rvSuggestions.setBackground(this.style.getSuggestionsBackground());
    }

    private final void configOnClickListener() {
        this.binding.sendButton.setOnClickListener(arg_0 -> MessageInputView.configOnClickListener$lambda-3(this, arg_0));
        this.binding.ivOpenAttach.setOnClickListener(arg_0 -> MessageInputView.configOnClickListener$lambda-4(this, arg_0));
    }

    private final void configInputEditText() {
        this.binding.messageTextInput.setOnFocusChangeListener((arg_0, arg_1) -> MessageInputView.configInputEditText$lambda-5(this, arg_0, arg_1));
        GifEditText gifEditText = this.binding.messageTextInput;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gifEditText), (String)"binding.messageTextInput");
        TextView $this$doAfterTextChanged$iv = (TextView)gifEditText;
        boolean $i$f$doAfterTextChanged = false;
        TextView $this$addTextChangedListener$iv$iv = $this$doAfterTextChanged$iv;
        boolean $i$f$addTextChangedListener = false;
        TextWatcher textWatcher$iv$iv = new TextWatcher(this){
            final /* synthetic */ MessageInputView this$0;
            {
                this.this$0 = messageInputView;
            }

            public void afterTextChanged(@Nullable Editable s) {
                String string2;
                Editable editable = s;
                boolean bl = false;
                Editable editable2 = editable;
                MessageInputView.access$keyStroke(this.this$0, editable2 == null ? "" : ((string2 = editable2.toString()) == null ? "" : string2));
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                int n = after;
                int n2 = count;
                int n3 = start;
                CharSequence $noName_0 = text;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                int n = count;
                int n2 = before;
                int n3 = start;
                CharSequence $noName_0 = text;
            }
        };
        $this$addTextChangedListener$iv$iv.addTextChangedListener(textWatcher$iv$iv);
        this.binding.messageTextInput.setCallback((arg_0, arg_1, arg_2) -> MessageInputView.configInputEditText$lambda-7(this, arg_0, arg_1, arg_2));
    }

    /*
     * WARNING - void declaration
     */
    private final void keyStroke(String inputMessage) {
        void $this$isVisible$iv;
        TypeListener p0;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        this.getMessageInputController().checkCommandsOrMentions$stream_chat_android_release(this.getMessageText());
        ImageView imageView = this.binding.sendButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.sendButton");
        imageView = (View)imageView;
        CharSequence charSequence = inputMessage;
        boolean bl = false;
        boolean $this$whenTrue$iv = !StringsKt.isBlank((CharSequence)charSequence);
        boolean $i$f$whenTrue = false;
        boolean bl2 = $this$whenTrue$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean it$iv = bl2;
        boolean bl5 = false;
        if ($this$whenTrue$iv) {
            boolean bl6 = false;
            $this$forEach$iv = this.typeListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (TypeListener)element$iv;
                boolean bl7 = false;
                p0.onKeystroke();
            }
        }
        boolean $this$whenFalse$iv = bl2;
        boolean $i$f$whenFalse = false;
        bl2 = $this$whenFalse$iv;
        bl3 = false;
        bl4 = false;
        it$iv = bl2;
        boolean bl8 = false;
        if (!$this$whenFalse$iv) {
            boolean bl9 = false;
            $this$forEach$iv = this.typeListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (TypeListener)element$iv;
                boolean bl10 = false;
                p0.onStopTyping();
            }
        }
        boolean value$iv = bl2;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        this.configSendButtonEnableState();
        this.configInputEditTextError();
    }

    private final void configInputEditTextError() {
        if (this.isMessageTooLong()) {
            GifEditText gifEditText = this.binding.messageTextInput;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = this.getContext().getString(R.string.stream_message_length_exceeded_error);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.stream_message_length_exceeded_error)");
            Object[] objectArray = new Object[]{this.maxMessageLength};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            gifEditText.setError(string3);
        } else {
            this.binding.messageTextInput.setError(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void configSendButtonEnableState() {
        attachments = this.getMessageInputController().getSelectedAttachments();
        var3_2 = this.getMessageText();
        var4_3 = false;
        if (StringsKt.isBlank((CharSequence)var3_2) == false) ** GOTO lbl-1000
        var3_2 = attachments;
        var4_3 = false;
        if (var3_2.isEmpty() == false) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        notEmptyMessage = v0;
        var3_2 = this.binding.sendButton;
        Intrinsics.checkNotNullExpressionValue((Object)var3_2, (String)"binding.sendButton");
        var3_2 = (View)var3_2;
        value$iv = notEmptyMessage != false && this.isMessageTooLong() == false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv != false ? 0 : 8);
    }

    private final boolean isMessageTooLong() {
        return this.getMessageText().length() > this.maxMessageLength;
    }

    private final void configAttachmentUI() {
        this.binding.mediaComposer.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 1, 0, false));
        this.binding.btnClose.setOnClickListener(arg_0 -> MessageInputView.configAttachmentUI$lambda-11(this, arg_0));
        this.binding.selectMedia.setOnClickListener(arg_0 -> MessageInputView.configAttachmentUI$lambda-12(this, arg_0));
        this.binding.selectCamera.setOnClickListener(arg_0 -> MessageInputView.configAttachmentUI$lambda-13(this, arg_0));
        this.binding.selectFile.setOnClickListener(arg_0 -> MessageInputView.configAttachmentUI$lambda-14(this, arg_0));
    }

    public final void showCameraOptions$stream_chat_android_release() {
        ActivityResultLauncher<Unit> activityResultLauncher = this.activityResultLauncher;
        if (activityResultLauncher != null) {
            activityResultLauncher.launch((Object)Unit.INSTANCE);
        }
    }

    private final void setKeyboardEventListener() {
        KeyboardVisibilityEvent.setEventListener((Activity)((Activity)ViewKt.getActivity((View)((View)this))), arg_0 -> MessageInputView.setKeyboardEventListener$lambda-15(this, arg_0));
    }

    public void setEnabled(boolean enabled) {
        this.binding.messageTextInput.setEnabled(true);
    }

    public void clearFocus() {
        this.binding.messageTextInput.clearFocus();
    }

    public final void configureMembers(@NotNull List<Member> members) {
        Intrinsics.checkNotNullParameter(members, (String)"members");
        this.getMessageInputController().setMembers$stream_chat_android_release(members);
    }

    public final void configureCommands(@NotNull List<Command> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        this.getMessageInputController().setChannelCommands$stream_chat_android_release(commands);
    }

    private final void onSendMessage() {
        this.getMessageInputController().onSendMessageClick$stream_chat_android_release(this.getMessageText());
        this.handleSentMessage();
    }

    public final void sendTextMessage$stream_chat_android_release(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messageSendHandler.sendMessage(message);
    }

    public final void sendAttachments$stream_chat_android_release(@NotNull String message, @NotNull List<? extends Pair<? extends File, String>> attachmentFilesWithMimeType) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attachmentFilesWithMimeType, (String)"attachmentFilesWithMimeType");
        this.messageSendHandler.sendMessageWithAttachments(message, attachmentFilesWithMimeType);
    }

    public final void sendToThread$stream_chat_android_release(@NotNull Message parentMessage, @NotNull String message, boolean alsoSendToChannel) {
        Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messageSendHandler.sendToThread(parentMessage, message, alsoSendToChannel);
    }

    public final void sendToThreadWithAttachments$stream_chat_android_release(@NotNull Message parentMessage, @NotNull String message, boolean alsoSendToChannel, @NotNull List<? extends Pair<? extends File, String>> attachmentFilesWithMimeType) {
        Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attachmentFilesWithMimeType, (String)"attachmentFilesWithMimeType");
        this.messageSendHandler.sendToThreadWithAttachments(parentMessage, message, alsoSendToChannel, attachmentFilesWithMimeType);
    }

    public final void editMessage$stream_chat_android_release(@NotNull Message oldMessage, @NotNull String newMessageText) {
        Intrinsics.checkNotNullParameter((Object)oldMessage, (String)"oldMessage");
        Intrinsics.checkNotNullParameter((Object)newMessageText, (String)"newMessageText");
        this.messageSendHandler.editMessage(oldMessage, newMessageText);
    }

    private final void handleSentMessage() {
        Iterable $this$forEach$iv = this.typeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeListener p0 = (TypeListener)element$iv;
            boolean bl = false;
            p0.onStopTyping();
        }
        this.initSendMessage();
    }

    private final void initSendMessage() {
        this.getMessageInputController().initSendMessage$stream_chat_android_release();
        this.binding.messageTextInput.setText("");
        this.binding.sendButton.setEnabled(true);
    }

    private final boolean sendGifFromKeyboard(InputContentInfoCompat inputContentInfo, int flags) {
        if (Build.VERSION.SDK_INT >= 29 && (flags & 1) != 0) {
            try {
                inputContentInfo.requestPermission();
            }
            catch (Exception e) {
                return false;
            }
        }
        List list = inputContentInfo.getContentUri().getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"inputContentInfo.contentUri.pathSegments");
        String string2 = (String)CollectionsKt.lastOrNull((List)list);
        String title = string2 == null ? "attachment" : string2;
        this.getMessageInputController().setSelectedAttachments(SetsKt.setOf((Object)new AttachmentMetaData(inputContentInfo.getContentUri(), "image", "image/gif", title, null, 16, null)));
        this.binding.messageTextInput.setText("");
        this.onSendMessage();
        return true;
    }

    public final void showSuggestedMentions$stream_chat_android_release(@NotNull List<User> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        this.mentionsAdapter.submitList(users);
    }

    public final void showSuggestedCommand$stream_chat_android_release(@NotNull List<Command> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        this.commandsAdapter.submitList(commands);
    }

    public final void setNormalMode() {
        this.getMessageInputController().setInputMode$stream_chat_android_release(InputMode.Normal.INSTANCE);
    }

    public final void setThreadMode(@NotNull Message parentMessage) {
        Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
        this.getMessageInputController().setInputMode$stream_chat_android_release(new InputMode.Thread(parentMessage));
    }

    public final void setEditMode(@NotNull Message oldMessage) {
        Intrinsics.checkNotNullParameter((Object)oldMessage, (String)"oldMessage");
        this.getMessageInputController().setInputMode$stream_chat_android_release(new InputMode.Edit(oldMessage));
    }

    public final void showSelectedMediaAttachments$stream_chat_android_release(@NotNull MediaAttachmentSelectedAdapter selectedMediaAttachmentAdapter) {
        ListView $this$isVisible$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)selectedMediaAttachmentAdapter), (String)"selectedMediaAttachmentAdapter");
        this.binding.mediaComposer.setAdapter((RecyclerView.Adapter)selectedMediaAttachmentAdapter);
        RecyclerView recyclerView = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.mediaComposer");
        recyclerView = (View)recyclerView;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$isVisible$iv = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.fileComposer");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.binding.fileComposer.setAdapter(null);
    }

    public final void showSelectedFileAttachments$stream_chat_android_release(@NotNull FileAttachmentSelectedAdapter selectedFileAttachmentAdapter) {
        RecyclerView $this$isVisible$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)selectedFileAttachmentAdapter), (String)"selectedFileAttachmentAdapter");
        this.binding.fileComposer.setAdapter((ListAdapter)selectedFileAttachmentAdapter);
        ListView listView = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"binding.fileComposer");
        listView = (View)listView;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$isVisible$iv = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.mediaComposer");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.binding.mediaComposer.setAdapter(null);
    }

    public final void showTotalMediaAttachments$stream_chat_android_release(@NotNull MediaAttachmentAdapter totalMediaAttachmentAdapter) {
        Intrinsics.checkNotNullParameter((Object)((Object)totalMediaAttachmentAdapter), (String)"totalMediaAttachmentAdapter");
        this.binding.rvMedia.setAdapter((RecyclerView.Adapter)totalMediaAttachmentAdapter);
    }

    public final void showMediaAttachments$stream_chat_android_release() {
        ListView $this$isVisible$iv;
        RecyclerView recyclerView = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.mediaComposer");
        recyclerView = (View)recyclerView;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$isVisible$iv = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.fileComposer");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
    }

    public final void showFileAttachments$stream_chat_android_release() {
        ListView $this$isVisible$iv;
        RecyclerView recyclerView = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.mediaComposer");
        recyclerView = (View)recyclerView;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        $this$isVisible$iv = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.fileComposer");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = true;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
    }

    public final void showMediaPermissions$stream_chat_android_release(boolean shouldBeVisible) {
        ImageView imageView = this.binding.ivMediaPermission;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivMediaPermission");
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(shouldBeVisible ? 0 : 8);
    }

    public final void showCameraPermissions$stream_chat_android_release(boolean shouldBeVisible) {
        ImageView imageView = this.binding.ivCameraPermission;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivCameraPermission");
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(shouldBeVisible ? 0 : 8);
    }

    public final void hideAttachmentsMenu$stream_chat_android_release() {
        ConstraintLayout $this$isVisible$iv;
        ConstraintLayout constraintLayout = this.binding.clTitle;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.clTitle");
        constraintLayout = (View)constraintLayout;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        $this$isVisible$iv = this.binding.clAddFile;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.clAddFile");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        $this$isVisible$iv = this.binding.clSelectPhoto;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.clSelectPhoto");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.binding.getRoot().setBackgroundResource(0);
    }

    public final void showAttachmentsMenu$stream_chat_android_release() {
        this.binding.getRoot().setBackground(this.style.getAttachmentsMenuBackground());
        this.binding.clTitle.setVisibility(0);
        this.binding.btnClose.setVisibility(0);
        this.binding.clAddFile.setVisibility(8);
        this.binding.clSelectPhoto.setVisibility(8);
    }

    public final void showLoadingTotalAttachments$stream_chat_android_release(boolean shouldBeVisible) {
        ProgressBar progressBar = this.binding.progressBarFileLoader;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.progressBarFileLoader");
        View $this$isVisible$iv = (View)progressBar;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(shouldBeVisible ? 0 : 8);
    }

    public final void showOpenAttachmentsMenuButton$stream_chat_android_release(boolean shouldBeVisible) {
        ImageView imageView = this.binding.ivOpenAttach;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivOpenAttach");
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(shouldBeVisible ? 0 : 8);
    }

    public final void showMessage(@StringRes int messageResId) {
        Toast.makeText((Context)this.getContext(), (int)messageResId, (int)0).show();
    }

    private static final void onAttachedToWindow$lambda-1(MessageInputView this$0, File file) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        File file2 = file;
        if (file2 != null) {
            File file3 = file2;
            boolean bl = false;
            boolean bl2 = false;
            File it = file3;
            boolean bl3 = false;
            MessageInputController messageInputController2 = this$0.getMessageInputController();
            Context context = this$0.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            messageInputController2.onFileCaptured$stream_chat_android_release(context, it);
        }
    }

    private static final void onAttachedToWindow$lambda-2(MessageInputView this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        MessageInputController messageInputController2 = this$0.getMessageInputController();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        messageInputController2.onFilesSelected$stream_chat_android_release(it);
    }

    private static final void configOnClickListener$lambda-3(MessageInputView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onSendMessage();
    }

    private static final void configOnClickListener$lambda-4(MessageInputView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getMessageInputController().onClickOpenAttachmentSelectionMenu$stream_chat_android_release(MessageInputType.ADD_FILE);
    }

    private static final void configInputEditText$lambda-5(MessageInputView this$0, View $noName_0, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (hasFocus) {
            Utils.showSoftKeyboard((View)((View)this$0));
        } else {
            Utils.hideSoftKeyboard((View)((View)this$0));
        }
        if (!this$0.isKeyboardEventListenerInitialized) {
            this$0.isKeyboardEventListenerInitialized = true;
            this$0.setKeyboardEventListener();
        }
    }

    private static final boolean configInputEditText$lambda-7(MessageInputView this$0, InputContentInfoCompat inputContentInfo, int flags, Bundle $noName_2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)inputContentInfo, (String)"inputContentInfo");
        return this$0.sendGifFromKeyboard(inputContentInfo, flags);
    }

    private static final void configAttachmentUI$lambda-11(MessageInputView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getMessageInputController().onClickCloseAttachmentSelectionMenu$stream_chat_android_release();
        Utils.hideSoftKeyboard((View)((View)this$0));
    }

    private static final void configAttachmentUI$lambda-12(MessageInputView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getMessageInputController().onClickOpenMediaSelectView();
    }

    private static final void configAttachmentUI$lambda-13(MessageInputView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getMessageInputController().onCameraClick();
    }

    private static final void configAttachmentUI$lambda-14(MessageInputView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ActivityResultLauncher<Unit> activityResultLauncher = this$0.selectFilesResultLauncher;
        if (activityResultLauncher != null) {
            activityResultLauncher.launch((Object)Unit.INSTANCE);
        }
    }

    private static final void setKeyboardEventListener$lambda-15(MessageInputView this$0, boolean isOpen) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!isOpen) {
            this$0.binding.messageTextInput.clearFocus();
        }
    }

    public static final /* synthetic */ void access$keyStroke(MessageInputView $this, String inputMessage) {
        $this.keyStroke(inputMessage);
    }

    public static final /* synthetic */ MessageInputController access$getMessageInputController(MessageInputView $this) {
        return $this.getMessageInputController();
    }

    public static final /* synthetic */ StreamViewMessageInputBinding access$getBinding$p(MessageInputView $this) {
        return $this.binding;
    }

    public static final /* synthetic */ MessageInputStyle access$getStyle$p(MessageInputView $this) {
        return $this.style;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$LauncherRequestsKeys;", "", "()V", "CAPTURE_MEDIA", "", "SELECT_FILES", "stream-chat-android_release"})
    private static final class LauncherRequestsKeys {
        @NotNull
        public static final LauncherRequestsKeys INSTANCE = new LauncherRequestsKeys();
        @NotNull
        public static final String CAPTURE_MEDIA = "capture_media_request_key";
        @NotNull
        public static final String SELECT_FILES = "select_files_request_key";

        private LauncherRequestsKeys() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$TypeListener;", "", "onKeystroke", "", "onStopTyping", "stream-chat-android_release"})
    public static interface TypeListener {
        public void onKeystroke();

        public void onStopTyping();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H&J,\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00072\u001a\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000e0\rH&J \u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H&J<\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u001a\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000e0\rH&\u00a8\u0006\u0015"}, d2={"Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$MessageSendHandler;", "", "editMessage", "", "oldMessage", "Lio/getstream/chat/android/client/models/Message;", "newMessageText", "", "sendMessage", "messageText", "sendMessageWithAttachments", "message", "attachmentsFilesWithMimeType", "", "Lkotlin/Pair;", "Ljava/io/File;", "sendToThread", "parentMessage", "alsoSendToChannel", "", "sendToThreadWithAttachments", "stream-chat-android_release"})
    public static interface MessageSendHandler {
        public void sendMessage(@NotNull String var1);

        public void sendMessageWithAttachments(@NotNull String var1, @NotNull List<? extends Pair<? extends File, String>> var2);

        public void sendToThread(@NotNull Message var1, @NotNull String var2, boolean var3);

        public void sendToThreadWithAttachments(@NotNull Message var1, @NotNull String var2, boolean var3, @NotNull List<? extends Pair<? extends File, String>> var4);

        public void editMessage(@NotNull Message var1, @NotNull String var2);
    }
}

