/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.message;

import android.content.Context;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.MessageListItemPayloadDiff;
import com.getstream.sdk.chat.adapter.viewholder.message.BaseMessageListItemViewHolder;
import com.getstream.sdk.chat.databinding.StreamItemDateSeparatorBinding;
import com.getstream.sdk.chat.enums.Dates;
import com.getstream.sdk.chat.enums.DatesKt;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/message/DateSeparatorViewHolder;", "Lcom/getstream/sdk/chat/adapter/viewholder/message/BaseMessageListItemViewHolder;", "Lcom/getstream/sdk/chat/adapter/MessageListItem$DateSeparatorItem;", "parent", "Landroid/view/ViewGroup;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemDateSeparatorBinding;", "(Landroid/view/ViewGroup;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/databinding/StreamItemDateSeparatorBinding;)V", "applyStyle", "", "bind", "messageListItem", "diff", "Lcom/getstream/sdk/chat/adapter/MessageListItemPayloadDiff;", "configDate", "configSeparatorLineWidth", "view", "Landroid/view/View;", "stream-chat-android_release"})
public final class DateSeparatorViewHolder
extends BaseMessageListItemViewHolder<MessageListItem.DateSeparatorItem> {
    @NotNull
    private final MessageListViewStyle style;
    @NotNull
    private final StreamItemDateSeparatorBinding binding;

    public DateSeparatorViewHolder(@NotNull ViewGroup parent, @NotNull MessageListViewStyle style, @NotNull StreamItemDateSeparatorBinding binding) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        ConstraintLayout constraintLayout = binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
        super((View)constraintLayout);
        this.style = style;
        this.binding = binding;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ DateSeparatorViewHolder(ViewGroup viewGroup, MessageListViewStyle messageListViewStyle, StreamItemDateSeparatorBinding streamItemDateSeparatorBinding, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            void $this$inflater$iv;
            ViewGroup viewGroup2 = viewGroup;
            boolean $i$f$getInflater = false;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$inflater$iv.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(context)");
            StreamItemDateSeparatorBinding streamItemDateSeparatorBinding2 = StreamItemDateSeparatorBinding.inflate(layoutInflater, viewGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)streamItemDateSeparatorBinding2, (String)"class DateSeparatorViewHolder(\n    parent: ViewGroup,\n    private val style: MessageListViewStyle,\n    private val binding: StreamItemDateSeparatorBinding =\n        StreamItemDateSeparatorBinding.inflate(parent.inflater, parent, false)\n) : BaseMessageListItemViewHolder<DateSeparatorItem>(binding.root) {\n\n    override fun bind(messageListItem: DateSeparatorItem, diff: MessageListItemPayloadDiff) {\n        configDate(messageListItem)\n        applyStyle()\n    }\n\n    private fun configDate(messageListItem: DateSeparatorItem) {\n        val messageDate = messageListItem.date.time\n        val now = Date()\n        val humanizedDate =\n            if (now.time - messageDate < 60 * 1000) {\n                Dates.JUST_NOW.label\n            } else {\n                DateUtils.getRelativeTimeSpanString(messageDate)\n            }\n        binding.tvDate.text = humanizedDate\n    }\n\n    private fun applyStyle() {\n        style.dateSeparatorDateText.apply(binding.tvDate)\n\n        if (style.dateSeparatorLineDrawable != -1) {\n            val drawable = style.dateSeparatorLineDrawable\n            binding.ivLineRight.background = ContextCompat.getDrawable(context, drawable)\n            binding.ivLineLeft.background = ContextCompat.getDrawable(context, drawable)\n        } else {\n            binding.ivLineRight.setBackgroundColor(style.dateSeparatorLineColor)\n            binding.ivLineLeft.setBackgroundColor(style.dateSeparatorLineColor)\n        }\n        configSeparatorLineWidth(binding.ivLineRight)\n        configSeparatorLineWidth(binding.ivLineLeft)\n    }\n\n    private fun configSeparatorLineWidth(view: View) {\n        view.updateLayoutParams<ConstraintLayout.LayoutParams> {\n            height = style.dateSeparatorLineWidth\n        }\n    }\n}");
            streamItemDateSeparatorBinding = streamItemDateSeparatorBinding2;
        }
        this(viewGroup, messageListViewStyle, streamItemDateSeparatorBinding);
    }

    @Override
    protected void bind(@NotNull MessageListItem.DateSeparatorItem messageListItem, @NotNull MessageListItemPayloadDiff diff) {
        Intrinsics.checkNotNullParameter((Object)messageListItem, (String)"messageListItem");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.configDate(messageListItem);
        this.applyStyle();
    }

    private final void configDate(MessageListItem.DateSeparatorItem messageListItem) {
        long messageDate = messageListItem.getDate().getTime();
        Date now = new Date();
        CharSequence humanizedDate = now.getTime() - messageDate < 60000L ? (CharSequence)DatesKt.getLabel(Dates.JUST_NOW) : DateUtils.getRelativeTimeSpanString((long)messageDate);
        this.binding.tvDate.setText(humanizedDate);
    }

    private final void applyStyle() {
        TextStyle textStyle = this.style.getDateSeparatorDateText();
        TextView textView = this.binding.tvDate;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvDate");
        textStyle.apply(textView);
        if (this.style.getDateSeparatorLineDrawable() != -1) {
            int drawable2 = this.style.getDateSeparatorLineDrawable();
            this.binding.ivLineRight.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)drawable2));
            this.binding.ivLineLeft.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)drawable2));
        } else {
            this.binding.ivLineRight.setBackgroundColor(this.style.getDateSeparatorLineColor());
            this.binding.ivLineLeft.setBackgroundColor(this.style.getDateSeparatorLineColor());
        }
        ImageView imageView = this.binding.ivLineRight;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivLineRight");
        this.configSeparatorLineWidth((View)imageView);
        imageView = this.binding.ivLineLeft;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivLineLeft");
        this.configSeparatorLineWidth((View)imageView);
    }

    private final void configSeparatorLineWidth(View view) {
        View $this$updateLayoutParams$iv = view;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
        ConstraintLayout.LayoutParams $this$configSeparatorLineWidth_u24lambda_u2d0 = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl = false;
        $this$configSeparatorLineWidth_u24lambda_u2d0.height = this.style.getDateSeparatorLineWidth();
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }
}

