/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.message.configurators;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.ReactionListItemAdapter;
import com.getstream.sdk.chat.adapter.viewholder.message.ExtensionsKt;
import com.getstream.sdk.chat.adapter.viewholder.message.configurators.Configurator;
import com.getstream.sdk.chat.adapter.viewholder.message.configurators.ReactionConfigurator;
import com.getstream.sdk.chat.databinding.StreamItemMessageBinding;
import com.getstream.sdk.chat.utils.UiUtils;
import com.getstream.sdk.chat.utils.extensions.ConstraintLayoutKt;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Message;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import top.defaults.drawabletoolbox.DrawableBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/ReactionConfigurator;", "Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/Configurator;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;", "context", "Landroid/content/Context;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "channel", "Lio/getstream/chat/android/client/models/Channel;", "reactionViewClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$ReactionViewClickListener;", "configParamsReadIndicator", "Lkotlin/Function1;", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "", "(Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;Landroid/content/Context;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lio/getstream/chat/android/client/models/Channel;Lcom/getstream/sdk/chat/view/MessageListView$ReactionViewClickListener;Lkotlin/jvm/functions/Function1;)V", "configParamsReactionRecyclerView", "messageItem", "configParamsReactionSpace", "configParamsReactionTail", "configReactionView", "configStyleReactionView", "configure", "stream-chat-android_release"})
public final class ReactionConfigurator
implements Configurator {
    @NotNull
    private final StreamItemMessageBinding binding;
    @NotNull
    private final Context context;
    @NotNull
    private final MessageListViewStyle style;
    @NotNull
    private final Channel channel;
    @NotNull
    private final MessageListView.ReactionViewClickListener reactionViewClickListener;
    @NotNull
    private final Function1<MessageListItem.MessageItem, Unit> configParamsReadIndicator;

    public ReactionConfigurator(@NotNull StreamItemMessageBinding binding, @NotNull Context context, @NotNull MessageListViewStyle style, @NotNull Channel channel, @NotNull MessageListView.ReactionViewClickListener reactionViewClickListener2, @NotNull Function1<? super MessageListItem.MessageItem, Unit> configParamsReadIndicator2) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)reactionViewClickListener2, (String)"reactionViewClickListener");
        Intrinsics.checkNotNullParameter(configParamsReadIndicator2, (String)"configParamsReadIndicator");
        this.binding = binding;
        this.context = context;
        this.style = style;
        this.channel = channel;
        this.reactionViewClickListener = reactionViewClickListener2;
        this.configParamsReadIndicator = configParamsReadIndicator2;
    }

    @Override
    public void configure(@NotNull MessageListItem.MessageItem messageItem) {
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        this.configReactionView(messageItem);
        this.configParamsReactionSpace(messageItem);
        this.configParamsReactionTail(messageItem);
        this.configParamsReactionRecyclerView(messageItem);
    }

    private final void configReactionView(MessageListItem.MessageItem messageItem) {
        Message message = messageItem.getMessage();
        if (ExtensionsKt.isDeleted(message) || ExtensionsKt.isFailed(message) || !this.style.isReactionEnabled() || !this.channel.getConfig().isReactionsEnabled() || message.getReactionCounts().isEmpty()) {
            this.binding.reactionsRecyclerView.setVisibility(8);
            this.binding.ivTail.setVisibility(8);
            this.binding.spaceReactionTail.setVisibility(8);
            return;
        }
        this.configStyleReactionView(messageItem);
        this.binding.reactionsRecyclerView.setVisibility(0);
        this.binding.ivTail.setVisibility(0);
        this.binding.spaceReactionTail.setVisibility(0);
        this.binding.reactionsRecyclerView.setAdapter((RecyclerView.Adapter)new ReactionListItemAdapter(this.context, message.getReactionCounts(), UiUtils.getReactionTypes(), this.style));
        this.binding.reactionsRecyclerView.setOnTouchListener((arg_0, arg_1) -> ReactionConfigurator.configReactionView$lambda-0(this, message, arg_0, arg_1));
    }

    private final void configStyleReactionView(MessageListItem.MessageItem messageItem) {
        if (this.style.getReactionViewBgDrawable() == -1) {
            this.binding.reactionsRecyclerView.setBackground(new DrawableBuilder().rectangle().rounded().solidColor(this.style.getReactionViewBgColor()).solidColorPressed(Integer.valueOf(-3355444)).build());
            this.binding.ivTail.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)(messageItem.isMine() ? R.drawable.stream_tail_outgoing : R.drawable.stream_tail_incoming)));
            DrawableCompat.setTint((Drawable)this.binding.ivTail.getDrawable(), (int)this.style.getReactionViewBgColor());
        } else {
            int drawable2 = this.style.getReactionViewBgDrawable();
            this.binding.reactionsRecyclerView.setBackground(ContextCompat.getDrawable((Context)this.context, (int)drawable2));
            this.binding.ivTail.setVisibility(8);
        }
    }

    private final void configParamsReactionSpace(MessageListItem.MessageItem messageItem) {
        if (this.binding.ivTail.getVisibility() != 0) {
            return;
        }
        ConstraintLayout constraintLayout = this.binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
        ConstraintLayoutKt.updateConstraints((ConstraintLayout)constraintLayout, (Function1)configParamsReactionSpace.1.INSTANCE);
        ViewGroup.LayoutParams layoutParams = this.binding.spaceReactionTail.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)layoutParams;
        int activeContentViewResId = ExtensionsKt.getActiveContentViewResId(messageItem.getMessage(), this.binding);
        if (messageItem.isMine()) {
            params.endToStart = activeContentViewResId;
        } else {
            params.startToEnd = activeContentViewResId;
        }
        this.binding.spaceReactionTail.setLayoutParams((ViewGroup.LayoutParams)params);
        this.binding.reactionsRecyclerView.post(() -> ReactionConfigurator.configParamsReactionSpace$lambda-1(params, this));
    }

    private final void configParamsReactionTail(MessageListItem.MessageItem messageItem) {
        if (this.binding.ivTail.getVisibility() != 0) {
            return;
        }
        ConstraintLayout constraintLayout = this.binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
        ConstraintLayoutKt.updateConstraints((ConstraintLayout)constraintLayout, (Function1)configParamsReactionTail.1.INSTANCE);
        ViewGroup.LayoutParams layoutParams = this.binding.ivTail.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)layoutParams;
        if (messageItem.isMine()) {
            params.startToStart = this.binding.spaceReactionTail.getId();
        } else {
            params.endToEnd = this.binding.spaceReactionTail.getId();
        }
        this.binding.reactionsRecyclerView.post(() -> ReactionConfigurator.configParamsReactionTail$lambda-2(params, this));
    }

    private final void configParamsReactionRecyclerView(MessageListItem.MessageItem messageItem) {
        if (this.binding.reactionsRecyclerView.getVisibility() != 0) {
            return;
        }
        this.binding.reactionsRecyclerView.setVisibility(4);
        this.binding.ivTail.setVisibility(4);
        this.binding.reactionsRecyclerView.post(() -> ReactionConfigurator.configParamsReactionRecyclerView$lambda-4(this, messageItem));
    }

    private static final boolean configReactionView$lambda-0(ReactionConfigurator this$0, Message $message, View $noName_0, MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() == 1) {
            this$0.reactionViewClickListener.onReactionViewClick($message);
        }
        return false;
    }

    private static final void configParamsReactionSpace$lambda-1(ConstraintLayout.LayoutParams $params, ReactionConfigurator this$0) {
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $params.width = this$0.binding.reactionsRecyclerView.getHeight() / 3;
        this$0.binding.spaceReactionTail.setLayoutParams((ViewGroup.LayoutParams)$params);
    }

    private static final void configParamsReactionTail$lambda-2(ConstraintLayout.LayoutParams $params, ReactionConfigurator this$0) {
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $params.height = this$0.binding.reactionsRecyclerView.getHeight();
        $params.width = this$0.binding.reactionsRecyclerView.getHeight();
        $params.topMargin = this$0.binding.reactionsRecyclerView.getHeight() / 3;
        this$0.binding.ivTail.setLayoutParams((ViewGroup.LayoutParams)$params);
    }

    private static final void configParamsReactionRecyclerView$lambda-4(ReactionConfigurator this$0, MessageListItem.MessageItem $messageItem) {
        ImageView $this$isVisible$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$messageItem, (String)"$messageItem");
        if (this$0.binding.reactionsRecyclerView.getVisibility() == 8) {
            return;
        }
        ConstraintLayout constraintLayout = this$0.binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
        ConstraintLayoutKt.updateConstraints((ConstraintLayout)constraintLayout, (Function1)configParamsReactionRecyclerView.1.1.INSTANCE);
        constraintLayout = this$0.binding.reactionsRecyclerView;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.reactionsRecyclerView");
        View $this$updateLayoutParams$iv = (View)constraintLayout;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
        ConstraintLayout.LayoutParams $this$configParamsReactionRecyclerView_u24lambda_u2d4_u24lambda_u2d3 = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl = false;
        Collection collection = $messageItem.getMessage().getAttachments();
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            if ($messageItem.isMine()) {
                $this$configParamsReactionRecyclerView_u24lambda_u2d4_u24lambda_u2d3.startToStart = R.id.spaceReactionTail;
            } else {
                $this$configParamsReactionRecyclerView_u24lambda_u2d4_u24lambda_u2d3.endToEnd = R.id.spaceReactionTail;
            }
        } else {
            int reactionMargin = this$0.context.getResources().getDimensionPixelSize(R.dimen.stream_reaction_margin);
            if (this$0.binding.tvText.getWidth() + reactionMargin < this$0.binding.reactionsRecyclerView.getWidth()) {
                if ($messageItem.isMine()) {
                    $this$configParamsReactionRecyclerView_u24lambda_u2d4_u24lambda_u2d3.endToEnd = R.id.tvText;
                } else {
                    $this$configParamsReactionRecyclerView_u24lambda_u2d4_u24lambda_u2d3.startToStart = R.id.tvText;
                }
            } else if ($messageItem.isMine()) {
                $this$configParamsReactionRecyclerView_u24lambda_u2d4_u24lambda_u2d3.startToStart = R.id.spaceReactionTail;
            } else {
                $this$configParamsReactionRecyclerView_u24lambda_u2d4_u24lambda_u2d3.endToEnd = R.id.spaceReactionTail;
            }
        }
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        $this$updateLayoutParams$iv = this$0.binding.reactionsRecyclerView;
        Intrinsics.checkNotNullExpressionValue((Object)$this$updateLayoutParams$iv, (String)"binding.reactionsRecyclerView");
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$isVisible$iv = this$0.binding.ivTail;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.ivTail");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = true;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        this$0.configParamsReadIndicator.invoke((Object)$messageItem);
    }
}

