/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.message.configurators;

import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.viewholder.message.ExtensionsKt;
import com.getstream.sdk.chat.adapter.viewholder.message.configurators.Configurator;
import com.getstream.sdk.chat.adapter.viewholder.message.configurators.UsernameAndDateConfigurator;
import com.getstream.sdk.chat.databinding.StreamItemMessageBinding;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.DateFormatter;
import com.getstream.sdk.chat.utils.DateFormatterKt;
import com.getstream.sdk.chat.utils.extensions.ConstraintLayoutKt;
import com.getstream.sdk.chat.utils.extensions.MessageItemKt;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.ContentUtils;
import io.getstream.chat.android.client.models.User;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/UsernameAndDateConfigurator;", "Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/Configurator;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "dateFormatter", "Lcom/getstream/sdk/chat/utils/DateFormatter;", "(Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/utils/DateFormatter;)V", "configParamsMessageDate", "", "messageItem", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "configUserNameAndMessageDateStyle", "configure", "stream-chat-android_release"})
public final class UsernameAndDateConfigurator
implements Configurator {
    @NotNull
    private final StreamItemMessageBinding binding;
    @NotNull
    private final MessageListViewStyle style;
    @NotNull
    private final DateFormatter dateFormatter;

    public UsernameAndDateConfigurator(@NotNull StreamItemMessageBinding binding, @NotNull MessageListViewStyle style, @NotNull DateFormatter dateFormatter) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)dateFormatter, (String)"dateFormatter");
        this.binding = binding;
        this.style = style;
        this.dateFormatter = dateFormatter;
    }

    @Override
    public void configure(@NotNull MessageListItem.MessageItem messageItem) {
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        this.configUserNameAndMessageDateStyle(messageItem);
        this.configParamsMessageDate(messageItem);
    }

    private final void configUserNameAndMessageDateStyle(MessageListItem.MessageItem messageItem) {
        TextView $this$isVisible$iv;
        boolean value$iv;
        Date date;
        boolean $i$f$setVisible;
        boolean value$iv22;
        TextView $this$isVisible$iv2;
        if (MessageItemKt.isNotBottomPosition((MessageListItem.MessageItem)messageItem) || !this.style.isUserNameShow() && !this.style.isMessageDateShow()) {
            TextView $this$isVisible$iv3;
            TextView textView = this.binding.tvUsername;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvUsername");
            textView = (View)textView;
            boolean value$iv3 = false;
            boolean $i$f$setVisible2 = false;
            $this$isVisible$iv3.setVisibility(8);
            $this$isVisible$iv3 = this.binding.tvMessagedate;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv3, (String)"binding.tvMessagedate");
            $this$isVisible$iv3 = (View)$this$isVisible$iv3;
            value$iv3 = false;
            $i$f$setVisible2 = false;
            $this$isVisible$iv3.setVisibility(8);
            return;
        }
        if (this.style.isUserNameShow() && messageItem.isTheirs()) {
            $this$isVisible$iv2 = this.binding.tvUsername;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv2, (String)"binding.tvUsername");
            $this$isVisible$iv2 = (View)$this$isVisible$iv2;
            value$iv22 = true;
            $i$f$setVisible = false;
            $this$isVisible$iv2.setVisibility(0);
            this.binding.tvUsername.setText((CharSequence)ContentUtils.getName((User)messageItem.getMessage().getUser()));
        } else {
            $this$isVisible$iv2 = this.binding.tvUsername;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv2, (String)"binding.tvUsername");
            $this$isVisible$iv2 = (View)$this$isVisible$iv2;
            value$iv22 = false;
            $i$f$setVisible = false;
            $this$isVisible$iv2.setVisibility(8);
        }
        Date value$iv22 = messageItem.getMessage().getCreatedAt();
        Date date2 = date = value$iv22 == null ? messageItem.getMessage().getCreatedLocallyAt() : value$iv22;
        if (this.style.isMessageDateShow() && date != null) {
            value$iv22 = this.binding.tvMessagedate;
            Intrinsics.checkNotNullExpressionValue((Object)value$iv22, (String)"binding.tvMessagedate");
            value$iv22 = (View)value$iv22;
            value$iv = true;
            boolean $i$f$setVisible3 = false;
            $this$isVisible$iv.setVisibility(0);
            this.binding.tvMessagedate.setText((CharSequence)DateFormatterKt.formatDate((DateFormatter)this.dateFormatter, (Date)date));
        } else {
            $this$isVisible$iv = this.binding.tvMessagedate;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.tvMessagedate");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = false;
            boolean $i$f$setVisible4 = false;
            $this$isVisible$iv.setVisibility(8);
        }
        TextStyle textStyle = this.style.getMessageUserNameText();
        TextView textView = this.binding.tvUsername;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvUsername");
        textStyle.apply(textView);
        if (messageItem.isMine()) {
            TextStyle textStyle2 = this.style.getMessageDateTextMine();
            textView = this.binding.tvMessagedate;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvMessagedate");
            textStyle2.apply(textView);
        } else {
            TextStyle textStyle3 = this.style.getMessageDateTextTheirs();
            textView = this.binding.tvMessagedate;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvMessagedate");
            textStyle3.apply(textView);
        }
    }

    private final void configParamsMessageDate(MessageListItem.MessageItem messageItem) {
        TextView textView = this.binding.tvMessagedate;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvMessagedate");
        View $this$isGone$iv = (View)textView;
        boolean $i$f$isGone = false;
        if ($this$isGone$iv.getVisibility() == 8) {
            return;
        }
        $this$isGone$iv = this.binding.tvMessagedate;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isGone$iv, (String)"binding.tvMessagedate");
        View $this$updateLayoutParams$iv = $this$isGone$iv;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
        ConstraintLayout.LayoutParams $this$configParamsMessageDate_u24lambda_u2d0 = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl = false;
        if (!this.style.isUserNameShow() && this.style.isMessageDateShow()) {
            ConstraintLayout constraintLayout = this.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            ConstraintLayoutKt.updateConstraints((ConstraintLayout)constraintLayout, (Function1)configParamsMessageDate.1.1.INSTANCE);
            $this$configParamsMessageDate_u24lambda_u2d0.startToStart = ExtensionsKt.getActiveContentViewResId(messageItem.getMessage(), this.binding);
        }
        $this$configParamsMessageDate_u24lambda_u2d0.horizontalBias = messageItem.isTheirs() ? 0.0f : 1.0f;
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }
}

