/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.viewmodel.channels;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import com.getstream.sdk.chat.utils.extensions.FiltersKt;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.api.models.FilterObject;
import io.getstream.chat.android.client.api.models.QuerySort;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Filters;
import io.getstream.chat.android.client.models.TypingEvent;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.livedata.ChatDomain;
import io.getstream.chat.android.livedata.controller.QueryChannelsController;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0004+,-.B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ\u0006\u0010\"\u001a\u00020\u001cJ\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u001cH\u0002J!\u0010'\u001a\u00020\u001c2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0)\u00a2\u0006\u0002\b*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel;", "Landroidx/lifecycle/ViewModel;", "chatDomain", "Lio/getstream/chat/android/livedata/ChatDomain;", "filter", "Lio/getstream/chat/android/client/api/models/FilterObject;", "sort", "Lio/getstream/chat/android/client/api/models/QuerySort;", "Lio/getstream/chat/android/client/models/Channel;", "limit", "", "(Lio/getstream/chat/android/livedata/ChatDomain;Lio/getstream/chat/android/client/api/models/FilterObject;Lio/getstream/chat/android/client/api/models/QuerySort;I)V", "filterLiveData", "Landroidx/lifecycle/LiveData;", "paginationState", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$PaginationState;", "getPaginationState", "()Landroidx/lifecycle/LiveData;", "paginationStateMerger", "Landroidx/lifecycle/MediatorLiveData;", "state", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "getState", "stateMerger", "typingEvents", "Lio/getstream/chat/android/client/models/TypingEvent;", "getTypingEvents", "deleteChannel", "", "channel", "hideChannel", "initData", "filterObject", "leaveChannel", "markAllRead", "onEvent", "event", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event;", "requestMoreChannels", "setPaginationState", "reducer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Companion", "Event", "PaginationState", "State", "stream-chat-android_release"})
public final class ChannelsViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ChatDomain chatDomain;
    @Nullable
    private final FilterObject filter;
    @NotNull
    private final QuerySort<Channel> sort;
    private final int limit;
    @NotNull
    private final MediatorLiveData<State> stateMerger;
    @NotNull
    private final LiveData<State> state;
    @NotNull
    private final MediatorLiveData<PaginationState> paginationStateMerger;
    @NotNull
    private final LiveData<PaginationState> paginationState;
    @NotNull
    private final LiveData<FilterObject> filterLiveData;
    @JvmField
    @NotNull
    public static final QuerySort<Channel> DEFAULT_SORT;

    /*
     * WARNING - void declaration
     */
    public ChannelsViewModel(@NotNull ChatDomain chatDomain, @Nullable FilterObject filter, @NotNull QuerySort<Channel> sort, int limit) {
        LiveData liveData;
        MutableLiveData mutableLiveData;
        Intrinsics.checkNotNullParameter((Object)chatDomain, (String)"chatDomain");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        this.chatDomain = chatDomain;
        this.filter = filter;
        this.sort = sort;
        this.limit = limit;
        this.stateMerger = new MediatorLiveData();
        this.state = (LiveData)this.stateMerger;
        this.paginationStateMerger = new MediatorLiveData();
        LiveData liveData2 = Transformations.distinctUntilChanged((LiveData)((LiveData)this.paginationStateMerger));
        Intrinsics.checkNotNullExpressionValue((Object)liveData2, (String)"distinctUntilChanged(paginationStateMerger)");
        this.paginationState = liveData2;
        ChannelsViewModel channelsViewModel = this;
        FilterObject filterObject = this.filter;
        if (filterObject == null) {
            mutableLiveData = null;
        } else {
            void p0;
            FilterObject filterObject2 = filterObject;
            boolean bl = false;
            boolean bl2 = false;
            FilterObject filterObject3 = filterObject2;
            ChannelsViewModel channelsViewModel2 = channelsViewModel;
            boolean bl3 = false;
            MutableLiveData mutableLiveData2 = new MutableLiveData((Object)p0);
            channelsViewModel = channelsViewModel2;
            mutableLiveData = mutableLiveData2;
        }
        liveData2 = mutableLiveData;
        if (liveData2 == null) {
            filterObject = Transformations.map((LiveData)this.chatDomain.getUser(), arg_0 -> FiltersKt.defaultChannelListFilter((Filters)Filters.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)filterObject, (String)"map(chatDomain.user, Filters::defaultChannelListFilter)");
            liveData = filterObject;
        } else {
            liveData = liveData2;
        }
        channelsViewModel.filterLiveData = liveData;
        this.stateMerger.addSource(this.filterLiveData, arg_0 -> ChannelsViewModel._init_$lambda-0(this, arg_0));
    }

    public /* synthetic */ ChannelsViewModel(ChatDomain chatDomain, FilterObject filterObject, QuerySort querySort, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            chatDomain = ChatDomain.Companion.instance();
        }
        if ((n2 & 2) != 0) {
            filterObject = null;
        }
        if ((n2 & 4) != 0) {
            querySort = DEFAULT_SORT;
        }
        if ((n2 & 8) != 0) {
            n = 30;
        }
        this(chatDomain, filterObject, querySort, n);
    }

    @NotNull
    public final LiveData<State> getState() {
        return this.state;
    }

    @NotNull
    public final LiveData<TypingEvent> getTypingEvents() {
        return this.chatDomain.getTypingUpdates();
    }

    @NotNull
    public final LiveData<PaginationState> getPaginationState() {
        return this.paginationState;
    }

    private final void initData(FilterObject filterObject) {
        this.stateMerger.setValue((Object)State.Loading.INSTANCE);
        ChatDomain.DefaultImpls.queryChannels$default((ChatDomain)this.chatDomain, (FilterObject)filterObject, this.sort, (int)this.limit, (int)0, (int)8, null).enqueue(arg_0 -> ChannelsViewModel.initData$lambda-5(this, arg_0));
    }

    public final void onEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Event event2 = event;
        if (event2 instanceof Event.ReachedEndOfList) {
            this.requestMoreChannels();
        } else if (event2 instanceof Event.LogoutClicked) {
            ChatClient.Companion.instance().disconnect();
            this.stateMerger.postValue((Object)State.NavigateToLoginScreen.INSTANCE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Unit $this$exhaustive$iv = Unit.INSTANCE;
        boolean $i$f$getExhaustive = false;
    }

    public final void leaveChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.chatDomain.leaveChannel(channel.getCid()).enqueue();
    }

    public final void deleteChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.chatDomain.deleteChannel(channel.getCid()).enqueue();
    }

    public final void hideChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.chatDomain.hideChannel(channel.getCid(), true).enqueue();
    }

    public final void markAllRead() {
        this.chatDomain.markAllRead().enqueue();
    }

    private final void requestMoreChannels() {
        FilterObject filterObject = (FilterObject)this.filterLiveData.getValue();
        if (filterObject != null) {
            FilterObject filterObject2 = filterObject;
            boolean bl = false;
            boolean bl2 = false;
            FilterObject filter = filterObject2;
            boolean bl3 = false;
            this.chatDomain.queryChannelsLoadMore(filter, this.sort).enqueue();
        }
    }

    private final void setPaginationState(Function1<? super PaginationState, PaginationState> reducer) {
        PaginationState paginationState = (PaginationState)this.paginationStateMerger.getValue();
        PaginationState paginationState2 = paginationState == null ? new PaginationState(false, false, 3, null) : paginationState;
        this.paginationStateMerger.setValue(reducer.invoke((Object)paginationState2));
    }

    private static final void _init_$lambda-0(ChannelsViewModel this$0, FilterObject filterObject) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (filterObject != null) {
            this$0.initData(filterObject);
        }
    }

    private static final State initData$lambda-5$lambda-1(QueryChannelsController.ChannelsState channelState) {
        State state;
        QueryChannelsController.ChannelsState channelsState = channelState;
        if (channelsState instanceof QueryChannelsController.ChannelsState.NoQueryActive ? true : channelsState instanceof QueryChannelsController.ChannelsState.Loading) {
            state = State.Loading.INSTANCE;
        } else if (channelsState instanceof QueryChannelsController.ChannelsState.OfflineNoResults) {
            state = State.NoChannelsAvailable.INSTANCE;
        } else if (channelsState instanceof QueryChannelsController.ChannelsState.Result) {
            state = new State.Result(((QueryChannelsController.ChannelsState.Result)channelState).getChannels());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return state;
    }

    private static final void initData$lambda-5$lambda-2(ChannelsViewModel this$0, State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.stateMerger.setValue((Object)state);
    }

    private static final void initData$lambda-5$lambda-3(ChannelsViewModel this$0, Boolean loadingMore) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setPaginationState((Function1<? super PaginationState, PaginationState>)((Function1)new Function1<PaginationState, PaginationState>(loadingMore){
            final /* synthetic */ Boolean $loadingMore;
            {
                this.$loadingMore = $loadingMore;
                super(1);
            }

            @NotNull
            public final PaginationState invoke(@NotNull PaginationState $this$setPaginationState) {
                Intrinsics.checkNotNullParameter((Object)$this$setPaginationState, (String)"$this$setPaginationState");
                Boolean bl = this.$loadingMore;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"loadingMore");
                return PaginationState.copy$default($this$setPaginationState, bl, false, 2, null);
            }
        }));
    }

    private static final void initData$lambda-5$lambda-4(ChannelsViewModel this$0, Boolean endOfChannels) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setPaginationState((Function1<? super PaginationState, PaginationState>)((Function1)new Function1<PaginationState, PaginationState>(endOfChannels){
            final /* synthetic */ Boolean $endOfChannels;
            {
                this.$endOfChannels = $endOfChannels;
                super(1);
            }

            @NotNull
            public final PaginationState invoke(@NotNull PaginationState $this$setPaginationState) {
                Intrinsics.checkNotNullParameter((Object)$this$setPaginationState, (String)"$this$setPaginationState");
                Boolean bl = this.$endOfChannels;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"endOfChannels");
                return PaginationState.copy$default($this$setPaginationState, false, bl, 1, null);
            }
        }));
    }

    private static final void initData$lambda-5(ChannelsViewModel this$0, Result queryChannelsControllerResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)queryChannelsControllerResult, (String)"queryChannelsControllerResult");
        if (queryChannelsControllerResult.isSuccess()) {
            QueryChannelsController queryChannelsController = (QueryChannelsController)queryChannelsControllerResult.data();
            this$0.stateMerger.addSource(Transformations.map((LiveData)queryChannelsController.getChannelsState(), ChannelsViewModel::initData$lambda-5$lambda-1), arg_0 -> ChannelsViewModel.initData$lambda-5$lambda-2(this$0, arg_0));
            this$0.paginationStateMerger.addSource(queryChannelsController.getLoadingMore(), arg_0 -> ChannelsViewModel.initData$lambda-5$lambda-3(this$0, arg_0));
            this$0.paginationStateMerger.addSource(queryChannelsController.getEndOfChannels(), arg_0 -> ChannelsViewModel.initData$lambda-5$lambda-4(this$0, arg_0));
        } else {
            this$0.stateMerger.postValue((Object)State.NoChannelsAvailable.INSTANCE);
        }
    }

    public ChannelsViewModel() {
        this(null, null, null, 0, 15, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void this_$iv;
        Companion = new Companion(null);
        QuerySort.Companion companion = QuerySort.Companion;
        String fieldName$iv = "last_updated";
        boolean $i$f$desc = false;
        void var3_3 = this_$iv;
        QuerySort $this$descByName$iv$iv = new QuerySort();
        boolean $i$f$descByName = false;
        DEFAULT_SORT = $this$descByName$iv$iv.desc(fieldName$iv, Reflection.getOrCreateKotlinClass(Channel.class));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "", "()V", "Loading", "NavigateToLoginScreen", "NoChannelsAvailable", "Result", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$Loading;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$Result;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$NoChannelsAvailable;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$NavigateToLoginScreen;", "stream-chat-android_release"})
    public static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$Loading;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class Loading
        extends State {
            @NotNull
            public static final Loading INSTANCE = new Loading();

            private Loading() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$Result;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "channels", "", "Lio/getstream/chat/android/client/models/Channel;", "(Ljava/util/List;)V", "getChannels", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android_release"})
        public static final class Result
        extends State {
            @NotNull
            private final List<Channel> channels;

            public Result(@NotNull List<Channel> channels) {
                Intrinsics.checkNotNullParameter(channels, (String)"channels");
                super(null);
                this.channels = channels;
            }

            @NotNull
            public final List<Channel> getChannels() {
                return this.channels;
            }

            @NotNull
            public final List<Channel> component1() {
                return this.channels;
            }

            @NotNull
            public final Result copy(@NotNull List<Channel> channels) {
                Intrinsics.checkNotNullParameter(channels, (String)"channels");
                return new Result(channels);
            }

            public static /* synthetic */ Result copy$default(Result result, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = result.channels;
                }
                return result.copy(list);
            }

            @NotNull
            public String toString() {
                return "Result(channels=" + this.channels + ')';
            }

            public int hashCode() {
                return ((Object)this.channels).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Result)) {
                    return false;
                }
                Result result = (Result)other;
                return Intrinsics.areEqual(this.channels, result.channels);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$NoChannelsAvailable;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class NoChannelsAvailable
        extends State {
            @NotNull
            public static final NoChannelsAvailable INSTANCE = new NoChannelsAvailable();

            private NoChannelsAvailable() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$NavigateToLoginScreen;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class NavigateToLoginScreen
        extends State {
            @NotNull
            public static final NavigateToLoginScreen INSTANCE = new NavigateToLoginScreen();

            private NavigateToLoginScreen() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$PaginationState;", "", "loadingMore", "", "endOfChannels", "(ZZ)V", "getEndOfChannels", "()Z", "getLoadingMore", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "stream-chat-android_release"})
    public static final class PaginationState {
        private final boolean loadingMore;
        private final boolean endOfChannels;

        public PaginationState(boolean loadingMore, boolean endOfChannels) {
            this.loadingMore = loadingMore;
            this.endOfChannels = endOfChannels;
        }

        public /* synthetic */ PaginationState(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getLoadingMore() {
            return this.loadingMore;
        }

        public final boolean getEndOfChannels() {
            return this.endOfChannels;
        }

        public final boolean component1() {
            return this.loadingMore;
        }

        public final boolean component2() {
            return this.endOfChannels;
        }

        @NotNull
        public final PaginationState copy(boolean loadingMore, boolean endOfChannels) {
            return new PaginationState(loadingMore, endOfChannels);
        }

        public static /* synthetic */ PaginationState copy$default(PaginationState paginationState, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = paginationState.loadingMore;
            }
            if ((n & 2) != 0) {
                bl2 = paginationState.endOfChannels;
            }
            return paginationState.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "PaginationState(loadingMore=" + this.loadingMore + ", endOfChannels=" + this.endOfChannels + ')';
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.loadingMore ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.endOfChannels) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PaginationState)) {
                return false;
            }
            PaginationState paginationState = (PaginationState)other;
            if (this.loadingMore != paginationState.loadingMore) {
                return false;
            }
            return this.endOfChannels == paginationState.endOfChannels;
        }

        public PaginationState() {
            this(false, false, 3, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event;", "", "()V", "LogoutClicked", "ReachedEndOfList", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event$ReachedEndOfList;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event$LogoutClicked;", "stream-chat-android_release"})
    public static abstract class Event {
        private Event() {
        }

        public /* synthetic */ Event(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event$ReachedEndOfList;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event;", "()V", "stream-chat-android_release"})
        public static final class ReachedEndOfList
        extends Event {
            @NotNull
            public static final ReachedEndOfList INSTANCE = new ReachedEndOfList();

            private ReachedEndOfList() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event$LogoutClicked;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event;", "()V", "stream-chat-android_release"})
        public static final class LogoutClicked
        extends Event {
            @NotNull
            public static final LogoutClicked INSTANCE = new LogoutClicked();

            private LogoutClicked() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Companion;", "", "()V", "DEFAULT_SORT", "Lio/getstream/chat/android/client/api/models/QuerySort;", "Lio/getstream/chat/android/client/models/Channel;", "stream-chat-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

