/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.message.configurators;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.method.MovementMethod;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.getstream.sdk.chat.ChatMarkdown;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.viewholder.message.ExtensionsKt;
import com.getstream.sdk.chat.adapter.viewholder.message.configurators.Configurator;
import com.getstream.sdk.chat.databinding.StreamItemMessageBinding;
import com.getstream.sdk.chat.navigation.destinations.ChatDestination;
import com.getstream.sdk.chat.navigation.destinations.WebLinkDestination;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.StringUtility;
import com.getstream.sdk.chat.utils.Utils;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Message;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/MessageTextConfigurator;", "Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/Configurator;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;", "context", "Landroid/content/Context;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "bubbleHelper", "Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;", "messageClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageClickListener;", "messageLongClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;", "messageRetryListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageRetryListener;", "(Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;Landroid/content/Context;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;Lcom/getstream/sdk/chat/view/MessageListView$MessageClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageRetryListener;)V", "isLongClick", "", "configMessageTextBackground", "", "message", "Lio/getstream/chat/android/client/models/Message;", "messageItem", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "configMessageTextClickListener", "configMessageTextStyle", "configMessageTextViewText", "configParamsMessageText", "configure", "stream-chat-android_release"})
public final class MessageTextConfigurator
implements Configurator {
    @NotNull
    private final StreamItemMessageBinding binding;
    @NotNull
    private final Context context;
    @NotNull
    private final MessageListViewStyle style;
    @NotNull
    private final MessageListView.BubbleHelper bubbleHelper;
    @NotNull
    private final MessageListView.MessageClickListener messageClickListener;
    @Nullable
    private final MessageListView.MessageLongClickListener messageLongClickListener;
    @NotNull
    private final MessageListView.MessageRetryListener messageRetryListener;
    private boolean isLongClick;

    public MessageTextConfigurator(@NotNull StreamItemMessageBinding binding, @NotNull Context context, @NotNull MessageListViewStyle style, @NotNull MessageListView.BubbleHelper bubbleHelper, @NotNull MessageListView.MessageClickListener messageClickListener2, @Nullable MessageListView.MessageLongClickListener messageLongClickListener2, @NotNull MessageListView.MessageRetryListener messageRetryListener2) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)bubbleHelper, (String)"bubbleHelper");
        Intrinsics.checkNotNullParameter((Object)messageClickListener2, (String)"messageClickListener");
        Intrinsics.checkNotNullParameter((Object)messageRetryListener2, (String)"messageRetryListener");
        this.binding = binding;
        this.context = context;
        this.style = style;
        this.bubbleHelper = bubbleHelper;
        this.messageClickListener = messageClickListener2;
        this.messageLongClickListener = messageLongClickListener2;
        this.messageRetryListener = messageRetryListener2;
    }

    @Override
    public void configure(@NotNull MessageListItem.MessageItem messageItem) {
        TextView $this$isVisible$iv;
        boolean value$iv;
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        Message message = messageItem.getMessage();
        CharSequence charSequence = message.getText();
        boolean bl = false;
        if (charSequence.length() == 0 && !ExtensionsKt.isDeleted(message)) {
            charSequence = this.binding.tvText;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"binding.tvText");
            charSequence = (View)charSequence;
            value$iv = false;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            return;
        }
        $this$isVisible$iv = this.binding.tvText;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.tvText");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        this.configMessageTextViewText(message);
        this.configMessageTextStyle(message, messageItem);
        this.configMessageTextBackground(message, messageItem);
        this.configMessageTextClickListener(message);
        this.configParamsMessageText(messageItem);
    }

    private final void configMessageTextViewText(Message message) {
        if (ExtensionsKt.isFailed(message)) {
            SpannableStringBuilder builder = new SpannableStringBuilder();
            CharSequence charSequence = message.getCommand();
            boolean bl = false;
            boolean bl2 = false;
            int failedDes = charSequence == null || charSequence.length() == 0 ? R.string.stream_message_failed_send : R.string.stream_message_invalid_command;
            SpannableString str1 = new SpannableString(this.context.getResources().getText(failedDes));
            str1.setSpan((Object)new ForegroundColorSpan(-7829368), 0, str1.length(), 0);
            str1.setSpan((Object)new RelativeSizeSpan(0.7f), 0, str1.length(), 0);
            builder.append((CharSequence)str1);
            builder.append((CharSequence)"\n");
            SpannableString str2 = new SpannableString((CharSequence)message.getText());
            builder.append((CharSequence)str2);
            this.binding.tvText.setText((CharSequence)builder, TextView.BufferType.SPANNABLE);
            return;
        }
        String text = StringUtility.getDeletedOrMentionedText(message);
        ChatMarkdown markdown = ChatUI.Companion.instance().getMarkdown();
        markdown.setText(this.binding.tvText, text);
    }

    private final void configMessageTextStyle(Message message, MessageListItem.MessageItem messageItem) {
        TextView textView;
        if (ExtensionsKt.isDeleted(message)) {
            this.binding.tvText.setTextSize(0, (float)this.context.getResources().getDimensionPixelSize(R.dimen.stream_message_deleted_text_font_size));
            this.binding.tvText.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.stream_gray_dark));
            return;
        }
        if (messageItem.isMine()) {
            TextStyle textStyle = this.style.getMessageTextMine();
            textView = this.binding.tvText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
            textStyle.apply(textView);
        } else {
            TextStyle textStyle = this.style.getMessageTextTheirs();
            textView = this.binding.tvText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
            textStyle.apply(textView);
        }
        int messageLinkTextColor = this.style.getMessageLinkTextColor(messageItem.isMine());
        if (messageLinkTextColor != 0) {
            this.binding.tvText.setLinkTextColor(messageLinkTextColor);
        }
    }

    private final void configMessageTextBackground(Message message, MessageListItem.MessageItem messageItem) {
        Drawable background;
        Drawable drawable2;
        if (ExtensionsKt.isFailed(message)) {
            drawable2 = this.bubbleHelper.getDrawableForMessage(messageItem.getMessage(), messageItem.isMine(), messageItem.getPositions());
        } else if (ExtensionsKt.isDeleted(message) || StringUtility.INSTANCE.isEmoji(message.getText())) {
            drawable2 = null;
        } else {
            Collection collection = message.getAttachments();
            boolean bl = false;
            drawable2 = background = !collection.isEmpty() ? this.bubbleHelper.getDrawableForMessage(messageItem.getMessage(), messageItem.isMine(), CollectionsKt.listOf((Object)MessageListItem.Position.MIDDLE)) : this.bubbleHelper.getDrawableForMessage(messageItem.getMessage(), messageItem.isMine(), messageItem.getPositions());
        }
        if (background != null) {
            this.binding.tvText.setBackground(background);
        } else {
            this.binding.tvText.setBackgroundResource(0);
        }
    }

    private final void configMessageTextClickListener(Message message) {
        this.binding.tvText.setOnClickListener(arg_0 -> MessageTextConfigurator.configMessageTextClickListener$lambda-0(message, this, arg_0));
        this.binding.tvText.setOnLongClickListener(arg_0 -> MessageTextConfigurator.configMessageTextClickListener$lambda-1(message, this, arg_0));
        this.binding.tvText.setMovementMethod((MovementMethod)new Utils.TextViewLinkHandler(message, this){
            final /* synthetic */ Message $message;
            final /* synthetic */ MessageTextConfigurator this$0;
            {
                this.$message = $message;
                this.this$0 = $receiver;
            }

            public void onLinkClick(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                if (ExtensionsKt.isDeleted(this.$message) || ExtensionsKt.isFailed(this.$message)) {
                    return;
                }
                if (MessageTextConfigurator.access$isLongClick$p(this.this$0)) {
                    MessageTextConfigurator.access$setLongClick$p(this.this$0, false);
                    return;
                }
                ChatUI.Companion.instance().getNavigator().navigate((ChatDestination)new WebLinkDestination(url, MessageTextConfigurator.access$getContext$p(this.this$0)));
            }
        });
    }

    private final void configParamsMessageText(MessageListItem.MessageItem messageItem) {
        TextView textView = this.binding.tvText;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
        View $this$isGone$iv = (View)textView;
        boolean $i$f$isGone = false;
        if ($this$isGone$iv.getVisibility() == 8) {
            return;
        }
        $this$isGone$iv = this.binding.tvText;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isGone$iv, (String)"binding.tvText");
        View $this$updateLayoutParams$iv = $this$isGone$iv;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
        ConstraintLayout.LayoutParams $this$configParamsMessageText_u24lambda_u2d2 = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl = false;
        $this$configParamsMessageText_u24lambda_u2d2.horizontalBias = messageItem.isTheirs() ? 0.0f : 1.0f;
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void configMessageTextClickListener$lambda-0(Message $message, MessageTextConfigurator this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (ExtensionsKt.isFailed($message)) {
            CharSequence charSequence = $message.getCommand();
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                this$0.messageRetryListener.onRetryMessage($message);
                return;
            }
        }
        this$0.messageClickListener.onMessageClick($message);
    }

    private static final boolean configMessageTextClickListener$lambda-1(Message $message, MessageTextConfigurator this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (ExtensionsKt.isDeleted($message) || ExtensionsKt.isFailed($message)) {
            return true;
        }
        this$0.isLongClick = true;
        MessageListView.MessageLongClickListener messageLongClickListener2 = this$0.messageLongClickListener;
        if (messageLongClickListener2 != null) {
            messageLongClickListener2.onMessageLongClick($message);
        }
        return true;
    }

    public static final /* synthetic */ boolean access$isLongClick$p(MessageTextConfigurator $this) {
        return $this.isLongClick;
    }

    public static final /* synthetic */ void access$setLongClick$p(MessageTextConfigurator $this, boolean bl) {
        $this.isLongClick = bl;
    }

    public static final /* synthetic */ Context access$getContext$p(MessageTextConfigurator $this) {
        return $this.context;
    }
}

